/*
 * Decompiled with CFR 0.152.
 */
package com.craftaro.skyblock.visit;

import com.craftaro.skyblock.SkyBlock;
import com.craftaro.skyblock.config.FileManager;
import com.craftaro.skyblock.island.Island;
import com.craftaro.skyblock.island.IslandLevel;
import com.craftaro.skyblock.island.IslandLocation;
import com.craftaro.skyblock.island.IslandStatus;
import com.craftaro.skyblock.island.IslandWorld;
import com.craftaro.skyblock.message.MessageManager;
import com.craftaro.skyblock.sound.SoundManager;
import com.craftaro.skyblock.third_party.com.eatthepath.uuid.FastUUID;
import com.craftaro.skyblock.utils.world.LocationUtil;
import com.craftaro.skyblock.visit.Visit;
import com.craftaro.skyblock.world.WorldManager;
import com.craftaro.third_party.com.cryptomorin.xseries.XSound;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;

public class VisitManager {
    private final SkyBlock plugin;
    private final HashMap<UUID, Visit> visitStorage = new HashMap();

    public VisitManager(SkyBlock plugin) {
        this.plugin = plugin;
        this.loadIslands();
    }

    public void onDisable() {
        HashMap<UUID, Visit> visitIslands = this.getIslands();
        for (Visit visit : visitIslands.values()) {
            visit.save();
        }
    }

    public void loadIslands() {
        WorldManager worldManager = this.plugin.getWorldManager();
        FileManager fileManager = this.plugin.getFileManager();
        if (!this.plugin.getConfiguration().getBoolean("Island.Visitor.Unload")) {
            File configFile = new File(this.plugin.getDataFolder(), "island-data");
            if (!configFile.exists()) {
                return;
            }
            for (File fileList : configFile.listFiles()) {
                if (fileList == null || !fileList.getName().contains(".yml") || fileList.getName().length() <= 35) continue;
                try {
                    IslandStatus status;
                    String open;
                    FileManager.Config config = new FileManager.Config(fileManager, fileList);
                    FileConfiguration configLoad = config.getFileConfiguration();
                    UUID islandOwnerUUID = FastUUID.parseUUID(fileList.getName().replace(".yml", ""));
                    ArrayList<String> islandSignature = new ArrayList();
                    if (configLoad.getString("Visitor.Signature.Message") != null) {
                        islandSignature = configLoad.getStringList("Visitor.Signature.Message");
                    }
                    int size = 100;
                    if (configLoad.getString("Size") != null) {
                        size = configLoad.getInt("Size");
                    }
                    if ((open = configLoad.getString("Visitor.Open", null)) != null && (open.equalsIgnoreCase("true") || open.equalsIgnoreCase("false"))) {
                        status = configLoad.getBoolean("Visitor.Open") ? IslandStatus.OPEN : IslandStatus.CLOSED;
                        configLoad.set("Visitor.Open", null);
                    } else {
                        status = configLoad.getString("Visitor.Status") != null ? IslandStatus.getEnum(configLoad.getString("Visitor.Status")) : IslandStatus.WHITELISTED;
                    }
                    this.createIsland(islandOwnerUUID, new IslandLocation[]{new IslandLocation(IslandWorld.NORMAL, null, worldManager.getLocation(fileManager.getLocation(config, "Location.Normal.Island", true), IslandWorld.NORMAL)), new IslandLocation(IslandWorld.NETHER, null, worldManager.getLocation(fileManager.getLocation(config, "Location.Nether.Island", true), IslandWorld.NETHER)), new IslandLocation(IslandWorld.END, null, worldManager.getLocation(fileManager.getLocation(config, "Location.Nether.Island", true), IslandWorld.END))}, size, configLoad.getStringList("Members").size() + configLoad.getStringList("Operators").size() + 1, configLoad.getDouble("Bank.Balance", 0.0), this.getIslandSafeLevel(islandOwnerUUID), new IslandLevel(islandOwnerUUID, this.plugin), islandSignature, status);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
    }

    public void transfer(UUID uuid1, UUID uuid2) {
        Visit visit = this.getIsland(uuid1);
        visit.setOwnerUUID(uuid2);
        visit.getLevel().setOwnerUUID(uuid2);
        visit.save();
        File oldVisitDataFile = new File(new File(this.plugin.getDataFolder().toString() + "/visit-data"), uuid1.toString() + ".yml");
        File newVisitDataFile = new File(new File(this.plugin.getDataFolder().toString() + "/visit-data"), uuid2.toString() + ".yml");
        this.plugin.getFileManager().unloadConfig(oldVisitDataFile);
        this.plugin.getFileManager().unloadConfig(newVisitDataFile);
        oldVisitDataFile.renameTo(newVisitDataFile);
        this.removeIsland(uuid1);
        this.addIsland(uuid2, visit);
    }

    public void removeVisitors(Island island, Removal removal) {
        MessageManager messageManager = this.plugin.getMessageManager();
        SoundManager soundManager = this.plugin.getSoundManager();
        FileManager fileManager = this.plugin.getFileManager();
        FileManager.Config config = fileManager.getConfig(new File(this.plugin.getDataFolder(), "language.yml"));
        FileConfiguration configLoad = config.getFileConfiguration();
        for (UUID visitorList : this.plugin.getIslandManager().getVisitorsAtIsland(island)) {
            Player targetPlayer = Bukkit.getServer().getPlayer(visitorList);
            LocationUtil.teleportPlayerToSpawn(targetPlayer);
            messageManager.sendMessage((CommandSender)targetPlayer, configLoad.getString("Island.Visit." + removal.getFriendlyName() + ".Message"));
            soundManager.playSound((CommandSender)targetPlayer, XSound.ENTITY_ENDERMAN_TELEPORT);
        }
    }

    public int getIslandSafeLevel(UUID islandOwnerUUID) {
        FileManager fileManager = this.plugin.getFileManager();
        FileManager.Config settingDataConfig = new FileManager.Config(fileManager, new File(this.plugin.getDataFolder() + "/setting-data", islandOwnerUUID.toString() + ".yml"));
        FileConfiguration settingDataConfigLoad = settingDataConfig.getFileConfiguration();
        FileManager.Config mainConfig = fileManager.getConfig(new File(this.plugin.getDataFolder(), "config.yml"));
        FileConfiguration mainConfigLoad = mainConfig.getFileConfiguration();
        int safeLevel = 0;
        HashMap<String, Boolean> settings = new HashMap<String, Boolean>();
        settings.put("KeepItemsOnDeath", false);
        settings.put("PvP", true);
        settings.put("Damage", true);
        for (String settingList : settings.keySet()) {
            if (!mainConfigLoad.getBoolean("Island.Settings." + settingList + ".Enable") || settingDataConfigLoad.getString("Settings.Owner." + settingList) == null || settingDataConfigLoad.getBoolean("Settings.Owner." + settingList) != ((Boolean)settings.get(settingList)).booleanValue()) continue;
            ++safeLevel;
        }
        return safeLevel;
    }

    public boolean hasIsland(UUID islandOwnerUUID) {
        return this.visitStorage.containsKey(islandOwnerUUID);
    }

    public Visit getIsland(UUID islandOwnerUUID) {
        return this.visitStorage.get(islandOwnerUUID);
    }

    public HashMap<UUID, Visit> getIslands() {
        return this.visitStorage;
    }

    public Map<UUID, Visit> getOpenIslands() {
        ConcurrentHashMap<UUID, Visit> visitIslands = new ConcurrentHashMap<UUID, Visit>(this.visitStorage);
        for (UUID islandOwnerUUID : visitIslands.keySet()) {
            Visit visit = (Visit)visitIslands.get(islandOwnerUUID);
            if (visit.getStatus() == IslandStatus.OPEN) continue;
            visitIslands.remove(islandOwnerUUID);
        }
        return visitIslands;
    }

    public void createIsland(UUID islandOwnerUUID, IslandLocation[] islandLocations, int islandSize, int islandMembers, double islandBankBalance, int safeLevel, IslandLevel islandLevel, List<String> islandSignature, IslandStatus status) {
        this.visitStorage.put(islandOwnerUUID, new Visit(this.plugin, islandOwnerUUID, islandLocations, islandSize, islandMembers, islandBankBalance, safeLevel, islandLevel, islandSignature, status));
    }

    public void addIsland(UUID islandOwnerUUID, Visit visit) {
        this.visitStorage.put(islandOwnerUUID, visit);
    }

    public void removeIsland(UUID islandOwnerUUID) {
        if (this.hasIsland(islandOwnerUUID)) {
            this.visitStorage.remove(islandOwnerUUID);
        }
    }

    public void unloadIsland(UUID islandOwnerUUID) {
        if (this.hasIsland(islandOwnerUUID)) {
            this.plugin.getFileManager().unloadConfig(new File(new File(this.plugin.getDataFolder(), "visit-data"), islandOwnerUUID.toString() + ".yml"));
            this.visitStorage.remove(islandOwnerUUID);
        }
    }

    public void deleteIsland(UUID islandOwnerUUID) {
        if (this.hasIsland(islandOwnerUUID)) {
            this.plugin.getFileManager().deleteConfig(new File(new File(this.plugin.getDataFolder(), "visit-data"), islandOwnerUUID.toString() + ".yml"));
            this.visitStorage.remove(islandOwnerUUID);
        }
    }

    public static enum Removal {
        UNLOADED("Unloaded"),
        KICKED("Kicked"),
        DELETED("Deleted");

        private final String friendlyName;

        private Removal(String friendlyName) {
            this.friendlyName = friendlyName;
        }

        public String getFriendlyName() {
            return this.friendlyName;
        }
    }
}

