/*
 * Decompiled with CFR 0.152.
 */
package com.craftaro.skyblock.utils.version;

import com.craftaro.skyblock.core.compatibility.MajorServerVersion;
import com.craftaro.skyblock.utils.StringUtil;
import com.craftaro.third_party.com.cryptomorin.xseries.XMaterial;
import java.util.Arrays;
import org.bukkit.Material;
import org.bukkit.block.Biome;
import org.bukkit.inventory.ItemStack;

public enum SBiome {
    BADLANDS(true, XMaterial.DEAD_BUSH),
    COLD_OCEAN(true, XMaterial.ICE),
    DARK_FOREST("ROOFED_FOREST", XMaterial.DARK_OAK_SAPLING),
    DESERT(XMaterial.SAND),
    FOREST(XMaterial.FERN),
    JUNGLE(XMaterial.VINE),
    MOUNTAINS("EXTREME_HILLS", XMaterial.EMERALD_ORE),
    MUSHROOM_FIELDS("MUSHROOM_ISLAND", XMaterial.RED_MUSHROOM),
    NETHER("HELL", XMaterial.NETHERRACK),
    PLAINS(XMaterial.SUNFLOWER),
    RIVER(XMaterial.COD),
    SAVANNA(XMaterial.ACACIA_SAPLING),
    SNOWY_BEACH("COLD_BEACH", XMaterial.SNOWBALL),
    SWAMP("SWAMPLAND", XMaterial.SLIME_BALL),
    TAIGA(XMaterial.SPRUCE_SAPLING),
    THE_END(true, XMaterial.END_STONE),
    THE_VOID("SKY", XMaterial.OBSIDIAN),
    WARM_OCEAN(true, XMaterial.TROPICAL_FISH);

    private static final boolean isPostVersion;
    private final String legacyName;
    private final boolean isPost13;
    private final XMaterial guiIcon;

    private SBiome(XMaterial guiIcon) {
        this(null, false, guiIcon);
    }

    private SBiome(String legacyName, XMaterial guiIcon) {
        this(legacyName, false, guiIcon);
    }

    private SBiome(boolean isPost13, XMaterial guiIcon) {
        this(null, isPost13, guiIcon);
    }

    private SBiome(String legacyName, boolean is13only, XMaterial guiIcon) {
        this.legacyName = legacyName;
        this.isPost13 = is13only;
        this.guiIcon = guiIcon;
    }

    public static SBiome getFromGuiIcon(Material material, byte data) {
        return Arrays.stream(SBiome.values()).filter(biome -> biome.isAvailable() && biome.getGuiIcon().getType() == material && (isPostVersion || biome.getGuiIcon().getData().getData() == data)).findFirst().orElse(null);
    }

    public boolean isAvailable() {
        return !this.isPost13 || isPostVersion;
    }

    public Biome getBiome() {
        return !this.isAvailable() ? null : (isPostVersion || this.legacyName == null ? Biome.valueOf((String)this.name()) : Biome.valueOf((String)this.legacyName));
    }

    public String getFormattedBiomeName() {
        return !this.isAvailable() ? null : StringUtil.capitalizeWord(this.getBiome().name().replaceAll("_", " "));
    }

    public ItemStack getGuiIcon() {
        return !this.isAvailable() ? null : this.guiIcon.parseItem();
    }

    static {
        isPostVersion = MajorServerVersion.isServerVersionAtLeast(MajorServerVersion.V1_13);
    }
}

