/*
 * Decompiled with CFR 0.152.
 */
package com.craftaro.skyblock.utils.version;

import com.craftaro.skyblock.core.compatibility.MajorServerVersion;
import com.craftaro.third_party.com.cryptomorin.xseries.XMaterial;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.bukkit.Material;
import org.bukkit.entity.EntityType;

public enum CompatibleSpawners {
    SPAWNER("MOB_SPAWNER", 0),
    SPAWNER_BAT(null, -1),
    SPAWNER_BLAZE(null, -1),
    SPAWNER_CAVE_SPIDER(null, -1),
    SPAWNER_CHICKEN(null, -1),
    SPAWNER_COD(null, -1),
    SPAWNER_COW(null, -1),
    SPAWNER_CREEPER(null, -1),
    SPAWNER_DOLPHIN(null, -1),
    SPAWNER_DONKEY(null, -1),
    SPAWNER_DROWNED(null, -1),
    SPAWNER_ELDER_GUARDIAN(null, -1),
    SPAWNER_ENDER_DRAGON(null, -1),
    SPAWNER_ENDERMAN(null, -1),
    SPAWNER_ENDERMITE(null, -1),
    SPAWNER_EVOKER(null, -1),
    SPAWNER_GHAST(null, -1),
    SPAWNER_GIANT(null, -1),
    SPAWNER_GUARDIAN(null, -1),
    SPAWNER_HORSE(null, -1),
    SPAWNER_HUSK(null, -1),
    SPAWNER_ILLUSIONER(null, -1),
    SPAWNER_IRON_GOLEM(null, -1),
    SPAWNER_LLAMA(null, -1),
    SPAWNER_MAGMA_CUBE(null, -1),
    SPAWNER_MULE(null, -1),
    SPAWNER_MUSHROOM_COW(null, -1),
    SPAWNER_OCELOT(null, -1),
    SPAWNER_PARROT(null, -1),
    SPAWNER_PHANTOM(null, -1),
    SPAWNER_PIG(null, -1),
    SPAWNER_PIG_ZOMBIE(null, -1),
    SPAWNER_POLAR_BEAR(null, -1),
    SPAWNER_PUFFERFISH(null, -1),
    SPAWNER_RABBIT(null, -1),
    SPAWNER_SALMON(null, -1),
    SPAWNER_SHEEP(null, -1),
    SPAWNER_SHULKER(null, -1),
    SPAWNER_SILVERFISH(null, -1),
    SPAWNER_SKELETON(null, -1),
    SPAWNER_SKELETON_HORSE(null, -1),
    SPAWNER_SLIME(null, -1),
    SPAWNER_SNOWMAN(null, -1),
    SPAWNER_SPIDER(null, -1),
    SPAWNER_SQUID(null, -1),
    SPAWNER_STRAY(null, -1),
    SPAWNER_TROPICAL_FISH(null, -1),
    SPAWNER_TURTLE(null, -1),
    SPAWNER_VEX(null, -1),
    SPAWNER_VILLAGER(null, -1),
    SPAWNER_VINDICATOR(null, -1),
    SPAWNER_WITCH(null, -1),
    SPAWNER_WITHER(null, -1),
    SPAWNER_WITHER_SKELETON(null, -1),
    SPAWNER_WOLF(null, -1),
    SPAWNER_ZOMBIE(null, -1),
    SPAWNER_ZOMBIE_HORSE(null, -1),
    SPAWNER_ZOMBIE_VILLAGER(null, -1);

    private static final Set<CompatibleSpawners> ALL;
    static int newV;
    private static final Map<String, CompatibleSpawners> cachedSearch;
    final String old13Mat;
    final String old12Mat;
    final int data;
    final boolean is13PlusOnly;
    private Material cachedMaterial;
    private boolean isMaterialParsed = false;
    private String actualMaterials;

    private CompatibleSpawners(String old13Mat, String old12Mat, int data, boolean is13PlusOnly) {
        this.old13Mat = old13Mat;
        this.old12Mat = old12Mat;
        this.data = data;
        this.is13PlusOnly = is13PlusOnly;
    }

    private CompatibleSpawners(String old12Mat, int data) {
        this(null, old12Mat, data, false);
    }

    private CompatibleSpawners(String old12Mat, int data, boolean is13PlusOnly) {
        this(null, old12Mat, data, is13PlusOnly);
    }

    public CompatibleSpawners getActualMaterials() {
        return this.actualMaterials == null ? null : CompatibleSpawners.valueOf(this.actualMaterials);
    }

    public static boolean isNewVersion() {
        if (newV == 0) {
            return false;
        }
        if (newV == 1) {
            return true;
        }
        Material mat = Material.matchMaterial((String)"RED_WOOL");
        if (mat != null) {
            newV = 1;
            return true;
        }
        newV = 0;
        return false;
    }

    public static CompatibleSpawners requestMaterials(String name, byte data) {
        String blockName = name.toUpperCase() + "," + data;
        CompatibleSpawners cached = cachedSearch.get(blockName);
        if (cached != null) {
            return cached;
        }
        CompatibleSpawners pmat = CompatibleSpawners.internalRequestMaterials(name, data);
        if (pmat != null || data == 0) {
            cachedSearch.put(blockName, pmat);
            return pmat;
        }
        pmat = CompatibleSpawners.internalRequestMaterials(name, (byte)0);
        cachedSearch.put(blockName, pmat);
        return pmat;
    }

    private static CompatibleSpawners internalRequestMaterials(String name, byte data) {
        CompatibleSpawners actual;
        CompatibleSpawners pmat = null;
        for (CompatibleSpawners mat : ALL) {
            if (!name.equalsIgnoreCase(mat.name())) continue;
            if (pmat == null) {
                pmat = mat;
            }
            if ((actual = mat.getActualMaterials()) != null && mat.is13PlusOnly) {
                return actual;
            }
            if ((byte)mat.data != data) continue;
            return mat;
        }
        for (CompatibleSpawners mat : ALL) {
            if (!name.equalsIgnoreCase(mat.old12Mat)) continue;
            if (pmat == null) {
                pmat = mat;
            }
            if ((actual = mat.getActualMaterials()) != null && mat.is13PlusOnly) {
                return actual;
            }
            if ((byte)mat.data != data) continue;
            return mat;
        }
        return pmat;
    }

    public static CompatibleSpawners getSpawner(EntityType spawnerType) {
        return CompatibleSpawners.fromString("SPAWNER_" + spawnerType.name());
    }

    public static CompatibleSpawners fromString(String key) {
        try {
            return CompatibleSpawners.valueOf(key);
        }
        catch (IllegalArgumentException e) {
            String[] split = key.split(":");
            if (split.length == 1) {
                return CompatibleSpawners.requestMaterials(key, (byte)0);
            }
            return CompatibleSpawners.requestMaterials(split[0], (byte)Integer.parseInt(split[1]));
        }
    }

    public static CompatibleSpawners getMaterials(Material material, byte data) {
        if (MajorServerVersion.isServerVersionAtLeast(MajorServerVersion.V1_13)) {
            return CompatibleSpawners.fromString(material.name());
        }
        return CompatibleSpawners.requestMaterials(material.name(), data);
    }

    public boolean isAvailable() {
        if (this.isSpawner() && this != SPAWNER) {
            String spawnerType = this.name().replace("SPAWNER_", "");
            for (EntityType entityType : EntityType.values()) {
                if (!entityType.name().equalsIgnoreCase(spawnerType)) continue;
                return true;
            }
            return false;
        }
        return CompatibleSpawners.isNewVersion() || !this.is13PlusOnly;
    }

    public boolean isSpawner() {
        return this.name().startsWith("SPAWNER");
    }

    public CompatibleSpawners fromMaterial(Material mat) {
        try {
            return CompatibleSpawners.valueOf(mat.toString());
        }
        catch (IllegalArgumentException e) {
            for (CompatibleSpawners xmat : ALL) {
                if (!xmat.old12Mat.equalsIgnoreCase(mat.toString())) continue;
                return xmat;
            }
            return null;
        }
    }

    public Material getMaterial() {
        if (this.cachedMaterial != null || this.isMaterialParsed) {
            return this.cachedMaterial;
        }
        if (this.isSpawner() && this != SPAWNER) {
            this.cachedMaterial = XMaterial.SPAWNER.parseMaterial();
            return this.cachedMaterial;
        }
        this.cachedMaterial = Material.matchMaterial((String)this.old12Mat);
        this.isMaterialParsed = true;
        return this.cachedMaterial;
    }

    static {
        ALL = Collections.unmodifiableSet(EnumSet.allOf(CompatibleSpawners.class));
        newV = -1;
        cachedSearch = new HashMap<String, CompatibleSpawners>();
    }
}

