/*
 * Decompiled with CFR 0.152.
 */
package com.craftaro.skyblock.utils.structure;

import com.craftaro.skyblock.SkyBlock;
import com.craftaro.skyblock.core.compatibility.CompatibleMaterial;
import com.craftaro.skyblock.core.compatibility.ServerVersion;
import com.craftaro.skyblock.core.nms.Nms;
import com.craftaro.skyblock.core.nms.nbt.NBTEntity;
import com.craftaro.skyblock.utils.Compression;
import com.craftaro.skyblock.utils.structure.Location;
import com.craftaro.skyblock.utils.structure.SelectionLocation;
import com.craftaro.skyblock.utils.structure.Storage;
import com.craftaro.skyblock.utils.structure.Structure;
import com.craftaro.skyblock.utils.world.LocationUtil;
import com.craftaro.skyblock.utils.world.block.BlockData;
import com.craftaro.skyblock.utils.world.block.BlockDegreesType;
import com.craftaro.skyblock.utils.world.block.BlockUtil;
import com.craftaro.skyblock.utils.world.entity.EntityData;
import com.craftaro.skyblock.utils.world.entity.EntityUtil;
import com.craftaro.third_party.com.cryptomorin.xseries.XMaterial;
import com.google.common.io.Files;
import com.google.gson.Gson;
import com.google.gson.JsonSyntaxException;
import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Base64;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.logging.Level;
import java.util.regex.Pattern;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;

public final class StructureUtil {
    public static void saveStructure(File configFile, org.bukkit.Location originLocation, org.bukkit.Location[] positions) throws Exception {
        Location location;
        if (!configFile.exists()) {
            configFile.createNewFile();
        }
        Map<Block, Location> blocks = SelectionLocation.getBlocks(originLocation, positions[0], positions[1]);
        Map<Entity, Location> entities = SelectionLocation.getEntities(originLocation, positions[0], positions[1]);
        ArrayList<BlockData> blockData = new ArrayList<BlockData>();
        ArrayList<EntityData> entityData = new ArrayList<EntityData>();
        String originBlockLocation = "";
        for (Block block : blocks.keySet()) {
            location = blocks.get(block);
            Optional<XMaterial> material = CompatibleMaterial.getMaterial(block.getType());
            if (location.isOriginLocation()) {
                originBlockLocation = location.getX() + ":" + location.getY() + ":" + location.getZ() + ":" + positions[0].getWorld().getName();
                if (CompatibleMaterial.isAir(material.orElse(XMaterial.STONE))) {
                    blockData.add(BlockUtil.convertBlockToBlockData(block, location.getX(), location.getY(), location.getZ()));
                }
            }
            if (CompatibleMaterial.isAir(material.orElse(XMaterial.STONE))) continue;
            blockData.add(BlockUtil.convertBlockToBlockData(block, location.getX(), location.getY(), location.getZ()));
        }
        for (Entity entityList : entities.keySet()) {
            if (entityList.getType() == EntityType.PLAYER) continue;
            location = entities.get(entityList);
            entityData.add(EntityUtil.convertEntityToEntityData(entityList, location.getX(), location.getY(), location.getZ()));
        }
        if (!originBlockLocation.isEmpty()) {
            originBlockLocation = originBlockLocation + ":" + originLocation.getYaw() + ":" + originLocation.getPitch();
        }
        String jsonString = new Gson().toJson((Object)new Storage(new Gson().toJson(blockData), new Gson().toJson(entityData), originBlockLocation, System.currentTimeMillis(), Integer.parseInt(ServerVersion.getVersionReleaseNumber())), Storage.class);
        FileOutputStream fileOutputStream = new FileOutputStream(configFile, false);
        fileOutputStream.write(Base64.getEncoder().encode(jsonString.getBytes(StandardCharsets.UTF_8)));
        fileOutputStream.flush();
        fileOutputStream.close();
    }

    private static String getBase64String(File file) {
        if (!file.exists()) {
            return null;
        }
        String firstLine = null;
        try {
            firstLine = Files.asCharSource((File)file, (Charset)StandardCharsets.UTF_8).readFirstLine();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        return firstLine;
    }

    public static Structure loadStructure(File configFile) throws IOException {
        Storage storage;
        byte[] content = new byte[(int)configFile.length()];
        FileInputStream fileInputStream = new FileInputStream(configFile);
        fileInputStream.read(content);
        fileInputStream.close();
        Pattern pattern = Pattern.compile("^([A-Za-z0-9+/]{4})*([A-Za-z0-9+/]{3}=|[A-Za-z0-9+/]{2}==)?$");
        if (!pattern.matcher(new String(content)).find()) {
            try {
                storage = (Storage)new Gson().fromJson(Compression.decompress(content), Storage.class);
            }
            catch (JsonSyntaxException ex) {
                ex.printStackTrace();
                return null;
            }
        }
        String base64 = StructureUtil.getBase64String(configFile);
        if (base64 == null) {
            base64 = StructureUtil.getBase64String(new File(((SkyBlock)SkyBlock.getPlugin(SkyBlock.class)).getDataFolder() + "/structures", "default.structure"));
            ((SkyBlock)SkyBlock.getPlugin(SkyBlock.class)).getLogger().log(Level.SEVERE, "Unable to load structure '" + configFile.getAbsolutePath() + "' using default instead.");
        }
        if (base64 == null) {
            throw new IllegalArgumentException("Couldn't load the default structure file.");
        }
        try {
            storage = (Storage)new Gson().fromJson(new String(Base64.getDecoder().decode(base64.getBytes(StandardCharsets.UTF_8))), Storage.class);
        }
        catch (JsonSyntaxException ex) {
            ex.printStackTrace();
            return null;
        }
        return new Structure(storage, configFile.getName());
    }

    public static Float[] pasteStructure(Structure structure, org.bukkit.Location location, BlockDegreesType type) {
        Storage storage = structure.getStructureStorage();
        String[] originLocationPositions = null;
        if (!storage.getOriginLocation().isEmpty()) {
            originLocationPositions = storage.getOriginLocation().split(":");
        }
        float yaw = 0.0f;
        float pitch = 0.0f;
        if (originLocationPositions != null && originLocationPositions.length == 6) {
            yaw = Float.parseFloat(originLocationPositions[4]);
            pitch = Float.parseFloat(originLocationPositions[5]);
        }
        List blockData = (List)new Gson().fromJson(storage.getBlocks(), new TypeToken<List<BlockData>>(){}.getType());
        for (BlockData blockDataList : blockData) {
            Bukkit.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)SkyBlock.getPlugin(SkyBlock.class), () -> {
                try {
                    org.bukkit.Location blockRotationLocation = LocationUtil.rotateLocation(new org.bukkit.Location(location.getWorld(), (double)blockDataList.getX(), (double)blockDataList.getY(), (double)blockDataList.getZ()), type);
                    org.bukkit.Location blockLocation = new org.bukkit.Location(location.getWorld(), location.getX() - (double)Math.abs(Integer.parseInt(storage.getOriginLocation().split(":")[0])), location.getY() - (double)Integer.parseInt(storage.getOriginLocation().split(":")[1]), location.getZ() + (double)Math.abs(Integer.parseInt(storage.getOriginLocation().split(":")[2])));
                    blockLocation.add(blockRotationLocation);
                    BlockUtil.convertBlockDataToBlock(blockLocation.getBlock(), blockDataList);
                }
                catch (Exception e) {
                    ((SkyBlock)SkyBlock.getPlugin(SkyBlock.class)).getLogger().warning("Unable to convert BlockData to Block for type {" + blockDataList.getMaterial() + ":" + blockDataList.getData() + "} in structure {" + structure.getStructureFile() + "}");
                }
            });
        }
        Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)SkyBlock.getPlugin(SkyBlock.class), () -> {
            for (EntityData entityDataList : (List)new Gson().fromJson(storage.getEntities(), new TypeToken<List<EntityData>>(){}.getType())) {
                Bukkit.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)SkyBlock.getPlugin(SkyBlock.class), () -> {
                    try {
                        if (entityDataList.getSerializedNBT() != null) {
                            org.bukkit.Location blockRotationLocation = LocationUtil.rotateLocation(new org.bukkit.Location(location.getWorld(), entityDataList.getX(), entityDataList.getY(), entityDataList.getZ()), type);
                            org.bukkit.Location blockLocation = new org.bukkit.Location(location.getWorld(), location.getX() - (double)Math.abs(Integer.parseInt(storage.getOriginLocation().split(":")[0])), location.getY() - (double)Integer.parseInt(storage.getOriginLocation().split(":")[1]), location.getZ() + (double)Math.abs(Integer.parseInt(storage.getOriginLocation().split(":")[2])));
                            blockLocation.add(blockRotationLocation);
                            NBTEntity nbtEntity = Nms.getImplementations().getNbt().newEntity();
                            nbtEntity.deSerialize(entityDataList.getSerializedNBT());
                            nbtEntity.set("UUID", UUID.randomUUID());
                            nbtEntity.spawn(blockLocation);
                        } else {
                            org.bukkit.Location blockRotationLocation = LocationUtil.rotateLocation(new org.bukkit.Location(location.getWorld(), entityDataList.getX(), entityDataList.getY(), entityDataList.getZ()), type);
                            org.bukkit.Location blockLocation = new org.bukkit.Location(location.getWorld(), location.getX() - (double)Math.abs(Integer.parseInt(storage.getOriginLocation().split(":")[0])), location.getY() - (double)Integer.parseInt(storage.getOriginLocation().split(":")[1]), location.getZ() + (double)Math.abs(Integer.parseInt(storage.getOriginLocation().split(":")[2])));
                            blockLocation.add(blockRotationLocation);
                            EntityUtil.convertEntityDataToEntity(entityDataList, blockLocation);
                        }
                    }
                    catch (Exception e) {
                        ((SkyBlock)SkyBlock.getPlugin(SkyBlock.class)).getLogger().warning("Unable to convert EntityData to Entity for type {" + entityDataList.getEntityType() + "} in structure {" + structure.getStructureFile() + "}");
                    }
                });
            }
        }, 60L);
        return new Float[]{Float.valueOf(yaw), Float.valueOf(pitch)};
    }

    public static ItemStack getTool() {
        SkyBlock plugin = (SkyBlock)SkyBlock.getPlugin(SkyBlock.class);
        FileConfiguration configLoad = plugin.getLanguage();
        ItemStack is = new ItemStack(Material.valueOf((String)plugin.getConfiguration().getString("Island.Admin.Structure.Selector")));
        ItemMeta im = is.getItemMeta();
        im.setDisplayName(ChatColor.translateAlternateColorCodes((char)'&', (String)configLoad.getString("Island.Structure.Tool.Item.Displayname")));
        ArrayList<String> itemLore = new ArrayList<String>();
        for (String itemLoreList : configLoad.getStringList("Island.Structure.Tool.Item.Lore")) {
            itemLore.add(ChatColor.translateAlternateColorCodes((char)'&', (String)itemLoreList));
        }
        im.setLore(itemLore);
        is.setItemMeta(im);
        return is;
    }

    public static org.bukkit.Location[] getFixedLocations(org.bukkit.Location location1, org.bukkit.Location location2) {
        org.bukkit.Location location1Fixed = location1.clone();
        org.bukkit.Location location2Fixed = location2.clone();
        if (location1.getX() > location2.getX()) {
            location1Fixed.setX(location2.getX());
            location2Fixed.setX(location1.getX());
        }
        if (location1.getZ() < location2.getZ()) {
            location1Fixed.setZ(location2.getZ());
            location2Fixed.setZ(location1.getZ());
        }
        return new org.bukkit.Location[]{location1Fixed, location2Fixed};
    }
}

