/*
 * Decompiled with CFR 0.152.
 */
package com.craftaro.skyblock.utils.structure;

import com.craftaro.skyblock.SkyBlock;
import com.craftaro.skyblock.core.compatibility.MajorServerVersion;
import com.sk89q.worldedit.EditSession;
import com.sk89q.worldedit.WorldEdit;
import com.sk89q.worldedit.bukkit.BukkitWorld;
import com.sk89q.worldedit.extent.Extent;
import com.sk89q.worldedit.extent.clipboard.Clipboard;
import com.sk89q.worldedit.extent.clipboard.io.ClipboardFormat;
import com.sk89q.worldedit.extent.clipboard.io.ClipboardFormats;
import com.sk89q.worldedit.extent.clipboard.io.ClipboardReader;
import com.sk89q.worldedit.function.operation.Operation;
import com.sk89q.worldedit.function.operation.Operations;
import com.sk89q.worldedit.math.BlockVector3;
import com.sk89q.worldedit.session.ClipboardHolder;
import com.sk89q.worldedit.world.World;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;

public class SchematicUtil {
    public static Float[] pasteSchematic(File schematicFile, Location location) {
        PluginManager pluginManager = Bukkit.getPluginManager();
        if (!(pluginManager.isPluginEnabled("WorldEdit") || pluginManager.isPluginEnabled("AsyncWorldEdit") || pluginManager.isPluginEnabled("FastAsyncWorldEdit"))) {
            throw new IllegalStateException("Tried to generate an island using a schematic file without WorldEdit installed!");
        }
        Runnable pasteTask = () -> {
            if (MajorServerVersion.isServerVersionAbove(MajorServerVersion.V1_12)) {
                ClipboardFormat format = ClipboardFormats.findByFile((File)schematicFile);
                try (ClipboardReader reader = format.getReader(Files.newInputStream(schematicFile.toPath(), new OpenOption[0]));){
                    Clipboard clipboard = reader.read();
                    try (EditSession editSession = WorldEdit.getInstance().getEditSessionFactory().getEditSession((World)new BukkitWorld(location.getWorld()), -1);){
                        Operation operation = new ClipboardHolder(clipboard).createPaste((Extent)editSession).to(BlockVector3.at((double)location.getX(), (double)location.getY(), (double)location.getZ())).ignoreAirBlocks(true).build();
                        Operations.complete((Operation)operation);
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
            } else {
                try {
                    Class<?> bukkitWorldClass = Class.forName("com.sk89q.worldedit.bukkit.BukkitWorld");
                    Constructor<?> bukkitWorldConstructor = bukkitWorldClass.getConstructor(org.bukkit.World.class);
                    Class<?> editSessionClass = Class.forName("com.sk89q.worldedit.EditSession");
                    Class<?> localWorldClass = Class.forName("com.sk89q.worldedit.LocalWorld");
                    Constructor<?> editSessionConstructor = editSessionClass.getConstructor(localWorldClass, Integer.TYPE);
                    Class<?> cuboidClipboardClass = Class.forName("com.sk89q.worldedit.CuboidClipboard");
                    Method loadSchematicMethod = cuboidClipboardClass.getMethod("loadSchematic", File.class);
                    Class<?> vectorClass = Class.forName("com.sk89q.worldedit.Vector");
                    Constructor<?> vectorConstructor = vectorClass.getConstructor(Double.TYPE, Double.TYPE, Double.TYPE);
                    Method pasteMethod = cuboidClipboardClass.getMethod("paste", editSessionClass, vectorClass, Boolean.TYPE);
                    Object editSessionObj = editSessionConstructor.newInstance(bukkitWorldConstructor.newInstance(location.getWorld()), 999999999);
                    Object cuboidClipboardObj = loadSchematicMethod.invoke(null, schematicFile);
                    Object vectorObj = vectorConstructor.newInstance(location.getX(), location.getY(), location.getZ());
                    pasteMethod.invoke(cuboidClipboardObj, editSessionObj, vectorObj, true);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        };
        if (Bukkit.getPluginManager().isPluginEnabled("FastAsyncWorldEdit") || Bukkit.getPluginManager().isPluginEnabled("AsyncWorldEdit")) {
            Bukkit.getScheduler().runTaskAsynchronously((Plugin)SkyBlock.getPlugin(SkyBlock.class), pasteTask);
        } else {
            Bukkit.getScheduler().runTask((Plugin)SkyBlock.getPlugin(SkyBlock.class), pasteTask);
        }
        return new Float[]{Float.valueOf(location.getYaw()), Float.valueOf(location.getPitch())};
    }
}

