/*
 * Decompiled with CFR 0.152.
 */
package com.craftaro.skyblock.utils.player;

import java.util.Set;
import org.bukkit.entity.Player;
import org.bukkit.permissions.PermissionAttachmentInfo;

public final class PlayerUtil {
    private PlayerUtil() {
    }

    public static int getPositiveNumber(String input, int start, int end) {
        if (input.length() < start || input.length() > end) {
            throw new IndexOutOfBoundsException("");
        }
        int num = 0;
        for (int i = start; i < end; ++i) {
            char ch = input.charAt(i);
            if (!Character.isDigit(ch)) continue;
            int digit = Character.getNumericValue(ch);
            num = num * 10 + digit;
        }
        return num;
    }

    public static int getNumberFromPermission(Player player, String permission, boolean bypassPermission, int def) {
        Set permissions = player.getEffectivePermissions();
        if (bypassPermission && player.hasPermission(permission + ".bypass")) {
            return Integer.MAX_VALUE;
        }
        boolean set = false;
        int highest = 0;
        for (PermissionAttachmentInfo info : permissions) {
            int number;
            int index;
            String perm = info.getPermission();
            if (!perm.startsWith(permission) || (index = perm.lastIndexOf(46)) == -1 || index == perm.length() || (number = PlayerUtil.getPositiveNumber(perm, index, perm.length())) < highest) continue;
            highest = number;
            set = true;
        }
        return set ? highest : def;
    }
}

