/*
 * Decompiled with CFR 0.152.
 */
package com.craftaro.skyblock.utils.player;

import com.craftaro.skyblock.SkyBlock;
import com.craftaro.skyblock.third_party.com.eatthepath.uuid.FastUUID;
import com.craftaro.skyblock.usercache.UserCacheManager;
import java.io.File;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.configuration.file.YamlConfiguration;

public class OfflinePlayer {
    private final UUID uuid;
    org.bukkit.OfflinePlayer bukkitOfflinePlayer;
    private String name;
    private final String memberSince;
    private final String lastOnline;
    private UUID owner = null;
    private final String[] texture;
    private final int playtime;

    public OfflinePlayer(String name) {
        SkyBlock plugin = (SkyBlock)SkyBlock.getPlugin(SkyBlock.class);
        UserCacheManager userCacheManager = plugin.getUserCacheManager();
        this.bukkitOfflinePlayer = Bukkit.getServer().getOfflinePlayer(name);
        if (userCacheManager.hasUser(name)) {
            this.uuid = userCacheManager.getUser(name);
            this.bukkitOfflinePlayer = Bukkit.getServer().getOfflinePlayer(this.uuid);
        } else {
            this.uuid = this.bukkitOfflinePlayer.getUniqueId();
        }
        this.name = this.bukkitOfflinePlayer.getName();
        YamlConfiguration configLoad = YamlConfiguration.loadConfiguration((File)new File(new File(plugin.getDataFolder().toString() + "/player-data"), FastUUID.toString(this.uuid) + ".yml"));
        this.texture = new String[]{configLoad.getString("Texture.Signature"), configLoad.getString("Texture.Value")};
        this.playtime = configLoad.getInt("Statistics.Island.Playtime");
        this.memberSince = configLoad.getString("Statistics.Island.Join");
        this.lastOnline = configLoad.getString("Statistics.Island.LastOnline");
        if (configLoad.getString("Island.Owner") != null && !configLoad.getString("Island.Owner").isEmpty()) {
            this.owner = FastUUID.parseUUID(configLoad.getString("Island.Owner"));
        }
    }

    public OfflinePlayer(UUID uuid) {
        SkyBlock plugin = (SkyBlock)SkyBlock.getPlugin(SkyBlock.class);
        UserCacheManager userCacheManager = plugin.getUserCacheManager();
        this.bukkitOfflinePlayer = Bukkit.getServer().getOfflinePlayer(uuid);
        this.name = this.bukkitOfflinePlayer.getName();
        this.uuid = uuid;
        if (this.name == null) {
            this.name = userCacheManager.hasUser(uuid) ? userCacheManager.getUser(uuid) : "Unknown";
        }
        YamlConfiguration configLoad = YamlConfiguration.loadConfiguration((File)new File(new File(plugin.getDataFolder().toString() + "/player-data"), FastUUID.toString(uuid) + ".yml"));
        this.texture = new String[]{configLoad.getString("Texture.Signature"), configLoad.getString("Texture.Value")};
        this.playtime = configLoad.getInt("Statistics.Island.Playtime");
        this.memberSince = configLoad.getString("Statistics.Island.Join");
        this.lastOnline = configLoad.getString("Statistics.Island.LastOnline");
        if (configLoad.getString("Island.Owner") != null && !configLoad.getString("Island.Owner").isEmpty()) {
            this.owner = FastUUID.parseUUID(configLoad.getString("Island.Owner"));
        }
    }

    public UUID getUUID() {
        return this.uuid;
    }

    public UUID getUniqueId() {
        return this.uuid;
    }

    public String getName() {
        return this.name;
    }

    public String getMemberSince() {
        return this.memberSince;
    }

    public String getLastOnline() {
        return this.lastOnline;
    }

    public UUID getOwner() {
        return this.owner;
    }

    public String[] getTexture() {
        return this.texture;
    }

    public int getPlaytime() {
        return this.playtime;
    }

    public org.bukkit.OfflinePlayer getBukkitOfflinePlayer() {
        return this.bukkitOfflinePlayer;
    }
}

