/*
 * Decompiled with CFR 0.152.
 */
package com.craftaro.skyblock.utils.item;

import com.craftaro.skyblock.SkyBlock;
import com.craftaro.skyblock.core.compatibility.CompatibleMaterial;
import com.craftaro.skyblock.utils.StringUtil;
import com.craftaro.skyblock.utils.item.nInventoryUtil;
import com.craftaro.third_party.com.cryptomorin.xseries.XMaterial;
import java.io.File;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public final class MenuClickRegistry {
    private static MenuClickRegistry instance;
    private final Set<MenuPopulator> populators;
    private final Map<RegistryKey, MenuExecutor> executors = new HashMap<RegistryKey, MenuExecutor>();

    public static MenuClickRegistry getInstance() {
        return instance == null ? (instance = new MenuClickRegistry()) : instance;
    }

    private MenuClickRegistry() {
        this.populators = new HashSet<MenuPopulator>();
    }

    public void register(MenuPopulator populator) {
        populator.populate(this.executors);
        this.populators.add(populator);
    }

    public void reloadAll() {
        this.executors.clear();
        for (MenuPopulator populator : this.populators) {
            populator.populate(this.executors);
        }
    }

    public void dispatch(Player clicker, nInventoryUtil.ClickEvent e) {
        ItemStack item = e.getItem();
        if (item == null) {
            return;
        }
        ItemMeta meta = item.getItemMeta();
        if (meta == null) {
            return;
        }
        MenuExecutor executor = this.executors.get(RegistryKey.fromName(meta.getDisplayName(), CompatibleMaterial.getMaterial(item.getType()).get()));
        if (executor == null) {
            return;
        }
        executor.onClick((SkyBlock)SkyBlock.getPlugin(SkyBlock.class), clicker, e);
    }

    public static interface MenuPopulator {
        public void populate(Map<RegistryKey, MenuExecutor> var1);
    }

    public static class RegistryKey {
        private static final File path = new File(((SkyBlock)SkyBlock.getPlugin(SkyBlock.class)).getDataFolder(), "language.yml");
        private final String name;
        private final XMaterial type;

        private RegistryKey(String name, XMaterial type) {
            this.name = name;
            this.type = type;
        }

        public int hashCode() {
            return Objects.hash(this.name, this.type);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof RegistryKey)) {
                return false;
            }
            RegistryKey other = (RegistryKey)obj;
            return Objects.equals(this.name, other.name) && this.type == other.type;
        }

        public static RegistryKey fromName(String name, XMaterial type) {
            return new RegistryKey(name, type);
        }

        public static RegistryKey fromLanguageFile(String namePath, XMaterial type) {
            return new RegistryKey(StringUtil.color(((SkyBlock)SkyBlock.getPlugin(SkyBlock.class)).getFileManager().getConfig(path).getFileConfiguration().getString(namePath)), type);
        }
    }

    public static interface MenuExecutor {
        public void onClick(SkyBlock var1, Player var2, nInventoryUtil.ClickEvent var3);
    }
}

