/*
 * Decompiled with CFR 0.152.
 */
package com.craftaro.skyblock.utils.item;

import com.craftaro.skyblock.core.compatibility.ClassMapping;
import com.craftaro.skyblock.core.compatibility.MajorServerVersion;
import com.craftaro.skyblock.core.compatibility.MethodMapping;
import com.craftaro.skyblock.core.compatibility.ServerVersion;
import com.craftaro.skyblock.core.utils.NMSUtils;
import com.craftaro.third_party.com.cryptomorin.xseries.XMaterial;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.lang.reflect.Constructor;
import java.math.BigInteger;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;

public class ItemStackUtil {
    private static final boolean isAbove1_16_R1 = MajorServerVersion.isServerVersionAtLeast(MajorServerVersion.V1_16) && !ServerVersion.getServerVersionString().equals("v1_16_R1");

    public static ItemStack deserializeItemStack(String data) {
        ByteArrayInputStream inputStream = new ByteArrayInputStream(new BigInteger(data, 32).toByteArray());
        DataInputStream dataInputStream = new DataInputStream(inputStream);
        ItemStack itemStack = null;
        if (ServerVersion.isServerVersionAtLeast(ServerVersion.V1_20_5)) {
            byte[] bytes = new BigInteger(data, 32).toByteArray();
            itemStack = ItemStack.deserializeBytes((byte[])bytes);
        } else {
            try {
                Object NBTTagCompound;
                Class<?> NBTTagCompoundClass = ClassMapping.NBT_TAG_COMPOUND.getClazz();
                Class<?> NMSItemStackClass = ClassMapping.ITEM_STACK.getClazz();
                Object object = NBTTagCompound = isAbove1_16_R1 ? ClassMapping.NBT_COMPRESSED_STREAM_TOOLS.getClazz().getMethod("a", DataInput.class).invoke(null, dataInputStream) : ClassMapping.NBT_COMPRESSED_STREAM_TOOLS.getClazz().getMethod("a", DataInputStream.class).invoke(null, dataInputStream);
                assert (NMSItemStackClass != null);
                Object craftItemStack = MajorServerVersion.isServerVersionAtLeast(MajorServerVersion.V1_13) ? NMSItemStackClass.getMethod("a", NBTTagCompoundClass).invoke(null, NBTTagCompound) : (MajorServerVersion.isServerVersionAtLeast(MajorServerVersion.V1_11) ? NMSItemStackClass.getConstructor(NBTTagCompoundClass).newInstance(NBTTagCompound) : NMSItemStackClass.getMethod("createStack", NBTTagCompoundClass).invoke(null, NBTTagCompound));
                itemStack = (ItemStack)NMSUtils.getCraftClass("inventory.CraftItemStack").getMethod("asBukkitCopy", NMSItemStackClass).invoke(null, craftItemStack);
                if (itemStack.getType() == Material.AIR) {
                    if (NBTTagCompound.toString().equals("{id:\"minecraft:sugar_cane\",Count:1b}")) {
                        itemStack = XMaterial.SUGAR_CANE.parseItem();
                    } else if (NBTTagCompound.toString().equals("{id:\"minecraft:melon_slice\",Count:1b}")) {
                        itemStack = XMaterial.MELON_SLICE.parseItem();
                    }
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return itemStack;
    }

    public static String serializeItemStack(ItemStack item) {
        if (ServerVersion.isServerVersionAtLeast(ServerVersion.V1_20_5)) {
            byte[] bytes = item.serializeAsBytes();
            return new BigInteger(bytes).toString(32);
        }
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutput = new DataOutputStream(outputStream);
        try {
            Class<?> NBTTagCompoundClass = ClassMapping.NBT_TAG_COMPOUND.getClazz();
            Constructor<?> nbtTagCompoundConstructor = NBTTagCompoundClass.getConstructor(new Class[0]);
            Object NBTTagCompound = nbtTagCompoundConstructor.newInstance(new Object[0]);
            Object nmsItemStack = MethodMapping.CB_ITEM_STACK__AS_NMS_COPY.getMethod(ClassMapping.CRAFT_ITEM_STACK.getClazz()).invoke(null, item);
            MethodMapping.ITEM_STACK__SAVE.getMethod(ClassMapping.ITEM_STACK.getClazz()).invoke(nmsItemStack, NBTTagCompound);
            ClassMapping.NBT_COMPRESSED_STREAM_TOOLS.getClazz().getMethod("a", NBTTagCompoundClass, DataOutput.class).invoke(null, NBTTagCompound, dataOutput);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return new BigInteger(1, outputStream.toByteArray()).toString(32);
    }
}

