/*
 * Decompiled with CFR 0.152.
 */
package com.craftaro.skyblock.utils.item;

import com.craftaro.skyblock.core.compatibility.MajorServerVersion;
import java.util.HashMap;
import org.bukkit.GameMode;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.Damageable;
import org.bukkit.inventory.meta.ItemMeta;

public class InventoryUtil {
    public static void removeItem(Inventory inv, int amount, boolean hasDisplayname, Material material) {
        HashMap ammo = inv.all(material);
        for (Integer index : ammo.keySet()) {
            ItemStack is = (ItemStack)ammo.get(index);
            ItemMeta im = is.getItemMeta();
            if (MajorServerVersion.isServerVersionAbove(MajorServerVersion.V1_12) ? ((Damageable)im).getDamage() != 0 : is.getDurability() != 0) continue;
            int removed = Math.min(amount, is.getAmount());
            amount -= removed;
            if (is.getAmount() == removed) {
                inv.setItem(index.intValue(), null);
            } else {
                is.setAmount(is.getAmount() - removed);
            }
            if (amount > 0) continue;
            break;
        }
    }

    public static boolean isInventoryFull(Inventory inv, int subtract, int amount, Material material) {
        for (int i = 0; i < inv.getSize() - subtract; ++i) {
            ItemMeta im;
            ItemStack is = inv.getItem(i);
            if (is == null) {
                return false;
            }
            if (is.getType() != material || (im = is.getItemMeta()).hasDisplayName() || (!MajorServerVersion.isServerVersionAbove(MajorServerVersion.V1_12) ? is.getDurability() != 0 : ((Damageable)im).getDamage() != 0)) continue;
            if (is.getAmount() >= is.getMaxStackSize() || is.getAmount() + amount > is.getMaxStackSize()) continue;
            return false;
        }
        return true;
    }

    public static void takeItem(Player player, int amount) {
        if (player.getGameMode() == GameMode.CREATIVE) {
            return;
        }
        ItemStack item = player.getInventory().getItemInMainHand();
        int result = item.getAmount() - amount;
        item.setAmount(result);
        player.getInventory().setItemInMainHand((ItemStack)(result > 0 ? item : null));
    }
}

