/*
 * Decompiled with CFR 0.152.
 */
package com.craftaro.skyblock.upgrade;

import com.craftaro.skyblock.SkyBlock;
import com.craftaro.skyblock.config.FileManager;
import com.craftaro.skyblock.island.Island;
import com.craftaro.skyblock.island.IslandManager;
import com.craftaro.skyblock.upgrade.Upgrade;
import java.io.File;
import java.io.IOException;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

public class UpgradeManager {
    private final SkyBlock plugin;
    private final Map<Upgrade.Type, List<Upgrade>> upgradeStorage = new HashMap<Upgrade.Type, List<Upgrade>>();

    public UpgradeManager(SkyBlock plugin) {
        AbstractList upgrades;
        this.plugin = plugin;
        FileConfiguration configLoad = plugin.getUpgrades();
        for (Upgrade.Type typeList : Upgrade.Type.values()) {
            if (typeList == Upgrade.Type.SIZE || typeList == Upgrade.Type.MEMBERS) continue;
            ArrayList<Upgrade> upgrades2 = new ArrayList<Upgrade>();
            Upgrade upgrade = new Upgrade(configLoad.getDouble("Upgrades." + typeList.getFriendlyName() + ".Cost"));
            upgrade.setEnabled(configLoad.getBoolean("Upgrades." + typeList.getFriendlyName() + ".Enable"));
            upgrades2.add(upgrade);
            this.upgradeStorage.put(typeList, upgrades2);
        }
        if (configLoad.getString("Upgrades.Size") != null) {
            upgrades = new ArrayList();
            for (String tierList : configLoad.getConfigurationSection("Upgrades.Size").getKeys(false)) {
                if (configLoad.getString("Upgrades.Size." + tierList + ".Value") != null && configLoad.getInt("Upgrades.Size." + tierList + ".Value") > 1000) continue;
                upgrades.add(new Upgrade(configLoad.getDouble("Upgrades.Size." + tierList + ".Cost"), configLoad.getInt("Upgrades.Size." + tierList + ".Value")));
            }
            this.upgradeStorage.put(Upgrade.Type.SIZE, upgrades);
        }
        if (configLoad.getString("Upgrades.Members") != null) {
            upgrades = new LinkedList();
            for (String tierList : configLoad.getConfigurationSection("Upgrades.Members").getKeys(false)) {
                if (configLoad.getString("Upgrades.Members." + tierList + ".Value") != null && configLoad.getInt("Upgrades.Members." + tierList + ".Value") > 1000) continue;
                upgrades.add(new Upgrade(configLoad.getDouble("Upgrades.Members." + tierList + ".Cost"), configLoad.getInt("Upgrades.Members." + tierList + ".Value")));
            }
            this.upgradeStorage.put(Upgrade.Type.MEMBERS, upgrades);
        }
        Bukkit.getScheduler().scheduleSyncRepeatingTask((Plugin)SkyBlock.getPlugin(SkyBlock.class), this::applyUpgrades, 5L, 20L);
    }

    public List<Upgrade> getUpgrades(Upgrade.Type type) {
        return this.upgradeStorage.get((Object)type);
    }

    public synchronized void addUpgrade(Upgrade.Type type, int value) {
        Upgrade upgrade;
        ArrayList<Upgrade> upgrades = new ArrayList<Upgrade>();
        FileManager.Config config = this.plugin.getFileManager().getConfig(new File(this.plugin.getDataFolder(), "upgrades.yml"));
        FileConfiguration configLoad = config.getFileConfiguration();
        if (configLoad.getString("Upgrades.Size") != null) {
            for (String tierList : configLoad.getConfigurationSection("Upgrades.Size").getKeys(false)) {
                upgrades.add(new Upgrade(configLoad.getDouble("Upgrades.Size." + tierList + ".Cost"), configLoad.getInt("Upgrades.Size." + tierList + ".Value")));
            }
        }
        upgrades.add(new Upgrade(0.0, value));
        configLoad.set("Upgrades.Size", null);
        for (int i = 0; i < upgrades.size(); ++i) {
            upgrade = (Upgrade)upgrades.get(i);
            configLoad.set("Upgrades.Size." + i + ".Value", (Object)upgrade.getValue());
            configLoad.set("Upgrades.Size." + i + ".Cost", (Object)upgrade.getCost());
        }
        if (configLoad.getString("Upgrades.Members") != null) {
            for (String tierList : configLoad.getConfigurationSection("Upgrades.Members").getKeys(false)) {
                upgrades.add(new Upgrade(configLoad.getDouble("Upgrades.Members." + tierList + ".Cost"), configLoad.getInt("Upgrades.Members." + tierList + ".Value")));
            }
        }
        upgrades.add(new Upgrade(0.0, value));
        configLoad.set("Upgrades.Members", null);
        for (int i = 0; i < upgrades.size(); ++i) {
            upgrade = (Upgrade)upgrades.get(i);
            configLoad.set("Upgrades.Members." + i + ".Value", (Object)upgrade.getValue());
            configLoad.set("Upgrades.Members." + i + ".Cost", (Object)upgrade.getCost());
        }
        this.upgradeStorage.put(type, upgrades);
        try {
            configLoad.save(config.getFile());
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    public void removeUpgrade(Upgrade.Type type, double cost, int value) {
        for (Upgrade upgradeList : this.upgradeStorage.get((Object)type)) {
            Upgrade upgrade;
            int i;
            if (upgradeList.getCost() != cost || upgradeList.getValue() != value) continue;
            List<Upgrade> upgrades = this.upgradeStorage.get((Object)type);
            upgrades.remove(upgradeList);
            FileManager.Config config = this.plugin.getFileManager().getConfig(new File(this.plugin.getDataFolder(), "upgrades.yml"));
            FileConfiguration configLoad = config.getFileConfiguration();
            configLoad.set("Upgrades.Size", null);
            for (i = 0; i < upgrades.size(); ++i) {
                upgrade = upgrades.get(i);
                configLoad.set("Upgrades.Size." + i + ".Value", (Object)upgrade.getValue());
                configLoad.set("Upgrades.Size." + i + ".Cost", (Object)upgrade.getCost());
            }
            configLoad.set("Upgrades.Members", null);
            for (i = 0; i < upgrades.size(); ++i) {
                upgrade = upgrades.get(i);
                configLoad.set("Upgrades.Members." + i + ".Value", (Object)upgrade.getValue());
                configLoad.set("Upgrades.Members." + i + ".Cost", (Object)upgrade.getCost());
            }
            try {
                configLoad.save(config.getFile());
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
            return;
        }
    }

    public boolean hasUpgrade(Upgrade.Type type, int value) {
        if (this.upgradeStorage.containsKey((Object)type)) {
            for (Upgrade upgradeList : this.upgradeStorage.get((Object)type)) {
                if (upgradeList.getValue() != value) continue;
                return true;
            }
        }
        return false;
    }

    private void applyUpgrades() {
        IslandManager islandManager = this.plugin.getIslandManager();
        UpgradeManager upgradeManager = this.plugin.getUpgradeManager();
        for (Player player : Bukkit.getOnlinePlayers()) {
            List<Upgrade> jumpUpgrades;
            List<Upgrade> speedUpgrades;
            Island island = islandManager.getIslandAtLocation(player.getLocation());
            if (island == null) continue;
            Collection potionEffects = player.getActivePotionEffects();
            PotionEffect speed = null;
            PotionEffect jump = null;
            for (PotionEffect potionEffect : potionEffects) {
                if (potionEffect.getType().equals((Object)PotionEffectType.SPEED)) {
                    speed = potionEffect;
                } else if (potionEffect.getType().equals((Object)PotionEffectType.JUMP)) {
                    jump = potionEffect;
                }
                if (speed == null || jump == null) continue;
                break;
            }
            if ((speedUpgrades = upgradeManager.getUpgrades(Upgrade.Type.SPEED)) != null && !speedUpgrades.isEmpty() && speedUpgrades.get(0).isEnabled() && island.isUpgrade(Upgrade.Type.SPEED)) {
                if (speed == null) {
                    speed = new PotionEffect(PotionEffectType.SPEED, 60, 1);
                } else if (speed.getAmplifier() == 1 && speed.getDuration() < 60) {
                    speed = new PotionEffect(PotionEffectType.SPEED, speed.getDuration() + 21, 1);
                }
                player.addPotionEffect(speed, true);
            }
            if ((jumpUpgrades = upgradeManager.getUpgrades(Upgrade.Type.JUMP)) == null || jumpUpgrades.isEmpty() || !jumpUpgrades.get(0).isEnabled() || !island.isUpgrade(Upgrade.Type.JUMP)) continue;
            if (jump == null) {
                jump = new PotionEffect(PotionEffectType.JUMP, 60, 1);
            } else if (jump.getAmplifier() == 1 && jump.getDuration() < 60) {
                jump = new PotionEffect(PotionEffectType.JUMP, jump.getDuration() + 21, 1);
            }
            player.addPotionEffect(jump, true);
            player.addPotionEffect(jump);
        }
    }
}

