/*
 * Decompiled with CFR 0.152.
 */
package com.craftaro.skyblock.tasks;

import com.craftaro.skyblock.SkyBlock;
import com.craftaro.skyblock.core.compatibility.MajorServerVersion;
import com.craftaro.skyblock.island.IslandWorld;
import com.craftaro.third_party.com.cryptomorin.xseries.XSound;
import org.bukkit.Bukkit;
import org.bukkit.Effect;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Blaze;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Ghast;
import org.bukkit.entity.MagmaCube;
import org.bukkit.entity.Skeleton;
import org.bukkit.entity.Wither;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class MobNetherWaterTask
extends BukkitRunnable {
    private static MobNetherWaterTask instance;
    private static SkyBlock plugin;

    public MobNetherWaterTask(SkyBlock plug) {
        plugin = plug;
    }

    public static MobNetherWaterTask startTask(SkyBlock plug) {
        plugin = plug;
        if (instance == null) {
            instance = new MobNetherWaterTask(plugin);
            instance.runTaskTimer((Plugin)plugin, 0L, 2L);
        }
        return instance;
    }

    public void run() {
        if (!plugin.getConfiguration().getBoolean("Island.Nether.WaterDisappearWithNetherMobs", false)) {
            return;
        }
        for (World world : Bukkit.getServer().getWorlds()) {
            if (!plugin.getWorldManager().isIslandWorld(world) || plugin.getWorldManager().getIslandWorld(world) != IslandWorld.NETHER) continue;
            for (Entity ent : world.getEntities()) {
                if (!this.isNetherMob(ent)) continue;
                this.removeWaterAround(world, ent.getLocation().getBlock());
            }
        }
    }

    private boolean isNetherMob(Entity ent) {
        if (ent instanceof Blaze || ent instanceof MagmaCube || ent instanceof Wither || ent instanceof Ghast) {
            return true;
        }
        if (MajorServerVersion.isServerVersionAtLeast(MajorServerVersion.V1_11)) {
            return ent.getType() == EntityType.WITHER_SKELETON;
        }
        return ent instanceof Skeleton && ((Skeleton)ent).getSkeletonType() == Skeleton.SkeletonType.WITHER;
    }

    private void removeWaterAround(World world, Block block) {
        this.removeWater(world, block);
        this.removeWater(world, block.getRelative(BlockFace.UP));
    }

    private void removeWater(World world, Block block) {
        if (block.getType() != Material.WATER) {
            return;
        }
        block.setType(Material.AIR, true);
        XSound.BLOCK_FIRE_EXTINGUISH.play(block.getLocation());
        world.playEffect(block.getLocation(), Effect.SMOKE, 1);
    }

    public void onDisable() {
    }
}

