/*
 * Decompiled with CFR 0.152.
 */
package com.craftaro.skyblock.tasks;

import com.craftaro.skyblock.SkyBlock;
import com.craftaro.skyblock.config.FileManager;
import com.craftaro.skyblock.core.utils.NumberUtils;
import com.craftaro.skyblock.core.utils.TextUtils;
import com.craftaro.skyblock.hologram.Hologram;
import com.craftaro.skyblock.hologram.HologramType;
import com.craftaro.skyblock.island.IslandLevel;
import com.craftaro.skyblock.leaderboard.Leaderboard;
import com.craftaro.skyblock.leaderboard.LeaderboardManager;
import com.craftaro.skyblock.utils.player.OfflinePlayer;
import com.craftaro.skyblock.utils.world.LocationUtil;
import com.craftaro.skyblock.visit.Visit;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class HologramTask
extends BukkitRunnable {
    private static HologramTask instance;
    private static SkyBlock plugin;
    private final List<Hologram> hologramStorage = new ArrayList<Hologram>();

    public HologramTask(SkyBlock plug) {
        plugin = plug;
    }

    public static HologramTask startTask(SkyBlock plug) {
        plugin = plug;
        if (instance == null) {
            instance = new HologramTask(plugin);
            instance.runTaskTimerAsynchronously((Plugin)plugin, 0L, 1200L);
        }
        return instance;
    }

    public void run() {
        for (HologramType hologramTypeList : HologramType.values()) {
            if (hologramTypeList == HologramType.VOTES && !plugin.getConfiguration().getBoolean("Island.Visitor.Vote")) continue;
            this.spawnHologram(hologramTypeList);
        }
    }

    public void onDisable() {
    }

    public void spawnHologram(HologramType type, Location location, List<String> lines) {
        Hologram hologram = this.hologramStorage.stream().filter(h -> LocationUtil.isLocationLocation(h.getLocation(), location)).findFirst().orElse(null);
        if (hologram == null) {
            this.hologramStorage.add(new Hologram(type, location, lines));
        } else {
            hologram.update(lines);
        }
    }

    public void spawnHologram(HologramType type) {
        FileManager fileManager = plugin.getFileManager();
        FileManager.Config locationsConfig = fileManager.getConfig(new File(plugin.getDataFolder(), "locations.yml"));
        FileConfiguration locationsConfigLoad = locationsConfig.getFileConfiguration();
        if (locationsConfigLoad.getString("Location.Hologram.Leaderboard." + type.getFriendlyName()) != null) {
            this.spawnHologram(type, plugin.getFileManager().getLocation(locationsConfig, "Location.Hologram.Leaderboard." + type.getFriendlyName(), true), this.getHologramLines(type));
        }
    }

    private List<String> getHologramLines(HologramType type) {
        LeaderboardManager leaderboardManager = plugin.getLeaderboardManager();
        FileConfiguration languageConfigLoad = plugin.getLanguage();
        ArrayList<String> hologramLines = new ArrayList<String>();
        Leaderboard.Type leaderboardType = null;
        switch (type) {
            case LEVEL: {
                leaderboardType = Leaderboard.Type.LEVEL;
                break;
            }
            case BANK: {
                leaderboardType = Leaderboard.Type.BANK;
                break;
            }
            case VOTES: {
                leaderboardType = Leaderboard.Type.VOTES;
            }
        }
        hologramLines.add(TextUtils.formatText(languageConfigLoad.getString("Hologram.Leaderboard." + type.getFriendlyName() + ".Header")));
        for (int i = 0; i < 10; ++i) {
            String islandOwnerName;
            Leaderboard leaderboard = leaderboardManager.getLeaderboardFromPosition(leaderboardType, i);
            if (leaderboard == null) continue;
            Visit visit = leaderboard.getVisit();
            Player targetPlayer = Bukkit.getServer().getPlayer(visit.getOwnerUUID());
            String string = islandOwnerName = targetPlayer == null ? new OfflinePlayer(visit.getOwnerUUID()).getName() : targetPlayer.getName();
            if (type == HologramType.LEVEL) {
                IslandLevel level = visit.getLevel();
                hologramLines.add(TextUtils.formatText(languageConfigLoad.getString("Hologram.Leaderboard." + type.getFriendlyName() + ".Claimed").replace("%position", "" + (i + 1)).replace("%player", islandOwnerName).replace("%level", NumberUtils.formatNumber(level.getLevel())).replace("%points", NumberUtils.formatNumber(level.getPoints()))));
                continue;
            }
            if (type == HologramType.BANK) {
                hologramLines.add(TextUtils.formatText(languageConfigLoad.getString("Hologram.Leaderboard." + type.getFriendlyName() + ".Claimed").replace("%position", "" + (i + 1)).replace("%player", islandOwnerName).replace("%balance", "" + NumberUtils.formatNumber(visit.getBankBalance()))));
                continue;
            }
            if (type != HologramType.VOTES) continue;
            hologramLines.add(TextUtils.formatText(languageConfigLoad.getString("Hologram.Leaderboard." + type.getFriendlyName() + ".Claimed").replace("%position", "" + (i + 1)).replace("%player", islandOwnerName).replace("%votes", "" + NumberUtils.formatNumber(visit.getVoters().size()))));
        }
        String hologramFooter = languageConfigLoad.getString("Hologram.Leaderboard." + type.getFriendlyName() + ".Footer");
        if (!hologramFooter.isEmpty()) {
            hologramLines.add(TextUtils.formatText(hologramFooter));
        }
        return hologramLines;
    }

    public Hologram getHologram(HologramType type) {
        return this.hologramStorage.stream().filter(hologramList -> hologramList.getType() == type).findFirst().orElse(null);
    }

    public void updateHologram() {
        new ArrayList<Hologram>(this.hologramStorage).forEach(hologramList -> hologramList.update(this.getHologramLines(hologramList.getType())));
    }

    public void removeHologram(Hologram hologram) {
        this.hologramStorage.remove(hologram);
        hologram.remove();
    }
}

