/*
 * Decompiled with CFR 0.152.
 */
package com.craftaro.skyblock.stackable;

import com.craftaro.skyblock.SkyBlock;
import com.craftaro.skyblock.core.compatibility.CompatibleMaterial;
import com.craftaro.skyblock.stackable.Stackable;
import com.craftaro.skyblock.third_party.com.eatthepath.uuid.FastUUID;
import com.craftaro.third_party.com.cryptomorin.xseries.XMaterial;
import java.io.File;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;

public class StackableManager {
    private final SkyBlock plugin;
    private final Set<XMaterial> stackableMaterials = EnumSet.noneOf(XMaterial.class);
    private final Map<Location, Stackable> stacks = new HashMap<Location, Stackable>();

    public StackableManager(SkyBlock plugin) {
        this.plugin = plugin;
        this.registerStackables();
    }

    public void registerStackables() {
        FileConfiguration configLoad = this.plugin.getStackables();
        List stackableList = configLoad.getStringList("Stackables");
        if (stackableList.isEmpty()) {
            return;
        }
        for (String stackableStr : stackableList) {
            Optional<XMaterial> stackableMaterial = CompatibleMaterial.getMaterial(stackableStr);
            stackableMaterial.ifPresent(this.stackableMaterials::add);
        }
    }

    public void loadSavedStackables() {
        File path = new File(this.plugin.getDataFolder(), "island-data");
        File[] files = path.listFiles();
        if (files == null) {
            return;
        }
        for (File file : files) {
            FileConfiguration config = this.plugin.getFileManager().getConfig(file).getFileConfiguration();
            ConfigurationSection stackableSection = config.getConfigurationSection("Stackables");
            if (stackableSection == null) continue;
            for (String key : stackableSection.getKeys(false)) {
                int size;
                Optional<XMaterial> type;
                ConfigurationSection currentSection = stackableSection.getConfigurationSection(key);
                Location loc = (Location)currentSection.get("Location");
                Block block = loc.getWorld().getBlockAt(loc);
                if (block.getType() == Material.AIR || !(type = CompatibleMaterial.getMaterial(block.getType())).isPresent() || (size = currentSection.getInt("Size")) == 0) continue;
                this.addStack(new Stackable(FastUUID.parseUUID(key), loc, type.get(), size));
            }
        }
    }

    public void unregisterStackables() {
        this.stackableMaterials.clear();
    }

    public Set<XMaterial> getStackableMaterials() {
        return Collections.unmodifiableSet(this.stackableMaterials);
    }

    public boolean isStackableMaterial(XMaterial material) {
        return this.stackableMaterials.contains(material);
    }

    public Map<Location, Stackable> getStacks() {
        return Collections.unmodifiableMap(this.stacks);
    }

    public boolean isStacked(Location location) {
        return this.stacks.containsKey(location);
    }

    public Stackable getStack(Location location, XMaterial material) {
        Stackable stackable = this.stacks.get(location);
        return stackable != null && stackable.getMaterial() == material ? stackable : null;
    }

    public Stackable addStack(Stackable stackable) {
        return this.stacks.put(stackable.getLocation(), stackable);
    }

    public void removeStack(Stackable stackable) {
        stackable.setSize(0);
        this.stacks.remove(stackable.getLocation());
    }

    public long getStackSizeOf(Location loc, XMaterial type) {
        Stackable stack = this.getStack(loc, type);
        return stack == null ? 0L : (long)stack.getSize();
    }
}

