/*
 * Decompiled with CFR 0.152.
 */
package com.craftaro.skyblock.scoreboard;

import com.craftaro.skyblock.SkyBlock;
import com.craftaro.skyblock.config.FileManager;
import com.craftaro.skyblock.island.Island;
import com.craftaro.skyblock.island.IslandManager;
import com.craftaro.skyblock.manager.Manager;
import com.craftaro.skyblock.playerdata.PlayerData;
import com.craftaro.skyblock.playerdata.PlayerDataManager;
import com.craftaro.skyblock.scoreboard.Driver;
import com.craftaro.skyblock.scoreboard.Holder;
import com.craftaro.skyblock.scoreboard.ScoreboardType;
import com.craftaro.skyblock.visit.Visit;
import io.netty.util.internal.ConcurrentSet;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scoreboard.Scoreboard;

public class ScoreboardManager
extends Manager {
    private final boolean enabled;
    private final Scoreboard emptyScoreboard;
    private final List<Driver> drivers;
    private final Set<Player> disabledPlayers;

    public ScoreboardManager(SkyBlock plugin) {
        super(plugin);
        FileManager fileManager = plugin.getFileManager();
        this.enabled = fileManager.getConfig(new File(plugin.getDataFolder(), "config.yml")).getFileConfiguration().getBoolean("Island.Scoreboard.Enable", true);
        this.drivers = new ArrayList<Driver>();
        this.disabledPlayers = new ConcurrentSet();
        this.emptyScoreboard = Bukkit.getScoreboardManager().getNewScoreboard();
        if (this.enabled) {
            for (ScoreboardType type : ScoreboardType.values()) {
                this.newDriver(type);
            }
            this.updateOnlinePlayers();
        }
    }

    @Override
    public void disable() {
        this.clearDrivers();
    }

    @Override
    public void reload() {
        this.disable();
        this.updateOnlinePlayers();
    }

    public void updateOnlinePlayers() {
        if (this.enabled) {
            for (Player player : this.plugin.getServer().getOnlinePlayers()) {
                this.updatePlayerScoreboardType(player);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updatePlayerScoreboardType(Player player) {
        ScoreboardType type;
        if (!this.enabled) {
            return;
        }
        PlayerDataManager playerDataManager = this.plugin.getPlayerDataManager();
        IslandManager islandManager = this.plugin.getIslandManager();
        PlayerData playerData = playerDataManager.getPlayerData(player);
        Island island = islandManager.getIsland((OfflinePlayer)player);
        if (!playerData.isScoreboard()) {
            return;
        }
        if (island != null) {
            boolean hasMembers;
            Visit islandVisit = island.getVisit();
            boolean hasVisitors = islandVisit != null && islandVisit.getVisitors() != null && islandVisit.getVisitors().size() > 1;
            boolean bl = hasMembers = islandVisit != null && islandVisit.getMembers() > 1;
            type = hasMembers ? (hasVisitors ? ScoreboardType.ISLAND_TEAM_VISITORS : ScoreboardType.ISLAND_TEAM_EMPTY) : (hasVisitors ? ScoreboardType.ISLAND_SOLO_VISITORS : ScoreboardType.ISLAND_SOLO_EMPTY);
        } else {
            type = ScoreboardType.NO_ISLAND;
        }
        Player player2 = player;
        synchronized (player2) {
            this.setPlayerScoreboard(player, type);
        }
    }

    public void setPlayerScoreboard(Player player, ScoreboardType type) {
        if (!this.enabled) {
            return;
        }
        for (Driver driver : this.drivers) {
            driver.unregisterHolder(player);
            if (driver.getBoardType() != type) continue;
            driver.registerHolder(new Holder(this.plugin, driver, player));
        }
    }

    public void unregisterPlayer(Player player) {
        if (!this.enabled) {
            return;
        }
        for (Driver driver : this.drivers) {
            driver.unregisterHolder(player);
        }
        player.setScoreboard(this.emptyScoreboard);
    }

    public void addDisabledPlayer(Player player) {
        if (this.enabled) {
            this.disabledPlayers.add(player);
            Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> this.unregisterPlayer(player));
        }
    }

    public void removeDisabledPlayer(Player player) {
        if (this.enabled) {
            this.disabledPlayers.remove(player);
        }
    }

    public boolean isPlayerDisabled(Player player) {
        return this.disabledPlayers.contains(player);
    }

    private void newDriver(ScoreboardType board) {
        FileManager fileManager = this.plugin.getFileManager();
        FileConfiguration configload = fileManager.getConfig(new File(this.plugin.getDataFolder(), "config.yml")).getFileConfiguration();
        Driver driver = new Driver(this.plugin, board);
        if (configload.getBoolean("Island.Scoreboard.Async", true)) {
            driver.runTaskTimerAsynchronously((Plugin)this.plugin, 1L, 1L);
        } else {
            driver.runTaskTimer((Plugin)this.plugin, 1L, 1L);
        }
        this.drivers.add(driver);
    }

    public void clearDrivers() {
        if (this.enabled) {
            for (Driver driver : this.drivers) {
                driver.cancel();
            }
            this.drivers.clear();
        }
    }

    public Scoreboard getEmptyScoreboard() {
        return this.emptyScoreboard;
    }
}

