/*
 * Decompiled with CFR 0.152.
 */
package com.craftaro.skyblock.scoreboard;

import com.craftaro.skyblock.SkyBlock;
import com.craftaro.skyblock.config.FileManager;
import com.craftaro.skyblock.scoreboard.Holder;
import com.craftaro.skyblock.scoreboard.Row;
import com.craftaro.skyblock.scoreboard.ScoreboardType;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.scheduler.BukkitRunnable;

class Driver
extends BukkitRunnable {
    private final Row title;
    private final List<Row> rows;
    private final List<Holder> holders;
    private final ScoreboardType boardType;

    Driver(SkyBlock plugin, ScoreboardType boardType) {
        FileManager fileManager = plugin.getFileManager();
        FileConfiguration scoreboardLoad = fileManager.getConfig(new File(plugin.getDataFolder(), "scoreboard.yml")).getFileConfiguration();
        this.rows = new ArrayList<Row>();
        this.holders = new ArrayList<Holder>();
        this.boardType = boardType;
        ConfigurationSection config = scoreboardLoad.getConfigurationSection(boardType.getConfigSection());
        if (config != null) {
            List lines = config.getStringList("Title.Content");
            int interval = config.getInt("Title.Interval");
            this.title = new Row(lines, interval);
            for (int i = 1; i < 16; ++i) {
                List rowLines = config.getStringList("Rows." + i + ".Content");
                if (rowLines.isEmpty()) continue;
                Row row = new Row(rowLines, config.getInt("Rows." + i + ".Interval"));
                this.rows.add(row);
            }
        } else {
            this.title = new Row(new ArrayList<String>(), -1);
        }
    }

    List<Row> getRows() {
        return this.rows;
    }

    Row getTitle() {
        return this.title;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void registerHolder(Holder holder) {
        List<Holder> list = this.holders;
        synchronized (list) {
            this.holders.add(holder);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void unregisterHolder(Holder holder) {
        List<Holder> list = this.holders;
        synchronized (list) {
            this.holders.remove(holder);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void unregisterHolder(Player player) {
        List<Holder> list = this.holders;
        synchronized (list) {
            Iterator<Holder> it = this.holders.iterator();
            while (it.hasNext()) {
                Holder holder = it.next();
                if (!holder.getPlayer().equals((Object)player)) continue;
                it.remove();
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        this.title.update();
        for (Row row : this.rows) {
            row.update();
        }
        List<Holder> list = this.holders;
        synchronized (list) {
            for (Holder holder : this.holders) {
                holder.update();
            }
        }
    }

    ScoreboardType getBoardType() {
        return this.boardType;
    }
}

