/*
 * Decompiled with CFR 0.152.
 */
package com.craftaro.skyblock.scoreboard;

import com.craftaro.skyblock.SkyBlock;
import com.craftaro.skyblock.core.compatibility.MajorServerVersion;
import com.craftaro.skyblock.placeholder.PlaceholderManager;
import com.craftaro.skyblock.scoreboard.ScoreboardLine;
import java.util.HashMap;
import org.bukkit.ChatColor;
import org.bukkit.entity.Player;
import org.bukkit.scoreboard.DisplaySlot;
import org.bukkit.scoreboard.Objective;
import org.bukkit.scoreboard.Scoreboard;
import org.bukkit.scoreboard.Team;

class Board {
    private final Player player;
    private final SkyBlock plugin;
    private final Scoreboard board;
    private final Objective objective;
    private final HashMap<Integer, String> cache = new HashMap();

    Board(SkyBlock plugin, Player player, int lineCount) {
        this.player = player;
        this.plugin = plugin;
        this.board = this.plugin.getServer().getScoreboardManager().getNewScoreboard();
        this.objective = MajorServerVersion.isServerVersionAtLeast(MajorServerVersion.V1_13) ? this.board.registerNewObjective("sb1", "sb2", "sb3") : this.board.registerNewObjective("sb1", "sb2");
        this.objective.setDisplaySlot(DisplaySlot.SIDEBAR);
        this.objective.setDisplayName("...");
        for (int i = 0; i < lineCount; ++i) {
            Team t = this.board.registerNewTeam(i + "");
            t.addEntry(ChatColor.values()[i] + "");
            this.objective.getScore(ChatColor.values()[i] + "").setScore(lineCount - i);
        }
    }

    void setTitle(String string) {
        PlaceholderManager placeholderManager = this.plugin.getPlaceholderManager();
        if (string == null) {
            string = "";
        }
        string = placeholderManager.parsePlaceholders(this.player, string);
        if (!this.cache.containsKey(-1) || !this.cache.get(-1).equals(string)) {
            this.cache.remove(-1);
            this.cache.put(-1, string);
            this.objective.setDisplayName(string);
        }
    }

    void setLine(int line, String string) {
        Team t = this.board.getTeam(String.valueOf(line));
        if (string == null) {
            string = "";
        }
        if (!(this.cache.containsKey(line) && this.cache.get(line).equals(string) || t == null)) {
            this.cache.remove(line);
            this.cache.put(line, string);
            ScoreboardLine parts = MajorServerVersion.isServerVersionAtLeast(MajorServerVersion.V1_13) ? this.convertIntoPieces(string, 64) : this.convertIntoPieces(string, 16);
            t.setPrefix(parts.getPrefix());
            t.setSuffix(parts.getSuffix());
        }
    }

    Scoreboard getBoard() {
        return this.board;
    }

    private ScoreboardLine convertIntoPieces(String line, int allowed_line_size) {
        String suffixLine;
        String prefixLine = line.substring(0, Math.min(line.length(), allowed_line_size));
        String string = suffixLine = line.length() <= allowed_line_size ? "" : line.substring(allowed_line_size, Math.min(line.length(), allowed_line_size * 2));
        if (prefixLine.endsWith(String.valueOf('\u00a7'))) {
            prefixLine = ChatColor.translateAlternateColorCodes((char)'\u00a7', (String)prefixLine.substring(0, prefixLine.length() - 1));
            suffixLine = ChatColor.translateAlternateColorCodes((char)'\u00a7', (String)('\u00a7' + suffixLine));
        } else {
            String lastColorCodes;
            if (prefixLine.contains(String.valueOf('\u00a7'))) {
                String[] colorCodes = prefixLine.split(String.valueOf('\u00a7'));
                String lastColorCodeText = colorCodes[colorCodes.length - 1];
                lastColorCodes = '\u00a7' + lastColorCodeText.substring(0, Math.min(lastColorCodeText.length(), 1));
                if (colorCodes.length >= 2 && (lastColorCodes.equals(String.valueOf(ChatColor.BOLD)) || lastColorCodes.equals(String.valueOf(ChatColor.STRIKETHROUGH)) || lastColorCodes.equals(String.valueOf(ChatColor.UNDERLINE)) || lastColorCodes.equals(String.valueOf(ChatColor.ITALIC)) || lastColorCodes.equals(String.valueOf(ChatColor.MAGIC)))) {
                    lastColorCodeText = colorCodes[colorCodes.length - 2];
                    lastColorCodes = '\u00a7' + lastColorCodeText.substring(0, Math.min(lastColorCodeText.length(), 1)) + lastColorCodes;
                }
            } else {
                lastColorCodes = ChatColor.WHITE.toString();
            }
            prefixLine = ChatColor.translateAlternateColorCodes((char)'\u00a7', (String)prefixLine);
            suffixLine = ChatColor.translateAlternateColorCodes((char)'\u00a7', (String)(lastColorCodes + suffixLine));
        }
        return new ScoreboardLine(prefixLine, suffixLine, allowed_line_size);
    }
}

