/*
 * Decompiled with CFR 0.152.
 */
package com.craftaro.skyblock.permission.permissions.listening;

import com.craftaro.skyblock.SkyBlock;
import com.craftaro.skyblock.core.compatibility.CompatibleMaterial;
import com.craftaro.skyblock.message.MessageManager;
import com.craftaro.skyblock.permission.ListeningPermission;
import com.craftaro.skyblock.permission.PermissionHandler;
import com.craftaro.skyblock.permission.PermissionType;
import com.craftaro.third_party.com.cryptomorin.xseries.XMaterial;
import java.util.Optional;
import org.bukkit.entity.Player;
import org.bukkit.event.Cancellable;
import org.bukkit.event.block.Action;
import org.bukkit.event.player.PlayerInteractEvent;

public class TrapdoorPermission
extends ListeningPermission {
    private final SkyBlock plugin;
    private final MessageManager messageManager;

    public TrapdoorPermission(SkyBlock plugin) {
        super("Trapdoor", XMaterial.OAK_TRAPDOOR, PermissionType.GENERIC);
        this.plugin = plugin;
        this.messageManager = plugin.getMessageManager();
    }

    @Override
    @PermissionHandler
    public void onInteract(PlayerInteractEvent event) {
        if (event.getAction() == Action.LEFT_CLICK_BLOCK) {
            return;
        }
        Player player = event.getPlayer();
        Optional<XMaterial> material = CompatibleMaterial.getMaterial(event.getClickedBlock().getType());
        if (!material.isPresent()) {
            return;
        }
        switch (material.get()) {
            case OAK_TRAPDOOR: 
            case BIRCH_TRAPDOOR: 
            case ACACIA_TRAPDOOR: 
            case JUNGLE_TRAPDOOR: 
            case SPRUCE_TRAPDOOR: 
            case WARPED_TRAPDOOR: 
            case CRIMSON_TRAPDOOR: 
            case DARK_OAK_TRAPDOOR: {
                this.cancelAndMessage((Cancellable)event, player, this.plugin, this.messageManager);
            }
        }
    }
}

