/*
 * Decompiled with CFR 0.152.
 */
package com.craftaro.skyblock.permission.permissions.listening;

import com.craftaro.skyblock.SkyBlock;
import com.craftaro.skyblock.message.MessageManager;
import com.craftaro.skyblock.permission.ListeningPermission;
import com.craftaro.skyblock.permission.PermissionHandler;
import com.craftaro.skyblock.permission.PermissionPriority;
import com.craftaro.skyblock.permission.PermissionType;
import com.craftaro.third_party.com.cryptomorin.xseries.XMaterial;
import org.bukkit.entity.Player;
import org.bukkit.event.Cancellable;
import org.bukkit.event.block.Action;
import org.bukkit.event.entity.ProjectileLaunchEvent;
import org.bukkit.event.player.PlayerInteractEvent;

public class ProjectilePermission
extends ListeningPermission {
    private final SkyBlock plugin;
    private final MessageManager messageManager;

    public ProjectilePermission(SkyBlock plugin) {
        super("Projectile", XMaterial.ARROW, PermissionType.GENERIC);
        this.plugin = plugin;
        this.messageManager = plugin.getMessageManager();
    }

    @Override
    @PermissionHandler
    public void onInteract(PlayerInteractEvent event) {
        if (event.getAction() == Action.RIGHT_CLICK_AIR || event.getAction() == Action.LEFT_CLICK_AIR) {
            return;
        }
        Player player = event.getPlayer();
        if (event.getItem() != null && XMaterial.EGG.isSimilar(event.getItem())) {
            this.cancelAndMessage((Cancellable)event, player, this.plugin, this.messageManager);
        }
    }

    @Override
    @PermissionHandler(priority=PermissionPriority.LAST)
    public void onProjectileLaunch(ProjectileLaunchEvent event) {
        if (event.getEntity().getShooter() instanceof Player) {
            this.cancelAndMessage((Cancellable)event, (Player)event.getEntity().getShooter(), this.plugin, this.messageManager);
        }
    }
}

