/*
 * Decompiled with CFR 0.152.
 */
package com.craftaro.skyblock.permission.permissions.listening;

import com.craftaro.skyblock.SkyBlock;
import com.craftaro.skyblock.core.compatibility.CompatibleMaterial;
import com.craftaro.skyblock.core.compatibility.MajorServerVersion;
import com.craftaro.skyblock.island.Island;
import com.craftaro.skyblock.island.IslandEnvironment;
import com.craftaro.skyblock.island.IslandManager;
import com.craftaro.skyblock.island.IslandRole;
import com.craftaro.skyblock.island.IslandWorld;
import com.craftaro.skyblock.message.MessageManager;
import com.craftaro.skyblock.permission.ListeningPermission;
import com.craftaro.skyblock.permission.PermissionHandler;
import com.craftaro.skyblock.permission.PermissionType;
import com.craftaro.skyblock.permission.event.events.PlayerEnterPortalEvent;
import com.craftaro.skyblock.utils.world.LocationUtil;
import com.craftaro.third_party.com.cryptomorin.xseries.XMaterial;
import java.io.File;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.bukkit.event.Cancellable;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.event.player.PlayerTeleportEvent;

public class PortalPermission
extends ListeningPermission {
    private final SkyBlock plugin;
    private final MessageManager messageManager;

    public PortalPermission(SkyBlock plugin) {
        super("Portal", XMaterial.ENDER_PEARL, PermissionType.GENERIC);
        this.plugin = plugin;
        this.messageManager = plugin.getMessageManager();
    }

    @Override
    @PermissionHandler
    public void onPortalEnter(PlayerEnterPortalEvent event) {
        if (event.getEntity() instanceof Player) {
            Player player = (Player)event.getEntity();
            this.cancelAndMessage(event, player, this.plugin, this.messageManager);
        }
    }

    @Override
    @PermissionHandler
    public void onMove(PlayerMoveEvent event) {
        XMaterial toMaterial;
        if (event.getTo() != null && ((toMaterial = (XMaterial)CompatibleMaterial.getMaterial(event.getTo().getBlock().getType()).orElse(null)) == XMaterial.NETHER_PORTAL || toMaterial == XMaterial.END_PORTAL)) {
            this.cancelAndMessage((Cancellable)event, event.getPlayer(), this.plugin, this.messageManager);
        }
    }

    @Override
    @PermissionHandler
    public void onTeleport(PlayerTeleportEvent event) {
        if (event.getCause() == PlayerTeleportEvent.TeleportCause.ENDER_PEARL || event.getCause() == PlayerTeleportEvent.TeleportCause.NETHER_PORTAL || event.getCause() == PlayerTeleportEvent.TeleportCause.END_PORTAL || MajorServerVersion.isServerVersionAtLeast(MajorServerVersion.V1_9) && event.getCause() == PlayerTeleportEvent.TeleportCause.END_GATEWAY) {
            this.cancelAndMessage((Cancellable)event, event.getPlayer(), this.plugin, this.messageManager);
        }
    }

    private Location getToLocation(Location from, Player player) {
        IslandManager islandManager = this.plugin.getIslandManager();
        Island island = islandManager.getIslandAtLocation(from);
        Location to = island.getLocation(IslandWorld.NORMAL, IslandEnvironment.MAIN);
        if (island.hasRole(IslandRole.VISITOR, player.getUniqueId())) {
            Location safeLoc;
            Location isLoc;
            if (this.plugin.getFileManager().getConfig(new File(this.plugin.getDataFolder(), "config.yml")).getFileConfiguration().getBoolean("Island.Teleport.SafetyCheck", true) && (isLoc = island.getLocation(IslandWorld.NORMAL, IslandEnvironment.VISITOR)) != null && (safeLoc = LocationUtil.getSafeLocation(isLoc)) != null) {
                to = safeLoc;
            }
            if (to == null) {
                to = LocationUtil.getSpawnLocation();
            }
        }
        return to;
    }
}

