/*
 * Decompiled with CFR 0.152.
 */
package com.craftaro.skyblock.permission.permissions.listening;

import com.craftaro.skyblock.SkyBlock;
import com.craftaro.skyblock.message.MessageManager;
import com.craftaro.skyblock.permission.ListeningPermission;
import com.craftaro.skyblock.permission.PermissionHandler;
import com.craftaro.skyblock.permission.PermissionType;
import com.craftaro.third_party.com.cryptomorin.xseries.XMaterial;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Horse;
import org.bukkit.entity.Player;
import org.bukkit.event.Cancellable;
import org.bukkit.event.inventory.InventoryOpenEvent;
import org.bukkit.event.player.PlayerInteractEntityEvent;
import org.bukkit.inventory.HorseInventory;

public class HorseInventoryPermission
extends ListeningPermission {
    private final SkyBlock plugin;
    private final MessageManager messageManager;

    public HorseInventoryPermission(SkyBlock plugin) {
        super("HorseInventory", XMaterial.DIAMOND_HORSE_ARMOR, PermissionType.GENERIC);
        this.plugin = plugin;
        this.messageManager = plugin.getMessageManager();
    }

    @Override
    @PermissionHandler
    public void onInteractEntity(PlayerInteractEntityEvent event) {
        Horse horse;
        Player player = event.getPlayer();
        Entity entity = event.getRightClicked();
        if (entity.getType() == EntityType.HORSE && (horse = (Horse)event.getRightClicked()).getInventory().getSaddle() != null && player.isSneaking()) {
            this.cancelAndMessage((Cancellable)event, player, this.plugin, this.messageManager);
        }
    }

    @Override
    @PermissionHandler
    public void onInventoryOpen(InventoryOpenEvent event) {
        if (!(event.getInventory() instanceof HorseInventory)) {
            return;
        }
        this.cancelAndMessage((Cancellable)event, (Player)event.getPlayer(), this.plugin, this.messageManager);
    }
}

