/*
 * Decompiled with CFR 0.152.
 */
package com.craftaro.skyblock.permission;

import com.craftaro.skyblock.SkyBlock;
import com.craftaro.skyblock.core.utils.TextUtils;
import com.craftaro.skyblock.island.Island;
import com.craftaro.skyblock.island.IslandRole;
import com.craftaro.skyblock.permission.PermissionType;
import com.craftaro.third_party.com.cryptomorin.xseries.XMaterial;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public abstract class BasicPermission {
    private final String name;
    private final XMaterial icon;
    private final PermissionType type;
    private final Map<IslandRole, Boolean> defaultValues;

    protected BasicPermission(@Nonnull String name, @Nonnull XMaterial icon, @Nonnull PermissionType type) {
        this(name, icon, type, new HashMap<IslandRole, Boolean>());
    }

    protected BasicPermission(@Nonnull String name, @Nonnull XMaterial icon, @Nonnull PermissionType type, Map<IslandRole, Boolean> defaultValues) {
        this.name = name;
        this.icon = icon;
        this.type = type;
        if (defaultValues.isEmpty()) {
            this.defaultValues = new HashMap<IslandRole, Boolean>();
            this.defaultValues.put(IslandRole.VISITOR, false);
            this.defaultValues.put(IslandRole.MEMBER, true);
            this.defaultValues.put(IslandRole.OPERATOR, true);
            this.defaultValues.put(IslandRole.COOP, true);
            this.defaultValues.put(IslandRole.OWNER, true);
        } else {
            this.defaultValues = defaultValues;
        }
    }

    public ItemStack getItem(Island island, IslandRole role) {
        return this.getItem(island.hasPermission(role, this), role);
    }

    public ItemStack getItem(boolean permissionEnabled, IslandRole role) {
        ItemStack is = this.icon.parseItem();
        FileConfiguration configLoad = SkyBlock.getInstance().getLanguage();
        ArrayList<String> itemLore = new ArrayList<String>();
        ItemMeta im = is.getItemMeta();
        String roleName = role.getFriendlyName();
        if (role == IslandRole.VISITOR || role == IslandRole.MEMBER || role == IslandRole.COOP) {
            roleName = "Default";
        }
        String nameFinal = TextUtils.formatText(configLoad.getString("Menu.Settings." + roleName + ".Item.Setting." + this.name + ".Displayname", this.name));
        if (im != null) {
            im.setDisplayName(nameFinal);
            for (String itemLoreList : configLoad.getStringList("Menu.Settings." + roleName + ".Item.Setting.Status." + (permissionEnabled ? "Enabled" : "Disabled") + ".Lore")) {
                itemLore.add(TextUtils.formatText(itemLoreList));
            }
            im.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ATTRIBUTES});
            im.setLore(itemLore);
            is.setItemMeta(im);
        }
        return is;
    }

    public String getName() {
        return this.name;
    }

    public XMaterial getIcon() {
        return this.icon;
    }

    public PermissionType getType() {
        return this.type;
    }

    public Map<IslandRole, Boolean> getDefaultValues() {
        return this.defaultValues;
    }
}

