/*
 * Decompiled with CFR 0.152.
 */
package com.craftaro.skyblock.message;

import com.craftaro.skyblock.SkyBlock;
import com.craftaro.skyblock.placeholder.PlaceholderManager;
import java.util.ArrayList;
import java.util.Arrays;
import me.clip.placeholderapi.PlaceholderAPI;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class MessageManager {
    private final SkyBlock plugin;

    public MessageManager(SkyBlock plugin) {
        this.plugin = plugin;
    }

    public void sendMessage(CommandSender sender, String message) {
        if (message == null || message.isEmpty()) {
            return;
        }
        if (sender instanceof Player) {
            PlaceholderManager placeholderManager = this.plugin.getPlaceholderManager();
            Player player = (Player)sender;
            if (placeholderManager.isPlaceholderAPIEnabled()) {
                message = PlaceholderAPI.setPlaceholders((Player)player, (String)message.replace("&", "clr")).replace("clr", "&");
            }
            if (message.contains("\n") || message.contains("\\n")) {
                ArrayList<String> messages = new ArrayList<String>();
                message = message.replace("\\n", "\n");
                for (String messageList2 : message.split("\n")) {
                    messages.add(ChatColor.translateAlternateColorCodes((char)'&', (String)messageList2));
                }
                sender.sendMessage(messages.toArray(new String[0]));
            } else {
                sender.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)message));
            }
        } else if (message.contains("\n") || message.contains("\\n")) {
            message = message.replace("\\n", "\n");
            sender.sendMessage((String[])Arrays.stream(message.split("\n")).map(messageList -> ChatColor.stripColor((String)this.plugin.formatText((String)messageList))).toArray(String[]::new));
        } else {
            sender.sendMessage(ChatColor.stripColor((String)ChatColor.translateAlternateColorCodes((char)'&', (String)message)));
        }
    }

    public String replaceMessage(Player player, String message) {
        PlaceholderManager placeholderManager = this.plugin.getPlaceholderManager();
        if (placeholderManager.isPlaceholderAPIEnabled()) {
            message = PlaceholderAPI.setPlaceholders((Player)player, (String)message.replace("&", "clr")).replace("clr", "&");
        }
        return message;
    }
}

