/*
 * Decompiled with CFR 0.152.
 */
package com.craftaro.skyblock.menus.admin;

import com.craftaro.skyblock.SkyBlock;
import com.craftaro.skyblock.config.FileManager;
import com.craftaro.skyblock.core.compatibility.MajorServerVersion;
import com.craftaro.skyblock.core.gui.AnvilGui;
import com.craftaro.skyblock.core.utils.NumberUtils;
import com.craftaro.skyblock.message.MessageManager;
import com.craftaro.skyblock.placeholder.Placeholder;
import com.craftaro.skyblock.playerdata.PlayerData;
import com.craftaro.skyblock.playerdata.PlayerDataManager;
import com.craftaro.skyblock.sound.SoundManager;
import com.craftaro.skyblock.upgrade.Upgrade;
import com.craftaro.skyblock.upgrade.UpgradeManager;
import com.craftaro.skyblock.utils.item.nInventoryUtil;
import com.craftaro.third_party.com.cryptomorin.xseries.XMaterial;
import com.craftaro.third_party.com.cryptomorin.xseries.XSound;
import java.io.File;
import java.io.IOException;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.PotionMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionData;
import org.bukkit.potion.PotionType;

public class Upgrade {
    private static Upgrade instance;

    public static Upgrade getInstance() {
        if (instance == null) {
            instance = new Upgrade();
        }
        return instance;
    }

    public void open(Player player) {
        SkyBlock plugin = SkyBlock.getInstance();
        PlayerDataManager playerDataManager = plugin.getPlayerDataManager();
        MessageManager messageManager = plugin.getMessageManager();
        UpgradeManager upgradeManager = plugin.getUpgradeManager();
        SoundManager soundManager = plugin.getSoundManager();
        FileManager fileManager = plugin.getFileManager();
        if (playerDataManager.hasPlayerData(player) && playerDataManager.getPlayerData(player).getViewer() != null) {
            FileConfiguration configLoad = plugin.getLanguage();
            Viewer viewer = (Viewer)playerDataManager.getPlayerData(player).getViewer();
            if (viewer == null || viewer.getType() == Viewer.Type.UPGRADES) {
                PotionMeta pm;
                nInventoryUtil nInv = new nInventoryUtil(player, event -> {
                    if (!(player.hasPermission("fabledskyblock.admin.upgrade") || player.hasPermission("fabledskyblock.admin.*") || player.hasPermission("fabledskyblock.*"))) {
                        messageManager.sendMessage((CommandSender)player, configLoad.getString("Island.Admin.Upgrade.Permission.Message"));
                        soundManager.playSound((CommandSender)player, XSound.BLOCK_ANVIL_LAND);
                        return;
                    }
                    ItemStack is = event.getItem();
                    com.craftaro.skyblock.upgrade.Upgrade upgrade = null;
                    if (is.getType() == XMaterial.OAK_FENCE_GATE.parseMaterial() && is.hasItemMeta() && is.getItemMeta().getDisplayName().equals(plugin.formatText(configLoad.getString("Menu.Admin.Upgrade.Upgrades.Item.Exit.Displayname")))) {
                        soundManager.playSound((CommandSender)player, XSound.BLOCK_CHEST_CLOSE);
                        return;
                    }
                    if (is.getType() == Material.POTION && is.hasItemMeta()) {
                        if (is.getItemMeta().getDisplayName().equals(plugin.formatText(configLoad.getString("Menu.Admin.Upgrade.Upgrades.Item.Speed.Displayname")))) {
                            upgrade = upgradeManager.getUpgrades(Upgrade.Type.SPEED).get(0);
                            viewer.setUpgrade(Upgrade.Type.SPEED);
                        } else if (is.getItemMeta().getDisplayName().equals(plugin.formatText(configLoad.getString("Menu.Admin.Upgrade.Upgrades.Item.Jump.Displayname")))) {
                            upgrade = upgradeManager.getUpgrades(Upgrade.Type.JUMP).get(0);
                            viewer.setUpgrade(Upgrade.Type.JUMP);
                        }
                    } else if (is.getType() == XMaterial.WHEAT_SEEDS.parseMaterial() && is.hasItemMeta() && is.getItemMeta().getDisplayName().equals(plugin.formatText(configLoad.getString("Menu.Admin.Upgrade.Upgrades.Item.Crop.Displayname")))) {
                        upgrade = upgradeManager.getUpgrades(Upgrade.Type.CROP).get(0);
                        viewer.setUpgrade(Upgrade.Type.CROP);
                    } else if (is.getType() == Material.FEATHER && is.hasItemMeta() && is.getItemMeta().getDisplayName().equals(plugin.formatText(configLoad.getString("Menu.Admin.Upgrade.Upgrades.Item.Fly.Displayname")))) {
                        upgrade = upgradeManager.getUpgrades(Upgrade.Type.FLY).get(0);
                        viewer.setUpgrade(Upgrade.Type.FLY);
                    } else if (is.getType() == Material.SPIDER_EYE && is.hasItemMeta() && is.getItemMeta().getDisplayName().equals(plugin.formatText(configLoad.getString("Menu.Admin.Upgrade.Upgrades.Item.Drops.Displayname")))) {
                        upgrade = upgradeManager.getUpgrades(Upgrade.Type.DROPS).get(0);
                        viewer.setUpgrade(Upgrade.Type.DROPS);
                    } else if (is.getType() == Material.BEACON && is.hasItemMeta() && is.getItemMeta().getDisplayName().equals(plugin.formatText(configLoad.getString("Menu.Admin.Upgrade.Upgrades.Item.Size.Displayname")))) {
                        viewer.setType(Viewer.Type.SIZE);
                        viewer.setUpgrade(Upgrade.Type.SIZE);
                        soundManager.playSound((CommandSender)player, XSound.BLOCK_WOODEN_BUTTON_CLICK_ON);
                        Bukkit.getServer().getScheduler().runTaskLater((Plugin)plugin, () -> this.open(player), 1L);
                    } else if (is.getType() == Material.BOOKSHELF && is.hasItemMeta() && is.getItemMeta().getDisplayName().equals(plugin.formatText(configLoad.getString("Menu.Admin.Upgrade.Upgrades.Item.Members.Displayname")))) {
                        viewer.setType(Viewer.Type.MEMBERS);
                        viewer.setUpgrade(Upgrade.Type.MEMBERS);
                        soundManager.playSound((CommandSender)player, XSound.BLOCK_WOODEN_BUTTON_CLICK_ON);
                        Bukkit.getServer().getScheduler().runTaskLater((Plugin)plugin, () -> this.open(player), 1L);
                    } else if (is.getType() == XMaterial.SPAWNER.parseMaterial() && is.hasItemMeta() && is.getItemMeta().getDisplayName().equals(plugin.formatText(configLoad.getString("Menu.Admin.Upgrade.Upgrades.Item.Spawner.Displayname")))) {
                        upgrade = upgradeManager.getUpgrades(Upgrade.Type.SPAWNER).get(0);
                        viewer.setUpgrade(Upgrade.Type.SPAWNER);
                    }
                    if (upgrade != null) {
                        if (event.getClick() == ClickType.LEFT) {
                            upgrade.setEnabled(!upgrade.isEnabled());
                            if (playerDataManager.hasPlayerData(player)) {
                                Upgrade.Type upgradeType = ((Viewer)playerDataManager.getPlayerData(player).getViewer()).getUpgrade();
                                boolean enabled = upgrade.isEnabled();
                                Bukkit.getServer().getScheduler().runTaskAsynchronously((Plugin)plugin, () -> {
                                    FileManager.Config config = fileManager.getConfig(new File(plugin.getDataFolder(), "upgrades.yml"));
                                    FileConfiguration configLoad1 = config.getFileConfiguration();
                                    configLoad1.set("Upgrades." + upgradeType.getFriendlyName() + ".Enable", (Object)enabled);
                                    try {
                                        configLoad1.save(config.getFile());
                                    }
                                    catch (IOException ex) {
                                        ex.printStackTrace();
                                    }
                                });
                            }
                            soundManager.playSound((CommandSender)player, XSound.BLOCK_WOODEN_BUTTON_CLICK_ON);
                            Bukkit.getServer().getScheduler().runTaskLater((Plugin)plugin, () -> this.open(player), 1L);
                        } else if (event.getClick() == ClickType.RIGHT) {
                            soundManager.playSound((CommandSender)player, XSound.BLOCK_WOODEN_BUTTON_CLICK_ON);
                            Bukkit.getServer().getScheduler().runTaskLater((Plugin)plugin, () -> {
                                AnvilGui gui = new AnvilGui(player);
                                gui.setAction(event1 -> {
                                    if (!(player.hasPermission("fabledskyblock.admin.upgrade") || player.hasPermission("fabledskyblock.admin.*") || player.hasPermission("fabledskyblock.*"))) {
                                        messageManager.sendMessage((CommandSender)player, configLoad.getString("Island.Admin.Upgrade.Permission.Message"));
                                        soundManager.playSound((CommandSender)player, XSound.BLOCK_ANVIL_LAND);
                                        return;
                                    }
                                    if (!gui.getInputText().matches("[0-9]+") && !gui.getInputText().matches("([0-9]*)\\.([0-9]{1,2}$)")) {
                                        messageManager.sendMessage((CommandSender)player, configLoad.getString("Island.Admin.Upgrade.Numerical.Message"));
                                        soundManager.playSound((CommandSender)player, XSound.BLOCK_ANVIL_LAND);
                                        player.closeInventory();
                                        return;
                                    }
                                    if (playerDataManager.hasPlayerData(player)) {
                                        double upgradeCost = Double.parseDouble(gui.getInputText());
                                        Upgrade.Type upgradeType = ((Viewer)playerDataManager.getPlayerData(player).getViewer()).getUpgrade();
                                        com.craftaro.skyblock.upgrade.Upgrade upgrade1 = upgradeManager.getUpgrades(upgradeType).get(0);
                                        upgrade1.setCost(upgradeCost);
                                        soundManager.playSound((CommandSender)player, XSound.BLOCK_NOTE_BLOCK_PLING);
                                        Bukkit.getServer().getScheduler().runTaskAsynchronously((Plugin)plugin, () -> {
                                            FileManager.Config config = fileManager.getConfig(new File(plugin.getDataFolder(), "upgrades.yml"));
                                            FileConfiguration configLoad1 = config.getFileConfiguration();
                                            configLoad1.set("Upgrades." + upgradeType.getFriendlyName() + ".Cost", (Object)upgradeCost);
                                            try {
                                                configLoad1.save(config.getFile());
                                            }
                                            catch (IOException ex) {
                                                ex.printStackTrace();
                                            }
                                        });
                                        Bukkit.getServer().getScheduler().runTaskLater((Plugin)plugin, () -> this.open(player), 1L);
                                    }
                                    player.closeInventory();
                                });
                                ItemStack is1 = new ItemStack(Material.NAME_TAG);
                                ItemMeta im = is1.getItemMeta();
                                im.setDisplayName(configLoad.getString("Menu.Admin.Upgrade.Upgrades.Item.Word.Enter"));
                                is1.setItemMeta(im);
                                gui.setInput(is1);
                                plugin.getGuiManager().showGUI(player, gui);
                            }, 1L);
                        } else {
                            event.setWillClose(false);
                            event.setWillDestroy(false);
                        }
                    }
                });
                ItemStack speedPotion = new ItemStack(Material.POTION);
                ItemStack jumpPotion = new ItemStack(Material.POTION);
                if (MajorServerVersion.isServerVersionAtLeast(MajorServerVersion.V1_13)) {
                    pm = (PotionMeta)speedPotion.getItemMeta();
                    pm.setBasePotionData(new PotionData(PotionType.SPEED));
                    speedPotion.setItemMeta((ItemMeta)pm);
                } else {
                    speedPotion = new ItemStack(Material.POTION, 1, 8194);
                }
                com.craftaro.skyblock.upgrade.Upgrade upgrade = upgradeManager.getUpgrades(Upgrade.Type.SPEED).get(0);
                nInv.addItem(nInv.createItem(speedPotion, plugin.formatText(configLoad.getString("Menu.Admin.Upgrade.Upgrades.Item.Speed.Displayname")), configLoad.getStringList("Menu.Admin.Upgrade.Upgrades.Item.Speed.Lore"), new Placeholder[]{new Placeholder("%cost", NumberUtils.formatNumber(upgrade.getCost())), new Placeholder("%status", this.getStatus(upgrade))}, null, new ItemFlag[]{ItemFlag.HIDE_POTION_EFFECTS}), 0);
                if (MajorServerVersion.isServerVersionAtLeast(MajorServerVersion.V1_13)) {
                    pm = (PotionMeta)jumpPotion.getItemMeta();
                    pm.setBasePotionData(new PotionData(PotionType.JUMP));
                    jumpPotion.setItemMeta((ItemMeta)pm);
                } else {
                    jumpPotion = new ItemStack(Material.POTION, 1, 8203);
                }
                upgrade = upgradeManager.getUpgrades(Upgrade.Type.JUMP).get(0);
                nInv.addItem(nInv.createItem(jumpPotion, plugin.formatText(configLoad.getString("Menu.Admin.Upgrade.Upgrades.Item.Jump.Displayname")), configLoad.getStringList("Menu.Admin.Upgrade.Upgrades.Item.Jump.Lore"), new Placeholder[]{new Placeholder("%cost", NumberUtils.formatNumber(upgrade.getCost())), new Placeholder("%status", this.getStatus(upgrade))}, null, new ItemFlag[]{ItemFlag.HIDE_POTION_EFFECTS}), 1);
                upgrade = upgradeManager.getUpgrades(Upgrade.Type.CROP).get(0);
                nInv.addItem(nInv.createItem(XMaterial.WHEAT_SEEDS.parseItem(), plugin.formatText(configLoad.getString("Menu.Admin.Upgrade.Upgrades.Item.Crop.Displayname")), configLoad.getStringList("Menu.Admin.Upgrade.Upgrades.Item.Crop.Lore"), new Placeholder[]{new Placeholder("%cost", NumberUtils.formatNumber(upgrade.getCost())), new Placeholder("%status", this.getStatus(upgrade))}, null, null), 2);
                upgrade = upgradeManager.getUpgrades(Upgrade.Type.FLY).get(0);
                nInv.addItem(nInv.createItem(new ItemStack(Material.FEATHER), plugin.formatText(configLoad.getString("Menu.Admin.Upgrade.Upgrades.Item.Fly.Displayname")), configLoad.getStringList("Menu.Admin.Upgrade.Upgrades.Item.Fly.Lore"), new Placeholder[]{new Placeholder("%cost", NumberUtils.formatNumber(upgrade.getCost())), new Placeholder("%status", this.getStatus(upgrade))}, null, null), 3);
                upgrade = upgradeManager.getUpgrades(Upgrade.Type.DROPS).get(0);
                nInv.addItem(nInv.createItem(new ItemStack(Material.SPIDER_EYE), plugin.formatText(configLoad.getString("Menu.Admin.Upgrade.Upgrades.Item.Drops.Displayname")), configLoad.getStringList("Menu.Admin.Upgrade.Upgrades.Item.Drops.Lore"), new Placeholder[]{new Placeholder("%cost", NumberUtils.formatNumber(upgrade.getCost())), new Placeholder("%status", this.getStatus(upgrade))}, null, null), 4);
                List<com.craftaro.skyblock.upgrade.Upgrade> upgradesSize = upgradeManager.getUpgrades(Upgrade.Type.SIZE);
                int upgradeTiersSize = 0;
                if (upgradesSize != null) {
                    upgradeTiersSize = upgradesSize.size();
                }
                nInv.addItem(nInv.createItem(new ItemStack(Material.BEACON), plugin.formatText(configLoad.getString("Menu.Admin.Upgrade.Upgrades.Item.Size.Displayname")), configLoad.getStringList("Menu.Admin.Upgrade.Upgrades.Item.Size.Lore"), new Placeholder[]{new Placeholder("%tiers", "" + upgradeTiersSize)}, null, null), 5);
                List<com.craftaro.skyblock.upgrade.Upgrade> upgradesMembers = upgradeManager.getUpgrades(Upgrade.Type.MEMBERS);
                int upgradeTiersMembers = 0;
                if (upgradesMembers != null) {
                    upgradeTiersMembers = upgradesMembers.size();
                }
                nInv.addItem(nInv.createItem(XMaterial.BOOKSHELF.parseItem(), plugin.formatText(configLoad.getString("Menu.Admin.Upgrade.Upgrades.Item.Members.Displayname")), configLoad.getStringList("Menu.Admin.Upgrade.Upgrades.Item.Members.Lore"), new Placeholder[]{new Placeholder("%tiers", "" + upgradeTiersMembers)}, null, null), 4);
                upgrade = upgradeManager.getUpgrades(Upgrade.Type.SPAWNER).get(0);
                nInv.addItem(nInv.createItem(XMaterial.SPAWNER.parseItem(), plugin.formatText(configLoad.getString("Menu.Admin.Upgrade.Upgrades.Item.Spawner.Displayname")), configLoad.getStringList("Menu.Admin.Upgrade.Upgrades.Item.Spawner.Lore"), new Placeholder[]{new Placeholder("%cost", NumberUtils.formatNumber(upgrade.getCost())), new Placeholder("%status", this.getStatus(upgrade))}, null, null), 6);
                nInv.addItem(nInv.createItem(XMaterial.OAK_FENCE_GATE.parseItem(), plugin.formatText(configLoad.getString("Menu.Admin.Upgrade.Upgrades.Item.Exit.Displayname")), null, null, null, null), 8);
                nInv.setTitle(plugin.formatText(configLoad.getString("Menu.Admin.Upgrade.Upgrades.Title")));
                nInv.setRows(1);
                Bukkit.getServer().getScheduler().runTask((Plugin)plugin, nInv::open);
            } else if (viewer.getType() == Viewer.Type.SIZE) {
                nInventoryUtil nInv = new nInventoryUtil(player, event -> {
                    if (!(player.hasPermission("fabledskyblock.admin.upgrade") || player.hasPermission("fabledskyblock.admin.*") || player.hasPermission("fabledskyblock.*"))) {
                        messageManager.sendMessage((CommandSender)player, configLoad.getString("Island.Admin.Upgrade.Permission.Message"));
                        soundManager.playSound((CommandSender)player, XSound.BLOCK_ANVIL_LAND);
                        return;
                    }
                    if (playerDataManager.hasPlayerData(player)) {
                        PlayerData playerData = playerDataManager.getPlayerData(player);
                        ItemStack is = event.getItem();
                        if (is.getType() == XMaterial.OAK_FENCE_GATE.parseMaterial() && is.hasItemMeta() && is.getItemMeta().getDisplayName().equals(plugin.formatText(configLoad.getString("Menu.Admin.Upgrade.Size.Item.Return.Displayname")))) {
                            playerData.setViewer(new Viewer(Viewer.Type.UPGRADES, null));
                            soundManager.playSound((CommandSender)player, XSound.ENTITY_ARROW_HIT);
                            Bukkit.getServer().getScheduler().runTaskLater((Plugin)plugin, () -> this.open(player), 1L);
                        } else if (is.getType() == Material.PAINTING && is.hasItemMeta() && is.getItemMeta().getDisplayName().equals(plugin.formatText(configLoad.getString("Menu.Admin.Upgrade.Size.Item.Information.Displayname")))) {
                            List<com.craftaro.skyblock.upgrade.Upgrade> upgrades = upgradeManager.getUpgrades(Upgrade.Type.SIZE);
                            if (upgrades != null && upgrades.size() >= 5) {
                                messageManager.sendMessage((CommandSender)player, configLoad.getString("Island.Admin.Upgrade.Tier.Limit.Message"));
                                soundManager.playSound((CommandSender)player, XSound.BLOCK_ANVIL_LAND);
                                event.setWillClose(false);
                                event.setWillDestroy(false);
                            } else {
                                soundManager.playSound((CommandSender)player, XSound.BLOCK_WOODEN_BUTTON_CLICK_ON);
                                Bukkit.getServer().getScheduler().runTaskLater((Plugin)plugin, () -> {
                                    AnvilGui gui = new AnvilGui(player);
                                    gui.setAction(event1 -> {
                                        if (playerDataManager.hasPlayerData(player) && playerDataManager.getPlayerData(player) != null) {
                                            if (!gui.getInputText().matches("[0-9]+")) {
                                                messageManager.sendMessage((CommandSender)player, configLoad.getString("Island.Admin.Upgrade.Numerical.Message"));
                                                soundManager.playSound((CommandSender)player, XSound.BLOCK_ANVIL_LAND);
                                                player.closeInventory();
                                                return;
                                            }
                                            List<com.craftaro.skyblock.upgrade.Upgrade> upgrades1 = upgradeManager.getUpgrades(Upgrade.Type.SIZE);
                                            if (upgrades1 != null && upgrades1.size() >= 5) {
                                                messageManager.sendMessage((CommandSender)player, configLoad.getString("Island.Admin.Upgrade.Tier.Limit.Message"));
                                                soundManager.playSound((CommandSender)player, XSound.BLOCK_ANVIL_LAND);
                                                Bukkit.getServer().getScheduler().runTaskLater((Plugin)plugin, () -> this.open(player), 1L);
                                                return;
                                            }
                                            int size = Integer.valueOf(gui.getInputText());
                                            if (size > 1000) {
                                                messageManager.sendMessage((CommandSender)player, configLoad.getString("Island.Admin.Upgrade.Tier.Size.Message"));
                                                soundManager.playSound((CommandSender)player, XSound.BLOCK_ANVIL_LAND);
                                                event.setWillClose(false);
                                                event.setWillDestroy(false);
                                                return;
                                            }
                                            if (upgradeManager.hasUpgrade(Upgrade.Type.SIZE, size)) {
                                                messageManager.sendMessage((CommandSender)player, configLoad.getString("Island.Admin.Upgrade.Tier.Exist.Message"));
                                                soundManager.playSound((CommandSender)player, XSound.BLOCK_ANVIL_LAND);
                                                player.closeInventory();
                                                return;
                                            }
                                            soundManager.playSound((CommandSender)player, XSound.BLOCK_ANVIL_USE);
                                            upgradeManager.addUpgrade(Upgrade.Type.SIZE, size);
                                            Bukkit.getServer().getScheduler().runTaskLater((Plugin)plugin, () -> this.open(player), 1L);
                                        }
                                        player.closeInventory();
                                    });
                                    ItemStack is12 = new ItemStack(Material.NAME_TAG);
                                    ItemMeta im = is12.getItemMeta();
                                    im.setDisplayName(configLoad.getString("Menu.Admin.Upgrade.Size.Item.Word.Size.Enter"));
                                    is12.setItemMeta(im);
                                    gui.setInput(is12);
                                    plugin.getGuiManager().showGUI(player, gui);
                                }, 1L);
                            }
                        } else if (is.getType() == XMaterial.BLACK_STAINED_GLASS_PANE.parseMaterial() && is.hasItemMeta() && is.getItemMeta().getDisplayName().equals(plugin.formatText(configLoad.getString("Menu.Admin.Upgrade.Size.Item.Barrier.Displayname")))) {
                            soundManager.playSound((CommandSender)player, XSound.BLOCK_GLASS_BREAK);
                            event.setWillClose(false);
                            event.setWillDestroy(false);
                        } else if (is.getType() == Material.PAPER && is.hasItemMeta()) {
                            int slot = event.getSlot();
                            int tier = slot - 3;
                            com.craftaro.skyblock.upgrade.Upgrade upgrade = upgradeManager.getUpgrades(Upgrade.Type.SIZE).get(tier);
                            if (upgrade != null) {
                                if (event.getClick() == ClickType.LEFT) {
                                    soundManager.playSound((CommandSender)player, XSound.BLOCK_WOODEN_BUTTON_CLICK_ON);
                                    Bukkit.getServer().getScheduler().runTaskLater((Plugin)plugin, () -> {
                                        AnvilGui gui = new AnvilGui(player);
                                        gui.setAction(event1 -> {
                                            if (!(player.hasPermission("fabledskyblock.admin.upgrade") || player.hasPermission("fabledskyblock.admin.*") || player.hasPermission("fabledskyblock.*"))) {
                                                messageManager.sendMessage((CommandSender)player, configLoad.getString("Island.Admin.Upgrade.Permission.Message"));
                                                soundManager.playSound((CommandSender)player, XSound.BLOCK_ANVIL_LAND);
                                                return;
                                            }
                                            if (playerDataManager.hasPlayerData(player) && playerDataManager.getPlayerData(player) != null) {
                                                if (!gui.getInputText().matches("[0-9]+")) {
                                                    messageManager.sendMessage((CommandSender)player, configLoad.getString("Island.Admin.Upgrade.Numerical.Message"));
                                                    soundManager.playSound((CommandSender)player, XSound.BLOCK_ANVIL_LAND);
                                                    player.closeInventory();
                                                    return;
                                                }
                                                if (upgradeManager.getUpgrades(Upgrade.Type.SIZE).get(tier) == null) {
                                                    messageManager.sendMessage((CommandSender)player, configLoad.getString("Island.Admin.Upgrade.Tier.Selected.Message"));
                                                    soundManager.playSound((CommandSender)player, XSound.BLOCK_ANVIL_LAND);
                                                    Bukkit.getServer().getScheduler().runTaskLater((Plugin)plugin, () -> this.open(player), 1L);
                                                    return;
                                                }
                                                int size = Integer.parseInt(gui.getInputText());
                                                if (size > 1000) {
                                                    messageManager.sendMessage((CommandSender)player, configLoad.getString("Island.Admin.Upgrade.Tier.Size.Message"));
                                                    soundManager.playSound((CommandSender)player, XSound.BLOCK_ANVIL_LAND);
                                                    event.setWillClose(false);
                                                    event.setWillDestroy(false);
                                                    return;
                                                }
                                                if (upgradeManager.hasUpgrade(Upgrade.Type.SIZE, size)) {
                                                    messageManager.sendMessage((CommandSender)player, configLoad.getString("Island.Admin.Upgrade.Tier.Exist.Message"));
                                                    soundManager.playSound((CommandSender)player, XSound.BLOCK_ANVIL_LAND);
                                                    event.setWillClose(false);
                                                    event.setWillDestroy(false);
                                                    return;
                                                }
                                                soundManager.playSound((CommandSender)player, XSound.BLOCK_ANVIL_USE);
                                                upgradeManager.getUpgrades(Upgrade.Type.SIZE).get(tier).setValue(size);
                                                fileManager.getConfig(new File(plugin.getDataFolder(), "upgrades.yml")).getFileConfiguration().set("Upgrades.Size." + tier + ".Value", (Object)size);
                                                Bukkit.getServer().getScheduler().runTaskLater((Plugin)plugin, () -> this.open(player), 1L);
                                            }
                                            player.closeInventory();
                                        });
                                        ItemStack is13 = new ItemStack(Material.NAME_TAG);
                                        ItemMeta im = is13.getItemMeta();
                                        im.setDisplayName(configLoad.getString("Menu.Admin.Upgrade.Size.Item.Word.Size.Enter"));
                                        is13.setItemMeta(im);
                                        gui.setInput(is13);
                                        plugin.getGuiManager().showGUI(player, gui);
                                    }, 1L);
                                    return;
                                }
                                if (event.getClick() == ClickType.MIDDLE) {
                                    soundManager.playSound((CommandSender)player, XSound.ENTITY_IRON_GOLEM_ATTACK);
                                    upgradeManager.removeUpgrade(Upgrade.Type.SIZE, upgrade.getCost(), upgrade.getValue());
                                } else {
                                    if (event.getClick() == ClickType.RIGHT) {
                                        soundManager.playSound((CommandSender)player, XSound.BLOCK_WOODEN_BUTTON_CLICK_ON);
                                        Bukkit.getServer().getScheduler().runTaskLater((Plugin)plugin, () -> {
                                            AnvilGui gui = new AnvilGui(player);
                                            gui.setAction(event1 -> {
                                                if (!(player.hasPermission("fabledskyblock.admin.upgrade") || player.hasPermission("fabledskyblock.admin.*") || player.hasPermission("fabledskyblock.*"))) {
                                                    messageManager.sendMessage((CommandSender)player, configLoad.getString("Island.Admin.Upgrade.Permission.Message"));
                                                    soundManager.playSound((CommandSender)player, XSound.BLOCK_ANVIL_LAND);
                                                    return;
                                                }
                                                if (playerDataManager.hasPlayerData(player) && playerDataManager.getPlayerData(player) != null) {
                                                    if (!gui.getInputText().matches("[0-9]+") && !gui.getInputText().matches("([0-9]*)\\.([0-9]{2}$)")) {
                                                        messageManager.sendMessage((CommandSender)player, configLoad.getString("Island.Admin.Upgrade.Numerical.Message"));
                                                        soundManager.playSound((CommandSender)player, XSound.BLOCK_ANVIL_LAND);
                                                        player.closeInventory();
                                                        return;
                                                    }
                                                    if (upgradeManager.getUpgrades(Upgrade.Type.SIZE).get(tier) == null) {
                                                        messageManager.sendMessage((CommandSender)player, configLoad.getString("Island.Admin.Upgrade.Tier.Selected.Message"));
                                                        soundManager.playSound((CommandSender)player, XSound.BLOCK_ANVIL_LAND);
                                                        Bukkit.getServer().getScheduler().runTaskLater((Plugin)plugin, () -> this.open(player), 1L);
                                                        return;
                                                    }
                                                    double cost = Double.parseDouble(gui.getInputText());
                                                    soundManager.playSound((CommandSender)player, XSound.BLOCK_ANVIL_USE);
                                                    upgradeManager.getUpgrades(Upgrade.Type.SIZE).get(tier).setCost(cost);
                                                    fileManager.getConfig(new File(plugin.getDataFolder(), "upgrades.yml")).getFileConfiguration().set("Upgrades.Size." + tier + ".Cost", (Object)cost);
                                                    Bukkit.getServer().getScheduler().runTaskLater((Plugin)plugin, () -> this.open(player), 1L);
                                                }
                                                player.closeInventory();
                                            });
                                            ItemStack is14 = new ItemStack(Material.NAME_TAG);
                                            ItemMeta im = is14.getItemMeta();
                                            im.setDisplayName(configLoad.getString("Menu.Admin.Upgrade.Size.Item.Word.Cost.Enter"));
                                            is14.setItemMeta(im);
                                            gui.setInput(is14);
                                            plugin.getGuiManager().showGUI(player, gui);
                                        }, 1L);
                                        return;
                                    }
                                    event.setWillClose(false);
                                    event.setWillDestroy(false);
                                    return;
                                }
                            }
                            Bukkit.getServer().getScheduler().runTaskLater((Plugin)plugin, () -> this.open(player), 1L);
                        }
                    }
                });
                nInv.addItem(nInv.createItem(XMaterial.OAK_FENCE_GATE.parseItem(), plugin.formatText(configLoad.getString("Menu.Admin.Upgrade.Size.Item.Return.Displayname")), null, null, null, null), 0);
                nInv.addItem(nInv.createItem(new ItemStack(Material.PAINTING), plugin.formatText(configLoad.getString("Menu.Admin.Upgrade.Size.Item.Information.Displayname")), configLoad.getStringList("Menu.Admin.Upgrade.Size.Item.Information.Lore"), null, null, null), 1);
                nInv.addItem(nInv.createItem(XMaterial.BLACK_STAINED_GLASS_PANE.parseItem(), plugin.formatText(configLoad.getString("Menu.Admin.Upgrade.Size.Item.Barrier.Displayname")), null, null, null, null), 2);
                List<com.craftaro.skyblock.upgrade.Upgrade> upgrades = upgradeManager.getUpgrades(Upgrade.Type.SIZE);
                if (upgrades != null) {
                    for (int i = 0; i < 5; ++i) {
                        if (upgrades.size() < i + 1) continue;
                        com.craftaro.skyblock.upgrade.Upgrade upgrade = upgrades.get(i);
                        int tier = i + 1;
                        if (upgrade == null) continue;
                        nInv.addItem(nInv.createItem(new ItemStack(Material.PAPER, tier), plugin.formatText(configLoad.getString("Menu.Admin.Upgrade.Size.Item.Tier.Displayname").replace("%tier", "" + tier)), configLoad.getStringList("Menu.Admin.Upgrade.Size.Item.Tier.Lore"), new Placeholder[]{new Placeholder("%size", "" + upgrade.getValue()), new Placeholder("%cost", NumberUtils.formatNumber(upgrade.getCost()))}, null, null), i + 3);
                    }
                }
                nInv.setTitle(plugin.formatText(configLoad.getString("Menu.Admin.Upgrade.Size.Title")));
                nInv.setRows(1);
                Bukkit.getServer().getScheduler().runTask((Plugin)plugin, nInv::open);
            } else if (viewer.getType() == Viewer.Type.MEMBERS) {
                nInventoryUtil nInv = new nInventoryUtil(player, event -> {
                    if (!(player.hasPermission("fabledskyblock.admin.upgrade") || player.hasPermission("fabledskyblock.admin.*") || player.hasPermission("fabledskyblock.*"))) {
                        messageManager.sendMessage((CommandSender)player, configLoad.getString("Island.Admin.Upgrade.Permission.Message"));
                        soundManager.playSound((CommandSender)player, XSound.BLOCK_ANVIL_LAND);
                        return;
                    }
                    if (playerDataManager.hasPlayerData(player)) {
                        PlayerData playerData = playerDataManager.getPlayerData(player);
                        ItemStack is = event.getItem();
                        if (is.getType() == XMaterial.OAK_FENCE_GATE.parseMaterial() && is.hasItemMeta() && is.getItemMeta().getDisplayName().equals(plugin.formatText(configLoad.getString("Menu.Admin.Upgrade.Members.Item.Return.Displayname")))) {
                            playerData.setViewer(new Viewer(Viewer.Type.UPGRADES, null));
                            soundManager.playSound((CommandSender)player, XSound.ENTITY_ARROW_HIT);
                            Bukkit.getServer().getScheduler().runTaskLater((Plugin)plugin, () -> this.open(player), 1L);
                        } else if (is.getType() == Material.PAINTING && is.hasItemMeta() && is.getItemMeta().getDisplayName().equals(plugin.formatText(configLoad.getString("Menu.Admin.Upgrade.Members.Item.Information.Displayname")))) {
                            List<com.craftaro.skyblock.upgrade.Upgrade> upgrades = upgradeManager.getUpgrades(Upgrade.Type.MEMBERS);
                            if (upgrades != null && upgrades.size() >= 5) {
                                messageManager.sendMessage((CommandSender)player, configLoad.getString("Island.Admin.Upgrade.Tier.Limit.Message"));
                                soundManager.playSound((CommandSender)player, XSound.BLOCK_ANVIL_LAND);
                                event.setWillClose(false);
                                event.setWillDestroy(false);
                            } else {
                                soundManager.playSound((CommandSender)player, XSound.BLOCK_WOODEN_BUTTON_CLICK_ON);
                                Bukkit.getServer().getScheduler().runTaskLater((Plugin)plugin, () -> {
                                    AnvilGui gui = new AnvilGui(player);
                                    gui.setAction(event1 -> {
                                        if (playerDataManager.hasPlayerData(player) && playerDataManager.getPlayerData(player) != null) {
                                            if (!gui.getInputText().matches("[0-9]+")) {
                                                messageManager.sendMessage((CommandSender)player, configLoad.getString("Island.Admin.Upgrade.Numerical.Message"));
                                                soundManager.playSound((CommandSender)player, XSound.BLOCK_ANVIL_LAND);
                                                player.closeInventory();
                                                return;
                                            }
                                            List<com.craftaro.skyblock.upgrade.Upgrade> upgrades1 = upgradeManager.getUpgrades(Upgrade.Type.MEMBERS);
                                            if (upgrades1 != null && upgrades1.size() >= 5) {
                                                messageManager.sendMessage((CommandSender)player, configLoad.getString("Island.Admin.Upgrade.Tier.Limit.Message"));
                                                soundManager.playSound((CommandSender)player, XSound.BLOCK_ANVIL_LAND);
                                                Bukkit.getServer().getScheduler().runTaskLater((Plugin)plugin, () -> this.open(player), 1L);
                                                return;
                                            }
                                            int size = Integer.valueOf(gui.getInputText());
                                            if (size > 1000) {
                                                messageManager.sendMessage((CommandSender)player, configLoad.getString("Island.Admin.Upgrade.Tier.Members.Message"));
                                                soundManager.playSound((CommandSender)player, XSound.BLOCK_ANVIL_LAND);
                                                event.setWillClose(false);
                                                event.setWillDestroy(false);
                                                return;
                                            }
                                            if (upgradeManager.hasUpgrade(Upgrade.Type.MEMBERS, size)) {
                                                messageManager.sendMessage((CommandSender)player, configLoad.getString("Island.Admin.Upgrade.Tier.Exist.Message"));
                                                soundManager.playSound((CommandSender)player, XSound.BLOCK_ANVIL_LAND);
                                                player.closeInventory();
                                                return;
                                            }
                                            soundManager.playSound((CommandSender)player, XSound.BLOCK_ANVIL_USE);
                                            upgradeManager.addUpgrade(Upgrade.Type.MEMBERS, size);
                                            Bukkit.getServer().getScheduler().runTaskLater((Plugin)plugin, () -> this.open(player), 1L);
                                        }
                                        player.closeInventory();
                                    });
                                    ItemStack is12 = new ItemStack(Material.NAME_TAG);
                                    ItemMeta im = is12.getItemMeta();
                                    im.setDisplayName(configLoad.getString("Menu.Admin.Upgrade.Members.Item.Word.Members.Enter"));
                                    is12.setItemMeta(im);
                                    gui.setInput(is12);
                                    plugin.getGuiManager().showGUI(player, gui);
                                }, 1L);
                            }
                        } else if (is.getType() == XMaterial.BLACK_STAINED_GLASS_PANE.parseMaterial() && is.hasItemMeta() && is.getItemMeta().getDisplayName().equals(plugin.formatText(configLoad.getString("Menu.Admin.Upgrade.Members.Item.Barrier.Displayname")))) {
                            soundManager.playSound((CommandSender)player, XSound.BLOCK_GLASS_BREAK);
                            event.setWillClose(false);
                            event.setWillDestroy(false);
                        } else if (is.getType() == Material.PAPER && is.hasItemMeta()) {
                            int slot = event.getSlot();
                            int tier = slot - 3;
                            com.craftaro.skyblock.upgrade.Upgrade upgrade = upgradeManager.getUpgrades(Upgrade.Type.MEMBERS).get(tier);
                            if (upgrade != null) {
                                if (event.getClick() == ClickType.LEFT) {
                                    soundManager.playSound((CommandSender)player, XSound.BLOCK_WOODEN_BUTTON_CLICK_ON);
                                    Bukkit.getServer().getScheduler().runTaskLater((Plugin)plugin, () -> {
                                        AnvilGui gui = new AnvilGui(player);
                                        gui.setAction(event1 -> {
                                            if (!(player.hasPermission("fabledskyblock.admin.upgrade") || player.hasPermission("fabledskyblock.admin.*") || player.hasPermission("fabledskyblock.*"))) {
                                                messageManager.sendMessage((CommandSender)player, configLoad.getString("Island.Admin.Upgrade.Permission.Message"));
                                                soundManager.playSound((CommandSender)player, XSound.BLOCK_ANVIL_LAND);
                                                return;
                                            }
                                            if (playerDataManager.hasPlayerData(player) && playerDataManager.getPlayerData(player) != null) {
                                                if (!gui.getInputText().matches("[0-9]+")) {
                                                    messageManager.sendMessage((CommandSender)player, configLoad.getString("Island.Admin.Upgrade.Numerical.Message"));
                                                    soundManager.playSound((CommandSender)player, XSound.BLOCK_ANVIL_LAND);
                                                    player.closeInventory();
                                                    return;
                                                }
                                                if (upgradeManager.getUpgrades(Upgrade.Type.MEMBERS).get(tier) == null) {
                                                    messageManager.sendMessage((CommandSender)player, configLoad.getString("Island.Admin.Upgrade.Tier.Selected.Message"));
                                                    soundManager.playSound((CommandSender)player, XSound.BLOCK_ANVIL_LAND);
                                                    Bukkit.getServer().getScheduler().runTaskLater((Plugin)plugin, () -> this.open(player), 1L);
                                                    return;
                                                }
                                                int size = Integer.parseInt(gui.getInputText());
                                                if (size > 1000) {
                                                    messageManager.sendMessage((CommandSender)player, configLoad.getString("Island.Admin.Upgrade.Tier.Members.Message"));
                                                    soundManager.playSound((CommandSender)player, XSound.BLOCK_ANVIL_LAND);
                                                    event.setWillClose(false);
                                                    event.setWillDestroy(false);
                                                    return;
                                                }
                                                if (upgradeManager.hasUpgrade(Upgrade.Type.MEMBERS, size)) {
                                                    messageManager.sendMessage((CommandSender)player, configLoad.getString("Island.Admin.Upgrade.Tier.Exist.Message"));
                                                    soundManager.playSound((CommandSender)player, XSound.BLOCK_ANVIL_LAND);
                                                    event.setWillClose(false);
                                                    event.setWillDestroy(false);
                                                    return;
                                                }
                                                soundManager.playSound((CommandSender)player, XSound.BLOCK_ANVIL_USE);
                                                upgradeManager.getUpgrades(Upgrade.Type.MEMBERS).get(tier).setValue(size);
                                                fileManager.getConfig(new File(plugin.getDataFolder(), "upgrades.yml")).getFileConfiguration().set("Upgrades.Members." + tier + ".Value", (Object)size);
                                                Bukkit.getServer().getScheduler().runTaskLater((Plugin)plugin, () -> this.open(player), 1L);
                                            }
                                            player.closeInventory();
                                        });
                                        ItemStack is13 = new ItemStack(Material.NAME_TAG);
                                        ItemMeta im = is13.getItemMeta();
                                        im.setDisplayName(configLoad.getString("Menu.Admin.Upgrade.Members.Item.Word.Members.Enter"));
                                        is13.setItemMeta(im);
                                        gui.setInput(is13);
                                        plugin.getGuiManager().showGUI(player, gui);
                                    }, 1L);
                                    return;
                                }
                                if (event.getClick() == ClickType.MIDDLE) {
                                    soundManager.playSound((CommandSender)player, XSound.ENTITY_IRON_GOLEM_ATTACK);
                                    upgradeManager.removeUpgrade(Upgrade.Type.MEMBERS, upgrade.getCost(), upgrade.getValue());
                                } else {
                                    if (event.getClick() == ClickType.RIGHT) {
                                        soundManager.playSound((CommandSender)player, XSound.BLOCK_WOODEN_BUTTON_CLICK_ON);
                                        Bukkit.getServer().getScheduler().runTaskLater((Plugin)plugin, () -> {
                                            AnvilGui gui = new AnvilGui(player);
                                            gui.setAction(event1 -> {
                                                if (!(player.hasPermission("fabledskyblock.admin.upgrade") || player.hasPermission("fabledskyblock.admin.*") || player.hasPermission("fabledskyblock.*"))) {
                                                    messageManager.sendMessage((CommandSender)player, configLoad.getString("Island.Admin.Upgrade.Permission.Message"));
                                                    soundManager.playSound((CommandSender)player, XSound.BLOCK_ANVIL_LAND);
                                                    return;
                                                }
                                                if (playerDataManager.hasPlayerData(player) && playerDataManager.getPlayerData(player) != null) {
                                                    if (!gui.getInputText().matches("[0-9]+") && !gui.getInputText().matches("([0-9]*)\\.([0-9]{2}$)")) {
                                                        messageManager.sendMessage((CommandSender)player, configLoad.getString("Island.Admin.Upgrade.Numerical.Message"));
                                                        soundManager.playSound((CommandSender)player, XSound.BLOCK_ANVIL_LAND);
                                                        player.closeInventory();
                                                        return;
                                                    }
                                                    if (upgradeManager.getUpgrades(Upgrade.Type.MEMBERS).get(tier) == null) {
                                                        messageManager.sendMessage((CommandSender)player, configLoad.getString("Island.Admin.Upgrade.Tier.Selected.Message"));
                                                        soundManager.playSound((CommandSender)player, XSound.BLOCK_ANVIL_LAND);
                                                        Bukkit.getServer().getScheduler().runTaskLater((Plugin)plugin, () -> this.open(player), 1L);
                                                        return;
                                                    }
                                                    double cost = Double.parseDouble(gui.getInputText());
                                                    soundManager.playSound((CommandSender)player, XSound.BLOCK_ANVIL_USE);
                                                    upgradeManager.getUpgrades(Upgrade.Type.MEMBERS).get(tier).setCost(cost);
                                                    fileManager.getConfig(new File(plugin.getDataFolder(), "upgrades.yml")).getFileConfiguration().set("Upgrades.Members." + tier + ".Cost", (Object)cost);
                                                    Bukkit.getServer().getScheduler().runTaskLater((Plugin)plugin, () -> this.open(player), 1L);
                                                }
                                                player.closeInventory();
                                            });
                                            ItemStack is14 = new ItemStack(Material.NAME_TAG);
                                            ItemMeta im = is14.getItemMeta();
                                            im.setDisplayName(configLoad.getString("Menu.Admin.Upgrade.Members.Item.Word.Cost.Enter"));
                                            is14.setItemMeta(im);
                                            gui.setInput(is14);
                                            plugin.getGuiManager().showGUI(player, gui);
                                        }, 1L);
                                        return;
                                    }
                                    event.setWillClose(false);
                                    event.setWillDestroy(false);
                                    return;
                                }
                            }
                            Bukkit.getServer().getScheduler().runTaskLater((Plugin)plugin, () -> this.open(player), 1L);
                        }
                    }
                });
                nInv.addItem(nInv.createItem(XMaterial.OAK_FENCE_GATE.parseItem(), plugin.formatText(configLoad.getString("Menu.Admin.Upgrade.Members.Item.Return.Displayname")), null, null, null, null), 0);
                nInv.addItem(nInv.createItem(new ItemStack(Material.PAINTING), plugin.formatText(configLoad.getString("Menu.Admin.Upgrade.Members.Item.Information.Displayname")), configLoad.getStringList("Menu.Admin.Upgrade.Members.Item.Information.Lore"), null, null, null), 1);
                nInv.addItem(nInv.createItem(XMaterial.BLACK_STAINED_GLASS_PANE.parseItem(), plugin.formatText(configLoad.getString("Menu.Admin.Upgrade.Members.Item.Barrier.Displayname")), null, null, null, null), 2);
                List<com.craftaro.skyblock.upgrade.Upgrade> upgrades = upgradeManager.getUpgrades(Upgrade.Type.MEMBERS);
                if (upgrades != null) {
                    for (int i = 0; i < 5; ++i) {
                        if (upgrades.size() < i + 1) continue;
                        com.craftaro.skyblock.upgrade.Upgrade upgrade = upgrades.get(i);
                        int tier = i + 1;
                        if (upgrade == null) continue;
                        nInv.addItem(nInv.createItem(new ItemStack(Material.PAPER, tier), plugin.formatText(configLoad.getString("Menu.Admin.Upgrade.Members.Item.Tier.Displayname").replace("%tier", "" + tier)), configLoad.getStringList("Menu.Admin.Upgrade.Members.Item.Tier.Lore"), new Placeholder[]{new Placeholder("%maxMembers", "" + upgrade.getValue()), new Placeholder("%cost", NumberUtils.formatNumber(upgrade.getCost()))}, null, null), i + 3);
                    }
                }
                nInv.setTitle(plugin.formatText(configLoad.getString("Menu.Admin.Upgrade.Members.Title")));
                nInv.setRows(1);
                Bukkit.getServer().getScheduler().runTask((Plugin)plugin, nInv::open);
            }
        }
    }

    private String getStatus(com.craftaro.skyblock.upgrade.Upgrade upgrade) {
        FileConfiguration configLoad = ((SkyBlock)SkyBlock.getPlugin(SkyBlock.class)).getLanguage();
        if (upgrade.isEnabled()) {
            return configLoad.getString("Menu.Admin.Upgrade.Upgrades.Item.Word.Disable");
        }
        return configLoad.getString("Menu.Admin.Upgrade.Upgrades.Item.Word.Enable");
    }

    public static class Viewer {
        private Type type;
        private Upgrade.Type upgrade;

        public Viewer(Type type, Upgrade.Type upgrade) {
            this.type = type;
            this.upgrade = upgrade;
        }

        public Type getType() {
            return this.type;
        }

        public void setType(Type type) {
            this.type = type;
        }

        public Upgrade.Type getUpgrade() {
            return this.upgrade;
        }

        public void setUpgrade(Upgrade.Type upgrade) {
            this.upgrade = upgrade;
        }

        public static enum Type {
            UPGRADES,
            SIZE,
            MEMBERS;

        }
    }
}

