/*
 * Decompiled with CFR 0.152.
 */
package com.craftaro.skyblock.menus.admin;

import com.craftaro.skyblock.SkyBlock;
import com.craftaro.skyblock.config.FileManager;
import com.craftaro.skyblock.core.compatibility.CompatibleMaterial;
import com.craftaro.skyblock.core.compatibility.MajorServerVersion;
import com.craftaro.skyblock.core.gui.AnvilGui;
import com.craftaro.skyblock.core.utils.NumberUtils;
import com.craftaro.skyblock.core.utils.SkullItemCreator;
import com.craftaro.skyblock.levelling.IslandLevelManager;
import com.craftaro.skyblock.levelling.LevellingMaterial;
import com.craftaro.skyblock.menus.MenuType;
import com.craftaro.skyblock.message.MessageManager;
import com.craftaro.skyblock.placeholder.Placeholder;
import com.craftaro.skyblock.playerdata.PlayerData;
import com.craftaro.skyblock.sound.SoundManager;
import com.craftaro.skyblock.utils.item.nInventoryUtil;
import com.craftaro.third_party.com.cryptomorin.xseries.XMaterial;
import com.craftaro.third_party.com.cryptomorin.xseries.XSound;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;

public class Levelling
implements Listener {
    private static Levelling instance;

    public static Levelling getInstance() {
        if (instance == null) {
            instance = new Levelling();
        }
        return instance;
    }

    public void open(Player player) {
        SkyBlock plugin = SkyBlock.getInstance();
        IslandLevelManager levellingManager = plugin.getLevellingManager();
        FileManager fileManager = plugin.getFileManager();
        PlayerData playerData = plugin.getPlayerDataManager().getPlayerData(player);
        List<LevellingMaterial> levellingMaterials = levellingManager.getWorthsAsLevelingMaterials();
        Inventory testInventory = Bukkit.createInventory(null, (int)9);
        levellingMaterials = levellingMaterials.stream().filter(x -> {
            if (x.getMaterials() == XMaterial.SPAWNER) {
                return false;
            }
            if (x.getItemStack() == null) {
                return false;
            }
            ItemStack itemStack = x.getMaterials().parseItem();
            itemStack.setAmount(1);
            itemStack.setDurability(x.getItemStack().getDurability());
            if (itemStack.getItemMeta() == null) {
                return false;
            }
            testInventory.clear();
            testInventory.setItem(0, itemStack);
            return testInventory.getItem(0) != null;
        }).collect(Collectors.toList());
        FileConfiguration configLoad = plugin.getLanguage();
        nInventoryUtil nInv = new nInventoryUtil(player, null);
        nInv.addItem(nInv.createItem(XMaterial.OAK_FENCE_GATE.parseItem(), configLoad.getString("Menu.Admin.Levelling.Item.Exit.Displayname"), null, null, null, null), 0, 8);
        nInv.addItem(nInv.createItem(new ItemStack(XMaterial.OAK_SIGN.parseMaterial()), configLoad.getString("Menu.Admin.Levelling.Item.Information.Displayname"), configLoad.getStringList("Menu.Admin.Levelling.Item.Information.Lore"), new Placeholder[]{new Placeholder("%materials", "" + levellingMaterials.size()), new Placeholder("%division", "" + fileManager.getConfig(new File(plugin.getDataFolder(), "config.yml")).getFileConfiguration().getInt("Island.Levelling.Division"))}, null, null), 4);
        nInv.addItem(nInv.createItem(XMaterial.BLACK_STAINED_GLASS_PANE.parseItem(), configLoad.getString("Menu.Admin.Levelling.Item.Barrier.Displayname"), null, null, null, null), 9, 10, 11, 12, 13, 14, 15, 16, 17);
        int playerMenuPage = playerData.getPage(MenuType.ADMIN_LEVELLING);
        int nextEndIndex = levellingMaterials.size() - playerMenuPage * 36;
        if (playerMenuPage != 1) {
            ItemStack Lhead = SkullItemCreator.byTextureUrlHash("3ebf907494a935e955bfcadab81beafb90fb9be49c7026ba97d798d5f1a23");
            nInv.addItem(nInv.createItem(Lhead, configLoad.getString("Menu.Admin.Levelling.Item.Previous.Displayname"), null, null, null, null), 1);
        }
        if (nextEndIndex != 0 && nextEndIndex >= 0) {
            ItemStack Rhead = SkullItemCreator.byTextureUrlHash("1b6f1a25b6bc199946472aedb370522584ff6f4e83221e5946bd2e41b5ca13b");
            nInv.addItem(nInv.createItem(Rhead, configLoad.getString("Menu.Admin.Levelling.Item.Next.Displayname"), null, null, null, null), 7);
        }
        if (levellingMaterials.isEmpty()) {
            nInv.addItem(nInv.createItem(new ItemStack(Material.BARRIER), configLoad.getString("Menu.Admin.Levelling.Item.Nothing.Displayname"), null, null, null, null), 31);
        } else {
            int index = playerMenuPage * 36 - 36;
            int endIndex = index >= levellingMaterials.size() ? levellingMaterials.size() - 1 : index + 36;
            int inventorySlot = 17;
            while (index < endIndex) {
                if (levellingMaterials.size() > index) {
                    LevellingMaterial material = levellingMaterials.get(index);
                    ItemStack itemStack = material.getMaterials().parseItem();
                    itemStack.setAmount(1);
                    itemStack.setDurability(material.getItemStack().getDurability());
                    nInv.addItem(nInv.createItem(itemStack, ChatColor.translateAlternateColorCodes((char)'&', (String)configLoad.getString("Menu.Admin.Levelling.Item.Material.Displayname").replace("%material", material.getMaterials().name())), configLoad.getStringList("Menu.Admin.Levelling.Item.Material.Lore"), new Placeholder[]{new Placeholder("%points", NumberUtils.formatNumber(material.getPoints()))}, null, null), ++inventorySlot);
                }
                ++index;
            }
        }
        nInv.setTitle(ChatColor.translateAlternateColorCodes((char)'&', (String)configLoad.getString("Menu.Admin.Levelling.Title")));
        nInv.setRows(6);
        Bukkit.getServer().getScheduler().runTask((Plugin)plugin, nInv::open);
    }

    @EventHandler
    public void onInventoryClick(InventoryClickEvent event) {
        Player player = (Player)event.getWhoClicked();
        ItemStack is = event.getCurrentItem();
        if (event.getCurrentItem() != null && event.getCurrentItem().getType() != Material.AIR) {
            SkyBlock plugin = SkyBlock.getInstance();
            IslandLevelManager levellingManager = plugin.getLevellingManager();
            MessageManager messageManager = plugin.getMessageManager();
            SoundManager soundManager = plugin.getSoundManager();
            FileManager fileManager = plugin.getFileManager();
            FileConfiguration configLoad = plugin.getLanguage();
            String inventoryName = "";
            if (MajorServerVersion.isServerVersionAbove(MajorServerVersion.V1_13)) {
                inventoryName = event.getView().getTitle();
            } else {
                try {
                    inventoryName = (String)Inventory.class.getMethod("getName", new Class[0]).invoke((Object)event.getInventory(), new Object[0]);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
            if (inventoryName.equals(ChatColor.translateAlternateColorCodes((char)'&', (String)configLoad.getString("Menu.Admin.Levelling.Title")))) {
                event.setCancelled(true);
                PlayerData playerData = plugin.getPlayerDataManager().getPlayerData(player);
                if (!(player.hasPermission("fabledskyblock.admin.level") || player.hasPermission("fabledskyblock.admin.*") || player.hasPermission("fabledskyblock.*"))) {
                    messageManager.sendMessage((CommandSender)player, configLoad.getString("Island.Admin.Levelling.Permission.Message"));
                    soundManager.playSound((CommandSender)player, XSound.BLOCK_ANVIL_LAND);
                    return;
                }
                if (event.getCurrentItem().getType() == XMaterial.BLACK_STAINED_GLASS_PANE.parseMaterial() && is.hasItemMeta() && is.getItemMeta().getDisplayName().equals(ChatColor.translateAlternateColorCodes((char)'&', (String)configLoad.getString("Menu.Admin.Levelling.Item.Barrier.Displayname")))) {
                    soundManager.playSound((CommandSender)player, XSound.BLOCK_GLASS_BREAK);
                    return;
                }
                if (event.getCurrentItem().getType() == XMaterial.OAK_FENCE_GATE.parseMaterial() && is.hasItemMeta() && is.getItemMeta().getDisplayName().equals(ChatColor.translateAlternateColorCodes((char)'&', (String)configLoad.getString("Menu.Admin.Levelling.Item.Exit.Displayname")))) {
                    soundManager.playSound((CommandSender)player, XSound.BLOCK_CHEST_CLOSE);
                    player.closeInventory();
                    return;
                }
                if (event.getCurrentItem().getType() == XMaterial.OAK_SIGN.parseMaterial() && is.hasItemMeta() && is.getItemMeta().getDisplayName().equals(ChatColor.translateAlternateColorCodes((char)'&', (String)configLoad.getString("Menu.Admin.Levelling.Item.Information.Displayname")))) {
                    soundManager.playSound((CommandSender)player, XSound.BLOCK_WOODEN_BUTTON_CLICK_ON);
                    AnvilGui gui = new AnvilGui(player);
                    gui.setAction(event1 -> {
                        if (!(player.hasPermission("fabledskyblock.admin.level") || player.hasPermission("fabledskyblock.admin.*") || player.hasPermission("fabledskyblock.*"))) {
                            messageManager.sendMessage((CommandSender)player, configLoad.getString("Island.Admin.Levelling.Permission.Message"));
                            soundManager.playSound((CommandSender)player, XSound.BLOCK_ANVIL_LAND);
                        } else {
                            try {
                                double pointDivision = Double.parseDouble(gui.getInputText());
                                messageManager.sendMessage((CommandSender)player, configLoad.getString("Island.Admin.Levelling.Division.Message").replace("%division", NumberUtils.formatNumber(pointDivision)));
                                soundManager.playSound((CommandSender)player, XSound.BLOCK_NOTE_BLOCK_PLING);
                                Bukkit.getServer().getScheduler().runTaskAsynchronously((Plugin)plugin, () -> {
                                    FileManager.Config config12 = fileManager.getConfig(new File(plugin.getDataFolder(), "config.yml"));
                                    FileConfiguration configLoad12 = config12.getFileConfiguration();
                                    configLoad12.set("Island.Levelling.Division", (Object)pointDivision);
                                    try {
                                        configLoad12.save(config12.getFile());
                                    }
                                    catch (IOException ex) {
                                        ex.printStackTrace();
                                    }
                                });
                                player.closeInventory();
                                Bukkit.getServer().getScheduler().runTaskLater((Plugin)plugin, () -> this.open(player), 1L);
                            }
                            catch (NumberFormatException ignored) {
                                messageManager.sendMessage((CommandSender)player, configLoad.getString("Island.Admin.Levelling.Numerical.Message"));
                                soundManager.playSound((CommandSender)player, XSound.BLOCK_ANVIL_LAND);
                            }
                        }
                        player.closeInventory();
                    });
                    is = new ItemStack(Material.NAME_TAG);
                    ItemMeta im = is.getItemMeta();
                    im.setDisplayName(configLoad.getString("Menu.Admin.Levelling.Item.Information.Word.Enter"));
                    is.setItemMeta(im);
                    gui.setInput(is);
                    plugin.getGuiManager().showGUI(player, gui);
                    return;
                }
                if (event.getCurrentItem().getType() == Material.BARRIER && is.hasItemMeta() && is.getItemMeta().getDisplayName().equals(ChatColor.translateAlternateColorCodes((char)'&', (String)configLoad.getString("Menu.Admin.Levelling.Item.Nothing.Displayname")))) {
                    soundManager.playSound((CommandSender)player, XSound.BLOCK_ANVIL_LAND);
                    return;
                }
                if (event.getCurrentItem().getType() == XMaterial.PLAYER_HEAD.parseMaterial() && is.hasItemMeta()) {
                    if (is.getItemMeta().getDisplayName().equals(ChatColor.translateAlternateColorCodes((char)'&', (String)configLoad.getString("Menu.Admin.Levelling.Item.Previous.Displayname")))) {
                        player.closeInventory();
                        playerData.setPage(MenuType.ADMIN_LEVELLING, playerData.getPage(MenuType.ADMIN_LEVELLING) - 1);
                        soundManager.playSound((CommandSender)player, XSound.ENTITY_ARROW_HIT);
                        Bukkit.getServer().getScheduler().runTaskLater((Plugin)plugin, () -> this.open(player), 1L);
                        return;
                    }
                    if (is.getItemMeta().getDisplayName().equals(ChatColor.translateAlternateColorCodes((char)'&', (String)configLoad.getString("Menu.Admin.Levelling.Item.Next.Displayname")))) {
                        player.closeInventory();
                        playerData.setPage(MenuType.ADMIN_LEVELLING, playerData.getPage(MenuType.ADMIN_LEVELLING) + 1);
                        soundManager.playSound((CommandSender)player, XSound.ENTITY_ARROW_HIT);
                        Bukkit.getServer().getScheduler().runTaskLater((Plugin)plugin, () -> this.open(player), 1L);
                        return;
                    }
                }
                if (is.hasItemMeta() && is.getItemMeta().hasDisplayName()) {
                    for (LevellingMaterial materialList : levellingManager.getWorthsAsLevelingMaterials()) {
                        XMaterial materials = materialList.getMaterials();
                        if (CompatibleMaterial.getMaterial(materials.parseMaterial()) == null || event.getCurrentItem().getType() != CompatibleMaterial.getMaterial(materials.parseMaterial()).get().parseMaterial() || !ChatColor.stripColor((String)is.getItemMeta().getDisplayName()).equals(materials.name())) continue;
                        if (event.getClick() == ClickType.LEFT) {
                            soundManager.playSound((CommandSender)player, XSound.BLOCK_WOODEN_BUTTON_CLICK_ON);
                            AnvilGui gui = new AnvilGui(player);
                            gui.setAction(ev -> {
                                if (!(player.hasPermission("fabledskyblock.admin.level") || player.hasPermission("fabledskyblock.admin.*") || player.hasPermission("fabledskyblock.*"))) {
                                    messageManager.sendMessage((CommandSender)player, configLoad.getString("Island.Admin.Levelling.Permission.Message"));
                                    soundManager.playSound((CommandSender)player, XSound.BLOCK_ANVIL_LAND);
                                } else if (levellingManager.hasWorth(materials)) {
                                    try {
                                        double materialPoints = Double.parseDouble(gui.getInputText());
                                        materialList.setPoints(materialPoints);
                                        messageManager.sendMessage((CommandSender)player, configLoad.getString("Island.Admin.Levelling.Points.Message").replace("%material", materials.name()).replace("%points", NumberUtils.formatNumber(materialPoints)));
                                        soundManager.playSound((CommandSender)player, XSound.ENTITY_PLAYER_LEVELUP);
                                        player.closeInventory();
                                        Bukkit.getServer().getScheduler().runTaskLater((Plugin)plugin, () -> this.open(player), 1L);
                                        levellingManager.addWorth(materials, materialPoints);
                                        Bukkit.getServer().getScheduler().runTaskAsynchronously((Plugin)plugin, () -> {
                                            FileManager.Config config1 = fileManager.getConfig(new File(plugin.getDataFolder(), "levelling.yml"));
                                            FileConfiguration configLoad1 = config1.getFileConfiguration();
                                            configLoad1.set("Materials." + materials.name() + ".Points", (Object)materialPoints);
                                            try {
                                                configLoad1.save(config1.getFile());
                                            }
                                            catch (IOException ex) {
                                                ex.printStackTrace();
                                            }
                                        });
                                    }
                                    catch (NumberFormatException ignored) {
                                        messageManager.sendMessage((CommandSender)player, configLoad.getString("Island.Admin.Levelling.Numerical.Message"));
                                        soundManager.playSound((CommandSender)player, XSound.BLOCK_ANVIL_LAND);
                                    }
                                } else {
                                    messageManager.sendMessage((CommandSender)player, configLoad.getString("Island.Admin.Levelling.Exist.Message"));
                                    soundManager.playSound((CommandSender)player, XSound.BLOCK_ANVIL_LAND);
                                }
                            });
                            is = new ItemStack(Material.NAME_TAG);
                            ItemMeta im = is.getItemMeta();
                            im.setDisplayName(configLoad.getString("Menu.Admin.Levelling.Item.Material.Word.Enter"));
                            is.setItemMeta(im);
                            gui.setOutput(is);
                            plugin.getGuiManager().showGUI(player, gui);
                        } else if (event.getClick() == ClickType.RIGHT) {
                            levellingManager.removeWorth(materialList.getMaterials());
                            this.open(player);
                            messageManager.sendMessage((CommandSender)player, configLoad.getString("Island.Admin.Levelling.Removed.Message").replace("%material", materials.name()));
                            soundManager.playSound((CommandSender)player, XSound.ENTITY_IRON_GOLEM_ATTACK);
                            Bukkit.getServer().getScheduler().runTaskAsynchronously((Plugin)plugin, () -> {
                                FileManager.Config config13 = fileManager.getConfig(new File(plugin.getDataFolder(), "levelling.yml"));
                                FileConfiguration configLoad13 = config13.getFileConfiguration();
                                configLoad13.set("Materials." + materials.name(), null);
                                try {
                                    configLoad13.save(config13.getFile());
                                }
                                catch (IOException ex) {
                                    ex.printStackTrace();
                                }
                            });
                        }
                        return;
                    }
                }
                XMaterial materials = CompatibleMaterial.getMaterial(event.getCurrentItem().getType()).get();
                if (MajorServerVersion.isServerVersionBelow(MajorServerVersion.V1_13)) {
                    materials.parseItem().setData(event.getCurrentItem().getData());
                }
                if (levellingManager.hasWorth(materials)) {
                    messageManager.sendMessage((CommandSender)player, configLoad.getString("Island.Admin.Levelling.Already.Message"));
                    soundManager.playSound((CommandSender)player, XSound.BLOCK_ANVIL_LAND);
                    return;
                }
                levellingManager.addWorth(materials, 0.0);
                this.open(player);
                messageManager.sendMessage((CommandSender)player, configLoad.getString("Island.Admin.Levelling.Added.Message").replace("%material", materials.name()));
                soundManager.playSound((CommandSender)player, XSound.BLOCK_NOTE_BLOCK_PLING);
                Bukkit.getServer().getScheduler().runTaskAsynchronously((Plugin)plugin, () -> {
                    FileManager.Config config14 = fileManager.getConfig(new File(plugin.getDataFolder(), "levelling.yml"));
                    FileConfiguration configLoad14 = config14.getFileConfiguration();
                    configLoad14.set("Materials." + materials.name() + ".Points", (Object)0);
                    try {
                        configLoad14.save(config14.getFile());
                    }
                    catch (IOException ex) {
                        ex.printStackTrace();
                    }
                });
            }
        }
    }
}

