/*
 * Decompiled with CFR 0.152.
 */
package com.craftaro.skyblock.menus.admin;

import com.craftaro.skyblock.SkyBlock;
import com.craftaro.skyblock.config.FileManager;
import com.craftaro.skyblock.core.compatibility.CompatibleMaterial;
import com.craftaro.skyblock.core.compatibility.MajorServerVersion;
import com.craftaro.skyblock.core.gui.AnvilGui;
import com.craftaro.skyblock.core.utils.SkullItemCreator;
import com.craftaro.skyblock.menus.MenuType;
import com.craftaro.skyblock.message.MessageManager;
import com.craftaro.skyblock.placeholder.Placeholder;
import com.craftaro.skyblock.playerdata.PlayerData;
import com.craftaro.skyblock.playerdata.PlayerDataManager;
import com.craftaro.skyblock.sound.SoundManager;
import com.craftaro.skyblock.structure.Structure;
import com.craftaro.skyblock.structure.StructureManager;
import com.craftaro.skyblock.utils.item.nInventoryUtil;
import com.craftaro.third_party.com.cryptomorin.xseries.XMaterial;
import com.craftaro.third_party.com.cryptomorin.xseries.XSound;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;

public class Creator
implements Listener {
    private static Creator instance;

    public static Creator getInstance() {
        if (instance == null) {
            instance = new Creator();
        }
        return instance;
    }

    /*
     * WARNING - void declaration
     */
    public void open(Player player) {
        SkyBlock plugin = (SkyBlock)SkyBlock.getPlugin(SkyBlock.class);
        StructureManager structureManager = plugin.getStructureManager();
        FileManager fileManager = plugin.getFileManager();
        PlayerData playerData = plugin.getPlayerDataManager().getPlayerData(player);
        FileConfiguration configLoad = plugin.getLanguage();
        nInventoryUtil nInv = new nInventoryUtil(player, null);
        if (playerData.getViewer() == null) {
            List<Structure> structures = structureManager.getStructures();
            nInv.addItem(nInv.createItem(XMaterial.OAK_FENCE_GATE.parseItem(), configLoad.getString("Menu.Admin.Creator.Browse.Item.Exit.Displayname"), null, null, null, null), 0, 8);
            nInv.addItem(nInv.createItem(new ItemStack(XMaterial.OAK_SIGN.parseItem()), configLoad.getString("Menu.Admin.Creator.Browse.Item.Information.Displayname"), configLoad.getStringList("Menu.Admin.Creator.Browse.Item.Information.Lore"), new Placeholder[]{new Placeholder("%structures", "" + structures.size())}, null, null), 4);
            nInv.addItem(nInv.createItem(XMaterial.BLACK_STAINED_GLASS_PANE.parseItem(), configLoad.getString("Menu.Admin.Creator.Browse.Item.Barrier.Displayname"), null, null, null, null), 9, 10, 11, 12, 13, 14, 15, 16, 17);
            int playerMenuPage = playerData.getPage(MenuType.ADMIN_CREATOR);
            int nextEndIndex = structures.size() - playerMenuPage * 36;
            if (playerMenuPage != 1) {
                ItemStack Lhead = SkullItemCreator.byTextureUrlHash("3ebf907494a935e955bfcadab81beafb90fb9be49c7026ba97d798d5f1a23");
                nInv.addItem(nInv.createItem(Lhead, configLoad.getString("Menu.Admin.Creator.Browse.Item.Previous.Displayname"), null, null, null, null), 1);
            }
            if (nextEndIndex != 0 && nextEndIndex >= 0) {
                ItemStack Rhead = SkullItemCreator.byTextureUrlHash("1b6f1a25b6bc199946472aedb370522584ff6f4e83221e5946bd2e41b5ca13b");
                nInv.addItem(nInv.createItem(Rhead, configLoad.getString("Menu.Admin.Creator.Browse.Item.Next.Displayname"), null, null, null, null), 7);
            }
            if (structures.isEmpty()) {
                nInv.addItem(nInv.createItem(new ItemStack(XMaterial.BARRIER.parseMaterial()), configLoad.getString("Menu.Admin.Creator.Browse.Item.Nothing.Displayname"), null, null, null, null), 31);
            } else {
                int index = playerMenuPage * 36 - 36;
                int endIndex = index >= structures.size() ? structures.size() - 1 : index + 36;
                int inventorySlot = 17;
                while (index < endIndex) {
                    if (structures.size() > index) {
                        Structure structure = structures.get(index);
                        nInv.addItem(nInv.createItem(structure.getMaterial().parseItem(), ChatColor.translateAlternateColorCodes((char)'&', (String)configLoad.getString("Menu.Admin.Creator.Browse.Item.Structure.Displayname").replace("%structure", structure.getName())), configLoad.getStringList("Menu.Admin.Creator.Browse.Item.Structure.Lore"), null, null, null), ++inventorySlot);
                    }
                    ++index;
                }
            }
            nInv.setRows(6);
        } else {
            void var14_27;
            Structure structure = structureManager.getStructure(((Viewer)playerData.getViewer()).getName());
            nInv.addItem(nInv.createItem(XMaterial.OAK_FENCE_GATE.parseItem(), configLoad.getString("Menu.Admin.Creator.Options.Item.Return.Displayname"), null, null, null, null), 0, 8);
            String displayName = ChatColor.translateAlternateColorCodes((char)'&', (String)configLoad.getString("Menu.Admin.Creator.Options.Item.Word.Unset"));
            if (structure.getDisplayname() != null && !structure.getDisplayname().isEmpty()) {
                displayName = ChatColor.translateAlternateColorCodes((char)'&', (String)structure.getDisplayname());
            }
            nInv.addItem(nInv.createItem(new ItemStack(XMaterial.NAME_TAG.parseMaterial()), configLoad.getString("Menu.Admin.Creator.Options.Item.Displayname.Displayname"), configLoad.getStringList("Menu.Admin.Creator.Options.Item.Displayname.Lore"), new Placeholder[]{new Placeholder("%displayname", displayName)}, null, null), 1);
            ArrayList<String> descriptionLore = new ArrayList<String>();
            if (structure.getDescription() == null || structure.getDescription().isEmpty()) {
                for (Object itemLore : configLoad.getStringList("Menu.Admin.Creator.Options.Item.Description.Unset.Lore")) {
                    if (((String)itemLore).contains("%description")) {
                        descriptionLore.add(configLoad.getString("Menu.Admin.Creator.Options.Item.Word.Unset"));
                        continue;
                    }
                    descriptionLore.add((String)itemLore);
                }
            } else {
                for (Object itemLore : configLoad.getStringList("Menu.Admin.Creator.Options.Item.Description.Set.Lore")) {
                    if (((String)itemLore).contains("%description")) {
                        for (String string : structure.getDescription()) {
                            descriptionLore.add(string);
                        }
                        continue;
                    }
                    descriptionLore.add((String)itemLore);
                }
            }
            nInv.addItem(nInv.createItem(new ItemStack(XMaterial.ENCHANTED_BOOK.parseMaterial()), configLoad.getString("Menu.Admin.Creator.Options.Item.Description.Displayname"), descriptionLore, null, null, null), 2);
            ArrayList<String> commandsLore = new ArrayList<String>();
            if (structure.getCommands() == null || structure.getCommands().isEmpty()) {
                for (String itemLore : configLoad.getStringList("Menu.Admin.Creator.Options.Item.Commands.Unset.Lore")) {
                    if (itemLore.contains("%commands")) {
                        commandsLore.add(configLoad.getString("Menu.Admin.Creator.Options.Item.Word.Unset"));
                        continue;
                    }
                    commandsLore.add(itemLore);
                }
            } else {
                for (String itemLore : configLoad.getStringList("Menu.Admin.Creator.Options.Item.Commands.Set.Lore")) {
                    if (itemLore.contains("%commands")) {
                        for (String commandList : structure.getCommands()) {
                            commandsLore.add(commandList);
                        }
                        continue;
                    }
                    commandsLore.add(itemLore);
                }
            }
            nInv.addItem(nInv.createItem(new ItemStack(XMaterial.BOOK.parseMaterial()), configLoad.getString("Menu.Admin.Creator.Options.Item.Commands.Displayname"), commandsLore, null, null, null), 3);
            List permissionLore = structure.isPermission() ? configLoad.getStringList("Menu.Admin.Creator.Options.Item.Permission.Disable.Lore") : configLoad.getStringList("Menu.Admin.Creator.Options.Item.Permission.Enable.Lore");
            nInv.addItem(nInv.createItem(XMaterial.MAP.parseItem(), configLoad.getString("Menu.Admin.Creator.Options.Item.Permission.Displayname"), permissionLore, new Placeholder[]{new Placeholder("%permission", structure.getPermission())}, null, null), 4);
            String fileName = ChatColor.translateAlternateColorCodes((char)'&', (String)configLoad.getString("Menu.Admin.Creator.Options.Item.Word.Unset"));
            if (structure.getOverworldFile() != null && !structure.getOverworldFile().isEmpty()) {
                String string = structure.getOverworldFile();
            } else {
                String string = fileName;
            }
            String netherFileName = structure.getNetherFile() != null && !structure.getNetherFile().isEmpty() ? structure.getNetherFile() : fileName;
            String endFileName = structure.getEndFile() != null && !structure.getEndFile().isEmpty() ? structure.getEndFile() : fileName;
            nInv.addItem(nInv.createItem(new ItemStack(XMaterial.PAPER.parseMaterial()), configLoad.getString("Menu.Admin.Creator.Options.Item.File.Displayname"), configLoad.getStringList("Menu.Admin.Creator.Options.Item.File.Lore"), new Placeholder[]{new Placeholder("%overworld_file", (String)var14_27), new Placeholder("%nether_file", netherFileName), new Placeholder("%end_file", endFileName)}, null, null), 5);
            nInv.addItem(nInv.createItem(new ItemStack(XMaterial.DIAMOND.parseMaterial()), configLoad.getString("Menu.Admin.Creator.Options.Item.Item.Displayname"), configLoad.getStringList("Menu.Admin.Creator.Options.Item.Item.Lore"), new Placeholder[]{new Placeholder("%material", structure.getMaterial().name())}, null, null), 6);
            nInv.addItem(nInv.createItem(new ItemStack(XMaterial.GOLD_NUGGET.parseMaterial()), configLoad.getString("Menu.Admin.Creator.Options.Item.DeletionCost.Displayname"), configLoad.getStringList("Menu.Admin.Creator.Options.Item.DeletionCost.Lore"), new Placeholder[]{new Placeholder("%cost", "" + structure.getDeletionCost())}, null, null), 7);
            nInv.setRows(1);
        }
        nInv.setTitle(ChatColor.translateAlternateColorCodes((char)'&', (String)configLoad.getString("Menu.Admin.Creator.Title")));
        Bukkit.getServer().getScheduler().runTask((Plugin)plugin, nInv::open);
    }

    @EventHandler
    public void onInventoryClick(InventoryClickEvent event) {
        Player player = (Player)event.getWhoClicked();
        ItemStack is = event.getCurrentItem();
        if (event.getCurrentItem() != null && event.getCurrentItem().getType() != XMaterial.AIR.parseMaterial()) {
            SkyBlock plugin = SkyBlock.getInstance();
            StructureManager structureManager = plugin.getStructureManager();
            MessageManager messageManager = plugin.getMessageManager();
            SoundManager soundManager = plugin.getSoundManager();
            FileManager fileManager = plugin.getFileManager();
            FileManager.Config config = fileManager.getConfig(new File(plugin.getDataFolder(), "language.yml"));
            FileConfiguration configLoad = config.getFileConfiguration();
            String inventoryName = "";
            if (MajorServerVersion.isServerVersionAbove(MajorServerVersion.V1_13)) {
                inventoryName = event.getView().getTitle();
            } else {
                try {
                    inventoryName = (String)Inventory.class.getMethod("getName", new Class[0]).invoke((Object)event.getInventory(), new Object[0]);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
            if (inventoryName.equals(ChatColor.translateAlternateColorCodes((char)'&', (String)configLoad.getString("Menu.Admin.Creator.Title")))) {
                Viewer viewer;
                event.setCancelled(true);
                PlayerData playerData = plugin.getPlayerDataManager().getPlayerData(player);
                if (!(player.hasPermission("fabledskyblock.admin.create") || player.hasPermission("fabledskyblock.admin.*") || player.hasPermission("fabledskyblock.*"))) {
                    messageManager.sendMessage((CommandSender)player, configLoad.getString("Island.Admin.Creator.Permission.Message"));
                    soundManager.playSound((CommandSender)player, XSound.BLOCK_ANVIL_LAND);
                    return;
                }
                if (event.getCurrentItem().getType() == XMaterial.BLACK_STAINED_GLASS_PANE.parseMaterial() && is.hasItemMeta() && is.getItemMeta().getDisplayName().equals(ChatColor.translateAlternateColorCodes((char)'&', (String)configLoad.getString("Menu.Admin.Creator.Browse.Item.Barrier.Displayname")))) {
                    soundManager.playSound((CommandSender)player, XSound.BLOCK_GLASS_BREAK);
                    return;
                }
                if (event.getCurrentItem().getType() == XMaterial.OAK_FENCE_GATE.parseMaterial() && is.hasItemMeta()) {
                    if (is.getItemMeta().getDisplayName().equals(ChatColor.translateAlternateColorCodes((char)'&', (String)configLoad.getString("Menu.Admin.Creator.Browse.Item.Exit.Displayname")))) {
                        soundManager.playSound((CommandSender)player, XSound.BLOCK_CHEST_CLOSE);
                        player.closeInventory();
                        return;
                    }
                    if (is.getItemMeta().getDisplayName().equals(ChatColor.translateAlternateColorCodes((char)'&', (String)configLoad.getString("Menu.Admin.Creator.Options.Item.Return.Displayname")))) {
                        playerData.setViewer(null);
                        soundManager.playSound((CommandSender)player, XSound.ENTITY_ARROW_HIT);
                        player.closeInventory();
                        Bukkit.getServer().getScheduler().runTaskLater((Plugin)plugin, () -> this.open(player), 1L);
                        return;
                    }
                } else {
                    if (event.getCurrentItem().getType() == XMaterial.OAK_SIGN.parseMaterial() && is.hasItemMeta() && is.getItemMeta().getDisplayName().equals(ChatColor.translateAlternateColorCodes((char)'&', (String)configLoad.getString("Menu.Admin.Creator.Browse.Item.Information.Displayname")))) {
                        soundManager.playSound((CommandSender)player, XSound.BLOCK_WOODEN_BUTTON_CLICK_ON);
                        AnvilGui gui = new AnvilGui(player);
                        gui.setAction(event1 -> {
                            if (!(player.hasPermission("fabledskyblock.admin.creator") || player.hasPermission("fabledskyblock.admin.*") || player.hasPermission("fabledskyblock.*"))) {
                                messageManager.sendMessage((CommandSender)player, configLoad.getString("Island.Admin.Creator.Permission.Message"));
                                soundManager.playSound((CommandSender)player, XSound.BLOCK_ANVIL_LAND);
                            } else if (structureManager.containsStructure(gui.getInputText())) {
                                messageManager.sendMessage((CommandSender)player, configLoad.getString("Island.Admin.Creator.Already.Message"));
                                soundManager.playSound((CommandSender)player, XSound.BLOCK_ANVIL_LAND);
                            } else if (!gui.getInputText().replace(" ", "").matches("^[a-zA-Z0-9]+$")) {
                                messageManager.sendMessage((CommandSender)player, configLoad.getString("Island.Admin.Creator.Characters.Message"));
                                soundManager.playSound((CommandSender)player, XSound.BLOCK_ANVIL_LAND);
                            } else {
                                structureManager.addStructure(gui.getInputText(), XMaterial.GRASS_BLOCK, null, null, null, null, false, new ArrayList<String>(), new ArrayList<String>(), 0.0);
                                messageManager.sendMessage((CommandSender)player, configLoad.getString("Island.Admin.Creator.Created.Message").replace("%structure", gui.getInputText()));
                                soundManager.playSound((CommandSender)player, XSound.BLOCK_NOTE_BLOCK_PLING);
                                Bukkit.getServer().getScheduler().runTaskAsynchronously((Plugin)plugin, () -> {
                                    FileManager.Config config111 = fileManager.getConfig(new File(plugin.getDataFolder(), "structures.yml"));
                                    FileConfiguration configLoad111 = config111.getFileConfiguration();
                                    configLoad111.set("Structures." + gui.getInputText() + ".Name", (Object)gui.getInputText());
                                    try {
                                        configLoad111.save(config111.getFile());
                                    }
                                    catch (IOException ex) {
                                        ex.printStackTrace();
                                    }
                                });
                                player.closeInventory();
                                Bukkit.getServer().getScheduler().runTaskLater((Plugin)plugin, () -> this.open(player), 1L);
                            }
                            player.closeInventory();
                        });
                        is = new ItemStack(XMaterial.NAME_TAG.parseMaterial());
                        ItemMeta im = is.getItemMeta();
                        im.setDisplayName(configLoad.getString("Menu.Admin.Creator.Browse.Item.Information.Word.Enter"));
                        is.setItemMeta(im);
                        gui.setInput(is);
                        plugin.getGuiManager().showGUI(player, gui);
                        return;
                    }
                    if (event.getCurrentItem().getType() == XMaterial.BARRIER.parseMaterial() && is.hasItemMeta() && is.getItemMeta().getDisplayName().equals(ChatColor.translateAlternateColorCodes((char)'&', (String)configLoad.getString("Menu.Admin.Creator.Browse.Item.Nothing.Displayname")))) {
                        soundManager.playSound((CommandSender)player, XSound.BLOCK_ANVIL_LAND);
                        return;
                    }
                    if (event.getCurrentItem().getType() == XMaterial.NAME_TAG.parseMaterial() && is.hasItemMeta() && is.getItemMeta().getDisplayName().equals(ChatColor.translateAlternateColorCodes((char)'&', (String)configLoad.getString("Menu.Admin.Creator.Options.Item.Displayname.Displayname")))) {
                        if (playerData.getViewer() == null) {
                            messageManager.sendMessage((CommandSender)player, configLoad.getString("Island.Admin.Creator.Selected.Message"));
                            soundManager.playSound((CommandSender)player, XSound.BLOCK_ANVIL_LAND);
                            player.closeInventory();
                            Bukkit.getServer().getScheduler().runTaskLater((Plugin)plugin, () -> this.open(player), 1L);
                        } else {
                            String name = ((Viewer)playerData.getViewer()).getName();
                            if (structureManager.containsStructure(name)) {
                                soundManager.playSound((CommandSender)player, XSound.BLOCK_WOODEN_BUTTON_CLICK_ON);
                                AnvilGui gui = new AnvilGui(player);
                                gui.setAction(event1 -> {
                                    if (!(player.hasPermission("fabledskyblock.admin.creator") || player.hasPermission("fabledskyblock.admin.*") || player.hasPermission("fabledskyblock.*"))) {
                                        messageManager.sendMessage((CommandSender)player, configLoad.getString("Island.Admin.Creator.Permission.Message"));
                                        soundManager.playSound((CommandSender)player, XSound.BLOCK_ANVIL_LAND);
                                    } else if (playerData.getViewer() == null) {
                                        messageManager.sendMessage((CommandSender)player, configLoad.getString("Island.Admin.Creator.Selected.Message"));
                                        soundManager.playSound((CommandSender)player, XSound.BLOCK_ANVIL_LAND);
                                        player.closeInventory();
                                        Bukkit.getServer().getScheduler().runTaskLater((Plugin)plugin, () -> this.open(player), 1L);
                                    } else if (!structureManager.containsStructure(name)) {
                                        messageManager.sendMessage((CommandSender)player, configLoad.getString("Island.Admin.Creator.Exist.Message"));
                                        soundManager.playSound((CommandSender)player, XSound.BLOCK_ANVIL_LAND);
                                        player.closeInventory();
                                        Bukkit.getServer().getScheduler().runTaskLater((Plugin)plugin, () -> this.open(player), 1L);
                                    } else {
                                        Structure structure = structureManager.getStructure(name);
                                        structure.setDisplayname(gui.getInputText());
                                        soundManager.playSound((CommandSender)player, XSound.BLOCK_NOTE_BLOCK_PLING);
                                        Bukkit.getServer().getScheduler().runTaskAsynchronously((Plugin)plugin, () -> {
                                            FileManager.Config config1 = fileManager.getConfig(new File(plugin.getDataFolder(), "structures.yml"));
                                            FileConfiguration configLoad1 = config1.getFileConfiguration();
                                            configLoad1.set("Structures." + structure.getName() + ".Displayname", (Object)gui.getInputText());
                                            try {
                                                configLoad1.save(config1.getFile());
                                            }
                                            catch (IOException ex) {
                                                ex.printStackTrace();
                                            }
                                        });
                                        player.closeInventory();
                                        Bukkit.getServer().getScheduler().runTaskLater((Plugin)plugin, () -> this.open(player), 1L);
                                    }
                                    player.closeInventory();
                                });
                                is = new ItemStack(XMaterial.NAME_TAG.parseMaterial());
                                ItemMeta im = is.getItemMeta();
                                im.setDisplayName(configLoad.getString("Menu.Admin.Creator.Options.Item.Displayname.Word.Enter"));
                                is.setItemMeta(im);
                                gui.setInput(is);
                                plugin.getGuiManager().showGUI(player, gui);
                            } else {
                                playerData.setViewer(null);
                                messageManager.sendMessage((CommandSender)player, configLoad.getString("Island.Admin.Creator.Exist.Message"));
                                soundManager.playSound((CommandSender)player, XSound.BLOCK_ANVIL_LAND);
                                player.closeInventory();
                                Bukkit.getServer().getScheduler().runTaskLater((Plugin)plugin, () -> this.open(player), 1L);
                            }
                        }
                        return;
                    }
                    if (event.getCurrentItem().getType() == XMaterial.ENCHANTED_BOOK.parseMaterial() && is.hasItemMeta() && is.getItemMeta().getDisplayName().equals(ChatColor.translateAlternateColorCodes((char)'&', (String)configLoad.getString("Menu.Admin.Creator.Options.Item.Description.Displayname")))) {
                        if (playerData.getViewer() == null) {
                            messageManager.sendMessage((CommandSender)player, configLoad.getString("Island.Admin.Creator.Selected.Message"));
                            soundManager.playSound((CommandSender)player, XSound.BLOCK_ANVIL_LAND);
                            player.closeInventory();
                            Bukkit.getServer().getScheduler().runTaskLater((Plugin)plugin, () -> this.open(player), 1L);
                        } else {
                            String name = ((Viewer)playerData.getViewer()).getName();
                            if (structureManager.containsStructure(name)) {
                                Structure structure = structureManager.getStructure(name);
                                if (structure.getDescription() != null && !structure.getDescription().isEmpty()) {
                                    if (event.getClick() == ClickType.RIGHT) {
                                        structure.removeLine(structure.getDescription().size() - 1);
                                        soundManager.playSound((CommandSender)player, XSound.ENTITY_GENERIC_EXPLODE);
                                        Bukkit.getServer().getScheduler().runTaskAsynchronously((Plugin)plugin, () -> {
                                            FileManager.Config config12 = fileManager.getConfig(new File(plugin.getDataFolder(), "structures.yml"));
                                            FileConfiguration configLoad12 = config12.getFileConfiguration();
                                            configLoad12.set("Structures." + structure.getName() + ".Description", structure.getDescription());
                                            try {
                                                configLoad12.save(config12.getFile());
                                            }
                                            catch (IOException e) {
                                                e.printStackTrace();
                                            }
                                        });
                                        player.closeInventory();
                                        Bukkit.getServer().getScheduler().runTaskLater((Plugin)plugin, () -> this.open(player), 1L);
                                        return;
                                    }
                                    if (event.getClick() != ClickType.LEFT) {
                                        return;
                                    }
                                }
                                soundManager.playSound((CommandSender)player, XSound.BLOCK_WOODEN_BUTTON_CLICK_ON);
                                AnvilGui gui = new AnvilGui(player);
                                gui.setAction(event1 -> {
                                    if (!(player.hasPermission("fabledskyblock.admin.creator") || player.hasPermission("fabledskyblock.admin.*") || player.hasPermission("fabledskyblock.*"))) {
                                        messageManager.sendMessage((CommandSender)player, configLoad.getString("Island.Admin.Creator.Permission.Message"));
                                        soundManager.playSound((CommandSender)player, XSound.BLOCK_ANVIL_LAND);
                                    } else if (playerData.getViewer() == null) {
                                        messageManager.sendMessage((CommandSender)player, configLoad.getString("Island.Admin.Creator.Selected.Message"));
                                        soundManager.playSound((CommandSender)player, XSound.BLOCK_ANVIL_LAND);
                                        player.closeInventory();
                                        Bukkit.getServer().getScheduler().runTaskLater((Plugin)plugin, () -> this.open(player), 1L);
                                    } else if (!structureManager.containsStructure(name)) {
                                        messageManager.sendMessage((CommandSender)player, configLoad.getString("Island.Admin.Creator.Exist.Message"));
                                        soundManager.playSound((CommandSender)player, XSound.BLOCK_ANVIL_LAND);
                                        player.closeInventory();
                                        Bukkit.getServer().getScheduler().runTaskLater((Plugin)plugin, () -> this.open(player), 1L);
                                    } else {
                                        structure.addLine(gui.getInputText());
                                        soundManager.playSound((CommandSender)player, XSound.BLOCK_NOTE_BLOCK_PLING);
                                        Bukkit.getServer().getScheduler().runTaskAsynchronously((Plugin)plugin, () -> {
                                            FileManager.Config config13 = fileManager.getConfig(new File(plugin.getDataFolder(), "structures.yml"));
                                            FileConfiguration configLoad13 = config13.getFileConfiguration();
                                            configLoad13.set("Structures." + structure.getName() + ".Description", structure.getDescription());
                                            try {
                                                configLoad13.save(config13.getFile());
                                            }
                                            catch (IOException ex) {
                                                ex.printStackTrace();
                                            }
                                        });
                                        player.closeInventory();
                                        Bukkit.getServer().getScheduler().runTaskLater((Plugin)plugin, () -> this.open(player), 1L);
                                    }
                                    player.closeInventory();
                                });
                                is = new ItemStack(XMaterial.NAME_TAG.parseMaterial());
                                ItemMeta im = is.getItemMeta();
                                im.setDisplayName(configLoad.getString("Menu.Admin.Creator.Options.Item.Description.Word.Enter"));
                                is.setItemMeta(im);
                                gui.setInput(is);
                                plugin.getGuiManager().showGUI(player, gui);
                            } else {
                                playerData.setViewer(null);
                                messageManager.sendMessage((CommandSender)player, configLoad.getString("Island.Admin.Creator.Exist.Message"));
                                soundManager.playSound((CommandSender)player, XSound.BLOCK_ANVIL_LAND);
                                player.closeInventory();
                                Bukkit.getServer().getScheduler().runTaskLater((Plugin)plugin, () -> this.open(player), 1L);
                            }
                        }
                        return;
                    }
                    if (event.getCurrentItem().getType() == XMaterial.BOOK.parseMaterial() && is.hasItemMeta() && is.getItemMeta().getDisplayName().equals(ChatColor.translateAlternateColorCodes((char)'&', (String)configLoad.getString("Menu.Admin.Creator.Options.Item.Commands.Displayname")))) {
                        if (playerData.getViewer() == null) {
                            messageManager.sendMessage((CommandSender)player, configLoad.getString("Island.Admin.Creator.Selected.Message"));
                            soundManager.playSound((CommandSender)player, XSound.BLOCK_ANVIL_LAND);
                            player.closeInventory();
                            Bukkit.getServer().getScheduler().runTaskLater((Plugin)plugin, () -> this.open(player), 1L);
                        } else {
                            String name = ((Viewer)playerData.getViewer()).getName();
                            if (structureManager.containsStructure(name)) {
                                Structure structure = structureManager.getStructure(name);
                                if (structure.getCommands() != null && !structure.getCommands().isEmpty()) {
                                    if (event.getClick() == ClickType.RIGHT) {
                                        structure.removeCommand(structure.getCommands().size() - 1);
                                        soundManager.playSound((CommandSender)player, XSound.ENTITY_GENERIC_EXPLODE);
                                        Bukkit.getServer().getScheduler().runTaskAsynchronously((Plugin)plugin, () -> {
                                            FileManager.Config config14 = fileManager.getConfig(new File(plugin.getDataFolder(), "structures.yml"));
                                            FileConfiguration configLoad14 = config14.getFileConfiguration();
                                            configLoad14.set("Structures." + structure.getName() + ".Commands", structure.getCommands());
                                            try {
                                                configLoad14.save(config14.getFile());
                                            }
                                            catch (IOException ex) {
                                                ex.printStackTrace();
                                            }
                                        });
                                        player.closeInventory();
                                        Bukkit.getServer().getScheduler().runTaskLater((Plugin)plugin, () -> this.open(player), 1L);
                                        return;
                                    }
                                    if (event.getClick() != ClickType.LEFT) {
                                        return;
                                    }
                                }
                                soundManager.playSound((CommandSender)player, XSound.BLOCK_WOODEN_BUTTON_CLICK_ON);
                                AnvilGui gui = new AnvilGui(player);
                                gui.setAction(event1 -> {
                                    if (!(player.hasPermission("fabledskyblock.admin.creator") || player.hasPermission("fabledskyblock.admin.*") || player.hasPermission("fabledskyblock.*"))) {
                                        messageManager.sendMessage((CommandSender)player, configLoad.getString("Island.Admin.Creator.Permission.Message"));
                                        soundManager.playSound((CommandSender)player, XSound.BLOCK_ANVIL_LAND);
                                    } else if (playerData.getViewer() == null) {
                                        messageManager.sendMessage((CommandSender)player, configLoad.getString("Island.Admin.Creator.Selected.Message"));
                                        soundManager.playSound((CommandSender)player, XSound.BLOCK_ANVIL_LAND);
                                        player.closeInventory();
                                        Bukkit.getServer().getScheduler().runTaskLater((Plugin)plugin, () -> this.open(player), 1L);
                                    } else if (!structureManager.containsStructure(name)) {
                                        messageManager.sendMessage((CommandSender)player, configLoad.getString("Island.Admin.Creator.Exist.Message"));
                                        soundManager.playSound((CommandSender)player, XSound.BLOCK_ANVIL_LAND);
                                        player.closeInventory();
                                        Bukkit.getServer().getScheduler().runTaskLater((Plugin)plugin, () -> this.open(player), 1L);
                                    } else {
                                        structure.addCommand(gui.getInputText());
                                        soundManager.playSound((CommandSender)player, XSound.BLOCK_NOTE_BLOCK_PLING);
                                        Bukkit.getServer().getScheduler().runTaskAsynchronously((Plugin)plugin, () -> {
                                            FileManager.Config config15 = fileManager.getConfig(new File(plugin.getDataFolder(), "structures.yml"));
                                            FileConfiguration configLoad15 = config15.getFileConfiguration();
                                            configLoad15.set("Structures." + structure.getName() + ".Commands", structure.getCommands());
                                            try {
                                                configLoad15.save(config15.getFile());
                                            }
                                            catch (IOException ex) {
                                                ex.printStackTrace();
                                            }
                                        });
                                        player.closeInventory();
                                        Bukkit.getServer().getScheduler().runTaskLater((Plugin)plugin, () -> this.open(player), 1L);
                                    }
                                    player.closeInventory();
                                });
                                is = new ItemStack(XMaterial.NAME_TAG.parseMaterial());
                                ItemMeta im = is.getItemMeta();
                                im.setDisplayName(configLoad.getString("Menu.Admin.Creator.Options.Item.Commands.Word.Enter"));
                                is.setItemMeta(im);
                                gui.setInput(is);
                                plugin.getGuiManager().showGUI(player, gui);
                            } else {
                                playerData.setViewer(null);
                                messageManager.sendMessage((CommandSender)player, configLoad.getString("Island.Admin.Creator.Exist.Message"));
                                soundManager.playSound((CommandSender)player, XSound.BLOCK_ANVIL_LAND);
                                player.closeInventory();
                                Bukkit.getServer().getScheduler().runTaskLater((Plugin)plugin, () -> this.open(player), 1L);
                            }
                        }
                        return;
                    }
                    if (event.getCurrentItem().getType() == XMaterial.MAP.parseMaterial() && is.hasItemMeta() && is.getItemMeta().getDisplayName().equals(ChatColor.translateAlternateColorCodes((char)'&', (String)configLoad.getString("Menu.Admin.Creator.Options.Item.Permission.Displayname")))) {
                        if (playerData.getViewer() == null) {
                            messageManager.sendMessage((CommandSender)player, configLoad.getString("Island.Admin.Creator.Selected.Message"));
                            soundManager.playSound((CommandSender)player, XSound.BLOCK_ANVIL_LAND);
                            player.closeInventory();
                            Bukkit.getServer().getScheduler().runTaskLater((Plugin)plugin, () -> this.open(player), 1L);
                        } else {
                            String name = ((Viewer)playerData.getViewer()).getName();
                            if (structureManager.containsStructure(name)) {
                                Structure structure;
                                structure.setPermission(!(structure = structureManager.getStructure(name)).isPermission());
                                soundManager.playSound((CommandSender)player, XSound.BLOCK_WOODEN_BUTTON_CLICK_ON);
                                Bukkit.getServer().getScheduler().runTaskAsynchronously((Plugin)plugin, () -> {
                                    FileManager.Config config16 = fileManager.getConfig(new File(plugin.getDataFolder(), "structures.yml"));
                                    FileConfiguration configLoad16 = config16.getFileConfiguration();
                                    configLoad16.set("Structures." + structure.getName() + ".Permission", (Object)structure.isPermission());
                                    try {
                                        configLoad16.save(config16.getFile());
                                    }
                                    catch (IOException e) {
                                        e.printStackTrace();
                                    }
                                });
                            } else {
                                playerData.setViewer(null);
                                messageManager.sendMessage((CommandSender)player, configLoad.getString("Island.Admin.Creator.Exist.Message"));
                                soundManager.playSound((CommandSender)player, XSound.BLOCK_ANVIL_LAND);
                            }
                            player.closeInventory();
                            Bukkit.getServer().getScheduler().runTaskLater((Plugin)plugin, () -> this.open(player), 1L);
                        }
                        return;
                    }
                    if (event.getCurrentItem().getType() == XMaterial.PAPER.parseMaterial() && is.hasItemMeta() && is.getItemMeta().getDisplayName().equals(ChatColor.translateAlternateColorCodes((char)'&', (String)configLoad.getString("Menu.Admin.Creator.Options.Item.File.Displayname")))) {
                        if (event.getClick() == ClickType.LEFT || event.getClick() == ClickType.MIDDLE || event.getClick() == ClickType.RIGHT) {
                            if (playerData.getViewer() == null) {
                                messageManager.sendMessage((CommandSender)player, configLoad.getString("Island.Admin.Creator.Selected.Message"));
                                soundManager.playSound((CommandSender)player, XSound.BLOCK_ANVIL_LAND);
                                player.closeInventory();
                                Bukkit.getServer().getScheduler().runTaskLater((Plugin)plugin, () -> this.open(player), 1L);
                            } else {
                                String name = ((Viewer)playerData.getViewer()).getName();
                                if (structureManager.containsStructure(name)) {
                                    soundManager.playSound((CommandSender)player, XSound.BLOCK_WOODEN_BUTTON_CLICK_ON);
                                    AnvilGui gui = new AnvilGui(player);
                                    gui.setAction(event1 -> {
                                        if (!(player.hasPermission("fabledskyblock.admin.creator") || player.hasPermission("fabledskyblock.admin.*") || player.hasPermission("fabledskyblock.*"))) {
                                            messageManager.sendMessage((CommandSender)player, configLoad.getString("Island.Admin.Creator.Permission.Message"));
                                            soundManager.playSound((CommandSender)player, XSound.BLOCK_ANVIL_LAND);
                                        } else if (playerData.getViewer() == null) {
                                            messageManager.sendMessage((CommandSender)player, configLoad.getString("Island.Admin.Creator.Selected.Message"));
                                            soundManager.playSound((CommandSender)player, XSound.BLOCK_ANVIL_LAND);
                                            player.closeInventory();
                                            Bukkit.getServer().getScheduler().runTaskLater((Plugin)plugin, () -> this.open(player), 1L);
                                        } else if (!structureManager.containsStructure(name)) {
                                            messageManager.sendMessage((CommandSender)player, configLoad.getString("Island.Admin.Creator.Exist.Message"));
                                            soundManager.playSound((CommandSender)player, XSound.BLOCK_ANVIL_LAND);
                                            player.closeInventory();
                                            Bukkit.getServer().getScheduler().runTaskLater((Plugin)plugin, () -> this.open(player), 1L);
                                        } else {
                                            String fileName = gui.getInputText();
                                            if (fileManager.isFileExist(new File(plugin.getDataFolder() + "/structures", fileName)) || fileManager.isFileExist(new File(plugin.getDataFolder() + "/schematics", fileName))) {
                                                if (event.getClick() == ClickType.LEFT) {
                                                    Structure structure = structureManager.getStructure(name);
                                                    structure.setOverworldFile(fileName);
                                                    soundManager.playSound((CommandSender)player, XSound.BLOCK_NOTE_BLOCK_PLING);
                                                    Bukkit.getServer().getScheduler().runTaskAsynchronously((Plugin)plugin, () -> {
                                                        FileManager.Config config17 = fileManager.getConfig(new File(plugin.getDataFolder(), "structures.yml"));
                                                        FileConfiguration configLoad17 = config17.getFileConfiguration();
                                                        configLoad17.set("Structures." + structure.getName() + ".File.Overworld", (Object)fileName);
                                                        try {
                                                            configLoad17.save(config17.getFile());
                                                        }
                                                        catch (IOException e) {
                                                            e.printStackTrace();
                                                        }
                                                    });
                                                } else if (event.getClick() == ClickType.MIDDLE) {
                                                    Structure structure = structureManager.getStructure(name);
                                                    structure.setNetherFile(fileName);
                                                    soundManager.playSound((CommandSender)player, XSound.BLOCK_NOTE_BLOCK_PLING);
                                                    Bukkit.getServer().getScheduler().runTaskAsynchronously((Plugin)plugin, () -> {
                                                        FileManager.Config config18 = fileManager.getConfig(new File(plugin.getDataFolder(), "structures.yml"));
                                                        FileConfiguration configLoad18 = config18.getFileConfiguration();
                                                        configLoad18.set("Structures." + structure.getName() + ".File.Nether", (Object)fileName);
                                                        try {
                                                            configLoad18.save(config18.getFile());
                                                        }
                                                        catch (IOException ex) {
                                                            ex.printStackTrace();
                                                        }
                                                    });
                                                } else {
                                                    Structure structure = structureManager.getStructure(name);
                                                    structure.setEndFile(fileName);
                                                    soundManager.playSound((CommandSender)player, XSound.BLOCK_NOTE_BLOCK_PLING);
                                                    Bukkit.getServer().getScheduler().runTaskAsynchronously((Plugin)plugin, () -> {
                                                        FileManager.Config config19 = fileManager.getConfig(new File(plugin.getDataFolder(), "structures.yml"));
                                                        FileConfiguration configLoad19 = config19.getFileConfiguration();
                                                        configLoad19.set("Structures." + structure.getName() + ".File.End", (Object)fileName);
                                                        try {
                                                            configLoad19.save(config19.getFile());
                                                        }
                                                        catch (IOException ex) {
                                                            ex.printStackTrace();
                                                        }
                                                    });
                                                }
                                            } else {
                                                messageManager.sendMessage((CommandSender)player, configLoad.getString("Island.Admin.Creator.File.Message"));
                                                soundManager.playSound((CommandSender)player, XSound.BLOCK_ANVIL_LAND);
                                            }
                                            player.closeInventory();
                                            Bukkit.getServer().getScheduler().runTaskLater((Plugin)plugin, () -> this.open(player), 1L);
                                        }
                                        player.closeInventory();
                                    });
                                    is = new ItemStack(XMaterial.NAME_TAG.parseMaterial());
                                    ItemMeta im = is.getItemMeta();
                                    im.setDisplayName(configLoad.getString("Menu.Admin.Creator.Options.Item.File.Word.Enter"));
                                    is.setItemMeta(im);
                                    gui.setInput(is);
                                    plugin.getGuiManager().showGUI(player, gui);
                                } else {
                                    playerData.setViewer(null);
                                    messageManager.sendMessage((CommandSender)player, configLoad.getString("Island.Admin.Creator.Exist.Message"));
                                    soundManager.playSound((CommandSender)player, XSound.BLOCK_ANVIL_LAND);
                                    player.closeInventory();
                                    Bukkit.getServer().getScheduler().runTaskLater((Plugin)plugin, () -> this.open(player), 1L);
                                }
                            }
                        }
                        return;
                    }
                    if (event.getCurrentItem().getType() == XMaterial.DIAMOND.parseMaterial() && is.hasItemMeta() && is.getItemMeta().getDisplayName().equals(ChatColor.translateAlternateColorCodes((char)'&', (String)configLoad.getString("Menu.Admin.Creator.Options.Item.Item.Displayname")))) {
                        if (playerData.getViewer() == null) {
                            messageManager.sendMessage((CommandSender)player, configLoad.getString("Island.Admin.Creator.Selected.Message"));
                            soundManager.playSound((CommandSender)player, XSound.BLOCK_ANVIL_LAND);
                            player.closeInventory();
                            Bukkit.getServer().getScheduler().runTaskLater((Plugin)plugin, () -> this.open(player), 1L);
                        } else {
                            Viewer viewer2 = (Viewer)playerData.getViewer();
                            String name = viewer2.getName();
                            if (viewer2.isItem()) {
                                viewer2.setItem(false);
                                messageManager.sendMessage((CommandSender)player, configLoad.getString("Island.Admin.Creator.Item.Cancelled.Message"));
                                soundManager.playSound((CommandSender)player, XSound.ENTITY_IRON_GOLEM_ATTACK);
                            } else if (structureManager.containsStructure(name)) {
                                viewer2.setItem(true);
                                messageManager.sendMessage((CommandSender)player, configLoad.getString("Island.Admin.Creator.Item.Added.Message"));
                                soundManager.playSound((CommandSender)player, XSound.BLOCK_WOODEN_BUTTON_CLICK_ON);
                            } else {
                                playerData.setViewer(null);
                                messageManager.sendMessage((CommandSender)player, configLoad.getString("Island.Admin.Creator.Exist.Message"));
                                soundManager.playSound((CommandSender)player, XSound.BLOCK_ANVIL_LAND);
                                player.closeInventory();
                                Bukkit.getServer().getScheduler().runTaskLater((Plugin)plugin, () -> this.open(player), 1L);
                            }
                        }
                        return;
                    }
                    if (event.getCurrentItem().getType() == XMaterial.GOLD_NUGGET.parseMaterial() && is.hasItemMeta() && is.getItemMeta().getDisplayName().equals(ChatColor.translateAlternateColorCodes((char)'&', (String)configLoad.getString("Menu.Admin.Creator.Options.Item.DeletionCost.Displayname")))) {
                        if (playerData.getViewer() == null) {
                            messageManager.sendMessage((CommandSender)player, configLoad.getString("Island.Admin.Creator.Selected.Message"));
                            soundManager.playSound((CommandSender)player, XSound.BLOCK_ANVIL_LAND);
                            player.closeInventory();
                            Bukkit.getServer().getScheduler().runTaskLater((Plugin)plugin, () -> this.open(player), 1L);
                        } else {
                            String name = ((Viewer)playerData.getViewer()).getName();
                            if (structureManager.containsStructure(name)) {
                                soundManager.playSound((CommandSender)player, XSound.BLOCK_WOODEN_BUTTON_CLICK_ON);
                                AnvilGui gui = new AnvilGui(player);
                                gui.setAction(event1 -> {
                                    if (!(player.hasPermission("fabledskyblock.admin.creator") || player.hasPermission("fabledskyblock.admin.*") || player.hasPermission("fabledskyblock.*"))) {
                                        messageManager.sendMessage((CommandSender)player, configLoad.getString("Island.Admin.Creator.Permission.Message"));
                                        soundManager.playSound((CommandSender)player, XSound.BLOCK_ANVIL_LAND);
                                        return;
                                    }
                                    if (playerData.getViewer() == null) {
                                        messageManager.sendMessage((CommandSender)player, configLoad.getString("Island.Admin.Creator.Selected.Message"));
                                        soundManager.playSound((CommandSender)player, XSound.BLOCK_ANVIL_LAND);
                                        player.closeInventory();
                                        Bukkit.getServer().getScheduler().runTaskLater((Plugin)plugin, () -> this.open(player), 1L);
                                        return;
                                    }
                                    if (!structureManager.containsStructure(name)) {
                                        messageManager.sendMessage((CommandSender)player, configLoad.getString("Island.Admin.Creator.Exist.Message"));
                                        soundManager.playSound((CommandSender)player, XSound.BLOCK_ANVIL_LAND);
                                        player.closeInventory();
                                        Bukkit.getServer().getScheduler().runTaskLater((Plugin)plugin, () -> this.open(player), 1L);
                                        return;
                                    }
                                    if (!gui.getInputText().matches("[0-9]+") && !gui.getInputText().matches("([0-9]*)\\.([0-9]{1,2}$)")) {
                                        messageManager.sendMessage((CommandSender)player, configLoad.getString("Island.Admin.Creator.Numerical.Message"));
                                        soundManager.playSound((CommandSender)player, XSound.BLOCK_ANVIL_LAND);
                                        player.closeInventory();
                                        return;
                                    }
                                    double deletionCost = Double.parseDouble(gui.getInputText());
                                    Structure structure = structureManager.getStructure(name);
                                    structure.setDeletionCost(deletionCost);
                                    soundManager.playSound((CommandSender)player, XSound.BLOCK_NOTE_BLOCK_PLING);
                                    Bukkit.getServer().getScheduler().runTaskAsynchronously((Plugin)plugin, () -> {
                                        FileManager.Config config112 = fileManager.getConfig(new File(plugin.getDataFolder(), "structures.yml"));
                                        FileConfiguration configLoad112 = config112.getFileConfiguration();
                                        configLoad112.set("Structures." + structure.getName() + ".Deletion.Cost", (Object)deletionCost);
                                        try {
                                            configLoad112.save(config112.getFile());
                                        }
                                        catch (IOException ex) {
                                            ex.printStackTrace();
                                        }
                                    });
                                    Bukkit.getServer().getScheduler().runTaskLater((Plugin)plugin, () -> this.open(player), 1L);
                                    player.closeInventory();
                                });
                                is = new ItemStack(XMaterial.NAME_TAG.parseMaterial());
                                ItemMeta im = is.getItemMeta();
                                im.setDisplayName(configLoad.getString("Menu.Admin.Creator.Options.Item.DeletionCost.Word.Enter"));
                                is.setItemMeta(im);
                                gui.setInput(is);
                                plugin.getGuiManager().showGUI(player, gui);
                            } else {
                                playerData.setViewer(null);
                                messageManager.sendMessage((CommandSender)player, configLoad.getString("Island.Admin.Creator.Exist.Message"));
                                soundManager.playSound((CommandSender)player, XSound.BLOCK_ANVIL_LAND);
                                player.closeInventory();
                                Bukkit.getServer().getScheduler().runTaskLater((Plugin)plugin, () -> this.open(player), 1L);
                            }
                        }
                        return;
                    }
                }
                if (playerData.getViewer() != null && (viewer = (Viewer)playerData.getViewer()).isItem()) {
                    if (structureManager.containsStructure(viewer.getName())) {
                        Structure structure = structureManager.getStructure(viewer.getName());
                        XMaterial materials = CompatibleMaterial.getMaterial(event.getCurrentItem().getType()).get();
                        materials.parseItem().setData(event.getCurrentItem().getData());
                        structure.setMaterial(materials);
                        Bukkit.getServer().getScheduler().runTaskAsynchronously((Plugin)plugin, () -> {
                            FileManager.Config config113 = fileManager.getConfig(new File(plugin.getDataFolder(), "structures.yml"));
                            FileConfiguration configLoad113 = config113.getFileConfiguration();
                            configLoad113.set("Structures." + structure.getName() + ".Item.Material", (Object)structure.getMaterial().name());
                            try {
                                configLoad113.save(config113.getFile());
                            }
                            catch (IOException ex) {
                                ex.printStackTrace();
                            }
                        });
                        viewer.setItem(false);
                        messageManager.sendMessage((CommandSender)player, configLoad.getString("Island.Admin.Creator.Item.Removed.Message"));
                        soundManager.playSound((CommandSender)player, XSound.ENTITY_PLAYER_LEVELUP);
                    } else {
                        playerData.setViewer(null);
                        messageManager.sendMessage((CommandSender)player, configLoad.getString("Island.Admin.Creator.Exist.Message"));
                        soundManager.playSound((CommandSender)player, XSound.BLOCK_ANVIL_LAND);
                    }
                    player.closeInventory();
                    Bukkit.getServer().getScheduler().runTaskLater((Plugin)plugin, () -> this.open(player), 1L);
                    return;
                }
                if (is.hasItemMeta() && is.getItemMeta().hasDisplayName()) {
                    for (Structure structureList : structureManager.getStructures()) {
                        if (!structureList.getMaterial().isSimilar(event.getCurrentItem()) || !ChatColor.stripColor((String)is.getItemMeta().getDisplayName()).equals(structureList.getName())) continue;
                        if (event.getClick() == ClickType.LEFT) {
                            playerData.setViewer(new Viewer(structureList.getName()));
                            soundManager.playSound((CommandSender)player, XSound.BLOCK_WOODEN_BUTTON_CLICK_ON);
                            player.closeInventory();
                            Bukkit.getServer().getScheduler().runTaskLater((Plugin)plugin, () -> this.open(player), 1L);
                        } else if (event.getClick() == ClickType.RIGHT) {
                            structureManager.removeStructure(structureList);
                            messageManager.sendMessage((CommandSender)player, configLoad.getString("Island.Admin.Creator.Removed.Message").replace("%structure", structureList.getName()));
                            soundManager.playSound((CommandSender)player, XSound.ENTITY_IRON_GOLEM_ATTACK);
                            Bukkit.getServer().getScheduler().runTaskAsynchronously((Plugin)plugin, () -> {
                                FileManager.Config config110 = fileManager.getConfig(new File(plugin.getDataFolder(), "structures.yml"));
                                FileConfiguration configLoad110 = config110.getFileConfiguration();
                                configLoad110.set("Structures." + structureList.getName(), null);
                                try {
                                    configLoad110.save(config110.getFile());
                                }
                                catch (IOException ex) {
                                    ex.printStackTrace();
                                }
                            });
                            player.closeInventory();
                            Bukkit.getServer().getScheduler().runTaskLater((Plugin)plugin, () -> this.open(player), 1L);
                        }
                        return;
                    }
                    messageManager.sendMessage((CommandSender)player, configLoad.getString("Island.Admin.Creator.Exist.Message"));
                    soundManager.playSound((CommandSender)player, XSound.BLOCK_ANVIL_LAND);
                    player.closeInventory();
                    Bukkit.getServer().getScheduler().runTaskLater((Plugin)plugin, () -> this.open(player), 1L);
                }
            }
        }
    }

    @EventHandler
    public void onInventoryClose(InventoryCloseEvent event) {
        Viewer viewer;
        PlayerDataManager playerDataManager;
        Player player = (Player)event.getPlayer();
        SkyBlock plugin = (SkyBlock)SkyBlock.getPlugin(SkyBlock.class);
        FileManager.Config config = plugin.getFileManager().getConfig(new File(plugin.getDataFolder(), "language.yml"));
        FileConfiguration configLoad = config.getFileConfiguration();
        String inventoryName = "";
        if (MajorServerVersion.isServerVersionAbove(MajorServerVersion.V1_13)) {
            inventoryName = event.getView().getTitle();
        } else {
            try {
                inventoryName = (String)Inventory.class.getMethod("getName", new Class[0]).invoke((Object)event.getInventory(), new Object[0]);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        if (inventoryName.equals(ChatColor.translateAlternateColorCodes((char)'&', (String)configLoad.getString("Menu.Admin.Creator.Title"))) && (playerDataManager = plugin.getPlayerDataManager()).hasPlayerData(player) && (viewer = (Viewer)playerDataManager.getPlayerData(player).getViewer()) != null && viewer.isItem()) {
            viewer.setItem(false);
            plugin.getMessageManager().sendMessage((CommandSender)player, configLoad.getString("Island.Admin.Creator.Item.Removed.Message"));
            plugin.getSoundManager().playSound((CommandSender)player, XSound.ENTITY_IRON_GOLEM_ATTACK);
        }
    }

    public class Viewer {
        private final String name;
        private boolean item = false;

        public Viewer(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public boolean isItem() {
            return this.item;
        }

        public void setItem(boolean item) {
            this.item = item;
        }
    }
}

