/*
 * Decompiled with CFR 0.152.
 */
package com.craftaro.skyblock.menus;

import com.craftaro.skyblock.SkyBlock;
import com.craftaro.skyblock.core.utils.SkullItemCreator;
import com.craftaro.skyblock.island.Island;
import com.craftaro.skyblock.island.IslandManager;
import com.craftaro.skyblock.island.IslandRole;
import com.craftaro.skyblock.menus.MenuType;
import com.craftaro.skyblock.permission.PermissionManager;
import com.craftaro.skyblock.placeholder.Placeholder;
import com.craftaro.skyblock.playerdata.PlayerData;
import com.craftaro.skyblock.playerdata.PlayerDataManager;
import com.craftaro.skyblock.sound.SoundManager;
import com.craftaro.skyblock.utils.NumberUtil;
import com.craftaro.skyblock.utils.item.nInventoryUtil;
import com.craftaro.third_party.com.cryptomorin.xseries.XMaterial;
import com.craftaro.third_party.com.cryptomorin.xseries.XSound;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeMap;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class Visitors {
    private static Visitors instance;

    public static Visitors getInstance() {
        if (instance == null) {
            instance = new Visitors();
        }
        return instance;
    }

    public void open(Player player) {
        SkyBlock plugin = (SkyBlock)SkyBlock.getPlugin(SkyBlock.class);
        PlayerDataManager playerDataManager = plugin.getPlayerDataManager();
        IslandManager islandManager = plugin.getIslandManager();
        PermissionManager permissionManager = plugin.getPermissionManager();
        SoundManager soundManager = plugin.getSoundManager();
        if (playerDataManager.hasPlayerData(player)) {
            FileConfiguration configLoad = plugin.getLanguage();
            nInventoryUtil nInv = new nInventoryUtil(player, event -> {
                block14: {
                    String playerName;
                    boolean banningEnabled;
                    boolean canBan;
                    boolean isOperator;
                    block15: {
                        if (!playerDataManager.hasPlayerData(player)) return;
                        PlayerData playerData = plugin.getPlayerDataManager().getPlayerData(player);
                        Island island = islandManager.getIsland((OfflinePlayer)player);
                        if (island == null) {
                            plugin.getMessageManager().sendMessage((CommandSender)player, configLoad.getString("Command.Island.Visitors.Owner.Message"));
                            soundManager.playSound((CommandSender)player, XSound.BLOCK_ANVIL_LAND);
                            return;
                        }
                        ItemStack is = event.getItem();
                        if (is.getType() == XMaterial.BLACK_STAINED_GLASS_PANE.parseMaterial() && is.hasItemMeta() && is.getItemMeta().getDisplayName().equals(ChatColor.translateAlternateColorCodes((char)'&', (String)configLoad.getString("Menu.Visitors.Item.Barrier.Displayname")))) {
                            soundManager.playSound((CommandSender)player, XSound.BLOCK_GLASS_BREAK);
                            event.setWillClose(false);
                            event.setWillDestroy(false);
                            return;
                        }
                        if (is.getType() == XMaterial.OAK_FENCE_GATE.parseMaterial() && is.hasItemMeta() && is.getItemMeta().getDisplayName().equals(ChatColor.translateAlternateColorCodes((char)'&', (String)configLoad.getString("Menu.Visitors.Item.Exit.Displayname")))) {
                            soundManager.playSound((CommandSender)player, XSound.BLOCK_CHEST_CLOSE);
                            return;
                        }
                        if (is.getType() == Material.PAINTING && is.hasItemMeta() && is.getItemMeta().getDisplayName().equals(ChatColor.translateAlternateColorCodes((char)'&', (String)configLoad.getString("Menu.Visitors.Item.Statistics.Displayname")))) {
                            soundManager.playSound((CommandSender)player, XSound.ENTITY_VILLAGER_YES);
                            event.setWillClose(false);
                            event.setWillDestroy(false);
                            return;
                        }
                        if (is.getType() == Material.BARRIER && is.hasItemMeta() && is.getItemMeta().getDisplayName().equals(ChatColor.translateAlternateColorCodes((char)'&', (String)configLoad.getString("Menu.Visitors.Item.Nothing.Displayname")))) {
                            soundManager.playSound((CommandSender)player, XSound.BLOCK_ANVIL_LAND);
                            event.setWillClose(false);
                            event.setWillDestroy(false);
                            return;
                        }
                        if (is.getType() != XMaterial.PLAYER_HEAD.parseMaterial()) return;
                        if (!is.hasItemMeta()) return;
                        if (is.getItemMeta().getDisplayName().equals(ChatColor.translateAlternateColorCodes((char)'&', (String)configLoad.getString("Menu.Visitors.Item.Previous.Displayname")))) {
                            playerData.setPage(MenuType.VISITORS, playerData.getPage(MenuType.VISITORS) - 1);
                            soundManager.playSound((CommandSender)player, XSound.ENTITY_ARROW_HIT);
                            Bukkit.getServer().getScheduler().runTaskLater((Plugin)plugin, () -> this.open(player), 1L);
                            return;
                        }
                        if (is.getItemMeta().getDisplayName().equals(ChatColor.translateAlternateColorCodes((char)'&', (String)configLoad.getString("Menu.Visitors.Item.Next.Displayname")))) {
                            playerData.setPage(MenuType.VISITORS, playerData.getPage(MenuType.VISITORS) + 1);
                            soundManager.playSound((CommandSender)player, XSound.ENTITY_ARROW_HIT);
                            Bukkit.getServer().getScheduler().runTaskLater((Plugin)plugin, () -> this.open(player), 1L);
                            return;
                        }
                        isOperator = island.hasRole(IslandRole.OPERATOR, player.getUniqueId());
                        boolean isOwner = island.hasRole(IslandRole.OWNER, player.getUniqueId());
                        boolean canKick = permissionManager.hasPermission(island, "Kick", IslandRole.OPERATOR);
                        canBan = permissionManager.hasPermission(island, "Ban", IslandRole.OPERATOR);
                        banningEnabled = plugin.getConfiguration().getBoolean("Island.Visitor.Banning");
                        playerName = ChatColor.stripColor((String)is.getItemMeta().getDisplayName());
                        if ((!isOperator || !canKick) && !isOwner) break block15;
                        if (banningEnabled && (isOperator && canBan || isOwner)) {
                            if (event.getClick() == ClickType.LEFT) {
                                Bukkit.getServer().dispatchCommand((CommandSender)player, "island kick " + playerName);
                                break block14;
                            } else {
                                if (event.getClick() != ClickType.RIGHT) {
                                    soundManager.playSound((CommandSender)player, XSound.ENTITY_CHICKEN_EGG);
                                    event.setWillClose(false);
                                    event.setWillDestroy(false);
                                    return;
                                }
                                Bukkit.getServer().dispatchCommand((CommandSender)player, "island ban " + playerName);
                            }
                            break block14;
                        } else {
                            Bukkit.getServer().dispatchCommand((CommandSender)player, "island kick " + playerName);
                        }
                        break block14;
                    }
                    if (banningEnabled && isOperator && canBan) {
                        Bukkit.getServer().dispatchCommand((CommandSender)player, "island ban " + playerName);
                    } else {
                        soundManager.playSound((CommandSender)player, XSound.ENTITY_CHICKEN_EGG);
                        event.setWillClose(false);
                        event.setWillDestroy(false);
                        return;
                    }
                }
                Bukkit.getServer().getScheduler().runTaskLater((Plugin)plugin, () -> this.open(player), 1L);
            });
            PlayerData playerData = playerDataManager.getPlayerData(player);
            Island island = plugin.getIslandManager().getIsland((OfflinePlayer)player);
            Set<UUID> islandVisitors = islandManager.getVisitorsAtIsland(island);
            TreeMap<Integer, UUID> sortedIslandVisitors = new TreeMap<Integer, UUID>();
            for (UUID islandVisitorList : islandVisitors) {
                Player targetPlayer = Bukkit.getPlayer((UUID)islandVisitorList);
                if (targetPlayer == null || !player.canSee(targetPlayer)) continue;
                sortedIslandVisitors.put(playerDataManager.getPlayerData(targetPlayer).getVisitTime(), islandVisitorList);
            }
            nInv.addItem(nInv.createItem(XMaterial.OAK_FENCE_GATE.parseItem(), configLoad.getString("Menu.Visitors.Item.Exit.Displayname"), null, null, null, null), 0, 8);
            nInv.addItem(nInv.createItem(new ItemStack(Material.PAINTING), configLoad.getString("Menu.Visitors.Item.Statistics.Displayname"), configLoad.getStringList("Menu.Visitors.Item.Statistics.Lore"), new Placeholder[]{new Placeholder("%visitors", "" + sortedIslandVisitors.size())}, null, null), 4);
            nInv.addItem(nInv.createItem(XMaterial.BLACK_STAINED_GLASS_PANE.parseItem(), configLoad.getString("Menu.Visitors.Item.Barrier.Displayname"), null, null, null, null), 9, 10, 11, 12, 13, 14, 15, 16, 17);
            islandVisitors.clear();
            Iterator<UUID> iterator = sortedIslandVisitors.keySet().iterator();
            while (iterator.hasNext()) {
                int sortedIslandVisitorList = (Integer)((Object)iterator.next());
                islandVisitors.add((UUID)sortedIslandVisitors.get(sortedIslandVisitorList));
            }
            int playerMenuPage = playerData.getPage(MenuType.VISITORS);
            int nextEndIndex = sortedIslandVisitors.size() - playerMenuPage * 36;
            if (playerMenuPage != 1) {
                ItemStack Lhead = SkullItemCreator.byTextureUrlHash("3ebf907494a935e955bfcadab81beafb90fb9be49c7026ba97d798d5f1a23");
                nInv.addItem(nInv.createItem(Lhead, configLoad.getString("Menu.Visitors.Item.Previous.Displayname"), null, null, null, null), 1);
            }
            if (nextEndIndex != 0 && nextEndIndex >= 0) {
                ItemStack Rhead = SkullItemCreator.byTextureUrlHash("1b6f1a25b6bc199946472aedb370522584ff6f4e83221e5946bd2e41b5ca13b");
                nInv.addItem(nInv.createItem(Rhead, configLoad.getString("Menu.Visitors.Item.Next.Displayname"), null, null, null, null), 7);
            }
            if (islandVisitors.size() == 0) {
                nInv.addItem(nInv.createItem(new ItemStack(Material.BARRIER), configLoad.getString("Menu.Visitors.Item.Nothing.Displayname"), null, null, null, null), 31);
            } else {
                boolean isOperator = island.hasRole(IslandRole.OPERATOR, player.getUniqueId());
                boolean isOwner = island.hasRole(IslandRole.OWNER, player.getUniqueId());
                boolean canKick = plugin.getPermissionManager().hasPermission(island, "Kick", IslandRole.OPERATOR);
                boolean canBan = plugin.getPermissionManager().hasPermission(island, "Ban", IslandRole.OPERATOR);
                boolean banningEnabled = plugin.getConfiguration().getBoolean("Island.Visitor.Banning");
                int index = playerMenuPage * 36 - 36;
                int endIndex = index >= islandVisitors.size() ? islandVisitors.size() - 1 : index + 36;
                int inventorySlot = 17;
                while (index < endIndex) {
                    if (islandVisitors.size() > index) {
                        ++inventorySlot;
                        Player targetPlayer = Bukkit.getServer().getPlayer((UUID)islandVisitors.toArray()[index]);
                        PlayerData targetPlayerData = playerDataManager.getPlayerData(targetPlayer.getUniqueId());
                        String[] targetPlayerTexture = targetPlayerData.getTexture();
                        long[] islandVisitTime = NumberUtil.getDuration(targetPlayerData.getVisitTime());
                        String islandVisitTimeFormatted = islandVisitTime[0] != 0L ? islandVisitTime[0] + " " + configLoad.getString("Menu.Visitors.Item.Visitor.Word.Days") + ", " + islandVisitTime[1] + " " + configLoad.getString("Menu.Visitors.Item.Visitor.Word.Hours") + ", " + islandVisitTime[2] + " " + configLoad.getString("Menu.Visitors.Item.Visitor.Word.Minutes") + ", " + islandVisitTime[3] + " " + configLoad.getString("Menu.Visitors.Item.Visitor.Word.Seconds") : (islandVisitTime[1] != 0L ? islandVisitTime[1] + " " + configLoad.getString("Menu.Visitors.Item.Visitor.Word.Hours") + ", " + islandVisitTime[2] + " " + configLoad.getString("Menu.Visitors.Item.Visitor.Word.Minutes") + ", " + islandVisitTime[3] + " " + configLoad.getString("Menu.Visitors.Item.Visitor.Word.Seconds") : (islandVisitTime[2] != 0L ? islandVisitTime[2] + " " + configLoad.getString("Menu.Visitors.Item.Visitor.Word.Minutes") + ", " + islandVisitTime[3] + " " + configLoad.getString("Menu.Visitors.Item.Visitor.Word.Seconds") : islandVisitTime[3] + " " + configLoad.getString("Menu.Visitors.Item.Visitor.Word.Seconds")));
                        ArrayList<String> itemLore = new ArrayList<String>();
                        if (isOperator && canKick || isOwner) {
                            if (banningEnabled && (isOperator && canBan || isOwner)) {
                                itemLore.addAll(configLoad.getStringList("Menu.Visitors.Item.Visitor.Kick.Permission.Ban.Permission.Lore"));
                            } else {
                                itemLore.addAll(configLoad.getStringList("Menu.Visitors.Item.Visitor.Kick.Permission.Ban.NoPermission.Lore"));
                            }
                        } else if (banningEnabled && (isOperator && canBan || isOwner)) {
                            itemLore.addAll(configLoad.getStringList("Menu.Visitors.Item.Visitor.Kick.NoPermission.Ban.Permission.Lore"));
                        } else {
                            itemLore.addAll(configLoad.getStringList("Menu.Visitors.Item.Visitor.Kick.NoPermission.Ban.NoPermission.Lore"));
                        }
                        ItemStack phead = SkullItemCreator.byPlayer(targetPlayer);
                        nInv.addItem(nInv.createItem(phead, ChatColor.translateAlternateColorCodes((char)'&', (String)configLoad.getString("Menu.Visitors.Item.Visitor.Displayname").replace("%player", targetPlayer.getName())), itemLore, new Placeholder[]{new Placeholder("%time", islandVisitTimeFormatted)}, null, null), inventorySlot);
                    }
                    ++index;
                }
            }
            nInv.setTitle(ChatColor.translateAlternateColorCodes((char)'&', (String)configLoad.getString("Menu.Visitors.Title")));
            nInv.setRows(6);
            Bukkit.getServer().getScheduler().runTask((Plugin)plugin, nInv::open);
        }
    }
}

