/*
 * Decompiled with CFR 0.152.
 */
package com.craftaro.skyblock.menus;

import com.craftaro.skyblock.SkyBlock;
import com.craftaro.skyblock.api.event.player.PlayerVoteEvent;
import com.craftaro.skyblock.config.FileManager;
import com.craftaro.skyblock.core.utils.NumberUtils;
import com.craftaro.skyblock.core.utils.SkullItemCreator;
import com.craftaro.skyblock.island.Island;
import com.craftaro.skyblock.island.IslandManager;
import com.craftaro.skyblock.island.IslandRole;
import com.craftaro.skyblock.island.IslandStatus;
import com.craftaro.skyblock.menus.MenuType;
import com.craftaro.skyblock.message.MessageManager;
import com.craftaro.skyblock.placeholder.Placeholder;
import com.craftaro.skyblock.playerdata.PlayerData;
import com.craftaro.skyblock.playerdata.PlayerDataManager;
import com.craftaro.skyblock.sound.SoundManager;
import com.craftaro.skyblock.utils.StringUtil;
import com.craftaro.skyblock.utils.item.nInventoryUtil;
import com.craftaro.skyblock.visit.VisitManager;
import com.craftaro.third_party.com.cryptomorin.xseries.XMaterial;
import com.craftaro.third_party.com.cryptomorin.xseries.XSound;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class Visit {
    private static Visit instance;

    public static Visit getInstance() {
        if (instance == null) {
            instance = new Visit();
        }
        return instance;
    }

    public void open(Player player, Type type, Sort sort) {
        SkyBlock plugin = (SkyBlock)SkyBlock.getPlugin(SkyBlock.class);
        PlayerDataManager playerDataManager = plugin.getPlayerDataManager();
        MessageManager messageManager = plugin.getMessageManager();
        IslandManager islandManager = plugin.getIslandManager();
        SoundManager soundManager = plugin.getSoundManager();
        VisitManager visitManager = plugin.getVisitManager();
        FileManager fileManager = plugin.getFileManager();
        FileConfiguration configLoad = plugin.getLanguage();
        nInventoryUtil nInv = new nInventoryUtil(player, event -> {
            if (playerDataManager.hasPlayerData(player)) {
                ItemStack is;
                PlayerData playerData = playerDataManager.getPlayerData(player);
                if (playerData.getType() == null || playerData.getSort() == null) {
                    playerData.setType((Object)Type.DEFAULT);
                    playerData.setSort((Object)Sort.DEFAULT);
                }
                if ((is = event.getItem()).getType() == XMaterial.BLACK_STAINED_GLASS_PANE.parseMaterial() && is.hasItemMeta() && is.getItemMeta().getDisplayName().equals(ChatColor.translateAlternateColorCodes((char)'&', (String)configLoad.getString("Menu.Visit.Item.Barrier.Displayname")))) {
                    soundManager.playSound((CommandSender)player, XSound.BLOCK_GLASS_BREAK);
                    event.setWillClose(false);
                    event.setWillDestroy(false);
                } else if (is.getType() == XMaterial.OAK_FENCE_GATE.parseMaterial() && is.hasItemMeta() && is.getItemMeta().getDisplayName().equals(ChatColor.translateAlternateColorCodes((char)'&', (String)configLoad.getString("Menu.Visit.Item.Exit.Displayname")))) {
                    soundManager.playSound((CommandSender)player, XSound.BLOCK_CHEST_CLOSE);
                } else if (is.getType() == Material.PAINTING && is.hasItemMeta() && is.getItemMeta().getDisplayName().equals(ChatColor.translateAlternateColorCodes((char)'&', (String)configLoad.getString("Menu.Visit.Item.Statistics.Displayname")))) {
                    soundManager.playSound((CommandSender)player, XSound.ENTITY_VILLAGER_YES);
                    event.setWillClose(false);
                    event.setWillDestroy(false);
                } else if (is.getType() == Material.HOPPER && is.hasItemMeta()) {
                    if (is.getItemMeta().getDisplayName().equals(ChatColor.translateAlternateColorCodes((char)'&', (String)configLoad.getString("Menu.Visit.Item.Type.Displayname")))) {
                        Type type1 = (Type)((Object)((Object)playerData.getType()));
                        if (type1.ordinal() + 1 == Type.values().length) {
                            playerData.setType((Object)Type.DEFAULT);
                        } else {
                            playerData.setType((Object)Type.values()[type1.ordinal() + 1]);
                        }
                    } else if (is.getItemMeta().getDisplayName().equals(ChatColor.translateAlternateColorCodes((char)'&', (String)configLoad.getString("Menu.Visit.Item.Sort.Displayname")))) {
                        Sort sort1 = (Sort)((Object)((Object)playerData.getSort()));
                        if (sort1.ordinal() + 1 == Sort.values().length) {
                            playerData.setSort((Object)Sort.DEFAULT);
                        } else {
                            playerData.setSort((Object)Sort.values()[sort1.ordinal() + 1]);
                        }
                    }
                    soundManager.playSound((CommandSender)player, XSound.BLOCK_WOODEN_BUTTON_CLICK_ON);
                    Bukkit.getServer().getScheduler().runTaskLater((Plugin)plugin, () -> this.open(player, (Type)((Object)((Object)((Object)playerData.getType()))), (Sort)((Object)((Object)((Object)playerData.getSort())))), 1L);
                } else if (is.getType() == Material.BARRIER && is.hasItemMeta() && is.getItemMeta().getDisplayName().equals(ChatColor.translateAlternateColorCodes((char)'&', (String)configLoad.getString("Menu.Visit.Item.Nothing.Displayname")))) {
                    soundManager.playSound((CommandSender)player, XSound.BLOCK_ANVIL_LAND);
                    event.setWillClose(false);
                    event.setWillDestroy(false);
                } else if (is.getType() == XMaterial.PLAYER_HEAD.parseMaterial() && is.hasItemMeta()) {
                    if (is.getItemMeta().getDisplayName().equals(ChatColor.translateAlternateColorCodes((char)'&', (String)configLoad.getString("Menu.Visit.Item.Previous.Displayname")))) {
                        playerData.setPage(MenuType.VISIT, playerData.getPage(MenuType.VISIT) - 1);
                        soundManager.playSound((CommandSender)player, XSound.ENTITY_ARROW_HIT);
                        Bukkit.getServer().getScheduler().runTaskLater((Plugin)plugin, () -> this.open(player, (Type)((Object)((Object)((Object)playerData.getType()))), (Sort)((Object)((Object)((Object)playerData.getSort())))), 1L);
                    } else if (is.getItemMeta().getDisplayName().equals(ChatColor.translateAlternateColorCodes((char)'&', (String)configLoad.getString("Menu.Visit.Item.Next.Displayname")))) {
                        playerData.setPage(MenuType.VISIT, playerData.getPage(MenuType.VISIT) + 1);
                        soundManager.playSound((CommandSender)player, XSound.ENTITY_ARROW_HIT);
                        Bukkit.getServer().getScheduler().runTaskLater((Plugin)plugin, () -> this.open(player, (Type)((Object)((Object)((Object)playerData.getType()))), (Sort)((Object)((Object)((Object)playerData.getSort())))), 1L);
                    } else {
                        String targetPlayerName = ChatColor.stripColor((String)is.getItemMeta().getDisplayName());
                        Player targetPlayer = Bukkit.getPlayerExact((String)targetPlayerName);
                        UUID targetPlayerUUID = targetPlayer == null ? new com.craftaro.skyblock.utils.player.OfflinePlayer(targetPlayerName).getUniqueId() : targetPlayer.getUniqueId();
                        if (visitManager.hasIsland(targetPlayerUUID)) {
                            com.craftaro.skyblock.visit.Visit visit = visitManager.getIsland(targetPlayerUUID);
                            boolean isCoopPlayer = false;
                            boolean isWhitelistedPlayer = false;
                            OfflinePlayer offlinePlayer = Bukkit.getServer().getOfflinePlayer(targetPlayerUUID);
                            if (islandManager.containsIsland(targetPlayerUUID)) {
                                if (islandManager.getIsland(offlinePlayer).isCoopPlayer(player.getUniqueId())) {
                                    isCoopPlayer = true;
                                }
                                if (visit.getStatus().equals((Object)IslandStatus.WHITELISTED) && islandManager.getIsland(offlinePlayer).isPlayerWhitelisted(player.getUniqueId())) {
                                    isWhitelistedPlayer = true;
                                }
                            }
                            if (visit.getStatus() == IslandStatus.OPEN || isCoopPlayer || isWhitelistedPlayer || player.hasPermission("fabledskyblock.bypass") || player.hasPermission("fabledskyblock.bypass.*") || player.hasPermission("fabledskyblock.*")) {
                                Island island;
                                if (!islandManager.containsIsland(targetPlayerUUID)) {
                                    islandManager.loadIsland(Bukkit.getServer().getOfflinePlayer(targetPlayerUUID));
                                }
                                if (!(island = islandManager.getIsland(offlinePlayer)).hasRole(IslandRole.MEMBER, player.getUniqueId()) && !island.hasRole(IslandRole.OPERATOR, player.getUniqueId()) && !island.hasRole(IslandRole.OWNER, player.getUniqueId()) && plugin.getConfiguration().getBoolean("Island.Visitor.Vote")) {
                                    if (event.getClick() == ClickType.RIGHT) {
                                        if (playerData.getIsland() != null && playerData.getIsland().equals(island.getOwnerUUID())) {
                                            if (visit.getVoters().contains(player.getUniqueId())) {
                                                visit.removeVoter(player.getUniqueId());
                                                messageManager.sendMessage((CommandSender)player, configLoad.getString("Island.Visit.Vote.Removed.Message").replace("%player", targetPlayerName));
                                                soundManager.playSound((CommandSender)player, XSound.ENTITY_GENERIC_EXPLODE);
                                            } else {
                                                PlayerVoteEvent playerVoteEvent = new PlayerVoteEvent(player, island.getAPIWrapper());
                                                Bukkit.getServer().getPluginManager().callEvent((Event)playerVoteEvent);
                                                if (playerVoteEvent.isCancelled()) {
                                                    return;
                                                }
                                                visit.addVoter(player.getUniqueId());
                                                messageManager.sendMessage((CommandSender)player, configLoad.getString("Island.Visit.Vote.Added.Message").replace("%player", targetPlayerName));
                                                soundManager.playSound((CommandSender)player, XSound.ENTITY_PLAYER_LEVELUP);
                                            }
                                            soundManager.playSound((CommandSender)player, XSound.BLOCK_WOODEN_BUTTON_CLICK_ON);
                                            Bukkit.getServer().getScheduler().runTaskLater((Plugin)plugin, () -> this.open(player, (Type)((Object)((Object)((Object)playerData.getType()))), (Sort)((Object)((Object)((Object)playerData.getSort())))), 1L);
                                        } else {
                                            messageManager.sendMessage((CommandSender)player, configLoad.getString("Island.Visit.Vote.Island.Message"));
                                            soundManager.playSound((CommandSender)player, XSound.BLOCK_ANVIL_LAND);
                                            event.setWillClose(false);
                                            event.setWillDestroy(false);
                                        }
                                        islandManager.unloadIsland(island, null);
                                        return;
                                    }
                                    if (event.getClick() != ClickType.LEFT) {
                                        return;
                                    }
                                }
                                if (islandManager.isPlayerAtIsland(island, player)) {
                                    messageManager.sendMessage((CommandSender)player, configLoad.getString("Island.Visit.Already.Message").replace("%player", targetPlayerName));
                                    soundManager.playSound((CommandSender)player, XSound.BLOCK_ANVIL_LAND);
                                    event.setWillClose(false);
                                    event.setWillDestroy(false);
                                    return;
                                }
                                islandManager.visitIsland(player, island);
                                messageManager.sendMessage((CommandSender)player, configLoad.getString("Island.Visit.Teleported.Message").replace("%player", targetPlayerName));
                                soundManager.playSound((CommandSender)player, XSound.ENTITY_ENDERMAN_TELEPORT);
                            } else {
                                messageManager.sendMessage((CommandSender)player, configLoad.getString("Island.Visit.Closed.Menu.Message").replace("%player", targetPlayerName));
                                soundManager.playSound((CommandSender)player, XSound.BLOCK_ANVIL_LAND);
                                Bukkit.getServer().getScheduler().runTaskLater((Plugin)plugin, () -> this.open(player, (Type)((Object)((Object)((Object)playerData.getType()))), (Sort)((Object)((Object)((Object)playerData.getSort())))), 1L);
                            }
                            return;
                        }
                        messageManager.sendMessage((CommandSender)player, configLoad.getString("Island.Visit.Exist.Message").replace("%player", targetPlayerName));
                        soundManager.playSound((CommandSender)player, XSound.BLOCK_ANVIL_LAND);
                        Bukkit.getServer().getScheduler().runTaskLater((Plugin)plugin, () -> this.open(player, (Type)((Object)((Object)((Object)playerData.getType()))), (Sort)((Object)((Object)((Object)playerData.getSort())))), 1L);
                    }
                }
            }
        });
        Map<UUID, com.craftaro.skyblock.visit.Visit> openIslands = visitManager.getOpenIslands();
        ArrayList<com.craftaro.skyblock.visit.Visit> visitIslands = new ArrayList<com.craftaro.skyblock.visit.Visit>();
        boolean keepBannedIslands = plugin.getConfiguration().getBoolean("Island.Visit.Menu.Bans");
        for (int i = 0; i < openIslands.size(); ++i) {
            UUID islandOwnerUUID = (UUID)openIslands.keySet().toArray()[i];
            com.craftaro.skyblock.visit.Visit visit = openIslands.get(islandOwnerUUID);
            if (type != Type.SOLO ? type == Type.TEAM && visit.getMembers() == 1 : visit.getMembers() != 1) continue;
            if (!keepBannedIslands && visit.getBan().isBanned(player.getUniqueId())) continue;
            visitIslands.add(visit);
        }
        openIslands.clear();
        if (sort == Sort.PLAYERS || sort == Sort.LEVEL || sort == Sort.MEMBERS || sort == Sort.VISITS || sort == Sort.VOTES) {
            visitIslands.sort((visit1, visit2) -> {
                if (sort == Sort.PLAYERS) {
                    int playersAtIsland1 = 0;
                    if (islandManager.containsIsland(visit1.getOwnerUUID())) {
                        playersAtIsland1 = islandManager.getPlayersAtIsland(islandManager.getIsland(Bukkit.getServer().getOfflinePlayer(visit1.getOwnerUUID()))).size();
                    }
                    int playersAtIsland2 = 0;
                    if (islandManager.containsIsland(visit2.getOwnerUUID())) {
                        playersAtIsland2 = islandManager.getPlayersAtIsland(islandManager.getIsland(Bukkit.getServer().getOfflinePlayer(visit2.getOwnerUUID()))).size();
                    }
                    return Integer.compare(playersAtIsland2, playersAtIsland1);
                }
                if (sort == Sort.LEVEL) {
                    return Long.compare(visit2.getLevel().getLevel(), visit1.getLevel().getLevel());
                }
                if (sort == Sort.MEMBERS) {
                    return Integer.compare(visit2.getMembers(), visit1.getMembers());
                }
                if (sort == Sort.VISITS) {
                    return Integer.compare(visit2.getVisitors().size(), visit1.getVisitors().size());
                }
                if (sort == Sort.VOTES) {
                    return Integer.compare(visit2.getVoters().size(), visit1.getVoters().size());
                }
                return 0;
            });
        }
        int playerMenuPage = playerDataManager.getPlayerData(player).getPage(MenuType.VISIT);
        int nextEndIndex = visitIslands.size() - playerMenuPage * 36;
        int totalIslands = visitManager.getIslands().size();
        nInv.addItem(nInv.createItem(XMaterial.OAK_FENCE_GATE.parseItem(), configLoad.getString("Menu.Visit.Item.Exit.Displayname"), null, null, null, null), 0, 8);
        nInv.addItem(nInv.createItem(new ItemStack(Material.HOPPER), configLoad.getString("Menu.Visit.Item.Type.Displayname"), configLoad.getStringList("Menu.Visit.Item.Type.Lore"), new Placeholder[]{new Placeholder("%type", StringUtil.capitalizeUppercaseLetters(type.getFriendlyName()))}, null, null), 3);
        nInv.addItem(nInv.createItem(new ItemStack(Material.PAINTING), configLoad.getString("Menu.Visit.Item.Statistics.Displayname"), configLoad.getStringList("Menu.Visit.Item.Statistics.Lore"), new Placeholder[]{new Placeholder("%islands_open", NumberUtils.formatNumber(visitIslands.size())), new Placeholder("%islands_closed", NumberUtils.formatNumber(totalIslands - visitIslands.size())), new Placeholder("%islands", NumberUtils.formatNumber(totalIslands))}, null, null), 4);
        nInv.addItem(nInv.createItem(new ItemStack(Material.HOPPER), configLoad.getString("Menu.Visit.Item.Sort.Displayname"), configLoad.getStringList("Menu.Visit.Item.Sort.Lore"), new Placeholder[]{new Placeholder("%sort", StringUtil.capitalizeUppercaseLetters(sort.getFriendlyName()))}, null, null), 5);
        nInv.addItem(nInv.createItem(XMaterial.BLACK_STAINED_GLASS_PANE.parseItem(), configLoad.getString("Menu.Visit.Item.Barrier.Displayname"), null, null, null, null), 9, 10, 11, 12, 13, 14, 15, 16, 17);
        if (playerMenuPage != 1) {
            ItemStack Lhead = SkullItemCreator.byTextureUrlHash("3ebf907494a935e955bfcadab81beafb90fb9be49c7026ba97d798d5f1a23");
            nInv.addItem(nInv.createItem(Lhead, configLoad.getString("Menu.Visit.Item.Previous.Displayname"), null, null, null, null), 1);
        }
        if (nextEndIndex != 0 && nextEndIndex >= 0) {
            ItemStack Rhead = SkullItemCreator.byTextureUrlHash("1b6f1a25b6bc199946472aedb370522584ff6f4e83221e5946bd2e41b5ca13b");
            nInv.addItem(nInv.createItem(Rhead, configLoad.getString("Menu.Visit.Item.Next.Displayname"), null, null, null, null), 7);
        }
        if (visitIslands.size() == 0) {
            nInv.addItem(nInv.createItem(new ItemStack(Material.BARRIER), configLoad.getString("Menu.Visit.Item.Nothing.Displayname"), null, null, null, null), 31);
        } else {
            int index = playerMenuPage * 36 - 36;
            int endIndex = index >= visitIslands.size() ? visitIslands.size() - 1 : index + 36;
            int inventorySlot = 17;
            int playerCapacity = plugin.getConfiguration().getInt("Island.Visitor.Capacity");
            boolean voteEnabled = plugin.getConfiguration().getBoolean("Island.Visitor.Vote");
            boolean signatureEnabled = plugin.getConfiguration().getBoolean("Island.Visitor.Signature.Enable");
            while (index < endIndex) {
                if (visitIslands.size() > index) {
                    String[] targetPlayerTexture;
                    String targetPlayerName;
                    ++inventorySlot;
                    com.craftaro.skyblock.visit.Visit visit = (com.craftaro.skyblock.visit.Visit)visitIslands.get(index);
                    OfflinePlayer targetPlayer = Bukkit.getServer().getOfflinePlayer(visit.getOwnerUUID());
                    if (targetPlayer == null) {
                        com.craftaro.skyblock.utils.player.OfflinePlayer offlinePlayer = new com.craftaro.skyblock.utils.player.OfflinePlayer(visit.getOwnerUUID());
                        targetPlayerName = offlinePlayer.getName();
                        targetPlayerTexture = offlinePlayer.getTexture();
                    } else {
                        targetPlayerName = targetPlayer.getName();
                        targetPlayerTexture = playerDataManager.hasPlayerData(targetPlayer.getUniqueId()) ? playerDataManager.getPlayerData(targetPlayer.getUniqueId()).getTexture() : new String[]{null, null};
                    }
                    Island island = null;
                    if (islandManager.containsIsland(visit.getOwnerUUID())) {
                        island = islandManager.getIsland(Bukkit.getServer().getOfflinePlayer(visit.getOwnerUUID()));
                    }
                    ArrayList<String> itemLore = new ArrayList<String>();
                    String safety = visit.getSafeLevel() > 0 ? configLoad.getString("Menu.Visit.Item.Island.Vote.Word.Unsafe") : configLoad.getString("Menu.Visit.Item.Island.Vote.Word.Safe");
                    if (voteEnabled) {
                        ItemStack phead;
                        String voteAction = visit.getVoters().contains(player.getUniqueId()) ? configLoad.getString("Menu.Visit.Item.Island.Vote.Enabled.Signature.Word.Remove") : configLoad.getString("Menu.Visit.Item.Island.Vote.Enabled.Signature.Word.Add");
                        if (signatureEnabled) {
                            List correctItemLore = island != null && (island.hasRole(IslandRole.MEMBER, player.getUniqueId()) || island.hasRole(IslandRole.OPERATOR, player.getUniqueId()) || island.hasRole(IslandRole.OWNER, player.getUniqueId())) ? configLoad.getStringList("Menu.Visit.Item.Island.Vote.Enabled.Signature.Enabled.Member.Lore") : configLoad.getStringList("Menu.Visit.Item.Island.Vote.Enabled.Signature.Enabled.Visitor.Lore");
                            for (String itemLoreList : correctItemLore) {
                                if (itemLoreList.contains("%signature")) {
                                    List<String> islandSignature = visit.getSiganture();
                                    if (islandSignature.size() == 0) {
                                        itemLore.add(configLoad.getString("Menu.Visit.Item.Island.Vote.Word.Empty"));
                                        continue;
                                    }
                                    for (String signatureList : islandSignature) {
                                        itemLore.add(signatureList);
                                    }
                                    continue;
                                }
                                itemLore.add(itemLoreList);
                            }
                        } else if (island != null && (island.hasRole(IslandRole.MEMBER, player.getUniqueId()) || island.hasRole(IslandRole.OPERATOR, player.getUniqueId()) || island.hasRole(IslandRole.OWNER, player.getUniqueId()))) {
                            itemLore.addAll(configLoad.getStringList("Menu.Visit.Item.Island.Vote.Enabled.Signature.Disabled.Member.Lore"));
                        } else {
                            itemLore.addAll(configLoad.getStringList("Menu.Visit.Item.Island.Vote.Enabled.Signature.Disabled.Visitor.Lore"));
                        }
                        if (targetPlayerTexture.length >= 1 && targetPlayerTexture[0] != null) {
                            phead = SkullItemCreator.byTextureValue(targetPlayerTexture[0]);
                        } else {
                            try {
                                phead = SkullItemCreator.byUuid(visit.getOwnerUUID()).get();
                            }
                            catch (InterruptedException | ExecutionException ex) {
                                throw new RuntimeException(ex);
                            }
                        }
                        nInv.addItem(nInv.createItem(phead, configLoad.getString("Menu.Visit.Item.Island.Displayname").replace("%player", targetPlayerName), itemLore, new Placeholder[]{new Placeholder("%level", "" + visit.getLevel().getLevel()), new Placeholder("%members", "" + visit.getMembers()), new Placeholder("%votes", "" + visit.getVoters().size()), new Placeholder("%visits", "" + visit.getVisitors().size()), new Placeholder("%players", "" + islandManager.getPlayersAtIsland(island).size()), new Placeholder("%player_capacity", "" + playerCapacity), new Placeholder("%action", voteAction), new Placeholder("%safety", safety)}, null, null), inventorySlot);
                    } else {
                        ItemStack phead;
                        if (signatureEnabled) {
                            for (String itemLoreList : configLoad.getStringList("Menu.Visit.Item.Island.Vote.Disabled.Signature.Enabled.Lore")) {
                                if (itemLoreList.contains("%signature")) {
                                    List<String> islandSignature = visit.getSiganture();
                                    if (islandSignature.size() == 0) {
                                        itemLore.add(configLoad.getString("Menu.Visit.Item.Island.Vote.Word.Empty"));
                                        continue;
                                    }
                                    for (String signatureList : islandSignature) {
                                        itemLore.add(signatureList);
                                    }
                                    continue;
                                }
                                itemLore.add(itemLoreList);
                            }
                        } else {
                            itemLore.addAll(configLoad.getStringList("Menu.Visit.Item.Island.Vote.Disabled.Signature.Disabled.Lore"));
                        }
                        if (targetPlayerTexture.length >= 1 && targetPlayerTexture[0] != null) {
                            phead = SkullItemCreator.byTextureValue(targetPlayerTexture[0]);
                        } else {
                            try {
                                phead = SkullItemCreator.byUuid(visit.getOwnerUUID()).get();
                            }
                            catch (InterruptedException | ExecutionException ex) {
                                throw new RuntimeException(ex);
                            }
                        }
                        nInv.addItem(nInv.createItem(phead, configLoad.getString("Menu.Visit.Item.Island.Displayname").replace("%player", targetPlayerName), itemLore, new Placeholder[]{new Placeholder("%level", "" + visit.getLevel().getLevel()), new Placeholder("%members", "" + visit.getMembers()), new Placeholder("%visits", "" + visit.getVisitors().size()), new Placeholder("%players", "" + islandManager.getPlayersAtIsland(island).size()), new Placeholder("%player_capacity", "" + playerCapacity), new Placeholder("%safety", safety)}, null, null), inventorySlot);
                    }
                }
                ++index;
            }
        }
        nInv.setTitle(ChatColor.translateAlternateColorCodes((char)'&', (String)configLoad.getString("Menu.Visit.Title")));
        nInv.setRows(6);
        Bukkit.getServer().getScheduler().runTask((Plugin)plugin, nInv::open);
    }

    public static enum Type {
        DEFAULT("Default"),
        SOLO("Solo"),
        TEAM("Team");

        private final String friendlyName;

        private Type(String friendlyName) {
            this.friendlyName = friendlyName;
        }

        public String getFriendlyName() {
            return this.friendlyName;
        }
    }

    public static enum Sort {
        DEFAULT("Default"),
        PLAYERS("Players"),
        LEVEL("Level"),
        MEMBERS("Members"),
        VISITS("Visits"),
        VOTES("Votes");

        private final String friendlyName;

        private Sort(String friendlyName) {
            this.friendlyName = friendlyName;
        }

        public String getFriendlyName() {
            return this.friendlyName;
        }
    }
}

