/*
 * Decompiled with CFR 0.152.
 */
package com.craftaro.skyblock.menus;

import com.craftaro.skyblock.SkyBlock;
import com.craftaro.skyblock.api.event.island.IslandUpgradeEvent;
import com.craftaro.skyblock.api.utils.APIUtil;
import com.craftaro.skyblock.core.compatibility.MajorServerVersion;
import com.craftaro.skyblock.core.hooks.economies.Economy;
import com.craftaro.skyblock.core.utils.NumberUtils;
import com.craftaro.skyblock.island.Island;
import com.craftaro.skyblock.island.IslandManager;
import com.craftaro.skyblock.message.MessageManager;
import com.craftaro.skyblock.placeholder.Placeholder;
import com.craftaro.skyblock.playerdata.PlayerData;
import com.craftaro.skyblock.playerdata.PlayerDataManager;
import com.craftaro.skyblock.sound.SoundManager;
import com.craftaro.skyblock.upgrade.Upgrade;
import com.craftaro.skyblock.upgrade.UpgradeManager;
import com.craftaro.skyblock.utils.item.nInventoryUtil;
import com.craftaro.third_party.com.cryptomorin.xseries.XMaterial;
import com.craftaro.third_party.com.cryptomorin.xseries.XSound;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.PotionMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionData;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.potion.PotionType;

public class Upgrade {
    private static Upgrade instance;

    public static Upgrade getInstance() {
        if (instance == null) {
            instance = new Upgrade();
        }
        return instance;
    }

    public void open(Player player) {
        SkyBlock plugin = (SkyBlock)SkyBlock.getPlugin(SkyBlock.class);
        PlayerDataManager playerDataManager = plugin.getPlayerDataManager();
        MessageManager messageManager = plugin.getMessageManager();
        UpgradeManager upgradeManager = plugin.getUpgradeManager();
        IslandManager islandManager = plugin.getIslandManager();
        SoundManager soundManager = plugin.getSoundManager();
        Economy economy = plugin.getEconomyManager().getEconomy();
        FileConfiguration configLoad = plugin.getLanguage();
        if (economy == null || !economy.isEnabled()) {
            messageManager.sendMessage((CommandSender)player, configLoad.getString("Island.Upgrade.Disabled.Message"));
            soundManager.playSound((CommandSender)player, XSound.BLOCK_ANVIL_LAND);
            return;
        }
        if (playerDataManager.hasPlayerData(player) && playerDataManager.getPlayerData(player).getOwner() != null) {
            int tier;
            com.craftaro.skyblock.upgrade.Upgrade upgrade;
            PotionMeta pm;
            com.craftaro.skyblock.upgrade.Upgrade upgrade2;
            List<com.craftaro.skyblock.upgrade.Upgrade> upgrades;
            Island island = islandManager.getIsland((OfflinePlayer)player);
            nInventoryUtil nInv = new nInventoryUtil(player, event -> {
                if (!economy.isEnabled()) {
                    messageManager.sendMessage((CommandSender)player, configLoad.getString("Island.Upgrade.Disabled.Message"));
                    soundManager.playSound((CommandSender)player, XSound.BLOCK_ANVIL_LAND);
                    return;
                }
                if (playerDataManager.hasPlayerData(player)) {
                    PlayerData playerData = playerDataManager.getPlayerData(player);
                    if (playerData.getOwner() == null) {
                        messageManager.sendMessage((CommandSender)player, configLoad.getString("Island.Upgrade.Owner.Message"));
                        soundManager.playSound((CommandSender)player, XSound.BLOCK_ANVIL_LAND);
                        return;
                    }
                    ItemStack is = event.getItem();
                    if (is.getType() == Material.POTION && is.hasItemMeta()) {
                        if (is.getItemMeta().getDisplayName().equals(plugin.formatText(configLoad.getString("Menu.Upgrade.Item.Speed.Displayname")))) {
                            if (island.hasUpgrade(Upgrade.Type.SPEED)) {
                                if (island.isUpgrade(Upgrade.Type.SPEED)) {
                                    island.setUpgrade(player, Upgrade.Type.SPEED, false);
                                    for (Player all : islandManager.getPlayersAtIsland(island)) {
                                        all.removePotionEffect(PotionEffectType.SPEED);
                                    }
                                } else {
                                    island.setUpgrade(player, Upgrade.Type.SPEED, true);
                                }
                                soundManager.playSound((CommandSender)player, XSound.BLOCK_WOODEN_BUTTON_CLICK_ON);
                                Bukkit.getServer().getScheduler().runTaskLater((Plugin)plugin, () -> this.open(player), 1L);
                            } else {
                                List<com.craftaro.skyblock.upgrade.Upgrade> upgrades = upgradeManager.getUpgrades(Upgrade.Type.SPEED);
                                if (upgrades != null && !upgrades.isEmpty() && upgrades.get(0).isEnabled()) {
                                    com.craftaro.skyblock.upgrade.Upgrade upgrade = upgrades.get(0);
                                    if (economy.hasBalance((OfflinePlayer)player, upgrade.getCost())) {
                                        messageManager.sendMessage((CommandSender)player, configLoad.getString("Island.Upgrade.Bought.Message").replace("%upgrade", is.getItemMeta().getDisplayName()));
                                        soundManager.playSound((CommandSender)player, XSound.ENTITY_PLAYER_LEVELUP);
                                        economy.withdrawBalance((OfflinePlayer)player, upgrade.getCost());
                                        island.setUpgrade(player, Upgrade.Type.SPEED, true);
                                        Bukkit.getServer().getScheduler().runTaskLater((Plugin)plugin, () -> this.open(player), 1L);
                                    } else {
                                        messageManager.sendMessage((CommandSender)player, configLoad.getString("Island.Upgrade.Money.Message"));
                                        soundManager.playSound((CommandSender)player, XSound.BLOCK_ANVIL_LAND);
                                        event.setWillClose(false);
                                        event.setWillDestroy(false);
                                    }
                                } else {
                                    messageManager.sendMessage((CommandSender)player, configLoad.getString("Island.Upgrade.Exist.Message"));
                                    soundManager.playSound((CommandSender)player, XSound.BLOCK_ANVIL_LAND);
                                    event.setWillClose(false);
                                    event.setWillDestroy(false);
                                }
                            }
                        } else if (is.getItemMeta().getDisplayName().equals(ChatColor.translateAlternateColorCodes((char)'&', (String)configLoad.getString("Menu.Upgrade.Item.Jump.Displayname")))) {
                            if (island.hasUpgrade(Upgrade.Type.JUMP)) {
                                if (island.isUpgrade(Upgrade.Type.JUMP)) {
                                    island.setUpgrade(player, Upgrade.Type.JUMP, false);
                                    for (Player all : islandManager.getPlayersAtIsland(island)) {
                                        all.removePotionEffect(PotionEffectType.JUMP);
                                    }
                                } else {
                                    island.setUpgrade(player, Upgrade.Type.JUMP, true);
                                }
                                soundManager.playSound((CommandSender)player, XSound.BLOCK_WOODEN_BUTTON_CLICK_ON);
                                Bukkit.getServer().getScheduler().runTaskLater((Plugin)plugin, () -> this.open(player), 1L);
                            } else {
                                List<com.craftaro.skyblock.upgrade.Upgrade> upgrades = upgradeManager.getUpgrades(Upgrade.Type.JUMP);
                                if (upgrades != null && !upgrades.isEmpty() && upgrades.get(0).isEnabled()) {
                                    com.craftaro.skyblock.upgrade.Upgrade upgrade = upgrades.get(0);
                                    if (economy.hasBalance((OfflinePlayer)player, upgrade.getCost())) {
                                        messageManager.sendMessage((CommandSender)player, configLoad.getString("Island.Upgrade.Bought.Message").replace("%upgrade", is.getItemMeta().getDisplayName()));
                                        soundManager.playSound((CommandSender)player, XSound.ENTITY_PLAYER_LEVELUP);
                                        economy.withdrawBalance((OfflinePlayer)player, upgrade.getCost());
                                        island.setUpgrade(player, Upgrade.Type.JUMP, true);
                                        Bukkit.getServer().getScheduler().runTaskLater((Plugin)plugin, () -> this.open(player), 1L);
                                    } else {
                                        messageManager.sendMessage((CommandSender)player, configLoad.getString("Island.Upgrade.Money.Message"));
                                        soundManager.playSound((CommandSender)player, XSound.BLOCK_ANVIL_LAND);
                                        event.setWillClose(false);
                                        event.setWillDestroy(false);
                                    }
                                } else {
                                    messageManager.sendMessage((CommandSender)player, configLoad.getString("Island.Upgrade.Exist.Message"));
                                    soundManager.playSound((CommandSender)player, XSound.BLOCK_ANVIL_LAND);
                                    event.setWillClose(false);
                                    event.setWillDestroy(false);
                                }
                            }
                        }
                    } else if (is.getType() == XMaterial.WHEAT_SEEDS.parseMaterial() && is.hasItemMeta() && is.getItemMeta().getDisplayName().equals(ChatColor.translateAlternateColorCodes((char)'&', (String)configLoad.getString("Menu.Upgrade.Item.Crop.Displayname")))) {
                        if (island.hasUpgrade(Upgrade.Type.CROP)) {
                            island.setUpgrade(player, Upgrade.Type.CROP, !island.isUpgrade(Upgrade.Type.CROP));
                            soundManager.playSound((CommandSender)player, XSound.BLOCK_WOODEN_BUTTON_CLICK_ON);
                            Bukkit.getServer().getScheduler().runTaskLater((Plugin)plugin, () -> this.open(player), 1L);
                        } else {
                            List<com.craftaro.skyblock.upgrade.Upgrade> upgrades = upgradeManager.getUpgrades(Upgrade.Type.CROP);
                            if (upgrades != null && !upgrades.isEmpty() && upgrades.get(0).isEnabled()) {
                                com.craftaro.skyblock.upgrade.Upgrade upgrade = upgrades.get(0);
                                if (economy.hasBalance((OfflinePlayer)player, upgrade.getCost())) {
                                    messageManager.sendMessage((CommandSender)player, configLoad.getString("Island.Upgrade.Bought.Message").replace("%upgrade", is.getItemMeta().getDisplayName()));
                                    soundManager.playSound((CommandSender)player, XSound.ENTITY_PLAYER_LEVELUP);
                                    economy.withdrawBalance((OfflinePlayer)player, upgrade.getCost());
                                    island.setUpgrade(player, Upgrade.Type.CROP, true);
                                    Bukkit.getServer().getScheduler().runTaskLater((Plugin)plugin, () -> this.open(player), 1L);
                                } else {
                                    messageManager.sendMessage((CommandSender)player, configLoad.getString("Island.Upgrade.Money.Message"));
                                    soundManager.playSound((CommandSender)player, XSound.BLOCK_ANVIL_LAND);
                                    event.setWillClose(false);
                                    event.setWillDestroy(false);
                                }
                            } else {
                                messageManager.sendMessage((CommandSender)player, configLoad.getString("Island.Upgrade.Exist.Message"));
                                soundManager.playSound((CommandSender)player, XSound.BLOCK_ANVIL_LAND);
                                event.setWillClose(false);
                                event.setWillDestroy(false);
                            }
                        }
                    } else if (is.getType() == Material.FEATHER && is.hasItemMeta() && is.getItemMeta().getDisplayName().equals(ChatColor.translateAlternateColorCodes((char)'&', (String)configLoad.getString("Menu.Upgrade.Item.Fly.Displayname")))) {
                        if (island.hasUpgrade(Upgrade.Type.FLY)) {
                            if (island.isUpgrade(Upgrade.Type.FLY)) {
                                island.setUpgrade(player, Upgrade.Type.FLY, false);
                                islandManager.updateFlightAtIsland(island);
                            } else {
                                island.setUpgrade(player, Upgrade.Type.FLY, true);
                                islandManager.updateFlightAtIsland(island);
                            }
                            soundManager.playSound((CommandSender)player, XSound.BLOCK_WOODEN_BUTTON_CLICK_ON);
                            Bukkit.getServer().getScheduler().runTaskLater((Plugin)plugin, () -> this.open(player), 1L);
                        } else {
                            List<com.craftaro.skyblock.upgrade.Upgrade> upgrades = upgradeManager.getUpgrades(Upgrade.Type.FLY);
                            if (upgrades != null && !upgrades.isEmpty() && upgrades.get(0).isEnabled()) {
                                com.craftaro.skyblock.upgrade.Upgrade upgrade = upgrades.get(0);
                                if (economy.hasBalance((OfflinePlayer)player, upgrade.getCost())) {
                                    messageManager.sendMessage((CommandSender)player, configLoad.getString("Island.Upgrade.Bought.Message").replace("%upgrade", is.getItemMeta().getDisplayName()));
                                    soundManager.playSound((CommandSender)player, XSound.ENTITY_PLAYER_LEVELUP);
                                    economy.withdrawBalance((OfflinePlayer)player, upgrade.getCost());
                                    island.setUpgrade(player, Upgrade.Type.FLY, true);
                                    islandManager.updateFlightAtIsland(island);
                                    Bukkit.getServer().getScheduler().runTaskLater((Plugin)plugin, () -> this.open(player), 1L);
                                } else {
                                    messageManager.sendMessage((CommandSender)player, configLoad.getString("Island.Upgrade.Money.Message"));
                                    soundManager.playSound((CommandSender)player, XSound.BLOCK_ANVIL_LAND);
                                    event.setWillClose(false);
                                    event.setWillDestroy(false);
                                }
                            } else {
                                messageManager.sendMessage((CommandSender)player, configLoad.getString("Island.Upgrade.Exist.Message"));
                                soundManager.playSound((CommandSender)player, XSound.BLOCK_ANVIL_LAND);
                                event.setWillClose(false);
                                event.setWillDestroy(false);
                            }
                        }
                    } else if (is.getType() == Material.SPIDER_EYE && is.hasItemMeta() && is.getItemMeta().getDisplayName().equals(ChatColor.translateAlternateColorCodes((char)'&', (String)configLoad.getString("Menu.Upgrade.Item.Drops.Displayname")))) {
                        if (island.hasUpgrade(Upgrade.Type.DROPS)) {
                            island.setUpgrade(player, Upgrade.Type.DROPS, !island.isUpgrade(Upgrade.Type.DROPS));
                            soundManager.playSound((CommandSender)player, XSound.BLOCK_WOODEN_BUTTON_CLICK_ON);
                            Bukkit.getServer().getScheduler().runTaskLater((Plugin)plugin, () -> this.open(player), 1L);
                        } else {
                            List<com.craftaro.skyblock.upgrade.Upgrade> upgrades = upgradeManager.getUpgrades(Upgrade.Type.DROPS);
                            if (upgrades != null && !upgrades.isEmpty() && upgrades.get(0).isEnabled()) {
                                com.craftaro.skyblock.upgrade.Upgrade upgrade = upgrades.get(0);
                                if (economy.hasBalance((OfflinePlayer)player, upgrade.getCost())) {
                                    messageManager.sendMessage((CommandSender)player, configLoad.getString("Island.Upgrade.Bought.Message").replace("%upgrade", is.getItemMeta().getDisplayName()));
                                    soundManager.playSound((CommandSender)player, XSound.ENTITY_PLAYER_LEVELUP);
                                    economy.withdrawBalance((OfflinePlayer)player, upgrade.getCost());
                                    island.setUpgrade(player, Upgrade.Type.DROPS, true);
                                    Bukkit.getServer().getScheduler().runTaskLater((Plugin)plugin, () -> this.open(player), 1L);
                                } else {
                                    messageManager.sendMessage((CommandSender)player, configLoad.getString("Island.Upgrade.Money.Message"));
                                    soundManager.playSound((CommandSender)player, XSound.BLOCK_ANVIL_LAND);
                                    event.setWillClose(false);
                                    event.setWillDestroy(false);
                                }
                            } else {
                                messageManager.sendMessage((CommandSender)player, configLoad.getString("Island.Upgrade.Exist.Message"));
                                soundManager.playSound((CommandSender)player, XSound.BLOCK_ANVIL_LAND);
                                event.setWillClose(false);
                                event.setWillDestroy(false);
                            }
                        }
                    } else if (is.getType() == Material.BOOKSHELF && is.hasItemMeta()) {
                        List<com.craftaro.skyblock.upgrade.Upgrade> upgrades = upgradeManager.getUpgrades(Upgrade.Type.MEMBERS);
                        if (upgrades != null && !upgrades.isEmpty()) {
                            for (int i = 0; i < upgrades.size(); ++i) {
                                com.craftaro.skyblock.upgrade.Upgrade upgrade = upgrades.get(i);
                                int tier = i + 1;
                                if (!is.getItemMeta().getDisplayName().equals(ChatColor.translateAlternateColorCodes((char)'&', (String)configLoad.getString("Menu.Upgrade.Item.Members.Displayname").replace("%tier", "" + tier))) || upgrade.getValue() <= island.getMaxMembers(player) || upgrade.getValue() == island.getMaxMembers(player)) continue;
                                if (economy.hasBalance((OfflinePlayer)player, upgrade.getCost())) {
                                    messageManager.sendMessage((CommandSender)player, configLoad.getString("Island.Upgrade.Bought.Message").replace("%upgrade", is.getItemMeta().getDisplayName()));
                                    soundManager.playSound((CommandSender)player, XSound.ENTITY_PLAYER_LEVELUP);
                                    economy.withdrawBalance((OfflinePlayer)player, upgrade.getCost());
                                    island.setMaxMembers(upgrade.getValue());
                                    Bukkit.getServer().getPluginManager().callEvent((Event)new IslandUpgradeEvent(island.getAPIWrapper(), player, APIUtil.fromImplementation(Upgrade.Type.MEMBERS)));
                                    Bukkit.getServer().getScheduler().runTaskLater((Plugin)plugin, () -> this.open(player), 1L);
                                } else {
                                    messageManager.sendMessage((CommandSender)player, configLoad.getString("Island.Upgrade.Money.Message"));
                                    soundManager.playSound((CommandSender)player, XSound.BLOCK_ANVIL_LAND);
                                    event.setWillClose(false);
                                    event.setWillDestroy(false);
                                }
                                return;
                            }
                            messageManager.sendMessage((CommandSender)player, configLoad.getString("Island.Upgrade.Claimed.Message"));
                            soundManager.playSound((CommandSender)player, XSound.BLOCK_ANVIL_LAND);
                            event.setWillClose(false);
                            event.setWillDestroy(false);
                        }
                    } else if (is.getType() == Material.BEACON && is.hasItemMeta()) {
                        List<com.craftaro.skyblock.upgrade.Upgrade> upgrades = upgradeManager.getUpgrades(Upgrade.Type.SIZE);
                        if (upgrades != null && !upgrades.isEmpty()) {
                            for (int i = 0; i < upgrades.size(); ++i) {
                                com.craftaro.skyblock.upgrade.Upgrade upgrade = upgrades.get(i);
                                int tier = i + 1;
                                if (!is.getItemMeta().getDisplayName().equals(ChatColor.translateAlternateColorCodes((char)'&', (String)configLoad.getString("Menu.Upgrade.Item.Size.Displayname").replace("%tier", "" + tier))) || upgrade.getValue() <= island.getSize() || upgrade.getValue() == island.getSize()) continue;
                                if (economy.hasBalance((OfflinePlayer)player, upgrade.getCost())) {
                                    messageManager.sendMessage((CommandSender)player, configLoad.getString("Island.Upgrade.Bought.Message").replace("%upgrade", is.getItemMeta().getDisplayName()));
                                    soundManager.playSound((CommandSender)player, XSound.ENTITY_PLAYER_LEVELUP);
                                    economy.withdrawBalance((OfflinePlayer)player, upgrade.getCost());
                                    island.setSize(upgrade.getValue());
                                    islandManager.updateBorder(island);
                                    Bukkit.getServer().getPluginManager().callEvent((Event)new IslandUpgradeEvent(island.getAPIWrapper(), player, APIUtil.fromImplementation(Upgrade.Type.SIZE)));
                                    Bukkit.getServer().getScheduler().runTaskLater((Plugin)plugin, () -> this.open(player), 1L);
                                } else {
                                    messageManager.sendMessage((CommandSender)player, configLoad.getString("Island.Upgrade.Money.Message"));
                                    soundManager.playSound((CommandSender)player, XSound.BLOCK_ANVIL_LAND);
                                    event.setWillClose(false);
                                    event.setWillDestroy(false);
                                }
                                return;
                            }
                            messageManager.sendMessage((CommandSender)player, configLoad.getString("Island.Upgrade.Claimed.Message"));
                            soundManager.playSound((CommandSender)player, XSound.BLOCK_ANVIL_LAND);
                            event.setWillClose(false);
                            event.setWillDestroy(false);
                        }
                    } else if (is.getType() == XMaterial.SPAWNER.parseMaterial() && is.hasItemMeta() && is.getItemMeta().getDisplayName().equals(ChatColor.translateAlternateColorCodes((char)'&', (String)configLoad.getString("Menu.Upgrade.Item.Spawner.Displayname")))) {
                        if (island.hasUpgrade(Upgrade.Type.SPAWNER)) {
                            island.setUpgrade(player, Upgrade.Type.SPAWNER, !island.isUpgrade(Upgrade.Type.SPAWNER));
                            soundManager.playSound((CommandSender)player, XSound.BLOCK_WOODEN_BUTTON_CLICK_ON);
                            Bukkit.getServer().getScheduler().runTaskLater((Plugin)plugin, () -> this.open(player), 1L);
                        } else {
                            List<com.craftaro.skyblock.upgrade.Upgrade> upgrades = upgradeManager.getUpgrades(Upgrade.Type.SPAWNER);
                            if (upgrades != null && !upgrades.isEmpty() && upgrades.get(0).isEnabled()) {
                                com.craftaro.skyblock.upgrade.Upgrade upgrade = upgrades.get(0);
                                if (economy.hasBalance((OfflinePlayer)player, upgrade.getCost())) {
                                    messageManager.sendMessage((CommandSender)player, configLoad.getString("Island.Upgrade.Bought.Message").replace("%upgrade", is.getItemMeta().getDisplayName()));
                                    soundManager.playSound((CommandSender)player, XSound.ENTITY_PLAYER_LEVELUP);
                                    economy.withdrawBalance((OfflinePlayer)player, upgrade.getCost());
                                    island.setUpgrade(player, Upgrade.Type.SPAWNER, true);
                                    Bukkit.getServer().getScheduler().runTaskLater((Plugin)plugin, () -> this.open(player), 1L);
                                } else {
                                    messageManager.sendMessage((CommandSender)player, configLoad.getString("Island.Upgrade.Money.Message"));
                                    soundManager.playSound((CommandSender)player, XSound.BLOCK_ANVIL_LAND);
                                    event.setWillClose(false);
                                    event.setWillDestroy(false);
                                }
                            } else {
                                messageManager.sendMessage((CommandSender)player, configLoad.getString("Island.Upgrade.Exist.Message"));
                                soundManager.playSound((CommandSender)player, XSound.BLOCK_ANVIL_LAND);
                                event.setWillClose(false);
                                event.setWillDestroy(false);
                            }
                        }
                    }
                }
            });
            ItemStack potion = new ItemStack(Material.POTION);
            if (player.hasPermission("fabledskyblock.upgrade." + Upgrade.Type.SPEED.getFriendlyName().toLowerCase()) && (upgrades = upgradeManager.getUpgrades(Upgrade.Type.SPEED)) != null && !upgrades.isEmpty() && upgrades.get(0).isEnabled()) {
                upgrade2 = upgrades.get(0);
                if (MajorServerVersion.isServerVersionAtLeast(MajorServerVersion.V1_9)) {
                    pm = (PotionMeta)potion.getItemMeta();
                    if (MajorServerVersion.isServerVersionAtLeast(MajorServerVersion.V1_10)) {
                        pm.setBasePotionData(new PotionData(PotionType.SPEED));
                    } else {
                        pm.addCustomEffect(new PotionEffect(PotionEffectType.SPEED, 1, 0), true);
                    }
                    potion.setItemMeta((ItemMeta)pm);
                } else {
                    potion = new ItemStack(Material.POTION, 1, 8194);
                }
                if (island.hasUpgrade(Upgrade.Type.SPEED)) {
                    nInv.addItem(nInv.createItem(potion, ChatColor.translateAlternateColorCodes((char)'&', (String)configLoad.getString("Menu.Upgrade.Item.Speed.Displayname")), configLoad.getStringList("Menu.Upgrade.Item.Speed.Claimed.Lore"), new Placeholder[]{new Placeholder("%cost", NumberUtils.formatNumber(upgrade2.getCost())), new Placeholder("%status", this.getStatus(island, Upgrade.Type.SPEED))}, null, new ItemFlag[]{ItemFlag.HIDE_POTION_EFFECTS}), 0);
                } else if (economy.hasBalance((OfflinePlayer)player, upgrade2.getCost())) {
                    nInv.addItem(nInv.createItem(potion, ChatColor.translateAlternateColorCodes((char)'&', (String)configLoad.getString("Menu.Upgrade.Item.Speed.Displayname")), configLoad.getStringList("Menu.Upgrade.Item.Speed.Claimable.Lore"), new Placeholder[]{new Placeholder("%cost", NumberUtils.formatNumber(upgrade2.getCost()))}, null, new ItemFlag[]{ItemFlag.HIDE_POTION_EFFECTS}), 0);
                } else {
                    nInv.addItem(nInv.createItem(potion, ChatColor.translateAlternateColorCodes((char)'&', (String)configLoad.getString("Menu.Upgrade.Item.Speed.Displayname")), configLoad.getStringList("Menu.Upgrade.Item.Speed.Unclaimable.Lore"), new Placeholder[]{new Placeholder("%cost", NumberUtils.formatNumber(upgrade2.getCost()))}, null, new ItemFlag[]{ItemFlag.HIDE_POTION_EFFECTS}), 0);
                }
            }
            if (player.hasPermission("fabledskyblock.upgrade." + Upgrade.Type.JUMP.getFriendlyName().toLowerCase()) && (upgrades = upgradeManager.getUpgrades(Upgrade.Type.JUMP)) != null && !upgrades.isEmpty() && upgrades.get(0).isEnabled()) {
                upgrade2 = upgrades.get(0);
                if (MajorServerVersion.isServerVersionAtLeast(MajorServerVersion.V1_8)) {
                    potion = new ItemStack(Material.POTION);
                    pm = (PotionMeta)potion.getItemMeta();
                    if (MajorServerVersion.isServerVersionAtLeast(MajorServerVersion.V1_9)) {
                        pm.setBasePotionData(new PotionData(PotionType.JUMP));
                    } else {
                        pm.addCustomEffect(new PotionEffect(PotionEffectType.JUMP, 1, 0), true);
                    }
                    potion.setItemMeta((ItemMeta)pm);
                } else {
                    potion = new ItemStack(Material.POTION, 1, 8203);
                }
                if (island.hasUpgrade(Upgrade.Type.JUMP)) {
                    nInv.addItem(nInv.createItem(potion, ChatColor.translateAlternateColorCodes((char)'&', (String)configLoad.getString("Menu.Upgrade.Item.Jump.Displayname")), configLoad.getStringList("Menu.Upgrade.Item.Jump.Claimed.Lore"), new Placeholder[]{new Placeholder("%cost", NumberUtils.formatNumber(upgrade2.getCost())), new Placeholder("%status", this.getStatus(island, Upgrade.Type.JUMP))}, null, new ItemFlag[]{ItemFlag.HIDE_POTION_EFFECTS}), 1);
                } else if (economy.hasBalance((OfflinePlayer)player, upgrade2.getCost())) {
                    nInv.addItem(nInv.createItem(potion, ChatColor.translateAlternateColorCodes((char)'&', (String)configLoad.getString("Menu.Upgrade.Item.Jump.Displayname")), configLoad.getStringList("Menu.Upgrade.Item.Jump.Claimable.Lore"), new Placeholder[]{new Placeholder("%cost", NumberUtils.formatNumber(upgrade2.getCost()))}, null, new ItemFlag[]{ItemFlag.HIDE_POTION_EFFECTS}), 1);
                } else {
                    nInv.addItem(nInv.createItem(potion, ChatColor.translateAlternateColorCodes((char)'&', (String)configLoad.getString("Menu.Upgrade.Item.Jump.Displayname")), configLoad.getStringList("Menu.Upgrade.Item.Jump.Unclaimable.Lore"), new Placeholder[]{new Placeholder("%cost", NumberUtils.formatNumber(upgrade2.getCost()))}, null, new ItemFlag[]{ItemFlag.HIDE_POTION_EFFECTS}), 1);
                }
            }
            if (player.hasPermission("fabledskyblock.upgrade." + Upgrade.Type.CROP.getFriendlyName().toLowerCase()) && (upgrades = upgradeManager.getUpgrades(Upgrade.Type.CROP)) != null && !upgrades.isEmpty() && upgrades.get(0).isEnabled()) {
                upgrade2 = upgrades.get(0);
                if (island.hasUpgrade(Upgrade.Type.CROP)) {
                    nInv.addItem(nInv.createItem(XMaterial.WHEAT_SEEDS.parseItem(), ChatColor.translateAlternateColorCodes((char)'&', (String)configLoad.getString("Menu.Upgrade.Item.Crop.Displayname")), configLoad.getStringList("Menu.Upgrade.Item.Crop.Claimed.Lore"), new Placeholder[]{new Placeholder("%cost", NumberUtils.formatNumber(upgrade2.getCost())), new Placeholder("%status", this.getStatus(island, Upgrade.Type.CROP))}, null, null), 3);
                } else if (economy.hasBalance((OfflinePlayer)player, upgrade2.getCost())) {
                    nInv.addItem(nInv.createItem(XMaterial.WHEAT_SEEDS.parseItem(), ChatColor.translateAlternateColorCodes((char)'&', (String)configLoad.getString("Menu.Upgrade.Item.Crop.Displayname")), configLoad.getStringList("Menu.Upgrade.Item.Crop.Claimable.Lore"), new Placeholder[]{new Placeholder("%cost", NumberUtils.formatNumber(upgrade2.getCost()))}, null, null), 3);
                } else {
                    nInv.addItem(nInv.createItem(XMaterial.WHEAT_SEEDS.parseItem(), ChatColor.translateAlternateColorCodes((char)'&', (String)configLoad.getString("Menu.Upgrade.Item.Crop.Displayname")), configLoad.getStringList("Menu.Upgrade.Item.Crop.Unclaimable.Lore"), new Placeholder[]{new Placeholder("%cost", NumberUtils.formatNumber(upgrade2.getCost()))}, null, null), 3);
                }
            }
            if (player.hasPermission("fabledskyblock.upgrade." + Upgrade.Type.FLY.getFriendlyName().toLowerCase()) && (upgrades = upgradeManager.getUpgrades(Upgrade.Type.FLY)) != null && !upgrades.isEmpty() && upgrades.get(0).isEnabled()) {
                upgrade2 = upgrades.get(0);
                if (island.hasUpgrade(Upgrade.Type.FLY)) {
                    nInv.addItem(nInv.createItem(new ItemStack(Material.FEATHER), ChatColor.translateAlternateColorCodes((char)'&', (String)configLoad.getString("Menu.Upgrade.Item.Fly.Displayname")), configLoad.getStringList("Menu.Upgrade.Item.Fly.Claimed.Lore"), new Placeholder[]{new Placeholder("%cost", NumberUtils.formatNumber(upgrade2.getCost())), new Placeholder("%status", this.getStatus(island, Upgrade.Type.FLY))}, null, null), 4);
                } else if (economy.hasBalance((OfflinePlayer)player, upgrade2.getCost())) {
                    nInv.addItem(nInv.createItem(new ItemStack(Material.FEATHER), ChatColor.translateAlternateColorCodes((char)'&', (String)configLoad.getString("Menu.Upgrade.Item.Fly.Displayname")), configLoad.getStringList("Menu.Upgrade.Item.Fly.Claimable.Lore"), new Placeholder[]{new Placeholder("%cost", NumberUtils.formatNumber(upgrade2.getCost()))}, null, null), 4);
                } else {
                    nInv.addItem(nInv.createItem(new ItemStack(Material.FEATHER), ChatColor.translateAlternateColorCodes((char)'&', (String)configLoad.getString("Menu.Upgrade.Item.Fly.Displayname")), configLoad.getStringList("Menu.Upgrade.Item.Fly.Unclaimable.Lore"), new Placeholder[]{new Placeholder("%cost", NumberUtils.formatNumber(upgrade2.getCost()))}, null, null), 4);
                }
            }
            if (player.hasPermission("fabledskyblock.upgrade." + Upgrade.Type.DROPS.getFriendlyName().toLowerCase()) && (upgrades = upgradeManager.getUpgrades(Upgrade.Type.DROPS)) != null && !upgrades.isEmpty() && upgrades.get(0).isEnabled()) {
                upgrade2 = upgrades.get(0);
                if (island.hasUpgrade(Upgrade.Type.DROPS)) {
                    nInv.addItem(nInv.createItem(new ItemStack(Material.SPIDER_EYE), ChatColor.translateAlternateColorCodes((char)'&', (String)configLoad.getString("Menu.Upgrade.Item.Drops.Displayname")), configLoad.getStringList("Menu.Upgrade.Item.Drops.Claimed.Lore"), new Placeholder[]{new Placeholder("%cost", NumberUtils.formatNumber(upgrade2.getCost())), new Placeholder("%status", this.getStatus(island, Upgrade.Type.DROPS))}, null, null), 5);
                } else if (economy.hasBalance((OfflinePlayer)player, upgrade2.getCost())) {
                    nInv.addItem(nInv.createItem(new ItemStack(Material.SPIDER_EYE), ChatColor.translateAlternateColorCodes((char)'&', (String)configLoad.getString("Menu.Upgrade.Item.Drops.Displayname")), configLoad.getStringList("Menu.Upgrade.Item.Drops.Claimable.Lore"), new Placeholder[]{new Placeholder("%cost", NumberUtils.formatNumber(upgrade2.getCost()))}, null, null), 5);
                } else {
                    nInv.addItem(nInv.createItem(new ItemStack(Material.SPIDER_EYE), ChatColor.translateAlternateColorCodes((char)'&', (String)configLoad.getString("Menu.Upgrade.Item.Drops.Displayname")), configLoad.getStringList("Menu.Upgrade.Item.Drops.Unclaimable.Lore"), new Placeholder[]{new Placeholder("%cost", NumberUtils.formatNumber(upgrade2.getCost()))}, null, null), 5);
                }
            }
            if (player.hasPermission("fabledskyblock.upgrade." + Upgrade.Type.MEMBERS.getFriendlyName().toLowerCase()) && (upgrades = upgradeManager.getUpgrades(Upgrade.Type.MEMBERS)) != null && !upgrades.isEmpty()) {
                for (int i = 0; i < upgrades.size(); ++i) {
                    upgrade = upgrades.get(i);
                    tier = i + 1;
                    if (tier != upgrades.size() && upgrade.getValue() <= island.getMaxMembers(player)) continue;
                    if (island.getMaxMembers(player) >= upgrade.getValue()) {
                        nInv.addItem(nInv.createItem(new ItemStack(Material.BOOKSHELF), ChatColor.translateAlternateColorCodes((char)'&', (String)configLoad.getString("Menu.Upgrade.Item.Members.Displayname").replace("%tier", "" + tier)), configLoad.getStringList("Menu.Upgrade.Item.Members.Claimed.Lore"), new Placeholder[]{new Placeholder("%cost", NumberUtils.formatNumber(upgrade.getCost())), new Placeholder("%tier", "" + tier), new Placeholder("%maxMembers", "" + upgrade.getValue())}, null, null), 6);
                        break;
                    }
                    if (economy.hasBalance((OfflinePlayer)player, upgrade.getCost())) {
                        nInv.addItem(nInv.createItem(new ItemStack(Material.BOOKSHELF), ChatColor.translateAlternateColorCodes((char)'&', (String)configLoad.getString("Menu.Upgrade.Item.Members.Displayname").replace("%tier", "" + tier)), configLoad.getStringList("Menu.Upgrade.Item.Members.Claimable.Lore"), new Placeholder[]{new Placeholder("%cost", NumberUtils.formatNumber(upgrade.getCost())), new Placeholder("%tier", "" + tier), new Placeholder("%maxMembers", "" + upgrade.getValue())}, null, null), 6);
                        break;
                    }
                    nInv.addItem(nInv.createItem(new ItemStack(Material.BOOKSHELF), ChatColor.translateAlternateColorCodes((char)'&', (String)configLoad.getString("Menu.Upgrade.Item.Members.Displayname").replace("%tier", "" + tier)), configLoad.getStringList("Menu.Upgrade.Item.Members.Unclaimable.Lore"), new Placeholder[]{new Placeholder("%cost", NumberUtils.formatNumber(upgrade.getCost())), new Placeholder("%tier", "" + tier), new Placeholder("%maxMembers", "" + upgrade.getValue())}, null, null), 6);
                    break;
                }
            }
            if (player.hasPermission("fabledskyblock.upgrade." + Upgrade.Type.SIZE.getFriendlyName().toLowerCase()) && (upgrades = upgradeManager.getUpgrades(Upgrade.Type.SIZE)) != null && !upgrades.isEmpty()) {
                for (int i = 0; i < upgrades.size(); ++i) {
                    upgrade = upgrades.get(i);
                    tier = i + 1;
                    if (tier != upgrades.size() && upgrade.getValue() <= island.getSize()) continue;
                    if (island.getSize() >= upgrade.getValue()) {
                        nInv.addItem(nInv.createItem(new ItemStack(Material.BEACON), ChatColor.translateAlternateColorCodes((char)'&', (String)configLoad.getString("Menu.Upgrade.Item.Size.Displayname").replace("%tier", "" + tier)), configLoad.getStringList("Menu.Upgrade.Item.Size.Claimed.Lore"), new Placeholder[]{new Placeholder("%cost", NumberUtils.formatNumber(upgrade.getCost())), new Placeholder("%tier", "" + tier), new Placeholder("%size", "" + upgrade.getValue())}, null, null), 7);
                        break;
                    }
                    if (economy.hasBalance((OfflinePlayer)player, upgrade.getCost())) {
                        nInv.addItem(nInv.createItem(new ItemStack(Material.BEACON), ChatColor.translateAlternateColorCodes((char)'&', (String)configLoad.getString("Menu.Upgrade.Item.Size.Displayname").replace("%tier", "" + tier)), configLoad.getStringList("Menu.Upgrade.Item.Size.Claimable.Lore"), new Placeholder[]{new Placeholder("%cost", NumberUtils.formatNumber(upgrade.getCost())), new Placeholder("%tier", "" + tier), new Placeholder("%size", "" + upgrade.getValue())}, null, null), 7);
                        break;
                    }
                    nInv.addItem(nInv.createItem(new ItemStack(Material.BEACON), ChatColor.translateAlternateColorCodes((char)'&', (String)configLoad.getString("Menu.Upgrade.Item.Size.Displayname").replace("%tier", "" + tier)), configLoad.getStringList("Menu.Upgrade.Item.Size.Unclaimable.Lore"), new Placeholder[]{new Placeholder("%cost", NumberUtils.formatNumber(upgrade.getCost())), new Placeholder("%tier", "" + tier), new Placeholder("%size", "" + upgrade.getValue())}, null, null), 7);
                    break;
                }
            }
            if (player.hasPermission("fabledskyblock.upgrade." + Upgrade.Type.SPAWNER.getFriendlyName().toLowerCase()) && (upgrades = upgradeManager.getUpgrades(Upgrade.Type.SPAWNER)) != null && !upgrades.isEmpty() && upgrades.get(0).isEnabled()) {
                com.craftaro.skyblock.upgrade.Upgrade upgrade3 = upgrades.get(0);
                if (island.hasUpgrade(Upgrade.Type.SPAWNER)) {
                    nInv.addItem(nInv.createItem(XMaterial.SPAWNER.parseItem(), ChatColor.translateAlternateColorCodes((char)'&', (String)configLoad.getString("Menu.Upgrade.Item.Spawner.Displayname")), configLoad.getStringList("Menu.Upgrade.Item.Spawner.Claimed.Lore"), new Placeholder[]{new Placeholder("%cost", NumberUtils.formatNumber(upgrade3.getCost())), new Placeholder("%status", this.getStatus(island, Upgrade.Type.SPAWNER))}, null, null), 8);
                } else if (economy.hasBalance((OfflinePlayer)player, upgrade3.getCost())) {
                    nInv.addItem(nInv.createItem(XMaterial.SPAWNER.parseItem(), ChatColor.translateAlternateColorCodes((char)'&', (String)configLoad.getString("Menu.Upgrade.Item.Spawner.Displayname")), configLoad.getStringList("Menu.Upgrade.Item.Spawner.Claimable.Lore"), new Placeholder[]{new Placeholder("%cost", NumberUtils.formatNumber(upgrade3.getCost()))}, null, null), 8);
                } else {
                    nInv.addItem(nInv.createItem(XMaterial.SPAWNER.parseItem(), ChatColor.translateAlternateColorCodes((char)'&', (String)configLoad.getString("Menu.Upgrade.Item.Spawner.Displayname")), configLoad.getStringList("Menu.Upgrade.Item.Spawner.Unclaimable.Lore"), new Placeholder[]{new Placeholder("%cost", NumberUtils.formatNumber(upgrade3.getCost()))}, null, null), 8);
                }
            }
            nInv.setTitle(ChatColor.translateAlternateColorCodes((char)'&', (String)configLoad.getString("Menu.Upgrade.Title")));
            nInv.setRows(1);
            nInv.open();
        }
    }

    private String getStatus(Island island, Upgrade.Type type) {
        FileConfiguration configLoad = ((SkyBlock)SkyBlock.getPlugin(SkyBlock.class)).getLanguage();
        if (island.isUpgrade(type)) {
            return configLoad.getString("Menu.Upgrade.Item.Word.Disable");
        }
        return configLoad.getString("Menu.Upgrade.Item.Word.Enable");
    }
}

