/*
 * Decompiled with CFR 0.152.
 */
package com.craftaro.skyblock.menus;

import com.craftaro.skyblock.SkyBlock;
import com.craftaro.skyblock.core.gui.AnvilGui;
import com.craftaro.skyblock.core.utils.SkullItemCreator;
import com.craftaro.skyblock.island.Island;
import com.craftaro.skyblock.island.IslandManager;
import com.craftaro.skyblock.island.IslandRole;
import com.craftaro.skyblock.message.MessageManager;
import com.craftaro.skyblock.placeholder.Placeholder;
import com.craftaro.skyblock.playerdata.PlayerData;
import com.craftaro.skyblock.playerdata.PlayerDataManager;
import com.craftaro.skyblock.sound.SoundManager;
import com.craftaro.skyblock.utils.item.nInventoryUtil;
import com.craftaro.third_party.com.cryptomorin.xseries.XMaterial;
import com.craftaro.third_party.com.cryptomorin.xseries.XSound;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;

public class Ownership {
    private static Ownership instance;

    public static Ownership getInstance() {
        if (instance == null) {
            instance = new Ownership();
        }
        return instance;
    }

    public void open(Player player) {
        SkyBlock plugin = (SkyBlock)SkyBlock.getPlugin(SkyBlock.class);
        PlayerDataManager playerDataManager = plugin.getPlayerDataManager();
        MessageManager messageManager = plugin.getMessageManager();
        IslandManager islandManager = plugin.getIslandManager();
        SoundManager soundManager = plugin.getSoundManager();
        if (playerDataManager.hasPlayerData(player)) {
            ItemStack phead;
            String[] playerTexture;
            String originalOwnerName;
            FileConfiguration configLoad = plugin.getLanguage();
            nInventoryUtil nInv = new nInventoryUtil(player, event -> {
                if (playerDataManager.hasPlayerData(player)) {
                    ItemStack is;
                    PlayerData playerData = plugin.getPlayerDataManager().getPlayerData(player);
                    Island island = islandManager.getIsland((OfflinePlayer)player);
                    if (island == null) {
                        messageManager.sendMessage((CommandSender)player, configLoad.getString("Command.Island.Ownership.Owner.Message"));
                        soundManager.playSound((CommandSender)player, XSound.BLOCK_ANVIL_LAND);
                        return;
                    }
                    if (!island.hasRole(IslandRole.OWNER, player.getUniqueId())) {
                        messageManager.sendMessage((CommandSender)player, configLoad.getString("Command.Island.Ownership.Role.Message"));
                        soundManager.playSound((CommandSender)player, XSound.ENTITY_VILLAGER_NO);
                        return;
                    }
                    if (playerData.getType() == null) {
                        playerData.setType((Object)Visibility.HIDDEN);
                    }
                    if (XMaterial.OAK_FENCE_GATE.isSimilar(is = event.getItem()) && is.hasItemMeta() && is.getItemMeta().getDisplayName().equals(ChatColor.translateAlternateColorCodes((char)'&', (String)configLoad.getString("Menu.Ownership.Item.Exit.Displayname")))) {
                        soundManager.playSound((CommandSender)player, XSound.BLOCK_CHEST_CLOSE);
                    } else if (XMaterial.PLAYER_HEAD.isSimilar(is) && is.hasItemMeta() && is.getItemMeta().getDisplayName().equals(ChatColor.translateAlternateColorCodes((char)'&', (String)configLoad.getString("Menu.Ownership.Item.Original.Displayname")))) {
                        soundManager.playSound((CommandSender)player, XSound.ENTITY_VILLAGER_YES);
                        event.setWillClose(false);
                        event.setWillDestroy(false);
                    } else if (XMaterial.BLACK_STAINED_GLASS_PANE.isSimilar(is) && is.hasItemMeta() && is.getItemMeta().getDisplayName().equals(ChatColor.translateAlternateColorCodes((char)'&', (String)configLoad.getString("Menu.Ownership.Item.Barrier.Displayname")))) {
                        soundManager.playSound((CommandSender)player, XSound.BLOCK_GLASS_BREAK);
                        event.setWillClose(false);
                        event.setWillDestroy(false);
                    } else if (XMaterial.WRITABLE_BOOK.isSimilar(is) && is.hasItemMeta() && is.getItemMeta().getDisplayName().equals(ChatColor.translateAlternateColorCodes((char)'&', (String)configLoad.getString("Menu.Ownership.Item.Assign.Displayname")))) {
                        soundManager.playSound((CommandSender)player, XSound.BLOCK_WOODEN_BUTTON_CLICK_ON);
                        Bukkit.getServer().getScheduler().runTaskLater((Plugin)plugin, () -> {
                            AnvilGui gui = new AnvilGui(player);
                            gui.setAction(event1 -> {
                                if (playerDataManager.hasPlayerData(player)) {
                                    Island island1 = islandManager.getIsland((OfflinePlayer)player);
                                    if (island1 == null) {
                                        messageManager.sendMessage((CommandSender)player, configLoad.getString("Command.Island.Ownership.Owner.Message"));
                                        soundManager.playSound((CommandSender)player, XSound.BLOCK_ANVIL_LAND);
                                        return;
                                    }
                                    if (!island1.hasRole(IslandRole.OWNER, player.getUniqueId())) {
                                        messageManager.sendMessage((CommandSender)player, configLoad.getString("Command.Island.Ownership.Role.Message"));
                                        soundManager.playSound((CommandSender)player, XSound.ENTITY_VILLAGER_NO);
                                        return;
                                    }
                                    Bukkit.getScheduler().runTask((Plugin)plugin, () -> Bukkit.getServer().dispatchCommand((CommandSender)player, "island ownership " + gui.getInputText()));
                                }
                                player.closeInventory();
                            });
                            ItemStack is1 = new ItemStack(Material.NAME_TAG);
                            ItemMeta im = is1.getItemMeta();
                            im.setDisplayName(configLoad.getString("Menu.Ownership.Item.Assign.Word.Enter"));
                            is1.setItemMeta(im);
                            gui.setInput(is);
                            plugin.getGuiManager().showGUI(player, gui);
                        }, 1L);
                    } else if (XMaterial.MAP.isSimilar(is) && is.hasItemMeta() && is.getItemMeta().getDisplayName().equals(ChatColor.translateAlternateColorCodes((char)'&', (String)configLoad.getString("Menu.Ownership.Item.Password.Displayname")))) {
                        if (island.hasPassword()) {
                            if (event.getClick() == ClickType.MIDDLE) {
                                Visibility visibility = (Visibility)((Object)((Object)playerData.getType()));
                                if (visibility == Visibility.HIDDEN) {
                                    playerData.setType((Object)Visibility.VISIBLE);
                                } else {
                                    playerData.setType((Object)Visibility.HIDDEN);
                                }
                                soundManager.playSound((CommandSender)player, XSound.BLOCK_WOODEN_BUTTON_CLICK_ON);
                                Bukkit.getServer().getScheduler().runTaskLater((Plugin)plugin, () -> this.open(player), 1L);
                                return;
                            }
                            if (event.getClick() == ClickType.RIGHT) {
                                island.setPassword(null);
                                soundManager.playSound((CommandSender)player, XSound.ENTITY_GENERIC_EXPLODE);
                                Bukkit.getServer().getScheduler().runTaskLater((Plugin)plugin, () -> this.open(player), 1L);
                                return;
                            }
                            if (event.getClick() != ClickType.LEFT) {
                                event.setWillClose(false);
                                event.setWillDestroy(false);
                                return;
                            }
                        }
                        soundManager.playSound((CommandSender)player, XSound.BLOCK_WOODEN_BUTTON_CLICK_ON);
                        Bukkit.getServer().getScheduler().runTaskLater((Plugin)plugin, () -> {
                            AnvilGui gui = new AnvilGui(player);
                            gui.setAction(event1 -> {
                                if (playerDataManager.hasPlayerData(player)) {
                                    Island island12 = islandManager.getIsland((OfflinePlayer)player);
                                    if (island12 == null) {
                                        messageManager.sendMessage((CommandSender)player, configLoad.getString("Command.Island.Ownership.Owner.Message"));
                                        soundManager.playSound((CommandSender)player, XSound.BLOCK_ANVIL_LAND);
                                        return;
                                    }
                                    if (!island12.hasRole(IslandRole.OWNER, player.getUniqueId())) {
                                        messageManager.sendMessage((CommandSender)player, configLoad.getString("Command.Island.Ownership.Role.Message"));
                                        soundManager.playSound((CommandSender)player, XSound.ENTITY_VILLAGER_NO);
                                        return;
                                    }
                                    island12.setPassword(gui.getInputText().replace("&", "").replace(" ", ""));
                                    soundManager.playSound((CommandSender)player, XSound.BLOCK_ANVIL_USE);
                                    Bukkit.getServer().getScheduler().runTaskLater((Plugin)plugin, () -> this.open(player), 1L);
                                }
                                player.closeInventory();
                            });
                            ItemStack is12 = new ItemStack(Material.NAME_TAG);
                            ItemMeta im = is12.getItemMeta();
                            im.setDisplayName(configLoad.getString("Menu.Ownership.Item.Password.Hidden.Word.Enter"));
                            is12.setItemMeta(im);
                            gui.setInput(is);
                            plugin.getGuiManager().showGUI(player, gui);
                        }, 1L);
                    }
                }
            });
            Island island = plugin.getIslandManager().getIsland((OfflinePlayer)player);
            UUID originalOwnerUUID = island.getOriginalOwnerUUID();
            String ownershipPassword = island.getPassword();
            Player targetPlayer = Bukkit.getServer().getPlayer(originalOwnerUUID);
            if (targetPlayer == null) {
                com.craftaro.skyblock.utils.player.OfflinePlayer offlinePlayer = new com.craftaro.skyblock.utils.player.OfflinePlayer(originalOwnerUUID);
                originalOwnerName = offlinePlayer.getName();
                playerTexture = offlinePlayer.getTexture();
            } else {
                originalOwnerName = targetPlayer.getName();
                playerTexture = playerDataManager.getPlayerData(targetPlayer.getUniqueId()).getTexture();
            }
            if (playerTexture.length >= 1 && playerTexture[0] != null) {
                phead = SkullItemCreator.byTextureValue(playerTexture[0]);
            } else {
                try {
                    phead = SkullItemCreator.byUuid(originalOwnerUUID).get();
                }
                catch (InterruptedException | ExecutionException ex) {
                    throw new RuntimeException(ex);
                }
            }
            nInv.addItem(nInv.createItem(XMaterial.OAK_FENCE_GATE.parseItem(), configLoad.getString("Menu.Ownership.Item.Exit.Displayname"), null, null, null, null), 0);
            nInv.addItem(nInv.createItem(phead, configLoad.getString("Menu.Ownership.Item.Original.Displayname"), configLoad.getStringList("Menu.Ownership.Item.Original.Lore"), new Placeholder[]{new Placeholder("%player", originalOwnerName)}, null, null), 1);
            nInv.addItem(nInv.createItem(XMaterial.BLACK_STAINED_GLASS_PANE.parseItem(), configLoad.getString("Menu.Ownership.Item.Barrier.Displayname"), null, null, null, null), 2);
            nInv.addItem(nInv.createItem(XMaterial.WRITABLE_BOOK.parseItem(), configLoad.getString("Menu.Ownership.Item.Assign.Displayname"), configLoad.getStringList("Menu.Ownership.Item.Assign.Lore"), null, null, null), 3);
            if (island.hasPassword()) {
                if (playerDataManager.getPlayerData(player).getType() == Visibility.HIDDEN) {
                    nInv.addItem(nInv.createItem(XMaterial.MAP.parseItem(), configLoad.getString("Menu.Ownership.Item.Password.Displayname"), configLoad.getStringList("Menu.Ownership.Item.Password.Hidden.Lore"), null, null, null), 4);
                } else {
                    nInv.addItem(nInv.createItem(XMaterial.MAP.parseItem(), configLoad.getString("Menu.Ownership.Item.Password.Displayname"), configLoad.getStringList("Menu.Ownership.Item.Password.Visible.Lore"), new Placeholder[]{new Placeholder("%password", ownershipPassword)}, null, null), 4);
                }
            } else {
                nInv.addItem(nInv.createItem(XMaterial.MAP.parseItem(), configLoad.getString("Menu.Ownership.Item.Password.Displayname"), configLoad.getStringList("Menu.Ownership.Item.Password.Unset.Lore"), null, null, null), 4);
            }
            nInv.setTitle(ChatColor.translateAlternateColorCodes((char)'&', (String)configLoad.getString("Menu.Ownership.Title")));
            nInv.setType(InventoryType.HOPPER);
            Bukkit.getServer().getScheduler().runTask((Plugin)plugin, nInv::open);
        }
    }

    public static enum Visibility {
        VISIBLE,
        HIDDEN;

    }
}

