/*
 * Decompiled with CFR 0.152.
 */
package com.craftaro.skyblock.menus;

import com.craftaro.skyblock.SkyBlock;
import com.craftaro.skyblock.config.FileManager;
import com.craftaro.skyblock.core.utils.SkullItemCreator;
import com.craftaro.skyblock.island.Island;
import com.craftaro.skyblock.island.IslandManager;
import com.craftaro.skyblock.island.IslandRole;
import com.craftaro.skyblock.menus.MenuType;
import com.craftaro.skyblock.permission.PermissionManager;
import com.craftaro.skyblock.placeholder.Placeholder;
import com.craftaro.skyblock.playerdata.PlayerData;
import com.craftaro.skyblock.playerdata.PlayerDataManager;
import com.craftaro.skyblock.sound.SoundManager;
import com.craftaro.skyblock.utils.NumberUtil;
import com.craftaro.skyblock.utils.StringUtil;
import com.craftaro.skyblock.utils.item.nInventoryUtil;
import com.craftaro.third_party.com.cryptomorin.xseries.XMaterial;
import com.craftaro.third_party.com.cryptomorin.xseries.XSound;
import java.io.File;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeMap;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class Members {
    private static Members instance;

    public static Members getInstance() {
        if (instance == null) {
            instance = new Members();
        }
        return instance;
    }

    public void open(Player player, Type type, Sort sort) {
        SkyBlock plugin = (SkyBlock)SkyBlock.getPlugin(SkyBlock.class);
        PlayerDataManager playerDataManager = plugin.getPlayerDataManager();
        IslandManager islandManager = plugin.getIslandManager();
        PermissionManager permissionManager = plugin.getPermissionManager();
        SoundManager soundManager = plugin.getSoundManager();
        FileManager fileManager = plugin.getFileManager();
        if (playerDataManager.hasPlayerData(player)) {
            Player targetPlayer;
            FileConfiguration configLoad = plugin.getLanguage();
            nInventoryUtil nInv = new nInventoryUtil(player, event -> {
                if (playerDataManager.hasPlayerData(player)) {
                    PlayerData playerData = playerDataManager.getPlayerData(player);
                    if (playerData.getType() == null || playerData.getSort() == null) {
                        playerData.setType((Object)Type.DEFAULT);
                        playerData.setSort((Object)Sort.DEFAULT);
                    }
                    ItemStack is = event.getItem();
                    Island island = islandManager.getIsland((OfflinePlayer)player);
                    if (island == null) {
                        plugin.getMessageManager().sendMessage((CommandSender)player, configLoad.getString("Command.Island.Members.Owner.Message"));
                        soundManager.playSound((CommandSender)player, XSound.BLOCK_ANVIL_LAND);
                        return;
                    }
                    if (is.getType() == XMaterial.BLACK_STAINED_GLASS_PANE.parseMaterial() && is.hasItemMeta() && is.getItemMeta().getDisplayName().equals(ChatColor.translateAlternateColorCodes((char)'&', (String)configLoad.getString("Menu.Members.Item.Barrier.Displayname")))) {
                        soundManager.playSound((CommandSender)player, XSound.BLOCK_GLASS_BREAK);
                        event.setWillClose(false);
                        event.setWillDestroy(false);
                    } else if (is.getType() == XMaterial.OAK_FENCE_GATE.parseMaterial() && is.hasItemMeta() && is.getItemMeta().getDisplayName().equals(ChatColor.translateAlternateColorCodes((char)'&', (String)configLoad.getString("Menu.Members.Item.Exit.Displayname")))) {
                        soundManager.playSound((CommandSender)player, XSound.BLOCK_CHEST_CLOSE);
                    } else if (is.getType() == Material.HOPPER && is.hasItemMeta()) {
                        if (is.getItemMeta().getDisplayName().equals(ChatColor.translateAlternateColorCodes((char)'&', (String)configLoad.getString("Menu.Members.Item.Type.Displayname")))) {
                            Type type1 = (Type)((Object)((Object)playerData.getType()));
                            if (type1.ordinal() + 1 == Type.values().length) {
                                playerData.setType((Object)Type.DEFAULT);
                            } else {
                                playerData.setType((Object)Type.values()[type1.ordinal() + 1]);
                            }
                        } else if (is.getItemMeta().getDisplayName().equals(ChatColor.translateAlternateColorCodes((char)'&', (String)configLoad.getString("Menu.Members.Item.Sort.Displayname")))) {
                            Sort sort1 = (Sort)((Object)((Object)playerData.getSort()));
                            if (sort1.ordinal() + 1 == Sort.values().length) {
                                playerData.setSort((Object)Sort.DEFAULT);
                            } else {
                                playerData.setSort((Object)Sort.values()[sort1.ordinal() + 1]);
                            }
                        }
                        soundManager.playSound((CommandSender)player, XSound.BLOCK_WOODEN_BUTTON_CLICK_ON);
                        Bukkit.getServer().getScheduler().runTaskLater((Plugin)plugin, () -> this.open(player, (Type)((Object)((Object)((Object)playerData.getType()))), (Sort)((Object)((Object)((Object)playerData.getSort())))), 1L);
                    } else if (is.getType() == Material.PAINTING && is.hasItemMeta() && is.getItemMeta().getDisplayName().equals(ChatColor.translateAlternateColorCodes((char)'&', (String)configLoad.getString("Menu.Members.Item.Statistics.Displayname")))) {
                        soundManager.playSound((CommandSender)player, XSound.ENTITY_VILLAGER_YES);
                        event.setWillClose(false);
                        event.setWillDestroy(false);
                    } else if (is.getType() == Material.BARRIER && is.hasItemMeta() && is.getItemMeta().getDisplayName().equals(ChatColor.translateAlternateColorCodes((char)'&', (String)configLoad.getString("Menu.Members.Item.Nothing.Displayname")))) {
                        soundManager.playSound((CommandSender)player, XSound.BLOCK_ANVIL_LAND);
                        event.setWillClose(false);
                        event.setWillDestroy(false);
                    } else if (is.getType() == XMaterial.PLAYER_HEAD.parseMaterial() && is.hasItemMeta()) {
                        if (is.getItemMeta().getDisplayName().equals(ChatColor.translateAlternateColorCodes((char)'&', (String)configLoad.getString("Menu.Members.Item.Previous.Displayname")))) {
                            playerData.setPage(MenuType.MEMBERS, playerData.getPage(MenuType.MEMBERS) - 1);
                            soundManager.playSound((CommandSender)player, XSound.ENTITY_ARROW_HIT);
                            Bukkit.getServer().getScheduler().runTaskLater((Plugin)plugin, () -> this.open(player, (Type)((Object)((Object)((Object)playerData.getType()))), (Sort)((Object)((Object)((Object)playerData.getSort())))), 1L);
                        } else if (is.getItemMeta().getDisplayName().equals(ChatColor.translateAlternateColorCodes((char)'&', (String)configLoad.getString("Menu.Members.Item.Next.Displayname")))) {
                            playerData.setPage(MenuType.MEMBERS, playerData.getPage(MenuType.MEMBERS) + 1);
                            soundManager.playSound((CommandSender)player, XSound.ENTITY_ARROW_HIT);
                            Bukkit.getServer().getScheduler().runTaskLater((Plugin)plugin, () -> this.open(player, (Type)((Object)((Object)((Object)playerData.getType()))), (Sort)((Object)((Object)((Object)playerData.getSort())))), 1L);
                        } else {
                            String playerName = ChatColor.stripColor((String)is.getItemMeta().getDisplayName());
                            Player targetPlayer = Bukkit.getPlayerExact((String)playerName);
                            UUID playerUUID = targetPlayer == null ? new com.craftaro.skyblock.utils.player.OfflinePlayer(playerName).getUUID() : targetPlayer.getUniqueId();
                            if (!playerUUID.equals(player.getUniqueId()) && !island.hasRole(IslandRole.OWNER, playerUUID)) {
                                if (island.hasRole(IslandRole.OWNER, player.getUniqueId())) {
                                    if (event.getClick() == ClickType.LEFT) {
                                        if (island.hasRole(IslandRole.MEMBER, playerUUID)) {
                                            Bukkit.getServer().dispatchCommand((CommandSender)player, "island promote " + playerName);
                                        } else {
                                            Bukkit.getServer().dispatchCommand((CommandSender)player, "island demote " + playerName);
                                        }
                                        Bukkit.getServer().getScheduler().runTaskLater((Plugin)plugin, () -> this.open(player, (Type)((Object)((Object)((Object)playerData.getType()))), (Sort)((Object)((Object)((Object)playerData.getSort())))), 3L);
                                        return;
                                    }
                                    if (event.getClick() == ClickType.RIGHT) {
                                        Bukkit.getServer().dispatchCommand((CommandSender)player, "island kick " + playerName);
                                        Bukkit.getServer().getScheduler().runTaskLater((Plugin)plugin, () -> this.open(player, (Type)((Object)((Object)((Object)playerData.getType()))), (Sort)((Object)((Object)((Object)playerData.getSort())))), 3L);
                                        return;
                                    }
                                } else if (island.hasRole(IslandRole.OPERATOR, player.getUniqueId()) && permissionManager.hasPermission(island, "Kick", IslandRole.OPERATOR)) {
                                    Bukkit.getServer().dispatchCommand((CommandSender)player, "island kick " + playerName);
                                    Bukkit.getServer().getScheduler().runTaskLater((Plugin)plugin, () -> this.open(player, (Type)((Object)((Object)((Object)playerData.getType()))), (Sort)((Object)((Object)((Object)playerData.getSort())))), 3L);
                                    return;
                                }
                            }
                            soundManager.playSound((CommandSender)player, XSound.ENTITY_CHICKEN_EGG);
                            event.setWillClose(false);
                            event.setWillDestroy(false);
                        }
                    }
                }
            });
            PlayerData playerData = playerDataManager.getPlayerData(player);
            Island island = islandManager.getIsland((OfflinePlayer)player);
            ArrayList<UUID> displayedMembers = new ArrayList<UUID>();
            Set<UUID> islandMembers = island.getRole(IslandRole.MEMBER);
            Set<UUID> islandOperators = island.getRole(IslandRole.OPERATOR);
            if (type == Type.DEFAULT) {
                displayedMembers.add(island.getOwnerUUID());
                displayedMembers.addAll(islandOperators);
                displayedMembers.addAll(islandMembers);
            } else if (type == Type.MEMBERS) {
                displayedMembers.addAll(islandMembers);
            } else if (type == Type.OPERATORS) {
                displayedMembers.addAll(islandOperators);
            } else if (type == Type.OWNER) {
                displayedMembers.add(island.getOwnerUUID());
            }
            if (sort == Sort.PLAYTIME) {
                TreeMap<Integer, UUID> sortedPlaytimes = new TreeMap<Integer, UUID>();
                for (UUID displayedMemberList : displayedMembers) {
                    targetPlayer = Bukkit.getServer().getPlayer(displayedMemberList);
                    if (targetPlayer == null) {
                        sortedPlaytimes.put(YamlConfiguration.loadConfiguration((File)new File(new File(plugin.getDataFolder().toString() + "/player-data"), displayedMemberList.toString() + ".yml")).getInt("Statistics.Island.Playtime"), displayedMemberList);
                        continue;
                    }
                    sortedPlaytimes.put(plugin.getPlayerDataManager().getPlayerData(targetPlayer).getPlaytime(), displayedMemberList);
                }
                displayedMembers.clear();
                for (Integer sortedPlaytimeList : sortedPlaytimes.keySet()) {
                    displayedMembers.add((UUID)sortedPlaytimes.get(sortedPlaytimeList));
                }
            } else if (sort == Sort.MEMBER_SINCE) {
                TreeMap<Date, UUID> sortedDates = new TreeMap<Date, UUID>();
                for (UUID displayedMemberList : displayedMembers) {
                    targetPlayer = Bukkit.getServer().getPlayer(displayedMemberList);
                    try {
                        if (targetPlayer == null) {
                            sortedDates.put(new SimpleDateFormat("dd/MM/yyyy HH:mm:ss").parse(YamlConfiguration.loadConfiguration((File)new File(new File(plugin.getDataFolder().toString() + "/player-data"), displayedMemberList.toString() + ".yml")).getString("Statistics.Island.Join")), displayedMemberList);
                            continue;
                        }
                        sortedDates.put(new SimpleDateFormat("dd/MM/yyyy HH:mm:ss").parse(plugin.getPlayerDataManager().getPlayerData(targetPlayer).getMemberSince()), displayedMemberList);
                    }
                    catch (ParseException ex) {
                        ex.printStackTrace();
                    }
                }
                displayedMembers.clear();
                for (Iterator sortedDateList : sortedDates.keySet()) {
                    displayedMembers.add((UUID)sortedDates.get(sortedDateList));
                }
            } else if (sort == Sort.LAST_ONLINE) {
                ArrayList onlineMembers = new ArrayList(displayedMembers);
                TreeMap<Date, UUID> sortedDates = new TreeMap<Date, UUID>();
                for (UUID displayedMemberList : displayedMembers) {
                    Player targetPlayer2 = Bukkit.getServer().getPlayer(displayedMemberList);
                    if (targetPlayer2 != null) continue;
                    onlineMembers.remove(displayedMemberList);
                    try {
                        sortedDates.put(new SimpleDateFormat("dd/MM/yyyy HH:mm:ss").parse(YamlConfiguration.loadConfiguration((File)new File(new File(plugin.getDataFolder().toString() + "/player-data"), displayedMemberList.toString() + ".yml")).getString("Statistics.Island.LastOnline")), displayedMemberList);
                    }
                    catch (ParseException ex) {
                        ex.printStackTrace();
                    }
                }
                displayedMembers.clear();
                displayedMembers.addAll(onlineMembers);
                for (Date sortedDateList : sortedDates.keySet()) {
                    displayedMembers.add((UUID)sortedDates.get(sortedDateList));
                }
            }
            boolean[] operatorActions = new boolean[]{false, false};
            if (island.hasRole(IslandRole.OWNER, player.getUniqueId())) {
                operatorActions = new boolean[]{true, true};
            } else if (island.hasRole(IslandRole.OPERATOR, player.getUniqueId()) && permissionManager.hasPermission(island, "Kick", IslandRole.OPERATOR)) {
                operatorActions = new boolean[]{false, true};
            }
            int playerMenuPage = playerData.getPage(MenuType.MEMBERS);
            int nextEndIndex = displayedMembers.size() - playerMenuPage * 36;
            nInv.addItem(nInv.createItem(XMaterial.OAK_FENCE_GATE.parseItem(), configLoad.getString("Menu.Members.Item.Exit.Displayname"), null, null, null, null), 0, 8);
            nInv.addItem(nInv.createItem(new ItemStack(Material.HOPPER), configLoad.getString("Menu.Members.Item.Type.Displayname"), configLoad.getStringList("Menu.Members.Item.Type.Lore"), new Placeholder[]{new Placeholder("%type", type.getFriendlyName())}, null, null), 3);
            nInv.addItem(nInv.createItem(new ItemStack(Material.PAINTING), configLoad.getString("Menu.Members.Item.Statistics.Displayname"), configLoad.getStringList("Menu.Members.Item.Statistics.Lore"), new Placeholder[]{new Placeholder("%island_members", "" + (islandMembers.size() + islandOperators.size() + 1)), new Placeholder("%island_capacity", "" + island.getMaxMembers(player)), new Placeholder("%members", "" + islandMembers.size()), new Placeholder("%operators", "" + islandOperators.size())}, null, null), 4);
            nInv.addItem(nInv.createItem(new ItemStack(Material.HOPPER), configLoad.getString("Menu.Members.Item.Sort.Displayname"), configLoad.getStringList("Menu.Members.Item.Sort.Lore"), new Placeholder[]{new Placeholder("%sort", StringUtil.capitalizeUppercaseLetters(sort.getFriendlyName()))}, null, null), 5);
            nInv.addItem(nInv.createItem(XMaterial.BLACK_STAINED_GLASS_PANE.parseItem(), configLoad.getString("Menu.Members.Item.Barrier.Displayname"), null, null, null, null), 9, 10, 11, 12, 13, 14, 15, 16, 17);
            if (playerMenuPage != 1) {
                ItemStack Lhead = SkullItemCreator.byTextureUrlHash("3ebf907494a935e955bfcadab81beafb90fb9be49c7026ba97d798d5f1a23");
                nInv.addItem(nInv.createItem(Lhead, configLoad.getString("Menu.Members.Item.Previous.Displayname"), null, null, null, null), 1);
            }
            if (nextEndIndex != 0 && nextEndIndex >= 0) {
                ItemStack Rhead = SkullItemCreator.byTextureUrlHash("1b6f1a25b6bc199946472aedb370522584ff6f4e83221e5946bd2e41b5ca13b");
                nInv.addItem(nInv.createItem(Rhead, configLoad.getString("Menu.Members.Item.Next.Displayname"), null, null, null, null), 7);
            }
            if (displayedMembers.isEmpty()) {
                nInv.addItem(nInv.createItem(new ItemStack(Material.BARRIER), configLoad.getString("Menu.Members.Item.Nothing.Displayname"), null, null, null, null), 31);
            } else {
                int index = playerMenuPage * 36 - 36;
                int endIndex = index >= displayedMembers.size() ? displayedMembers.size() - 1 : index + 36;
                int inventorySlot = 17;
                while (index < endIndex) {
                    if (displayedMembers.size() > index) {
                        ItemStack phead;
                        long[] playTimeDurationTime;
                        int islandPlaytime;
                        String playerName;
                        ++inventorySlot;
                        UUID playerUUID = (UUID)displayedMembers.get(index);
                        String lastOnlineFormatted = "";
                        long[] memberSinceDurationTime = null;
                        long[] lastOnlineDurationTime = null;
                        Player targetPlayer3 = Bukkit.getServer().getPlayer(playerUUID);
                        if (targetPlayer3 == null) {
                            com.craftaro.skyblock.utils.player.OfflinePlayer offlinePlayer = new com.craftaro.skyblock.utils.player.OfflinePlayer(playerUUID);
                            playerName = offlinePlayer.getName();
                            islandPlaytime = offlinePlayer.getPlaytime();
                            playTimeDurationTime = NumberUtil.getDuration(islandPlaytime);
                            try {
                                SimpleDateFormat simpleDateFormat = new SimpleDateFormat("dd/MM/yyyy HH:mm:ss");
                                memberSinceDurationTime = NumberUtil.getDuration(simpleDateFormat.parse(offlinePlayer.getMemberSince()), new Date());
                                lastOnlineDurationTime = NumberUtil.getDuration(simpleDateFormat.parse(offlinePlayer.getLastOnline()), new Date());
                            }
                            catch (ParseException ex) {
                                ex.printStackTrace();
                            }
                        } else {
                            playerName = targetPlayer3.getName();
                            playerData = plugin.getPlayerDataManager().getPlayerData(targetPlayer3);
                            islandPlaytime = playerData.getPlaytime();
                            playTimeDurationTime = NumberUtil.getDuration(islandPlaytime);
                            try {
                                memberSinceDurationTime = NumberUtil.getDuration(new SimpleDateFormat("dd/MM/yyyy HH:mm:ss").parse(playerData.getMemberSince()), new Date());
                            }
                            catch (ParseException ex) {
                                ex.printStackTrace();
                            }
                        }
                        String islandRole = islandMembers.contains(playerUUID) ? configLoad.getString("Menu.Members.Item.Member.Role.Word.Member") : (islandOperators.contains(playerUUID) ? configLoad.getString("Menu.Members.Item.Member.Role.Word.Operator") : configLoad.getString("Menu.Members.Item.Member.Role.Word.Owner"));
                        String islandPlaytimeFormatted = islandPlaytime >= 86400 ? playTimeDurationTime[0] + " " + configLoad.getString("Menu.Members.Item.Member.Word.Days") + ", " + playTimeDurationTime[1] + " " + configLoad.getString("Menu.Members.Item.Member.Word.Hours") + ", " + playTimeDurationTime[2] + " " + configLoad.getString("Menu.Members.Item.Member.Word.Minutes") + ", " + playTimeDurationTime[3] + " " + configLoad.getString("Menu.Members.Item.Member.Word.Seconds") : (islandPlaytime >= 3600 ? playTimeDurationTime[1] + " " + configLoad.getString("Menu.Members.Item.Member.Word.Hours") + ", " + playTimeDurationTime[2] + " " + configLoad.getString("Menu.Members.Item.Member.Word.Minutes") + ", " + playTimeDurationTime[3] + " " + configLoad.getString("Menu.Members.Item.Member.Word.Seconds") : (islandPlaytime >= 60 ? playTimeDurationTime[2] + " " + configLoad.getString("Menu.Members.Item.Member.Word.Minutes") + ", " + playTimeDurationTime[3] + " " + configLoad.getString("Menu.Members.Item.Member.Word.Seconds") : playTimeDurationTime[3] + " " + configLoad.getString("Menu.Members.Item.Member.Word.Seconds")));
                        String memberSinceFormatted = memberSinceDurationTime[0] != 0L ? memberSinceDurationTime[0] + " " + configLoad.getString("Menu.Members.Item.Member.Word.Days") + ", " + memberSinceDurationTime[1] + " " + configLoad.getString("Menu.Members.Item.Member.Word.Hours") + ", " + memberSinceDurationTime[2] + " " + configLoad.getString("Menu.Members.Item.Member.Word.Minutes") + ", " + memberSinceDurationTime[3] + " " + configLoad.getString("Menu.Members.Item.Member.Word.Seconds") : (memberSinceDurationTime[1] != 0L ? memberSinceDurationTime[1] + " " + configLoad.getString("Menu.Members.Item.Member.Word.Hours") + ", " + memberSinceDurationTime[2] + " " + configLoad.getString("Menu.Members.Item.Member.Word.Minutes") + ", " + memberSinceDurationTime[3] + " " + configLoad.getString("Menu.Members.Item.Member.Word.Seconds") : (memberSinceDurationTime[2] != 0L ? memberSinceDurationTime[2] + " " + configLoad.getString("Menu.Members.Item.Member.Word.Minutes") + ", " + memberSinceDurationTime[3] + " " + configLoad.getString("Menu.Members.Item.Member.Word.Seconds") : memberSinceDurationTime[3] + " " + configLoad.getString("Menu.Members.Item.Member.Word.Seconds")));
                        if (lastOnlineDurationTime != null) {
                            lastOnlineFormatted = lastOnlineDurationTime[0] != 0L ? lastOnlineDurationTime[0] + " " + configLoad.getString("Menu.Members.Item.Member.Word.Days") + ", " + lastOnlineDurationTime[1] + " " + configLoad.getString("Menu.Members.Item.Member.Word.Hours") + ", " + lastOnlineDurationTime[2] + " " + configLoad.getString("Menu.Members.Item.Member.Word.Minutes") + ", " + lastOnlineDurationTime[3] + " " + configLoad.getString("Menu.Members.Item.Member.Word.Seconds") : (lastOnlineDurationTime[1] != 0L ? lastOnlineDurationTime[1] + " " + configLoad.getString("Menu.Members.Item.Member.Word.Hours") + ", " + lastOnlineDurationTime[2] + " " + configLoad.getString("Menu.Members.Item.Member.Word.Minutes") + ", " + lastOnlineDurationTime[3] + " " + configLoad.getString("Menu.Members.Item.Member.Word.Seconds") : (lastOnlineDurationTime[2] != 0L ? lastOnlineDurationTime[2] + " " + configLoad.getString("Menu.Members.Item.Member.Word.Minutes") + ", " + lastOnlineDurationTime[3] + " " + configLoad.getString("Menu.Members.Item.Member.Word.Seconds") : lastOnlineDurationTime[3] + " " + configLoad.getString("Menu.Members.Item.Member.Word.Seconds")));
                        }
                        ArrayList<String> itemLore = new ArrayList<String>();
                        itemLore.addAll(configLoad.getStringList("Menu.Members.Item.Member.Role.Lore"));
                        itemLore.addAll(configLoad.getStringList("Menu.Members.Item.Member.Playtime.Lore"));
                        itemLore.addAll(configLoad.getStringList("Menu.Members.Item.Member.Since.Lore"));
                        if (lastOnlineDurationTime != null) {
                            itemLore.addAll(configLoad.getStringList("Menu.Members.Item.Member.LastOnline.Lore"));
                        }
                        if (!playerUUID.equals(player.getUniqueId()) && !island.hasRole(IslandRole.OWNER, playerUUID)) {
                            if (operatorActions[0] && operatorActions[1]) {
                                if (!island.hasRole(IslandRole.OWNER, playerUUID)) {
                                    itemLore.add("");
                                    if (island.hasRole(IslandRole.MEMBER, playerUUID)) {
                                        itemLore.add(configLoad.getString("Menu.Members.Item.Member.Action.Lore").replace("%click", configLoad.getString("Menu.Members.Item.Member.Word.Left-Click")).replace("%action", configLoad.getString("Menu.Members.Item.Member.Action.Word.Promote")));
                                    } else {
                                        itemLore.add(configLoad.getString("Menu.Members.Item.Member.Action.Lore").replace("%click", configLoad.getString("Menu.Members.Item.Member.Word.Left-Click")).replace("%action", configLoad.getString("Menu.Members.Item.Member.Action.Word.Demote")));
                                    }
                                    itemLore.add(configLoad.getString("Menu.Members.Item.Member.Action.Lore").replace("%click", configLoad.getString("Menu.Members.Item.Member.Word.Right-Click")).replace("%action", configLoad.getString("Menu.Members.Item.Member.Action.Word.Kick")));
                                }
                            } else if (!(operatorActions[0] || !operatorActions[1] || playerUUID.equals(player.getUniqueId()) && island.getRole(IslandRole.OPERATOR).contains(playerUUID) && island.hasRole(IslandRole.OWNER, playerUUID))) {
                                itemLore.add("");
                                itemLore.add(configLoad.getString("Menu.Members.Item.Member.Action.Lore").replace("%click", configLoad.getString("Menu.Members.Item.Member.Word.Click")).replace("%action", configLoad.getString("Menu.Members.Item.Member.Action.Word.Kick")));
                            }
                        }
                        try {
                            phead = SkullItemCreator.byUuid(playerUUID).get();
                        }
                        catch (InterruptedException | ExecutionException ex) {
                            throw new RuntimeException(ex);
                        }
                        nInv.addItem(nInv.createItem(phead, configLoad.getString("Menu.Members.Item.Member.Displayname").replace("%player", playerName), itemLore, new Placeholder[]{new Placeholder("%role", islandRole), new Placeholder("%playtime", islandPlaytimeFormatted), new Placeholder("%since", memberSinceFormatted), new Placeholder("%last_online", lastOnlineFormatted)}, null, null), inventorySlot);
                    }
                    ++index;
                }
            }
            nInv.setTitle(ChatColor.translateAlternateColorCodes((char)'&', (String)configLoad.getString("Menu.Members.Title")));
            nInv.setRows(6);
            Bukkit.getServer().getScheduler().runTask((Plugin)plugin, nInv::open);
        }
    }

    public static enum Type {
        DEFAULT("Default"),
        MEMBERS("Members"),
        OPERATORS("Operators"),
        OWNER("Owner");

        private final String friendlyName;

        private Type(String friendlyName) {
            this.friendlyName = friendlyName;
        }

        public String getFriendlyName() {
            return this.friendlyName;
        }
    }

    public static enum Sort {
        DEFAULT("Default"),
        PLAYTIME("Playtime"),
        MEMBER_SINCE("MemberSince"),
        LAST_ONLINE("LastOnline");

        private final String friendlyName;

        private Sort(String friendlyName) {
            this.friendlyName = friendlyName;
        }

        public String getFriendlyName() {
            return this.friendlyName;
        }
    }
}

