/*
 * Decompiled with CFR 0.152.
 */
package com.craftaro.skyblock.menus;

import com.craftaro.skyblock.SkyBlock;
import com.craftaro.skyblock.config.FileManager;
import com.craftaro.skyblock.cooldown.Cooldown;
import com.craftaro.skyblock.cooldown.CooldownManager;
import com.craftaro.skyblock.cooldown.CooldownPlayer;
import com.craftaro.skyblock.cooldown.CooldownType;
import com.craftaro.skyblock.island.IslandManager;
import com.craftaro.skyblock.message.MessageManager;
import com.craftaro.skyblock.sound.SoundManager;
import com.craftaro.skyblock.structure.Structure;
import com.craftaro.skyblock.utils.NumberUtil;
import com.craftaro.skyblock.utils.item.nInventoryUtil;
import com.craftaro.third_party.com.cryptomorin.xseries.XSound;
import java.io.File;
import java.util.ArrayList;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class Creator {
    private static Creator instance;

    public static Creator getInstance() {
        if (instance == null) {
            instance = new Creator();
        }
        return instance;
    }

    public void open(Player player) {
        SkyBlock plugin = (SkyBlock)SkyBlock.getPlugin(SkyBlock.class);
        CooldownManager cooldownManager = plugin.getCooldownManager();
        MessageManager messageManager = plugin.getMessageManager();
        IslandManager islandManager = plugin.getIslandManager();
        SoundManager soundManager = plugin.getSoundManager();
        FileManager fileManager = plugin.getFileManager();
        FileConfiguration configLoad = plugin.getLanguage();
        ArrayList<Structure> availableStructures = new ArrayList<Structure>();
        for (Structure structureList : plugin.getStructureManager().getStructures()) {
            if (structureList.getDisplayname() == null || structureList.getDisplayname().isEmpty() || structureList.getOverworldFile() == null || structureList.getOverworldFile().isEmpty() || structureList.getNetherFile() == null || structureList.getNetherFile().isEmpty() || structureList.isPermission() && !player.hasPermission(structureList.getPermission()) && !player.hasPermission("fabledskyblock.island.*") && !player.hasPermission("fabledskyblock.*")) continue;
            availableStructures.add(structureList);
        }
        int inventoryRows = 0;
        if (availableStructures.isEmpty()) {
            plugin.getMessageManager().sendMessage((CommandSender)player, configLoad.getString("Island.Creator.Selector.None.Message"));
            plugin.getSoundManager().playSound((CommandSender)player, XSound.BLOCK_ANVIL_LAND);
            return;
        }
        if (availableStructures.size() <= 9) {
            inventoryRows = 1;
        } else if (availableStructures.size() <= 18) {
            inventoryRows = 2;
        } else if (availableStructures.size() <= 27) {
            inventoryRows = 3;
        } else if (availableStructures.size() <= 36) {
            inventoryRows = 4;
        } else if (availableStructures.size() <= 45) {
            inventoryRows = 5;
        } else if (availableStructures.size() <= 54) {
            inventoryRows = 6;
        }
        nInventoryUtil nInv = new nInventoryUtil(player, event -> {
            if (islandManager.getIsland((OfflinePlayer)player) != null) {
                messageManager.sendMessage((CommandSender)player, configLoad.getString("Command.Island.Create.Owner.Message"));
                soundManager.playSound((CommandSender)player, XSound.ENTITY_VILLAGER_NO);
                return;
            }
            Bukkit.getServer().getScheduler().runTaskAsynchronously((Plugin)plugin, () -> {
                ItemStack is = event.getItem();
                for (Structure structureList : plugin.getStructureManager().getStructures()) {
                    if (!structureList.getMaterial().isSimilar(is) || !is.hasItemMeta() || !is.getItemMeta().getDisplayName().equals(ChatColor.translateAlternateColorCodes((char)'&', (String)configLoad.getString("Menu.Creator.Selector.Item.Island.Displayname").replace("%displayname", structureList.getDisplayname())))) continue;
                    if (!(!structureList.isPermission() || structureList.getPermission() == null || structureList.getPermission().isEmpty() || player.hasPermission(structureList.getPermission()) || player.hasPermission("fabledskyblock.island.*") || player.hasPermission("fabledskyblock.*"))) {
                        messageManager.sendMessage((CommandSender)player, configLoad.getString("Island.Creator.Selector.Permission.Message"));
                        soundManager.playSound((CommandSender)player, XSound.BLOCK_ANVIL_LAND);
                        Bukkit.getServer().getScheduler().runTaskLater((Plugin)plugin, () -> this.open(player), 1L);
                        return;
                    }
                    if (!fileManager.isFileExist(new File(new File(plugin.getDataFolder().toString() + "/" + (structureList.getOverworldFile().endsWith(".structure") ? "structures" : "schematics")), structureList.getOverworldFile()))) {
                        messageManager.sendMessage((CommandSender)player, configLoad.getString("Island.Creator.Selector.File.Overworld.Message"));
                        soundManager.playSound((CommandSender)player, XSound.BLOCK_ANVIL_LAND);
                        event.setWillClose(false);
                        event.setWillDestroy(false);
                        return;
                    }
                    if (!fileManager.isFileExist(new File(new File(plugin.getDataFolder().toString() + "/" + (structureList.getNetherFile().endsWith(".structure") ? "structures" : "schematics")), structureList.getNetherFile()))) {
                        messageManager.sendMessage((CommandSender)player, configLoad.getString("Island.Creator.Selector.File.Nether.Message"));
                        soundManager.playSound((CommandSender)player, XSound.BLOCK_ANVIL_LAND);
                        event.setWillClose(false);
                        event.setWillDestroy(false);
                        return;
                    }
                    if (!fileManager.isFileExist(new File(new File(plugin.getDataFolder().toString() + "/" + (structureList.getEndFile().endsWith(".structure") ? "structures" : "schematics")), structureList.getEndFile()))) {
                        messageManager.sendMessage((CommandSender)player, configLoad.getString("Island.Creator.Selector.File.End.Message"));
                        soundManager.playSound((CommandSender)player, XSound.BLOCK_ANVIL_LAND);
                        event.setWillClose(false);
                        event.setWillDestroy(false);
                        return;
                    }
                    if (event.getClick().isLeftClick()) {
                        if (plugin.getConfiguration().getBoolean("Island.Creation.Cooldown.Creation.Enable") && cooldownManager.hasPlayer(CooldownType.CREATION, (OfflinePlayer)player)) {
                            CooldownPlayer cooldownPlayer = cooldownManager.getCooldownPlayer(CooldownType.CREATION, (OfflinePlayer)player);
                            Cooldown cooldown = cooldownPlayer.getCooldown();
                            if (cooldown.getTime() < 60) {
                                messageManager.sendMessage((CommandSender)player, configLoad.getString("Island.Creator.Selector.Cooldown.Message").replace("%time", cooldown.getTime() + " " + configLoad.getString("Island.Creator.Selector.Cooldown.Word.Second")));
                            } else {
                                long[] durationTime = NumberUtil.getDuration(cooldown.getTime());
                                messageManager.sendMessage((CommandSender)player, configLoad.getString("Island.Creator.Selector.Cooldown.Message").replace("%time", durationTime[2] + " " + configLoad.getString("Island.Creator.Selector.Cooldown.Word.Minute") + " " + durationTime[3] + " " + configLoad.getString("Island.Creator.Selector.Cooldown.Word.Second")));
                            }
                            soundManager.playSound((CommandSender)player, XSound.ENTITY_VILLAGER_NO);
                            event.setWillClose(false);
                            event.setWillDestroy(false);
                            return;
                        }
                        if (islandManager.createIsland(player, structureList)) {
                            messageManager.sendMessage((CommandSender)player, configLoad.getString("Island.Creator.Selector.Created.Message"));
                            soundManager.playSound((CommandSender)player, XSound.BLOCK_NOTE_BLOCK_PLING);
                        }
                    } else if (event.getClick().isRightClick()) {
                        if (fileManager.getConfig(new File(plugin.getDataFolder(), "config.yml")).getFileConfiguration().getBoolean("Island.Preview.Cooldown.Enable") && cooldownManager.hasPlayer(CooldownType.PREVIEW, (OfflinePlayer)player)) {
                            CooldownPlayer cooldownPlayer = cooldownManager.getCooldownPlayer(CooldownType.PREVIEW, (OfflinePlayer)player);
                            Cooldown cooldown = cooldownPlayer.getCooldown();
                            if (cooldown.getTime() < 60) {
                                messageManager.sendMessage((CommandSender)player, configLoad.getString("Island.Preview.Cooldown.Message").replace("%time", cooldown.getTime() + " " + configLoad.getString("Island.Preview.Cooldown.Word.Second")));
                            } else {
                                long[] durationTime = NumberUtil.getDuration(cooldown.getTime());
                                messageManager.sendMessage((CommandSender)player, configLoad.getString("Island.Preview.Cooldown.Message").replace("%time", durationTime[2] + " " + configLoad.getString("Island.Preview.Cooldown.Word.Minute") + " " + durationTime[3] + " " + configLoad.getString("Island.Preview.Cooldown.Word.Second")));
                            }
                            soundManager.playSound((CommandSender)player, XSound.ENTITY_VILLAGER_NO);
                            event.setWillClose(false);
                            event.setWillDestroy(false);
                            return;
                        }
                        if (islandManager.previewIsland(player, structureList)) {
                            messageManager.sendMessage((CommandSender)player, configLoad.getString("Island.Creator.Selector.Preview.Message"));
                            soundManager.playSound((CommandSender)player, XSound.BLOCK_NOTE_BLOCK_PLING);
                        }
                    }
                    return;
                }
            });
        });
        int i = 0;
        while (i < availableStructures.size()) {
            Structure structure = (Structure)availableStructures.get(i);
            ArrayList<String> itemLore = new ArrayList<String>();
            for (String itemLoreList : configLoad.getStringList("Menu.Creator.Selector.Item.Island.Lore")) {
                if (itemLoreList.contains("%description")) {
                    if (structure.getDescription() == null || structure.getDescription().isEmpty()) {
                        itemLore.add(configLoad.getString("Menu.Creator.Selector.Item.Island.Word.Empty"));
                        continue;
                    }
                    for (String descriptionList : structure.getDescription()) {
                        itemLore.add(ChatColor.translateAlternateColorCodes((char)'&', (String)descriptionList));
                    }
                    continue;
                }
                itemLore.add(ChatColor.translateAlternateColorCodes((char)'&', (String)itemLoreList));
            }
            nInv.addItem(nInv.createItem(structure.getMaterial().parseItem(), ChatColor.translateAlternateColorCodes((char)'&', (String)configLoad.getString("Menu.Creator.Selector.Item.Island.Displayname").replace("%displayname", structure.getDisplayname())), itemLore, null, null, null), i++);
        }
        nInv.setTitle(ChatColor.translateAlternateColorCodes((char)'&', (String)configLoad.getString("Menu.Creator.Selector.Title")));
        nInv.setRows(inventoryRows);
        Bukkit.getServer().getScheduler().runTask((Plugin)plugin, nInv::open);
    }
}

