/*
 * Decompiled with CFR 0.152.
 */
package com.craftaro.skyblock.menus;

import com.craftaro.skyblock.SkyBlock;
import com.craftaro.skyblock.core.nms.world.NmsWorldBorder;
import com.craftaro.skyblock.island.Island;
import com.craftaro.skyblock.island.IslandManager;
import com.craftaro.skyblock.island.IslandRole;
import com.craftaro.skyblock.message.MessageManager;
import com.craftaro.skyblock.placeholder.Placeholder;
import com.craftaro.skyblock.sound.SoundManager;
import com.craftaro.skyblock.utils.item.nInventoryUtil;
import com.craftaro.third_party.com.cryptomorin.xseries.XMaterial;
import com.craftaro.third_party.com.cryptomorin.xseries.XSound;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class Border {
    private static Border instance;

    public static Border getInstance() {
        if (instance == null) {
            instance = new Border();
        }
        return instance;
    }

    public void open(Player player) {
        SkyBlock plugin = (SkyBlock)SkyBlock.getPlugin(SkyBlock.class);
        MessageManager messageManager = plugin.getMessageManager();
        IslandManager islandManager = plugin.getIslandManager();
        SoundManager soundManager = plugin.getSoundManager();
        FileConfiguration configLoad = plugin.getLanguage();
        nInventoryUtil nInv = new nInventoryUtil(player, event -> {
            Island island = islandManager.getIsland((OfflinePlayer)player);
            if (island == null) {
                messageManager.sendMessage((CommandSender)player, configLoad.getString("Command.Island.Border.Owner.Message"));
                soundManager.playSound((CommandSender)player, XSound.BLOCK_ANVIL_LAND);
                return;
            }
            if (!(island.hasRole(IslandRole.OPERATOR, player.getUniqueId()) && plugin.getPermissionManager().hasPermission(island, "Border", IslandRole.OPERATOR) || island.hasRole(IslandRole.OWNER, player.getUniqueId()))) {
                messageManager.sendMessage((CommandSender)player, configLoad.getString("Command.Island.Border.Permission.Message"));
                soundManager.playSound((CommandSender)player, XSound.ENTITY_VILLAGER_NO);
                return;
            }
            if (!plugin.getConfiguration().getBoolean("Island.WorldBorder.Enable")) {
                messageManager.sendMessage((CommandSender)player, configLoad.getString("Command.Island.Border.Disabled.Message"));
                soundManager.playSound((CommandSender)player, XSound.BLOCK_ANVIL_LAND);
                return;
            }
            ItemStack is = event.getItem();
            if (XMaterial.OAK_FENCE_GATE.isSimilar(is) && is.hasItemMeta() && is.getItemMeta().getDisplayName().equals(ChatColor.translateAlternateColorCodes((char)'&', (String)configLoad.getString("Menu.Border.Item.Exit.Displayname")))) {
                soundManager.playSound((CommandSender)player, XSound.BLOCK_CHEST_CLOSE);
            } else if (is.getType() == Material.TRIPWIRE_HOOK && is.hasItemMeta() && is.getItemMeta().getDisplayName().equals(ChatColor.translateAlternateColorCodes((char)'&', (String)configLoad.getString("Menu.Border.Item.Toggle.Displayname")))) {
                island.setBorder(!island.isBorder());
                islandManager.updateBorder(island);
                soundManager.playSound((CommandSender)player, XSound.BLOCK_WOODEN_BUTTON_CLICK_ON);
                Bukkit.getServer().getScheduler().runTaskLater((Plugin)plugin, () -> this.open(player), 1L);
            } else if (XMaterial.LIGHT_BLUE_DYE.isSimilar(is) && is.hasItemMeta() && is.getItemMeta().getDisplayName().equals(ChatColor.translateAlternateColorCodes((char)'&', (String)configLoad.getString("Menu.Border.Item.Color.Displayname").replace("%color", configLoad.getString("Menu.Border.Item.Word.Blue"))))) {
                if (island.getBorderColor() == NmsWorldBorder.BorderColor.BLUE) {
                    soundManager.playSound((CommandSender)player, XSound.ENTITY_CHICKEN_EGG);
                    event.setWillClose(false);
                    event.setWillDestroy(false);
                } else {
                    island.setBorderColor(NmsWorldBorder.BorderColor.BLUE);
                    islandManager.updateBorder(island);
                    soundManager.playSound((CommandSender)player, XSound.BLOCK_WOODEN_BUTTON_CLICK_ON);
                    Bukkit.getServer().getScheduler().runTaskLater((Plugin)plugin, () -> this.open(player), 1L);
                }
            } else if (XMaterial.LIME_DYE.isSimilar(is) && is.hasItemMeta() && is.getItemMeta().getDisplayName().equals(ChatColor.translateAlternateColorCodes((char)'&', (String)configLoad.getString("Menu.Border.Item.Color.Displayname").replace("%color", configLoad.getString("Menu.Border.Item.Word.Green"))))) {
                if (island.getBorderColor() == NmsWorldBorder.BorderColor.GREEN) {
                    soundManager.playSound((CommandSender)player, XSound.ENTITY_CHICKEN_EGG);
                    event.setWillClose(false);
                    event.setWillDestroy(false);
                } else {
                    island.setBorderColor(NmsWorldBorder.BorderColor.GREEN);
                    islandManager.updateBorder(island);
                    soundManager.playSound((CommandSender)player, XSound.BLOCK_WOODEN_BUTTON_CLICK_ON);
                    Bukkit.getServer().getScheduler().runTaskLater((Plugin)plugin, () -> this.open(player), 1L);
                }
            } else if (XMaterial.RED_DYE.isSimilar(is) && is.hasItemMeta() && is.getItemMeta().getDisplayName().equals(ChatColor.translateAlternateColorCodes((char)'&', (String)configLoad.getString("Menu.Border.Item.Color.Displayname").replace("%color", configLoad.getString("Menu.Border.Item.Word.Red"))))) {
                if (island.getBorderColor() == NmsWorldBorder.BorderColor.RED) {
                    soundManager.playSound((CommandSender)player, XSound.ENTITY_CHICKEN_EGG);
                    event.setWillClose(false);
                    event.setWillDestroy(false);
                } else {
                    island.setBorderColor(NmsWorldBorder.BorderColor.RED);
                    islandManager.updateBorder(island);
                    soundManager.playSound((CommandSender)player, XSound.BLOCK_WOODEN_BUTTON_CLICK_ON);
                    Bukkit.getServer().getScheduler().runTaskLater((Plugin)plugin, () -> this.open(player), 1L);
                }
            }
        });
        Island island = islandManager.getIsland((OfflinePlayer)player);
        nInv.addItem(nInv.createItem(XMaterial.OAK_FENCE_GATE.parseItem(), configLoad.getString("Menu.Border.Item.Exit.Displayname"), null, null, null, null), 0);
        NmsWorldBorder.BorderColor borderColor = island.getBorderColor();
        String borderToggle = island.isBorder() ? configLoad.getString("Menu.Border.Item.Word.Disable") : configLoad.getString("Menu.Border.Item.Word.Enable");
        nInv.addItem(nInv.createItem(new ItemStack(Material.TRIPWIRE_HOOK), configLoad.getString("Menu.Border.Item.Toggle.Displayname"), configLoad.getStringList("Menu.Border.Item.Toggle.Lore"), new Placeholder[]{new Placeholder("%toggle", borderToggle)}, null, null), 1);
        if (player.hasPermission("fabledskyblock.island.border.blue")) {
            if (borderColor == NmsWorldBorder.BorderColor.BLUE) {
                nInv.addItem(nInv.createItem(XMaterial.LIGHT_BLUE_DYE.parseItem(), configLoad.getString("Menu.Border.Item.Color.Displayname").replace("%color", configLoad.getString("Menu.Border.Item.Word.Blue")), configLoad.getStringList("Menu.Border.Item.Color.Selected.Lore"), new Placeholder[]{new Placeholder("%color", configLoad.getString("Menu.Border.Item.Word.Blue"))}, null, null), 2);
            } else {
                nInv.addItem(nInv.createItem(XMaterial.LIGHT_BLUE_DYE.parseItem(), configLoad.getString("Menu.Border.Item.Color.Displayname").replace("%color", configLoad.getString("Menu.Border.Item.Word.Blue")), configLoad.getStringList("Menu.Border.Item.Color.Unselected.Lore"), new Placeholder[]{new Placeholder("%color", configLoad.getString("Menu.Border.Item.Word.Blue"))}, null, null), 2);
            }
        } else {
            nInv.addItem(nInv.createItem(XMaterial.BLACK_STAINED_GLASS_PANE.parseItem(), "", null, null, null, null), 2);
        }
        if (player.hasPermission("fabledskyblock.island.border.green")) {
            if (borderColor == NmsWorldBorder.BorderColor.GREEN) {
                nInv.addItem(nInv.createItem(XMaterial.LIME_DYE.parseItem(), configLoad.getString("Menu.Border.Item.Color.Displayname").replace("%color", configLoad.getString("Menu.Border.Item.Word.Green")), configLoad.getStringList("Menu.Border.Item.Color.Selected.Lore"), new Placeholder[]{new Placeholder("%color", configLoad.getString("Menu.Border.Item.Word.Green"))}, null, null), 3);
            } else {
                nInv.addItem(nInv.createItem(XMaterial.LIME_DYE.parseItem(), configLoad.getString("Menu.Border.Item.Color.Displayname").replace("%color", configLoad.getString("Menu.Border.Item.Word.Green")), configLoad.getStringList("Menu.Border.Item.Color.Unselected.Lore"), new Placeholder[]{new Placeholder("%color", configLoad.getString("Menu.Border.Item.Word.Green"))}, null, null), 3);
            }
        } else {
            nInv.addItem(nInv.createItem(XMaterial.BLACK_STAINED_GLASS_PANE.parseItem(), "", null, null, null, null), 3);
        }
        if (player.hasPermission("fabledskyblock.island.border.red")) {
            if (borderColor == NmsWorldBorder.BorderColor.RED) {
                nInv.addItem(nInv.createItem(XMaterial.RED_DYE.parseItem(), configLoad.getString("Menu.Border.Item.Color.Displayname").replace("%color", configLoad.getString("Menu.Border.Item.Word.Red")), configLoad.getStringList("Menu.Border.Item.Color.Selected.Lore"), new Placeholder[]{new Placeholder("%color", configLoad.getString("Menu.Border.Item.Word.Red"))}, null, null), 4);
            } else {
                nInv.addItem(nInv.createItem(XMaterial.RED_DYE.parseItem(), configLoad.getString("Menu.Border.Item.Color.Displayname").replace("%color", configLoad.getString("Menu.Border.Item.Word.Red")), configLoad.getStringList("Menu.Border.Item.Color.Unselected.Lore"), new Placeholder[]{new Placeholder("%color", configLoad.getString("Menu.Border.Item.Word.Red"))}, null, null), 4);
            }
        } else {
            nInv.addItem(nInv.createItem(XMaterial.BLACK_STAINED_GLASS_PANE.parseItem(), "", null, null, null, null), 4);
        }
        nInv.setTitle(ChatColor.translateAlternateColorCodes((char)'&', (String)configLoad.getString("Menu.Border.Title")));
        nInv.setType(InventoryType.HOPPER);
        Bukkit.getServer().getScheduler().runTask((Plugin)plugin, nInv::open);
    }
}

