/*
 * Decompiled with CFR 0.152.
 */
package com.craftaro.skyblock.localization;

import com.craftaro.skyblock.SkyBlock;
import com.craftaro.skyblock.island.IslandRole;
import com.craftaro.skyblock.localization.type.Localization;
import com.craftaro.skyblock.localization.type.impl.BlankLocalization;
import com.craftaro.skyblock.localization.type.impl.EnumLocalization;
import com.craftaro.skyblock.localization.type.impl.MaterialsLocalization;
import com.craftaro.third_party.com.cryptomorin.xseries.XMaterial;
import com.google.common.collect.Sets;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.configuration.Configuration;
import org.bukkit.configuration.file.FileConfiguration;

public final class LocalizationManager {
    private final Localization<?> def = new BlankLocalization("", Object.class);
    private final Map<Class<?>, Localization<?>> map = new HashMap();

    public LocalizationManager() {
        this.registerLocalizationFor(XMaterial.class, new MaterialsLocalization("Materials"));
        this.registerLocalizationFor(IslandRole.class, new EnumLocalization<IslandRole>("IslandRoles", IslandRole.class));
    }

    public void registerLocalizationFor(Class<?> type, Localization<?> toUse) {
        if (type == null) {
            throw new IllegalArgumentException("type cannot be null");
        }
        if (toUse == null) {
            throw new IllegalArgumentException("toUse cannot be null");
        }
        if (toUse == this.def) {
            throw new IllegalArgumentException("Cannot register default localization.");
        }
        this.map.put(type, toUse);
        SkyBlock inst = (SkyBlock)SkyBlock.getPlugin(SkyBlock.class);
        toUse.reload(inst.getLanguage().getConfigurationSection(toUse.getKeysPath()));
    }

    public void reloadAll() {
        SkyBlock inst = (SkyBlock)SkyBlock.getPlugin(SkyBlock.class);
        FileConfiguration config = inst.getLanguage();
        Sets.newHashSet(this.map.values()).forEach(arg_0 -> LocalizationManager.lambda$reloadAll$0((Configuration)config, arg_0));
    }

    public <T> Localization<T> getLocalizationFor(Class<T> type) {
        Localization<?> locale = this.map.get(type);
        if (locale == null) {
            locale = this.def;
        }
        return locale;
    }

    private static /* synthetic */ void lambda$reloadAll$0(Configuration config, Localization locale) {
        locale.reload(config.getConfigurationSection(locale.getKeysPath()));
    }
}

