/*
 * Decompiled with CFR 0.152.
 */
package com.craftaro.skyblock.listeners.hooks;

import com.craftaro.skyblock.SkyBlock;
import com.craftaro.skyblock.island.Island;
import com.craftaro.skyblock.island.IslandLevel;
import com.craftaro.skyblock.island.IslandManager;
import com.craftaro.skyblock.utils.version.CompatibleSpawners;
import com.craftaro.skyblock.world.WorldManager;
import com.craftaro.ultimatestacker.api.events.spawner.SpawnerBreakEvent;
import com.craftaro.ultimatestacker.api.events.spawner.SpawnerPlaceEvent;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;

public class UltimateStacker
implements Listener {
    private final SkyBlock plugin;

    public UltimateStacker(SkyBlock plugin) {
        this.plugin = plugin;
    }

    @EventHandler
    public void onSpawnerPlace(SpawnerPlaceEvent event) {
        Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)SkyBlock.getPlugin(SkyBlock.class), () -> {
            CompatibleSpawners materials;
            Location location;
            IslandManager islandManager = this.plugin.getIslandManager();
            WorldManager worldManager = this.plugin.getWorldManager();
            if (!worldManager.isIslandWorld((location = event.getBlock().getLocation()).getWorld())) {
                return;
            }
            Island island = islandManager.getIslandAtLocation(location);
            FileConfiguration configLoad = this.plugin.getConfiguration();
            if (configLoad.getBoolean("Island.Block.Level.Enable") && (materials = CompatibleSpawners.getSpawner(event.getSpawnerType())) != null) {
                IslandLevel level = island.getLevel();
                long materialAmount = 0L;
                if (level.hasMaterial(materials.name())) {
                    materialAmount = level.getMaterialAmount(materials.name());
                }
                level.setMaterialAmount(materials.name(), materialAmount + (long)event.getAmount() - 1L);
            }
        });
    }

    @EventHandler
    public void onSpawnerBreak(SpawnerBreakEvent event) {
        IslandLevel level;
        CompatibleSpawners materials;
        Location location;
        IslandManager islandManager = this.plugin.getIslandManager();
        WorldManager worldManager = this.plugin.getWorldManager();
        if (!worldManager.isIslandWorld((location = event.getBlock().getLocation()).getWorld())) {
            return;
        }
        Island island = islandManager.getIslandAtLocation(location);
        FileConfiguration configLoad = this.plugin.getConfiguration();
        if (configLoad.getBoolean("Island.Block.Level.Enable") && (materials = CompatibleSpawners.getSpawner(event.getSpawnerType())) != null && (level = island.getLevel()).hasMaterial(materials.name())) {
            long materialAmount = level.getMaterialAmount(materials.name());
            if (materialAmount - (long)event.getAmount() <= 0L) {
                level.removeMaterial(materials.name());
            } else {
                level.setMaterialAmount(materials.name(), materialAmount - (long)event.getAmount());
            }
        }
    }
}

