/*
 * Decompiled with CFR 0.152.
 */
package com.craftaro.skyblock.listeners.hooks;

import com.craftaro.epicspawners.api.events.SpawnerAccessEvent;
import com.craftaro.epicspawners.api.events.SpawnerBreakEvent;
import com.craftaro.epicspawners.api.events.SpawnerChangeEvent;
import com.craftaro.epicspawners.api.events.SpawnerPlaceEvent;
import com.craftaro.skyblock.SkyBlock;
import com.craftaro.skyblock.island.Island;
import com.craftaro.skyblock.island.IslandLevel;
import com.craftaro.skyblock.island.IslandManager;
import com.craftaro.skyblock.permission.PermissionManager;
import com.craftaro.skyblock.utils.version.CompatibleSpawners;
import com.craftaro.skyblock.world.WorldManager;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.EntityType;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;

public class EpicSpawners
implements Listener {
    private final SkyBlock plugin;

    public EpicSpawners(SkyBlock plugin) {
        this.plugin = plugin;
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onSpawnerPlace(SpawnerPlaceEvent event) {
        Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)SkyBlock.getPlugin(SkyBlock.class), () -> {
            CompatibleSpawners materials;
            Location location;
            IslandManager islandManager = this.plugin.getIslandManager();
            WorldManager worldManager = this.plugin.getWorldManager();
            if (!worldManager.isIslandWorld((location = event.getSpawner().getLocation()).getWorld())) {
                return;
            }
            Island island = islandManager.getIslandAtLocation(location);
            int amount = event.getSpawner().getStackSize();
            EntityType spawnerType = event.getSpawner().getCreatureSpawner().getSpawnedType();
            FileConfiguration configLoad = this.plugin.getConfiguration();
            if (configLoad.getBoolean("Island.Block.Level.Enable") && (materials = CompatibleSpawners.getSpawner(spawnerType)) != null) {
                IslandLevel level = island.getLevel();
                long materialAmount = 0L;
                if (level.hasMaterial(materials.name())) {
                    materialAmount = level.getMaterialAmount(materials.name());
                }
                level.setMaterialAmount(materials.name(), materialAmount + (long)amount);
            }
        });
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onSpawnerChange(SpawnerChangeEvent event) {
        CompatibleSpawners materials;
        Location location;
        if (event.getChange() != SpawnerChangeEvent.ChangeType.STACK_SIZE) {
            return;
        }
        IslandManager islandManager = this.plugin.getIslandManager();
        WorldManager worldManager = this.plugin.getWorldManager();
        if (!worldManager.isIslandWorld((location = event.getSpawner().getLocation()).getWorld())) {
            return;
        }
        Island island = islandManager.getIslandAtLocation(location);
        int amount = event.getStackSize() - event.getOldStackSize();
        EntityType spawnerType = event.getSpawner().getCreatureSpawner().getSpawnedType();
        FileConfiguration configLoad = this.plugin.getConfiguration();
        if (configLoad.getBoolean("Island.Block.Level.Enable") && (materials = CompatibleSpawners.getSpawner(spawnerType)) != null) {
            IslandLevel level = island.getLevel();
            long materialAmount = 0L;
            if (level.hasMaterial(materials.name())) {
                materialAmount = level.getMaterialAmount(materials.name());
            }
            if (materialAmount + (long)amount <= 0L) {
                level.removeMaterial(materials.name());
            } else {
                level.setMaterialAmount(materials.name(), materialAmount + (long)amount);
            }
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onSpawnerBreak(SpawnerBreakEvent event) {
        IslandLevel level;
        CompatibleSpawners materials;
        Location location;
        IslandManager islandManager = this.plugin.getIslandManager();
        WorldManager worldManager = this.plugin.getWorldManager();
        if (!worldManager.isIslandWorld((location = event.getSpawner().getLocation()).getWorld())) {
            return;
        }
        Island island = islandManager.getIslandAtLocation(location);
        int amount = event.getSpawner().getStackSize();
        EntityType spawnerType = event.getSpawner().getCreatureSpawner().getSpawnedType();
        FileConfiguration configLoad = this.plugin.getConfiguration();
        if (configLoad.getBoolean("Island.Block.Level.Enable") && (materials = CompatibleSpawners.getSpawner(spawnerType)) != null && (level = island.getLevel()).hasMaterial(materials.name())) {
            long materialAmount = level.getMaterialAmount(materials.name());
            if (materialAmount - (long)amount <= 0L) {
                level.removeMaterial(materials.name());
            } else {
                level.setMaterialAmount(materials.name(), materialAmount - (long)amount);
            }
        }
    }

    @EventHandler
    public void onSpawnerAccess(SpawnerAccessEvent event) {
        Location location;
        if (event.getSpawner().getLocation() == null) {
            return;
        }
        IslandManager islandManager = this.plugin.getIslandManager();
        WorldManager worldManager = this.plugin.getWorldManager();
        if (!worldManager.isIslandWorld((location = event.getSpawner().getLocation()).getWorld())) {
            return;
        }
        Island island = islandManager.getIslandAtLocation(location);
        if (island == null) {
            return;
        }
        PermissionManager permissionManager = this.plugin.getPermissionManager();
        if (!permissionManager.hasPermission(event.getPlayer(), island, permissionManager.getPermission("SpawnEgg"))) {
            event.setCancelled(true);
        }
    }
}

