/*
 * Decompiled with CFR 0.152.
 */
package com.craftaro.skyblock.listeners;

import com.craftaro.skyblock.SkyBlock;
import com.craftaro.skyblock.island.Island;
import com.craftaro.skyblock.island.IslandLevel;
import com.craftaro.skyblock.island.IslandManager;
import com.craftaro.skyblock.levelling.IslandLevelManager;
import com.craftaro.skyblock.stackable.StackableManager;
import com.craftaro.skyblock.world.WorldManager;
import com.craftaro.third_party.com.cryptomorin.xseries.XMaterial;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.event.Cancellable;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.SpongeAbsorbEvent;
import org.bukkit.plugin.Plugin;

public class SpongeListeners
implements Listener {
    private final SkyBlock plugin;

    public SpongeListeners(SkyBlock plugin) {
        this.plugin = plugin;
    }

    @EventHandler(ignoreCancelled=true)
    public void onSponge(SpongeAbsorbEvent event) {
        Block block;
        IslandLevelManager islandLevelManager = this.plugin.getLevellingManager();
        IslandManager islandManager = this.plugin.getIslandManager();
        StackableManager stackableManager = this.plugin.getStackableManager();
        WorldManager worldManager = this.plugin.getWorldManager();
        if (worldManager.isIslandWorld((block = event.getBlock()).getWorld())) {
            Location blockLocation = block.getLocation();
            Island island = islandManager.getIslandAtLocation(blockLocation);
            if (island != null) {
                if (this.plugin.getPermissionManager().processPermission((Cancellable)event, island) && !event.isCancelled()) {
                    if (stackableManager == null || !stackableManager.isStacked(blockLocation)) {
                        XMaterial material;
                        IslandLevel level = island.getLevel();
                        if (level.hasMaterial((material = XMaterial.SPONGE).name())) {
                            long materialAmount = level.getMaterialAmount(material.name());
                            if (materialAmount - 1L <= 0L) {
                                level.removeMaterial(material.name());
                            } else {
                                level.setMaterialAmount(material.name(), materialAmount - 1L);
                            }
                            Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> islandLevelManager.updateLevel(island, blockLocation));
                        }
                    } else {
                        event.setCancelled(true);
                    }
                }
            } else {
                event.setCancelled(true);
            }
        }
    }
}

