/*
 * Decompiled with CFR 0.152.
 */
package com.craftaro.skyblock.listeners;

import com.craftaro.skyblock.SkyBlock;
import com.craftaro.skyblock.core.compatibility.MajorServerVersion;
import com.craftaro.skyblock.island.Island;
import com.craftaro.skyblock.island.IslandManager;
import com.craftaro.skyblock.upgrade.Upgrade;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import org.bukkit.Location;
import org.bukkit.block.CreatureSpawner;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.SpawnerSpawnEvent;

public class SpawnerListeners
implements Listener {
    private final SkyBlock plugin;

    public SpawnerListeners(SkyBlock plugin) {
        this.plugin = plugin;
    }

    @EventHandler
    public void onSpawnSpawn(SpawnerSpawnEvent event) {
        IslandManager islandManager = this.plugin.getIslandManager();
        CreatureSpawner spawner = event.getSpawner();
        Location location = spawner.getBlock().getLocation();
        if (!this.plugin.getWorldManager().isIslandWorld(location.getWorld())) {
            return;
        }
        Island island = islandManager.getIslandAtLocation(location);
        if (island == null) {
            return;
        }
        List<Upgrade> upgrades = this.plugin.getUpgradeManager().getUpgrades(Upgrade.Type.SPAWNER);
        if (upgrades != null && !upgrades.isEmpty() && upgrades.get(0).isEnabled() && island.isUpgrade(Upgrade.Type.SPAWNER)) {
            if (MajorServerVersion.isServerVersionAbove(MajorServerVersion.V1_12)) {
                if (spawner.getDelay() == 20) {
                    spawner.setDelay(10);
                }
                spawner.setMinSpawnDelay(100);
                spawner.setMaxSpawnDelay(400);
            } else {
                try {
                    Object mobSpawner;
                    try {
                        Field tileEntityMobSpawnerField = spawner.getClass().getDeclaredField("spawner");
                        tileEntityMobSpawnerField.setAccessible(true);
                        Object tileEntityMobSpawner = tileEntityMobSpawnerField.get(spawner);
                        mobSpawner = tileEntityMobSpawner.getClass().getMethod("getSpawner", new Class[0]).invoke(tileEntityMobSpawner, new Object[0]);
                    }
                    catch (NoSuchFieldException ignored) {
                        Field snapshotField = spawner.getClass().getSuperclass().getDeclaredField("snapshot");
                        snapshotField.setAccessible(true);
                        Object snapshot = snapshotField.get(spawner);
                        mobSpawner = snapshot.getClass().getMethod("getSpawner", new Class[0]).invoke(snapshot, new Object[0]);
                    }
                    int spawnDelay = (Integer)mobSpawner.getClass().getSuperclass().getField("spawnDelay").get(mobSpawner);
                    if (spawnDelay == 20) {
                        Field spawnDelayField = mobSpawner.getClass().getSuperclass().getField("spawnDelay");
                        spawnDelayField.setAccessible(true);
                        spawnDelayField.set(mobSpawner, 10);
                    }
                    Field minSpawnDelayField = mobSpawner.getClass().getSuperclass().getDeclaredField("minSpawnDelay");
                    minSpawnDelayField.setAccessible(true);
                    int minSpawnDelay = (Integer)minSpawnDelayField.get(mobSpawner);
                    if (minSpawnDelay != 100) {
                        minSpawnDelayField.set(mobSpawner, 100);
                    }
                    Field maxSpawnDelayField = mobSpawner.getClass().getSuperclass().getDeclaredField("maxSpawnDelay");
                    maxSpawnDelayField.setAccessible(true);
                    int maxSpawnDelay = (Integer)maxSpawnDelayField.get(mobSpawner);
                    if (maxSpawnDelay != 400) {
                        maxSpawnDelayField.set(mobSpawner, 400);
                    }
                }
                catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | NoSuchMethodException | SecurityException | InvocationTargetException ex) {
                    ex.printStackTrace();
                }
            }
            spawner.update();
        }
    }
}

