/*
 * Decompiled with CFR 0.152.
 */
package com.craftaro.skyblock.listeners;

import com.craftaro.skyblock.SkyBlock;
import com.craftaro.skyblock.config.FileManager;
import com.craftaro.skyblock.island.Island;
import com.craftaro.skyblock.island.IslandEnvironment;
import com.craftaro.skyblock.island.IslandManager;
import com.craftaro.skyblock.island.IslandRole;
import com.craftaro.skyblock.island.IslandWorld;
import com.craftaro.skyblock.world.WorldManager;
import java.io.File;
import java.util.logging.Level;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerRespawnEvent;
import org.bukkit.event.player.PlayerTeleportEvent;

public class RespawnListeners
implements Listener {
    private final SkyBlock plugin;

    public RespawnListeners(SkyBlock plugin) {
        this.plugin = plugin;
    }

    @EventHandler
    public void onPlayerRespawn(PlayerRespawnEvent event) {
        Player player = event.getPlayer();
        IslandManager islandManager = this.plugin.getIslandManager();
        WorldManager worldManager = this.plugin.getWorldManager();
        FileManager fileManager = this.plugin.getFileManager();
        if (worldManager.isIslandWorld(player.getWorld())) {
            Location playerLocation;
            Island island;
            FileConfiguration configLoad = this.plugin.getConfiguration();
            if (configLoad.getBoolean("Island.Death.Respawn.Island") && (island = islandManager.getIslandAtLocation(playerLocation = player.getLocation())) != null) {
                IslandWorld world = worldManager.getIslandWorld(player.getWorld());
                Location islandLocation = island.hasRole(IslandRole.MEMBER, player.getUniqueId()) || island.hasRole(IslandRole.OPERATOR, player.getUniqueId()) || island.hasRole(IslandRole.OWNER, player.getUniqueId()) ? island.getLocation(world, IslandEnvironment.MAIN) : island.getLocation(world, IslandEnvironment.VISITOR);
                Bukkit.getServer().getPluginManager().callEvent((Event)new PlayerTeleportEvent(player, playerLocation, islandLocation));
                event.setRespawnLocation(islandLocation);
                islandManager.updateFlight(player);
                return;
            }
            FileManager.Config config = fileManager.getConfig(new File(this.plugin.getDataFolder(), "locations.yml"));
            if (config.getFileConfiguration().getString("Location.Spawn") == null) {
                Bukkit.getServer().getLogger().log(Level.WARNING, "SkyBlock | Error: A spawn point hasn't been set.");
            } else {
                Location playerLocation2 = player.getLocation();
                Location spawnLocation = fileManager.getLocation(config, "Location.Spawn", true);
                Bukkit.getServer().getPluginManager().callEvent((Event)new PlayerTeleportEvent(player, playerLocation2, spawnLocation));
                event.setRespawnLocation(spawnLocation);
            }
        }
    }
}

