/*
 * Decompiled with CFR 0.152.
 */
package com.craftaro.skyblock.listeners;

import com.craftaro.skyblock.SkyBlock;
import com.craftaro.skyblock.challenge.player.PlayerManager;
import com.craftaro.skyblock.cooldown.CooldownManager;
import com.craftaro.skyblock.cooldown.CooldownType;
import com.craftaro.skyblock.invite.Invite;
import com.craftaro.skyblock.invite.InviteManager;
import com.craftaro.skyblock.island.Island;
import com.craftaro.skyblock.island.IslandCoop;
import com.craftaro.skyblock.island.IslandManager;
import com.craftaro.skyblock.island.IslandRole;
import com.craftaro.skyblock.message.MessageManager;
import com.craftaro.skyblock.playerdata.PlayerData;
import com.craftaro.skyblock.playerdata.PlayerDataManager;
import com.craftaro.skyblock.scoreboard.ScoreboardManager;
import com.craftaro.third_party.com.cryptomorin.xseries.XSound;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Set;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.plugin.Plugin;

public class QuitListeners
implements Listener {
    private final SkyBlock plugin;

    public QuitListeners(SkyBlock plugin) {
        this.plugin = plugin;
    }

    @EventHandler
    public void onPlayerQuit(PlayerQuitEvent event) {
        Object is;
        Player player = event.getPlayer();
        PlayerDataManager playerDataManager = this.plugin.getPlayerDataManager();
        CooldownManager cooldownManager = this.plugin.getCooldownManager();
        MessageManager messageManager = this.plugin.getMessageManager();
        InviteManager inviteManager = this.plugin.getInviteManager();
        IslandManager islandManager = this.plugin.getIslandManager();
        ScoreboardManager scoreboardManager = this.plugin.getScoreboardManager();
        PlayerManager challengePlayerManager = this.plugin.getFabledChallenge().getPlayerManager();
        PlayerData playerData = playerDataManager.getPlayerData(player);
        try {
            playerData.setLastOnline(new SimpleDateFormat("dd/MM/yyyy HH:mm:ss").format(new Date()));
        }
        catch (Exception exception) {
            // empty catch block
        }
        Island island = islandManager.getIsland((OfflinePlayer)player);
        if (island != null) {
            Set<UUID> islandMembersOnline = islandManager.getMembersOnline(island);
            if (islandMembersOnline.size() == 1) {
                OfflinePlayer offlinePlayer = Bukkit.getServer().getOfflinePlayer(island.getOwnerUUID());
                cooldownManager.setCooldownPlayer(CooldownType.LEVELLING, offlinePlayer);
                cooldownManager.removeCooldownPlayer(CooldownType.LEVELLING, offlinePlayer);
                cooldownManager.setCooldownPlayer(CooldownType.OWNERSHIP, offlinePlayer);
                cooldownManager.removeCooldownPlayer(CooldownType.OWNERSHIP, offlinePlayer);
            } else if (islandMembersOnline.size() == 2) {
                for (UUID islandMembersOnlineList : islandMembersOnline) {
                    Player targetPlayer;
                    PlayerData targetPlayerData;
                    if (islandMembersOnlineList.equals(player.getUniqueId()) || !(targetPlayerData = playerDataManager.getPlayerData(targetPlayer = Bukkit.getServer().getPlayer(islandMembersOnlineList))).isChat()) continue;
                    targetPlayerData.setChat(false);
                    messageManager.sendMessage((CommandSender)targetPlayer, this.plugin.getLanguage().getString("Island.Chat.Untoggled.Message"));
                }
            }
            is = island;
            Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, () -> QuitListeners.lambda$onPlayerQuit$0(islandManager, (Island)is, player));
        }
        cooldownManager.setCooldownPlayer(CooldownType.BIOME, (OfflinePlayer)player);
        cooldownManager.removeCooldownPlayer(CooldownType.BIOME, (OfflinePlayer)player);
        cooldownManager.setCooldownPlayer(CooldownType.CREATION, (OfflinePlayer)player);
        cooldownManager.removeCooldownPlayer(CooldownType.CREATION, (OfflinePlayer)player);
        cooldownManager.setCooldownPlayer(CooldownType.DELETION, (OfflinePlayer)player);
        cooldownManager.removeCooldownPlayer(CooldownType.DELETION, (OfflinePlayer)player);
        playerDataManager.savePlayerData(player);
        playerDataManager.unloadPlayerData(player);
        boolean offline = true;
        if (island != null && this.plugin.getConfiguration().getBoolean("Island.Challenge.PerIsland", false)) {
            if (island.getRole(IslandRole.MEMBER) != null) {
                offline = island.getRole(IslandRole.MEMBER).stream().noneMatch(uuid -> Bukkit.getPlayer((UUID)uuid) != null && !Bukkit.getPlayer((UUID)uuid).isOnline());
            }
            if (offline && island.getRole(IslandRole.OPERATOR) != null && island.getRole(IslandRole.OPERATOR).stream().anyMatch(uuid -> Bukkit.getPlayer((UUID)uuid) != null && !Bukkit.getPlayer((UUID)uuid).isOnline())) {
                offline = false;
            }
            if (offline && island.getRole(IslandRole.OWNER) != null && island.getRole(IslandRole.OWNER).stream().anyMatch(uuid -> Bukkit.getPlayer((UUID)uuid) != null && !Bukkit.getPlayer((UUID)uuid).isOnline())) {
                offline = false;
            }
        }
        if (offline) {
            challengePlayerManager.unloadPlayer(player.getUniqueId());
        }
        for (Island islandList : islandManager.getCoopIslands(player)) {
            if (!this.plugin.getConfiguration().getBoolean("Island.Coop.Unload") && islandList.getCoopType(player.getUniqueId()) != IslandCoop.TEMP) continue;
            islandList.removeCoopPlayer(player.getUniqueId());
        }
        if (playerData != null && playerData.getIsland() != null && islandManager.containsIsland(playerData.getIsland()) && !(island = islandManager.getIsland(Bukkit.getServer().getOfflinePlayer(playerData.getIsland()))).hasRole(IslandRole.MEMBER, player.getUniqueId()) && !island.hasRole(IslandRole.OPERATOR, player.getUniqueId()) && !island.hasRole(IslandRole.OWNER, player.getUniqueId())) {
            is = island;
            Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, () -> QuitListeners.lambda$onPlayerQuit$4(islandManager, (Island)is));
        }
        if (inviteManager.hasInvite(player.getUniqueId())) {
            Invite invite = inviteManager.getInvite(player.getUniqueId());
            Player targetPlayer = Bukkit.getServer().getPlayer(invite.getOwnerUUID());
            if (targetPlayer != null) {
                messageManager.sendMessage((CommandSender)targetPlayer, this.plugin.getLanguage().getString("Command.Island.Invite.Invited.Sender.Disconnected.Message").replace("%player", player.getName()));
                this.plugin.getSoundManager().playSound((CommandSender)targetPlayer, XSound.ENTITY_VILLAGER_NO);
            }
            inviteManager.removeInvite(player.getUniqueId());
        }
        scoreboardManager.unregisterPlayer(player);
        ((SkyBlock)SkyBlock.getPlugin(SkyBlock.class)).getFabledChallenge().getPlayerManager().unloadPlayer(event.getPlayer().getUniqueId());
    }

    private static /* synthetic */ void lambda$onPlayerQuit$4(IslandManager islandManager, Island is) {
        islandManager.unloadIsland(is, null);
    }

    private static /* synthetic */ void lambda$onPlayerQuit$0(IslandManager islandManager, Island is, Player player) {
        islandManager.unloadIsland(is, (OfflinePlayer)player);
    }
}

