/*
 * Decompiled with CFR 0.152.
 */
package com.craftaro.skyblock.listeners;

import com.craftaro.skyblock.SkyBlock;
import com.craftaro.skyblock.island.Island;
import com.craftaro.skyblock.island.IslandEnvironment;
import com.craftaro.skyblock.island.IslandManager;
import com.craftaro.skyblock.island.IslandWorld;
import com.craftaro.skyblock.message.MessageManager;
import com.craftaro.skyblock.permission.event.events.PlayerEnterPortalEvent;
import com.craftaro.skyblock.sound.SoundManager;
import com.craftaro.skyblock.utils.world.LocationUtil;
import com.craftaro.skyblock.world.WorldManager;
import com.craftaro.third_party.com.cryptomorin.xseries.XMaterial;
import com.craftaro.third_party.com.cryptomorin.xseries.XSound;
import io.papermc.lib.PaperLib;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.OfflinePlayer;
import org.bukkit.block.Block;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.Cancellable;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityPortalEnterEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.plugin.Plugin;

public class PortalListeners
implements Listener {
    private final SkyBlock plugin;
    private final Map<UUID, Tick> tickCounter = new HashMap<UUID, Tick>();

    public PortalListeners(SkyBlock plugin) {
        this.plugin = plugin;
    }

    @EventHandler
    public void onPlayerMove(PlayerMoveEvent event) {
        Player player = event.getPlayer();
        Block from = event.getFrom().getBlock();
        Block to = event.getTo().getBlock();
        if (from.getX() == to.getX() && from.getY() == to.getY() && from.getZ() == to.getZ()) {
            return;
        }
        IslandManager islandManager = this.plugin.getIslandManager();
        Island island = islandManager.getIslandAtLocation(to.getLocation());
        if (island == null) {
            return;
        }
        this.plugin.getPermissionManager().processPermission((Cancellable)event, player, islandManager.getIslandAtLocation(event.getTo()));
    }

    @EventHandler(priority=EventPriority.LOW)
    public void onEntityPortalEnter(EntityPortalEnterEvent event) {
        block24: {
            IslandWorld toWorld;
            Player player;
            block23: {
                boolean perms;
                Tick tick;
                IslandEnvironment spawnEnvironment;
                if (!(event.getEntity() instanceof Player)) {
                    return;
                }
                player = (Player)event.getEntity();
                Block block = event.getLocation().getBlock();
                MessageManager messageManager = this.plugin.getMessageManager();
                IslandManager islandManager = this.plugin.getIslandManager();
                SoundManager soundManager = this.plugin.getSoundManager();
                WorldManager worldManager = this.plugin.getWorldManager();
                if (!worldManager.isIslandWorld(player.getWorld())) {
                    return;
                }
                Island island = islandManager.getIslandAtLocation(player.getLocation());
                if (island == null) {
                    return;
                }
                FileConfiguration configLoad = this.plugin.getConfiguration();
                switch (island.getRole((OfflinePlayer)player)) {
                    case OPERATOR: 
                    case OWNER: 
                    case MEMBER: 
                    case COOP: {
                        spawnEnvironment = IslandEnvironment.MAIN;
                        break;
                    }
                    default: {
                        spawnEnvironment = IslandEnvironment.VISITOR;
                    }
                }
                IslandWorld fromWorld = worldManager.getIslandWorld(player.getWorld());
                toWorld = IslandWorld.NORMAL;
                if (block.getType() == XMaterial.NETHER_PORTAL.parseMaterial()) {
                    toWorld = fromWorld == IslandWorld.NETHER ? IslandWorld.NORMAL : IslandWorld.NETHER;
                } else if (block.getType() == XMaterial.END_PORTAL.parseMaterial()) {
                    IslandWorld islandWorld = toWorld = fromWorld == IslandWorld.END ? IslandWorld.NORMAL : IslandWorld.END;
                }
                if (!configLoad.getBoolean("Island.World." + toWorld.getFriendlyName() + ".Enable")) {
                    return;
                }
                if (!this.tickCounter.containsKey(player.getUniqueId())) {
                    tick = this.tickCounter.put(player.getUniqueId(), new Tick());
                } else {
                    tick = this.tickCounter.get(player.getUniqueId());
                    tick.setTick(tick.getTick() + 1);
                    if (System.currentTimeMillis() - tick.getLast() < 1000L) {
                        return;
                    }
                    if (System.currentTimeMillis() - tick.getLast() >= 1000L) {
                        tick.setLast(System.currentTimeMillis());
                    }
                    if (tick.getTick() >= 100) {
                        messageManager.sendMessage((CommandSender)player, this.plugin.getLanguage().getString("Island.Portal.Stuck.Message"));
                        soundManager.playSound((CommandSender)player, XSound.ENTITY_ENDERMAN_TELEPORT);
                        LocationUtil.teleportPlayerToSpawn(player);
                        return;
                    }
                }
                if (tick == null) {
                    return;
                }
                PlayerEnterPortalEvent playerEnterPortalEvent = new PlayerEnterPortalEvent(player, player.getLocation());
                boolean bl = perms = !this.plugin.getPermissionManager().processPermission((Cancellable)playerEnterPortalEvent, player, island);
                if (perms) break block23;
                switch (toWorld) {
                    case END: 
                    case NETHER: {
                        if (island.isRegionUnlocked(player, toWorld)) {
                            this.teleportPlayerToWorld(player, soundManager, island, spawnEnvironment, tick, toWorld);
                            break;
                        }
                        break block24;
                    }
                    default: {
                        IslandWorld toWorldF = toWorld;
                        Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, () -> PaperLib.teleportAsync((Entity)player, island.getLocation(toWorldF, spawnEnvironment)), 1L);
                        soundManager.playSound((CommandSender)player, XSound.ENTITY_ENDERMAN_TELEPORT);
                        player.setFallDistance(0.0f);
                        tick.setTick(1);
                        break;
                    }
                }
                break block24;
            }
            if (toWorld == IslandWorld.END) {
                player.setVelocity(player.getLocation().getDirection().multiply(-0.5).setY(0.6f));
            } else if (toWorld == IslandWorld.NETHER) {
                player.setVelocity(player.getLocation().getDirection().multiply(-0.5));
            }
        }
    }

    private void teleportPlayerToWorld(Player player, SoundManager soundManager, Island island, IslandEnvironment spawnEnvironment, Tick tick, IslandWorld toWorld) {
        Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, () -> {
            Location safeLoc;
            Location loc = island.getLocation(toWorld, spawnEnvironment);
            if (this.plugin.getConfiguration().getBoolean("Island.Teleport.SafetyCheck", true) && (safeLoc = LocationUtil.getSafeLocation(loc)) != null) {
                loc = safeLoc;
            }
            Location finalLoc = loc;
            PaperLib.teleportAsync((Entity)player, finalLoc);
        }, 1L);
        soundManager.playSound((CommandSender)player, XSound.ENTITY_ENDERMAN_TELEPORT);
        player.setFallDistance(0.0f);
        tick.setTick(1);
    }

    public static class Tick {
        private int tick = 1;
        private long last = System.currentTimeMillis() - 1001L;

        public int getTick() {
            if (System.currentTimeMillis() - this.last >= 1500L) {
                this.tick = 0;
            }
            return this.tick;
        }

        public void setTick(int tick) {
            this.tick = tick;
        }

        public long getLast() {
            return this.last;
        }

        public void setLast(long last) {
            this.last = last;
        }
    }
}

