/*
 * Decompiled with CFR 0.152.
 */
package com.craftaro.skyblock.listeners;

import com.craftaro.skyblock.SkyBlock;
import com.craftaro.skyblock.core.compatibility.MajorServerVersion;
import com.craftaro.skyblock.island.Island;
import com.craftaro.skyblock.island.IslandEnvironment;
import com.craftaro.skyblock.island.IslandManager;
import com.craftaro.skyblock.island.IslandRole;
import com.craftaro.skyblock.island.IslandStatus;
import com.craftaro.skyblock.island.IslandWorld;
import com.craftaro.skyblock.message.MessageManager;
import com.craftaro.skyblock.permission.PermissionManager;
import com.craftaro.skyblock.playerdata.PlayerData;
import com.craftaro.skyblock.playerdata.PlayerDataManager;
import com.craftaro.skyblock.sound.SoundManager;
import com.craftaro.skyblock.utils.world.LocationUtil;
import com.craftaro.skyblock.world.WorldManager;
import com.craftaro.third_party.com.cryptomorin.xseries.XSound;
import io.papermc.lib.PaperLib;
import java.util.Objects;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.attribute.Attribute;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;

public class MoveListeners
implements Listener {
    private final SkyBlock plugin;

    public MoveListeners(SkyBlock plugin) {
        this.plugin = plugin;
    }

    @EventHandler
    public void onPlayerMove(PlayerMoveEvent event) {
        Player player = event.getPlayer();
        Location from = event.getFrom();
        Location to = event.getTo();
        if (from.getBlockX() == to.getBlockX() && from.getBlockY() == to.getBlockY() && from.getBlockZ() == to.getBlockZ()) {
            return;
        }
        PlayerDataManager playerDataManager = this.plugin.getPlayerDataManager();
        MessageManager messageManager = this.plugin.getMessageManager();
        IslandManager islandManager = this.plugin.getIslandManager();
        PermissionManager permissionManager = this.plugin.getPermissionManager();
        SoundManager soundManager = this.plugin.getSoundManager();
        WorldManager worldManager = this.plugin.getWorldManager();
        if (!worldManager.isIslandWorld(player.getWorld())) {
            return;
        }
        IslandWorld world = worldManager.getIslandWorld(player.getWorld());
        if (!(world != IslandWorld.NETHER && world != IslandWorld.END || this.plugin.getConfiguration().getBoolean("Island.World." + world.getFriendlyName() + ".Enable"))) {
            Island island;
            PlayerData playerData;
            FileConfiguration configLoad = this.plugin.getLanguage();
            messageManager.sendMessage((CommandSender)player, configLoad.getString("Island.World.Message").replace(configLoad.getString("Island.World.Word." + world.getFriendlyName()), world.getFriendlyName()));
            if (playerDataManager.hasPlayerData(player) && (playerData = playerDataManager.getPlayerData(player)).getIsland() != null && (island = islandManager.getIsland(Bukkit.getServer().getOfflinePlayer(playerData.getIsland()))) != null) {
                this.teleportPlayerToIslandSpawn(player, soundManager, island);
                return;
            }
            LocationUtil.teleportPlayerToSpawn(player);
            soundManager.playSound((CommandSender)player, XSound.ENTITY_ENDERMAN_TELEPORT);
        }
        if (playerDataManager.hasPlayerData(player)) {
            Island island;
            PlayerData playerData = playerDataManager.getPlayerData(player);
            if (playerData.getIsland() != null && (island = islandManager.getIsland(Bukkit.getServer().getOfflinePlayer(playerData.getIsland()))) != null) {
                FileConfiguration configLoad;
                if (islandManager.isLocationAtIsland(island, to)) {
                    configLoad = this.plugin.getConfiguration();
                    boolean keepItemsOnDeath = configLoad.getBoolean("Island.Settings.KeepItemsOnDeath.Enable") ? permissionManager.hasPermission(island, "KeepItemsOnDeath", IslandRole.OWNER) : configLoad.getBoolean("Island.KeepItemsOnDeath.Enable");
                    if (configLoad.getBoolean("Island.World." + world.getFriendlyName() + ".Liquid.Enable")) {
                        StringBuilder stringBuilder = new StringBuilder();
                        if (to.getY() <= (double)configLoad.getInt(stringBuilder.append("Island.World.").append(world.getFriendlyName()).append(".Liquid.Height").toString())) {
                            if (keepItemsOnDeath && configLoad.getBoolean("Island.Liquid.Teleport.Enable")) {
                                player.setFallDistance(0.0f);
                                this.teleportPlayerToIslandSpawn(player, soundManager, island);
                            }
                            return;
                        }
                    }
                    if (configLoad.getBoolean("Island.Void.Teleport.Enable") && to.getY() <= (double)configLoad.getInt("Island.Void.Teleport.Offset")) {
                        if (configLoad.getBoolean("Island.Void.Teleport.ClearInventory")) {
                            player.getInventory().clear();
                            player.setLevel(0);
                            player.setExp(0.0f);
                            if (MajorServerVersion.isServerVersionAtLeast(MajorServerVersion.V1_9)) {
                                player.setHealth(Objects.requireNonNull(player.getAttribute(Attribute.GENERIC_MAX_HEALTH)).getValue());
                            } else {
                                player.setHealth(player.getMaxHealth());
                            }
                            player.setFoodLevel(20);
                            player.getActivePotionEffects().stream().map(PotionEffect::getType).forEach(arg_0 -> ((Player)player).removePotionEffect(arg_0));
                        }
                        player.setFallDistance(0.0f);
                        if (configLoad.getBoolean("Island.Void.Teleport.Island")) {
                            this.teleportPlayerToIslandSpawn(player, island);
                        } else {
                            LocationUtil.teleportPlayerToSpawn(player);
                        }
                        player.setFallDistance(0.0f);
                        soundManager.playSound((CommandSender)player, XSound.ENTITY_ENDERMAN_TELEPORT);
                    }
                } else if (!islandManager.isLocationAtIsland(island, to)) {
                    this.teleportPlayerToIslandSpawn(player, world, island);
                    configLoad = this.plugin.getConfiguration();
                    if (!configLoad.getBoolean("Island.Teleport.FallDamage", true)) {
                        player.setFallDistance(0.0f);
                    }
                    messageManager.sendMessage((CommandSender)player, this.plugin.getLanguage().getString("Island.WorldBorder.Outside.Message"));
                    soundManager.playSound((CommandSender)player, XSound.ENTITY_ENDERMAN_TELEPORT);
                }
                return;
            }
            Location playerLoc = player.getLocation();
            Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.plugin, () -> {
                islandManager.loadIslandAtLocation(playerLoc);
                Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> {
                    Island loadedIsland = islandManager.getIslandAtLocation(playerLoc);
                    if (loadedIsland != null) {
                        if (player.hasPermission("fabledskyblock.bypass")) {
                            playerData.setIsland(loadedIsland.getOwnerUUID());
                            return;
                        }
                        if (loadedIsland.getStatus() == IslandStatus.OPEN || loadedIsland.getStatus() == IslandStatus.WHITELISTED && loadedIsland.isPlayerWhitelisted(player)) {
                            loadedIsland.getVisit().addVisitor(player.getUniqueId());
                            return;
                        }
                    }
                    LocationUtil.teleportPlayerToSpawn(player);
                    messageManager.sendMessage((CommandSender)player, this.plugin.getLanguage().getString("Island.WorldBorder.Disappeared.Message"));
                    soundManager.playSound((CommandSender)player, XSound.ENTITY_ENDERMAN_TELEPORT);
                });
            });
        }
    }

    private void teleportPlayerToIslandSpawn(Player player, IslandWorld world, Island island) {
        Location finalLoc;
        Location loc = null;
        if (island.hasRole(IslandRole.MEMBER, player.getUniqueId()) || island.hasRole(IslandRole.OPERATOR, player.getUniqueId()) || island.hasRole(IslandRole.OWNER, player.getUniqueId())) {
            if (player.getGameMode() != GameMode.CREATIVE && player.getGameMode() != GameMode.SPECTATOR) {
                Location safeLoc;
                if (this.plugin.getConfiguration().getBoolean("Island.Teleport.SafetyCheck", true) && (safeLoc = LocationUtil.getSafeLocation(island.getLocation(world, IslandEnvironment.MAIN))) != null) {
                    loc = safeLoc;
                }
            } else {
                loc = island.getLocation(world, IslandEnvironment.MAIN);
                if (this.plugin.getConfiguration().getBoolean("Island.Teleport.RemoveWater", false)) {
                    LocationUtil.removeWaterFromLoc(loc);
                }
            }
        } else if (player.getGameMode() != GameMode.CREATIVE && player.getGameMode() != GameMode.SPECTATOR) {
            Location safeLoc;
            Location isLoc;
            if (this.plugin.getConfiguration().getBoolean("Island.Teleport.SafetyCheck", true) && (isLoc = island.getLocation(world, IslandEnvironment.VISITOR)) != null && (safeLoc = LocationUtil.getSafeLocation(isLoc)) != null) {
                loc = safeLoc;
            }
        } else {
            loc = island.getLocation(world, IslandEnvironment.VISITOR);
        }
        if ((finalLoc = loc) != null) {
            PaperLib.teleportAsync((Entity)player, finalLoc);
        } else {
            LocationUtil.teleportPlayerToSpawn(player);
            player.sendMessage(this.plugin.formatText(this.plugin.getLanguage().getString("Command.Island.Teleport.Unsafe.Message")));
        }
    }

    private void teleportPlayerToIslandSpawn(Player player, Island island) {
        this.teleportPlayerToIslandSpawn(player, IslandWorld.NORMAL, island);
    }

    private void teleportPlayerToIslandSpawn(Player player, SoundManager soundManager, Island island) {
        this.teleportPlayerToIslandSpawn(player, island);
        FileConfiguration configLoad = this.plugin.getConfiguration();
        if (!configLoad.getBoolean("Island.Teleport.FallDamage", true)) {
            player.setFallDistance(0.0f);
        }
        soundManager.playSound((CommandSender)player, XSound.ENTITY_ENDERMAN_TELEPORT);
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onTeleport(PlayerTeleportEvent e) {
        Player player = e.getPlayer();
        WorldManager worldManager = this.plugin.getWorldManager();
        if (e.getTo() != null && e.getTo().getWorld() != null) {
            if (Bukkit.isPrimaryThread()) {
                e.getTo().getWorld().loadChunk(e.getTo().getChunk());
            }
            if (worldManager.isIslandWorld(e.getTo().getWorld()) && (!e.getTo().getWorld().equals((Object)e.getFrom().getWorld()) || e.getTo().distance(e.getFrom()) > 1.0) && this.plugin.getIslandManager().getIslandAtLocation(e.getTo()) == null) {
                e.setCancelled(true);
                this.plugin.getMessageManager().sendMessage((CommandSender)player, this.plugin.getLanguage().getString("Island.WorldBorder.Disappeared.Message"));
                this.plugin.getSoundManager().playSound((CommandSender)player, XSound.ENTITY_ENDERMAN_TELEPORT);
            }
        }
    }
}

