/*
 * Decompiled with CFR 0.152.
 */
package com.craftaro.skyblock.listeners;

import com.craftaro.skyblock.SkyBlock;
import com.craftaro.skyblock.core.compatibility.CompatibleMaterial;
import com.craftaro.skyblock.core.compatibility.MajorServerVersion;
import com.craftaro.skyblock.island.Island;
import com.craftaro.skyblock.island.IslandManager;
import com.craftaro.skyblock.island.IslandRole;
import com.craftaro.skyblock.island.IslandWorld;
import com.craftaro.skyblock.permission.PermissionManager;
import com.craftaro.skyblock.upgrade.Upgrade;
import com.craftaro.skyblock.utils.world.LocationUtil;
import com.craftaro.skyblock.world.WorldManager;
import com.craftaro.third_party.com.cryptomorin.xseries.XMaterial;
import java.lang.reflect.InvocationTargetException;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.block.data.Ageable;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockGrowEvent;
import org.bukkit.event.block.BlockSpreadEvent;
import org.bukkit.event.block.LeavesDecayEvent;
import org.bukkit.event.world.StructureGrowEvent;
import org.bukkit.material.Crops;
import org.bukkit.plugin.Plugin;

public class GrowListeners
implements Listener {
    private final SkyBlock plugin;

    public GrowListeners(SkyBlock plugin) {
        this.plugin = plugin;
    }

    @EventHandler(ignoreCancelled=true)
    public void onStructureGrow(StructureGrowEvent event) {
        WorldManager worldManager = this.plugin.getWorldManager();
        if (!worldManager.isIslandWorld(event.getWorld())) {
            return;
        }
        IslandManager islandManager = this.plugin.getIslandManager();
        Island origin = islandManager.getIslandAtLocation(event.getLocation());
        Iterator it = event.getBlocks().iterator();
        while (it.hasNext()) {
            BlockState state = (BlockState)it.next();
            Island growingTo = islandManager.getIslandAtLocation(state.getLocation());
            if (origin == null && growingTo == null) continue;
            if (origin != null && !origin.isInBorder(state.getLocation())) {
                it.remove();
                continue;
            }
            if (origin == null || growingTo == null) {
                it.remove();
                continue;
            }
            if (origin.getIslandUUID().equals(growingTo.getIslandUUID())) continue;
            it.remove();
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onCropUpgrade(BlockGrowEvent event) {
        Block block = event.getBlock();
        WorldManager worldManager = this.plugin.getWorldManager();
        if (!this.plugin.getWorldManager().isIslandWorld(block.getWorld())) {
            return;
        }
        IslandManager islandManager = this.plugin.getIslandManager();
        Island island = islandManager.getIslandAtLocation(block.getLocation());
        if (island == null) {
            return;
        }
        IslandWorld world = worldManager.getIslandWorld(block.getWorld());
        if (LocationUtil.isLocationAffectingIslandSpawn(block.getLocation(), island, world) && this.plugin.getConfiguration().getBoolean("Island.Spawn.Protection")) {
            event.setCancelled(true);
            return;
        }
        List<Upgrade> upgrades = this.plugin.getUpgradeManager().getUpgrades(Upgrade.Type.CROP);
        if (upgrades == null || upgrades.isEmpty() || !upgrades.get(0).isEnabled() || !island.isUpgrade(Upgrade.Type.CROP)) {
            return;
        }
        if (MajorServerVersion.isServerVersionAbove(MajorServerVersion.V1_12)) {
            try {
                Object blockData = block.getClass().getMethod("getBlockData", new Class[0]).invoke((Object)block, new Object[0]);
                if (blockData instanceof Ageable) {
                    Ageable ageable = (Ageable)blockData;
                    ageable.setAge(ageable.getAge() + 1);
                    block.getClass().getMethod("setBlockData", Class.forName("org.bukkit.block.data.BlockData")).invoke((Object)block, ageable);
                }
            }
            catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException ex) {
                ex.printStackTrace();
            }
        } else {
            Optional<XMaterial> type = CompatibleMaterial.getMaterial(block.getType());
            if (block.getState().getData() instanceof Crops || type.get().name().equals("BEETROOT_BLOCK") || type.get().name().equals("CARROT") || type.get().name().equals("POTATO") || type.get().name().equals("WHEAT") || type.get().name().equals("CROPS")) {
                try {
                    block.getClass().getMethod("setData", Byte.TYPE).invoke((Object)block, (byte)(block.getData() + 1));
                }
                catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException ex) {
                    ex.printStackTrace();
                }
            }
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onBlockGrow(BlockGrowEvent event) {
        BlockState state;
        WorldManager worldManager = this.plugin.getWorldManager();
        if (!worldManager.isIslandWorld((state = event.getNewState()).getWorld())) {
            return;
        }
        IslandManager islandManager = this.plugin.getIslandManager();
        Island origin = islandManager.getIslandAtLocation(event.getBlock().getLocation());
        Island growingTo = islandManager.getIslandAtLocation(state.getLocation());
        if (origin == null && growingTo == null) {
            return;
        }
        if (origin == null || growingTo == null || !origin.getIslandUUID().equals(growingTo.getIslandUUID())) {
            event.setCancelled(true);
            return;
        }
        Material type = state.getType();
        Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, () -> {
            if (state.getBlock().getType() == type) {
                growingTo.getLevel().addMaterial(type.name(), 1L);
            }
        }, 1L);
    }

    @EventHandler(ignoreCancelled=true)
    public void onStructureCreate(StructureGrowEvent event) {
        if (!this.plugin.getConfiguration().getBoolean("Island.Spawn.Protection")) {
            return;
        }
        List blocks = event.getBlocks();
        if (blocks.isEmpty()) {
            return;
        }
        WorldManager worldManager = this.plugin.getWorldManager();
        IslandManager islandManager = this.plugin.getIslandManager();
        Island island = islandManager.getIslandAtLocation(event.getLocation());
        if (island == null) {
            return;
        }
        IslandWorld world = worldManager.getIslandWorld(((BlockState)blocks.get(0)).getWorld());
        for (BlockState block : event.getBlocks()) {
            if (!LocationUtil.isLocationAffectingIslandSpawn(block.getLocation(), island, world)) continue;
            event.setCancelled(true);
            return;
        }
    }

    @EventHandler
    public void onFireSpread(BlockSpreadEvent event) {
        if (event.getSource().getType() != Material.FIRE) {
            return;
        }
        Block block = event.getBlock();
        if (!this.plugin.getWorldManager().isIslandWorld(block.getWorld())) {
            return;
        }
        PermissionManager permissionManager = this.plugin.getPermissionManager();
        if (!permissionManager.hasPermission(block.getLocation(), "FireSpread", IslandRole.OWNER)) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onLeavesDecay(LeavesDecayEvent event) {
        Block block = event.getBlock();
        if (!this.plugin.getWorldManager().isIslandWorld(block.getWorld())) {
            return;
        }
        PermissionManager permissionManager = this.plugin.getPermissionManager();
        if (!permissionManager.hasPermission(block.getLocation(), "LeafDecay", IslandRole.OWNER)) {
            event.setCancelled(true);
        }
    }
}

