/*
 * Decompiled with CFR 0.152.
 */
package com.craftaro.skyblock.listeners;

import com.craftaro.skyblock.SkyBlock;
import com.craftaro.skyblock.core.compatibility.CompatibleMaterial;
import com.craftaro.skyblock.core.compatibility.MajorServerVersion;
import com.craftaro.skyblock.island.Island;
import com.craftaro.skyblock.island.IslandLevel;
import com.craftaro.skyblock.island.IslandManager;
import com.craftaro.skyblock.world.WorldManager;
import com.craftaro.third_party.com.cryptomorin.xseries.XMaterial;
import java.lang.reflect.InvocationTargetException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Optional;
import java.util.Set;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.FallingBlock;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityChangeBlockEvent;
import org.bukkit.plugin.Plugin;

public class FallBreakListeners
implements Listener {
    private final SkyBlock plugin;
    private final Set<FallingBlock> fallingBlocks;

    public FallBreakListeners(SkyBlock plugin) {
        this.plugin = plugin;
        this.fallingBlocks = new HashSet<FallingBlock>();
        Bukkit.getScheduler().runTaskTimer((Plugin)plugin, () -> {
            if (!this.fallingBlocks.isEmpty()) {
                int counter = 0;
                IslandManager islandManager = plugin.getIslandManager();
                WorldManager worldManager = plugin.getWorldManager();
                FileConfiguration configLoad = plugin.getConfiguration();
                Iterator<FallingBlock> iterator = this.fallingBlocks.iterator();
                while (iterator.hasNext()) {
                    FallingBlock ent = iterator.next();
                    if (ent.isDead()) {
                        Island island;
                        if (worldManager.isIslandWorld(ent.getLocation().getWorld()) && configLoad.getBoolean("Island.Block.Level.Enable") && (island = islandManager.getIslandAtLocation(ent.getLocation())) != null) {
                            IslandLevel level;
                            Optional<Object> material = Optional.empty();
                            if (MajorServerVersion.isServerVersionAtLeast(MajorServerVersion.V1_13)) {
                                material = CompatibleMaterial.getMaterial(ent.getBlockData().getMaterial());
                            } else {
                                try {
                                    material = CompatibleMaterial.getMaterial((Material)ent.getClass().getMethod("getMaterial", new Class[0]).invoke((Object)ent, new Object[0]));
                                }
                                catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException ex) {
                                    ex.printStackTrace();
                                }
                            }
                            if (material.isPresent() && (level = island.getLevel()).hasMaterial(((XMaterial)material.get()).name())) {
                                long materialAmount = level.getMaterialAmount(((XMaterial)material.get()).name());
                                if (materialAmount <= 1L) {
                                    level.removeMaterial(((XMaterial)material.get()).name());
                                } else {
                                    level.setMaterialAmount(((XMaterial)material.get()).name(), materialAmount - 1L);
                                }
                            }
                        }
                        iterator.remove();
                    }
                    if (++counter <= 50) continue;
                    break;
                }
            }
        }, 2L, 2L);
    }

    @EventHandler
    public void onFallingBlockModify(EntityChangeBlockEvent event) {
        WorldManager worldManager;
        if (event.getEntity() instanceof FallingBlock && (worldManager = this.plugin.getWorldManager()).isIslandWorld(event.getEntity().getLocation().getWorld())) {
            if (!CompatibleMaterial.isAir(CompatibleMaterial.getMaterial(event.getTo()).orElse(XMaterial.STONE))) {
                this.fallingBlocks.remove(event.getEntity());
            } else if (!event.isCancelled()) {
                this.fallingBlocks.add((FallingBlock)event.getEntity());
            }
        }
    }
}

