/*
 * Decompiled with CFR 0.152.
 */
package com.craftaro.skyblock.listeners;

import com.craftaro.skyblock.SkyBlock;
import com.craftaro.skyblock.core.compatibility.CompatibleMaterial;
import com.craftaro.skyblock.core.compatibility.MajorServerVersion;
import com.craftaro.skyblock.island.Island;
import com.craftaro.skyblock.island.IslandEnvironment;
import com.craftaro.skyblock.island.IslandLevel;
import com.craftaro.skyblock.island.IslandManager;
import com.craftaro.skyblock.island.IslandWorld;
import com.craftaro.skyblock.limit.impl.EntityLimitation;
import com.craftaro.skyblock.stackable.Stackable;
import com.craftaro.skyblock.stackable.StackableManager;
import com.craftaro.skyblock.upgrade.Upgrade;
import com.craftaro.skyblock.utils.world.LocationUtil;
import com.craftaro.skyblock.world.WorldManager;
import com.craftaro.third_party.com.cryptomorin.xseries.XBlock;
import com.craftaro.third_party.com.cryptomorin.xseries.XMaterial;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Arrow;
import org.bukkit.entity.Blaze;
import org.bukkit.entity.Donkey;
import org.bukkit.entity.ElderGuardian;
import org.bukkit.entity.EnderSignal;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Evoker;
import org.bukkit.entity.FallingBlock;
import org.bukkit.entity.Hanging;
import org.bukkit.entity.Horse;
import org.bukkit.entity.Illager;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Llama;
import org.bukkit.entity.Mule;
import org.bukkit.entity.Pig;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.entity.Ravager;
import org.bukkit.entity.Steerable;
import org.bukkit.event.Cancellable;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.EntityChangeBlockEvent;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.event.entity.EntityExplodeEvent;
import org.bukkit.event.entity.EntitySpawnEvent;
import org.bukkit.event.entity.EntityTameEvent;
import org.bukkit.event.entity.EntityTargetEvent;
import org.bukkit.event.entity.EntityTargetLivingEntityEvent;
import org.bukkit.event.hanging.HangingBreakByEntityEvent;
import org.bukkit.event.hanging.HangingBreakEvent;
import org.bukkit.event.hanging.HangingPlaceEvent;
import org.bukkit.event.player.PlayerArmorStandManipulateEvent;
import org.bukkit.event.player.PlayerShearEntityEvent;
import org.bukkit.event.vehicle.VehicleDamageEvent;
import org.bukkit.event.vehicle.VehicleDestroyEvent;
import org.bukkit.inventory.EntityEquipment;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class EntityListeners
implements Listener {
    private final SkyBlock plugin;
    private final Set<UUID> preventFireTicks = new HashSet<UUID>();
    private static final Set<CreatureSpawnEvent.SpawnReason> CHECKED_REASONS = EnumSet.of(CreatureSpawnEvent.SpawnReason.NATURAL, CreatureSpawnEvent.SpawnReason.JOCKEY, CreatureSpawnEvent.SpawnReason.MOUNT);

    public EntityListeners(SkyBlock plugin) {
        this.plugin = plugin;
    }

    @EventHandler(ignoreCancelled=true)
    public void onFireWorkBoom(EntityDamageByEntityEvent event) {
        if (event.getDamager().getType() == EntityType.FIREWORK && this.plugin.getWorldManager().isIslandWorld(event.getEntity().getWorld())) {
            event.setCancelled(true);
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onEntityDamage(EntityDamageEvent event) {
        IslandManager islandManager = this.plugin.getIslandManager();
        if (event.getEntity() instanceof Blaze) {
            WorldManager worldManager = this.plugin.getWorldManager();
            FileConfiguration configLoad = this.plugin.getConfiguration();
            if (configLoad.getBoolean("Island.Nether.BlazeImmuneToWaterInNether", false) && worldManager.getIslandWorld(event.getEntity().getWorld()) == IslandWorld.NETHER && event.getCause() == EntityDamageEvent.DamageCause.DROWNING) {
                event.setCancelled(true);
            }
        } else if (event.getEntity() instanceof Player) {
            Player player = (Player)event.getEntity();
            if (this.plugin.getWorldManager().isIslandWorld(player.getWorld())) {
                this.plugin.getPermissionManager().processPermission((Cancellable)event, player, islandManager.getIslandAtLocation(player.getLocation()));
            }
            if (this.preventFireTicks.contains(player.getUniqueId()) && event.getCause() == EntityDamageEvent.DamageCause.FIRE_TICK) {
                player.setFireTicks(0);
                event.setCancelled(true);
            }
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onEntityDamageByEntity(EntityDamageByEntityEvent event) {
        IslandManager islandManager = this.plugin.getIslandManager();
        FileConfiguration configLoad = this.plugin.getConfiguration();
        Entity victim = event.getEntity();
        Island island = islandManager.getIslandAtLocation(victim.getLocation());
        if (island != null) {
            Entity attacker = event.getDamager();
            if (attacker instanceof Projectile && ((Projectile)attacker).getShooter() instanceof Entity) {
                attacker = (Entity)((Projectile)attacker).getShooter();
            }
            if (victim instanceof Player && attacker instanceof Player) {
                if (configLoad.getBoolean("Island.Entity_Damage.PVP")) {
                    if (this.plugin.getPermissionManager().processPermission((Cancellable)event, (Player)attacker, island)) {
                        this.plugin.getPermissionManager().processPermission((Cancellable)event, (Player)victim, island);
                    }
                } else {
                    event.setCancelled(true);
                }
            } else if (victim instanceof Player) {
                if (configLoad.getBoolean("Island.Entity_Damage.EVP")) {
                    this.plugin.getPermissionManager().processPermission((Cancellable)event, (Player)victim, island, true);
                }
            } else if (attacker instanceof Player) {
                if (configLoad.getBoolean("Island.Entity_Damage.PVE")) {
                    this.plugin.getPermissionManager().processPermission((Cancellable)event, (Player)attacker, island);
                }
            } else if (configLoad.getBoolean("Island.Entity_Damage.PVE")) {
                this.plugin.getPermissionManager().processPermission((Cancellable)event, island);
            }
            if (event.isCancelled() && event.getDamager() instanceof Arrow && event.getDamager().getFireTicks() != 0) {
                this.preventFireTicks.add(event.getEntity().getUniqueId());
                Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, () -> this.preventFireTicks.remove(victim.getUniqueId()), 5L);
            }
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onPlayerShearEntity(PlayerShearEntityEvent event) {
        Player player = event.getPlayer();
        if (this.plugin.getWorldManager().isIslandWorld(player.getWorld())) {
            IslandManager islandManager = this.plugin.getIslandManager();
            Island island = islandManager.getIslandAtLocation(event.getEntity().getLocation());
            this.plugin.getPermissionManager().processPermission((Cancellable)event, player, island);
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onEntityTarget(EntityTargetEvent event) {
        Entity entity = event.getEntity();
        WorldManager worldManager = this.plugin.getWorldManager();
        if (!worldManager.isIslandWorld(entity.getWorld())) {
            return;
        }
        Entity target = event.getTarget();
        if (target == null) {
            return;
        }
        IslandManager islandManager = this.plugin.getIslandManager();
        Island entityIsland = islandManager.getIslandAtLocation(entity.getLocation());
        Island targetIsland = islandManager.getIslandAtLocation(target.getLocation());
        if (entityIsland == null && targetIsland == null) {
            return;
        }
        if (entityIsland == null || targetIsland == null) {
            event.setCancelled(true);
            return;
        }
        if (!entityIsland.getIslandUUID().equals(targetIsland.getIslandUUID())) {
            event.setCancelled(true);
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onStackableInteract(PlayerArmorStandManipulateEvent event) {
        Player player = event.getPlayer();
        if (!this.plugin.getWorldManager().isIslandWorld(player.getWorld())) {
            return;
        }
        IslandManager islandManager = this.plugin.getIslandManager();
        if (!this.plugin.getPermissionManager().processPermission((Cancellable)event, player, islandManager.getIslandAtLocation(event.getRightClicked().getLocation()))) {
            return;
        }
        if (MajorServerVersion.isServerVersion(MajorServerVersion.V1_8)) {
            return;
        }
        StackableManager stackableManager = ((SkyBlock)SkyBlock.getPlugin(SkyBlock.class)).getStackableManager();
        if (stackableManager == null) {
            return;
        }
        ArmorStand armorStand = event.getRightClicked();
        for (Location stackLocation : stackableManager.getStacks().keySet()) {
            if (!stackLocation.getWorld().equals((Object)armorStand.getWorld()) || !(armorStand.getLocation().distanceSquared(stackLocation) <= 1.5)) continue;
            event.setCancelled(true);
            return;
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onHangingPlace(HangingPlaceEvent event) {
        Player player = event.getPlayer();
        if (player != null) {
            if (!this.plugin.getWorldManager().isIslandWorld(player.getWorld())) {
                return;
            }
            IslandManager islandManager = this.plugin.getIslandManager();
            this.plugin.getPermissionManager().processPermission((Cancellable)event, player, islandManager.getIslandAtLocation(event.getEntity().getLocation()));
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onHangingBreak(HangingBreakEvent event) {
        Hanging hanging = event.getEntity();
        if (!this.plugin.getWorldManager().isIslandWorld(hanging.getWorld())) {
            return;
        }
        IslandManager islandManager = this.plugin.getIslandManager();
        this.plugin.getPermissionManager().processPermission((Cancellable)event, null, islandManager.getIslandAtLocation(hanging.getLocation()));
    }

    @EventHandler(ignoreCancelled=true)
    public void onHangingBreak(HangingBreakByEntityEvent event) {
        Hanging hanging = event.getEntity();
        if (!this.plugin.getWorldManager().isIslandWorld(hanging.getWorld())) {
            return;
        }
        IslandManager islandManager = this.plugin.getIslandManager();
        Player p = null;
        if (event.getRemover() instanceof Player) {
            p = (Player)event.getRemover();
        }
        this.plugin.getPermissionManager().processPermission((Cancellable)event, p, islandManager.getIslandAtLocation(hanging.getLocation()));
    }

    @EventHandler(ignoreCancelled=true)
    public void onEntityTaming(EntityTameEvent event) {
        if (!(event.getOwner() instanceof Player)) {
            return;
        }
        LivingEntity entity = event.getEntity();
        if (!this.plugin.getWorldManager().isIslandWorld(entity.getWorld())) {
            return;
        }
        IslandManager islandManager = this.plugin.getIslandManager();
        this.plugin.getPermissionManager().processPermission((Cancellable)event, (Player)event.getOwner(), islandManager.getIslandAtLocation(entity.getLocation()));
    }

    @EventHandler(ignoreCancelled=true)
    public void onEntityChangeBlock(EntityChangeBlockEvent event) {
        Optional<XMaterial> materials;
        Entity entity = event.getEntity();
        if (entity instanceof Player) {
            return;
        }
        IslandManager islandManager = this.plugin.getIslandManager();
        WorldManager worldManager = this.plugin.getWorldManager();
        Island island = islandManager.getIslandAtLocation(event.getBlock().getLocation());
        if (island == null || !this.plugin.getWorldManager().isIslandWorld(entity.getWorld())) {
            return;
        }
        if (event.isCancelled()) {
            return;
        }
        FileConfiguration configLoad = this.plugin.getConfiguration();
        IslandWorld world = worldManager.getIslandWorld(event.getBlock().getWorld());
        Block block = event.getBlock();
        if ((LocationUtil.isLocationLocation(block.getLocation(), island.getLocation(world, IslandEnvironment.MAIN).clone().subtract(0.0, 1.0, 0.0)) || LocationUtil.isLocationLocation(block.getLocation(), island.getLocation(world, IslandEnvironment.VISITOR).clone().subtract(0.0, 1.0, 0.0))) && this.plugin.getConfiguration().getBoolean("Island.Spawn.Protection")) {
            Optional<XMaterial> material = CompatibleMaterial.getMaterial(block.getType());
            Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, () -> {
                event.getEntity().remove();
                XBlock.setType((Block)event.getBlock(), (XMaterial)((XMaterial)material.get()));
            }, 1L);
            return;
        }
        if (event.getEntityType() == EntityType.FALLING_BLOCK && LocationUtil.isLocationAffectingIslandSpawn(block.getLocation(), island, world) && configLoad.getBoolean("Island.Spawn.Protection")) {
            FallingBlock fallingBlock = (FallingBlock)event.getEntity();
            if (fallingBlock.getDropItem()) {
                if (MajorServerVersion.isServerVersionAtLeast(MajorServerVersion.V1_13)) {
                    fallingBlock.getWorld().dropItemNaturally(fallingBlock.getLocation(), new ItemStack(fallingBlock.getBlockData().getMaterial(), 1));
                } else {
                    try {
                        Method getBlockDataMethod = FallingBlock.class.getMethod("getBlockData", new Class[0]);
                        byte data = (Byte)getBlockDataMethod.invoke((Object)fallingBlock, new Object[0]);
                        if (fallingBlock.getMaterial().name().endsWith("ANVIL")) {
                            data = (byte)Math.ceil((double)data / 4.0);
                        }
                        fallingBlock.getWorld().dropItemNaturally(fallingBlock.getLocation(), new ItemStack(fallingBlock.getMaterial(), 1, (short)data));
                    }
                    catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException ex) {
                        ex.printStackTrace();
                    }
                }
            }
            event.setCancelled(true);
        }
        if (entity instanceof FallingBlock) {
            return;
        }
        if (LocationUtil.isLocationAffectingIslandSpawn(block.getLocation(), island, world) && this.plugin.getConfiguration().getBoolean("Island.Spawn.Protection")) {
            event.setCancelled(true);
            return;
        }
        this.plugin.getPermissionManager().processPermission((Cancellable)event, null, island);
        if (!this.plugin.getConfiguration().getBoolean("Island.Block.Level.Enable")) {
            return;
        }
        this.removeBlockFromLevel(island, block);
        if (event.getTo() != Material.AIR && (materials = CompatibleMaterial.getMaterial(event.getTo())).isPresent()) {
            long materialAmount = 0L;
            IslandLevel level = island.getLevel();
            if (level.hasMaterial(materials.get().name())) {
                materialAmount = level.getMaterialAmount(materials.get().name());
            }
            level.setMaterialAmount(materials.get().name(), materialAmount + 1L);
        }
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.LOW)
    public void onEntityExplode(EntityExplodeEvent event) {
        Entity entity = event.getEntity();
        WorldManager worldManager = this.plugin.getWorldManager();
        IslandManager islandManager = this.plugin.getIslandManager();
        if (this.plugin.getWorldManager().isIslandWorld(entity.getWorld())) {
            Island island = islandManager.getIslandAtLocation(entity.getLocation());
            this.plugin.getPermissionManager().processPermission((Cancellable)event, null, island);
            if (!event.isCancelled() && island != null) {
                StackableManager stackableManager = this.plugin.getStackableManager();
                Iterator it = event.blockList().iterator();
                while (it.hasNext()) {
                    Stackable stackable;
                    boolean removed = false;
                    Block block = (Block)it.next();
                    if (((SkyBlock)SkyBlock.getPlugin(SkyBlock.class)).getConfiguration().getBoolean("Island.Spawn.Protection")) {
                        IslandWorld world = worldManager.getIslandWorld(event.getEntity().getWorld());
                        if (LocationUtil.isLocationLocation(block.getLocation(), island.getLocation(world, IslandEnvironment.MAIN).clone().subtract(0.0, 1.0, 0.0))) {
                            it.remove();
                            removed = true;
                        }
                    }
                    Location blockLocation = block.getLocation();
                    if (stackableManager != null && stackableManager.isStacked(blockLocation) && (stackable = stackableManager.getStack(block.getLocation(), CompatibleMaterial.getMaterial(block.getType()).get())) != null) {
                        FileConfiguration configLoad;
                        Optional<XMaterial> material = CompatibleMaterial.getMaterial(block.getType());
                        byte data = block.getData();
                        int removedAmount = (int)(Math.random() * (double)Math.min(64, stackable.getSize() - 1));
                        stackable.take(removedAmount);
                        Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> block.getWorld().dropItemNaturally(blockLocation.clone().add(0.5, 1.0, 0.5), new ItemStack(((XMaterial)material.get()).parseMaterial(), (int)(Math.random() * (double)removedAmount), (short)data)));
                        if (stackable.getSize() <= 1) {
                            stackableManager.removeStack(stackable);
                        }
                        if ((configLoad = this.plugin.getConfiguration()).getBoolean("Island.Block.Level.Enable")) {
                            this.removeBlockFromLevel(island, block);
                        }
                        it.remove();
                        if (!removed) {
                            removed = true;
                        }
                    }
                    if (!this.plugin.getConfiguration().getBoolean("Island.Block.Level.Enable") || removed) continue;
                    this.removeBlockFromLevel(island, block);
                }
            }
        }
    }

    private void removeBlockFromLevel(Island island, XMaterial material) {
        if (material == null) {
            return;
        }
        IslandLevel level = island.getLevel();
        if (level.hasMaterial(material.name())) {
            long materialAmount = level.getMaterialAmount(material.name());
            if (materialAmount - 1L <= 0L) {
                level.removeMaterial(material.name());
            } else {
                level.setMaterialAmount(material.name(), materialAmount - 1L);
            }
        }
    }

    private void removeBlockFromLevel(Island island, Block block) {
        this.removeBlockFromLevel(island, CompatibleMaterial.getMaterial(block.getType()).get());
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.MONITOR)
    public void onEntityDeath(EntityDeathEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player || livingEntity instanceof ArmorStand || livingEntity instanceof Horse) {
            return;
        }
        if (MajorServerVersion.isServerVersionAtLeast(MajorServerVersion.V1_10) && (livingEntity instanceof Donkey || livingEntity instanceof Mule || livingEntity instanceof ElderGuardian)) {
            return;
        }
        if (MajorServerVersion.isServerVersionAtLeast(MajorServerVersion.V1_11) && livingEntity instanceof Evoker) {
            return;
        }
        if (MajorServerVersion.isServerVersionAtLeast(MajorServerVersion.V1_12) && livingEntity instanceof Llama) {
            return;
        }
        if (MajorServerVersion.isServerVersionAtLeast(MajorServerVersion.V1_14) && (livingEntity instanceof Ravager || livingEntity instanceof Illager)) {
            return;
        }
        if (livingEntity.hasMetadata("SkyBlock")) {
            return;
        }
        IslandManager islandManager = this.plugin.getIslandManager();
        if (!this.plugin.getWorldManager().isIslandWorld(livingEntity.getWorld())) {
            return;
        }
        Island island = islandManager.getIslandAtLocation(livingEntity.getLocation());
        if (island == null) {
            return;
        }
        List<Upgrade> upgrades = this.plugin.getUpgradeManager().getUpgrades(Upgrade.Type.DROPS);
        if (upgrades != null && !upgrades.isEmpty() && upgrades.get(0).isEnabled() && island.isUpgrade(Upgrade.Type.DROPS)) {
            HashSet<ItemStack> dontMultiply = new HashSet<ItemStack>();
            if (MajorServerVersion.isServerVersionAbove(MajorServerVersion.V1_8)) {
                Pig pig;
                EntityEquipment equipment = livingEntity.getEquipment();
                if (equipment != null) {
                    for (ItemStack item : event.getDrops()) {
                        if (!item.isSimilar(equipment.getHelmet()) && !item.isSimilar(equipment.getChestplate()) && !item.isSimilar(equipment.getLeggings()) && !item.isSimilar(equipment.getBoots()) && !item.isSimilar(equipment.getItemInMainHand()) && !item.isSimilar(equipment.getItemInOffHand())) continue;
                        dontMultiply.add(item);
                    }
                }
                if (MajorServerVersion.isServerVersionAtLeast(MajorServerVersion.V1_16)) {
                    Steerable steerable;
                    if (livingEntity instanceof Steerable && (steerable = (Steerable)livingEntity).hasSaddle()) {
                        dontMultiply.add(new ItemStack(XMaterial.SADDLE.parseMaterial(), 1));
                    }
                } else if (livingEntity instanceof Pig && (pig = (Pig)livingEntity).hasSaddle()) {
                    dontMultiply.add(new ItemStack(XMaterial.SADDLE.parseMaterial(), 1));
                }
            }
            for (ItemStack item : event.getDrops()) {
                boolean shouldDrop = true;
                for (ItemStack dontMultiplyItem : dontMultiply) {
                    if (!item.isSimilar(dontMultiplyItem)) continue;
                    shouldDrop = false;
                    break;
                }
                if (!shouldDrop) continue;
                livingEntity.getWorld().dropItemNaturally(livingEntity.getLocation(), item);
            }
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onEntityTargetLivingEntity(EntityTargetLivingEntityEvent event) {
        if (!(event.getTarget() instanceof Player)) {
            return;
        }
        Player player = (Player)event.getTarget();
        if (!this.plugin.getWorldManager().isIslandWorld(player.getWorld())) {
            return;
        }
        IslandManager islandManager = this.plugin.getIslandManager();
        this.plugin.getPermissionManager().processPermission((Cancellable)event, player, islandManager.getIslandAtLocation(event.getEntity().getLocation()));
    }

    @EventHandler(ignoreCancelled=true)
    public void onCreatureSpawn(CreatureSpawnEvent event) {
        CreatureSpawnEvent.SpawnReason spawnReason;
        EntityType type;
        LivingEntity entity = event.getEntity();
        if (entity instanceof ArmorStand) {
            return;
        }
        Location entityLocation = entity.getLocation();
        Island island = this.plugin.getIslandManager().getIslandAtLocation(entityLocation);
        if (island == null) {
            return;
        }
        EntityLimitation limits = this.plugin.getLimitationHandler().getInstance(EntityLimitation.class);
        if (limits.isBeingTracked(type = entity.getType())) {
            long count;
            FileConfiguration configLoad = this.plugin.getConfiguration();
            boolean isSplit = event.getSpawnReason() == CreatureSpawnEvent.SpawnReason.SLIME_SPLIT;
            boolean splitBypass = configLoad.getBoolean("Island.Challenge.PerIsland", true);
            if (!(isSplit && splitBypass || !limits.hasTooMuch((count = limits.getEntityCount(island, this.plugin.getWorldManager().getIslandWorld(entityLocation.getWorld()), type)) + 1L, type))) {
                entity.remove();
                event.setCancelled(true);
                return;
            }
        }
        if (!CHECKED_REASONS.contains(spawnReason = event.getSpawnReason())) {
            return;
        }
        if (!this.plugin.getWorldManager().isIslandWorld(entity.getWorld())) {
            return;
        }
        if (this.plugin.getPermissionManager().hasPermission(null, island, "NaturalMobSpawning")) {
            return;
        }
        if (spawnReason != CreatureSpawnEvent.SpawnReason.JOCKEY && spawnReason != CreatureSpawnEvent.SpawnReason.MOUNT) {
            entity.remove();
            return;
        }
        Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, () -> {
            if (MajorServerVersion.isServerVersionAtLeast(MajorServerVersion.V1_11)) {
                for (Entity passenger : entity.getPassengers()) {
                    passenger.remove();
                }
            } else if (entity.getPassenger() != null) {
                entity.getPassenger().remove();
            }
            entity.remove();
        });
        event.setCancelled(true);
    }

    @EventHandler(ignoreCancelled=true)
    public void onEntitySpawn(EntitySpawnEvent event) {
        WorldManager worldManager = this.plugin.getWorldManager();
        if (worldManager.isIslandWorld(event.getLocation().getWorld())) {
            Entity entity = event.getEntity();
            if (event.getEntity() instanceof EnderSignal) {
                ((EnderSignal)entity).setTargetLocation(entity.getLocation().add(0.0, 50.0, 0.0));
            }
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onDamageVehicle(VehicleDamageEvent event) {
        if (!(event.getAttacker() instanceof Player)) {
            IslandManager islandManager = this.plugin.getIslandManager();
            this.plugin.getPermissionManager().processPermission((Cancellable)event, null, islandManager.getIslandAtLocation(event.getVehicle().getLocation()));
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onDestroyVehicle(VehicleDestroyEvent event) {
        if (!(event.getAttacker() instanceof Player)) {
            IslandManager islandManager = this.plugin.getIslandManager();
            this.plugin.getPermissionManager().processPermission((Cancellable)event, null, islandManager.getIslandAtLocation(event.getVehicle().getLocation()));
        }
    }

    private static CreatureSpawnEvent.SpawnReason getSpawnReason(String reason) {
        try {
            return CreatureSpawnEvent.SpawnReason.valueOf((String)reason);
        }
        catch (Exception e) {
            return null;
        }
    }

    static {
        CreatureSpawnEvent.SpawnReason raid = EntityListeners.getSpawnReason("RAID");
        CreatureSpawnEvent.SpawnReason patrol = EntityListeners.getSpawnReason("PATROL");
        if (patrol != null) {
            CHECKED_REASONS.add(patrol);
        }
        if (raid != null) {
            CHECKED_REASONS.add(raid);
        }
    }
}

