/*
 * Decompiled with CFR 0.152.
 */
package com.craftaro.skyblock.listeners;

import com.craftaro.skyblock.SkyBlock;
import com.craftaro.skyblock.api.event.player.PlayerIslandChatEvent;
import com.craftaro.skyblock.island.Island;
import com.craftaro.skyblock.island.IslandManager;
import com.craftaro.skyblock.island.IslandRole;
import com.craftaro.skyblock.message.MessageManager;
import com.craftaro.skyblock.playerdata.PlayerData;
import com.craftaro.skyblock.playerdata.PlayerDataManager;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.AsyncPlayerChatEvent;

public class ChatListeners
implements Listener {
    private final SkyBlock plugin;

    public ChatListeners(SkyBlock plugin) {
        this.plugin = plugin;
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onAsyncPlayerChat(AsyncPlayerChatEvent event) {
        Player player = event.getPlayer();
        PlayerDataManager playerDataManager = this.plugin.getPlayerDataManager();
        if (playerDataManager.hasPlayerData(player)) {
            PlayerData playerData = playerDataManager.getPlayerData(player);
            Island island = null;
            if (playerData.getOwner() != null) {
                island = this.plugin.getIslandManager().getIsland((OfflinePlayer)player);
            }
            if (playerData.isChat() && island != null) {
                event.setCancelled(true);
                FileConfiguration languageLoad = this.plugin.getLanguage();
                PlayerIslandChatEvent islandChatEvent = new PlayerIslandChatEvent(player, island.getAPIWrapper(), event.getMessage(), languageLoad.getString("Island.Chat.Format.Message"));
                Bukkit.getServer().getPluginManager().callEvent((Event)islandChatEvent);
            }
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onIslandChat(PlayerIslandChatEvent event) {
        String message;
        PlayerDataManager playerDataManager = this.plugin.getPlayerDataManager();
        MessageManager messageManager = this.plugin.getMessageManager();
        IslandManager islandManager = this.plugin.getIslandManager();
        Island island = event.getIsland().getIsland();
        Player player = event.getPlayer();
        FileConfiguration languageLoad = this.plugin.getLanguage();
        String islandRole = null;
        if (island.hasRole(IslandRole.MEMBER, player.getUniqueId())) {
            islandRole = languageLoad.getString("Island.Chat.Format.Role.Member");
        } else if (island.hasRole(IslandRole.OPERATOR, player.getUniqueId())) {
            islandRole = languageLoad.getString("Island.Chat.Format.Role.Operator");
        } else if (island.hasRole(IslandRole.OWNER, player.getUniqueId())) {
            islandRole = languageLoad.getString("Island.Chat.Format.Role.Owner");
        }
        if (islandRole == null) {
            islandRole = "";
        }
        for (UUID islandMembersOnlineList : islandManager.getMembersOnline(island)) {
            Player targetPlayer = Bukkit.getServer().getPlayer(islandMembersOnlineList);
            message = ChatColor.translateAlternateColorCodes((char)'&', (String)messageManager.replaceMessage(targetPlayer, event.getFormat().replace("%role", islandRole).replace("%player", player.getName()))).replace("%message", event.getMessage());
            messageManager.sendMessage((CommandSender)targetPlayer, message);
        }
        for (Player targetPlayer : Bukkit.getServer().getOnlinePlayers()) {
            PlayerData pd;
            if (targetPlayer.equals((Object)event.getPlayer()) || islandManager.getMembersOnline(island).contains(targetPlayer.getUniqueId()) || !targetPlayer.hasPermission("fabledskyblock.admin.chatspy") || (pd = playerDataManager.getPlayerData(targetPlayer)) == null || !pd.isChatSpy() || !pd.isGlobalChatSpy() && !pd.isChatSpyIsland(island)) continue;
            message = ChatColor.translateAlternateColorCodes((char)'&', (String)messageManager.replaceMessage(targetPlayer, languageLoad.getString("Island.Chat.Spy.Format.Message").replace("%role", islandRole).replace("%player", player.getName()))).replace("%islandOwner", new com.craftaro.skyblock.utils.player.OfflinePlayer(island.getOwnerUUID()).getName()).replace("%message", event.getMessage());
            messageManager.sendMessage((CommandSender)targetPlayer, message);
        }
        if (this.plugin.getConfiguration().getBoolean("Island.Chat.OutputToConsole")) {
            messageManager.sendMessage((CommandSender)Bukkit.getConsoleSender(), event.getFormat().replace("%role", islandRole).replace("%player", player.getName()).replace("%message", event.getMessage()));
        }
    }
}

