/*
 * Decompiled with CFR 0.152.
 */
package com.craftaro.skyblock.listeners;

import com.craftaro.skyblock.SkyBlock;
import com.craftaro.skyblock.core.compatibility.CompatibleMaterial;
import com.craftaro.skyblock.island.Island;
import com.craftaro.skyblock.island.IslandManager;
import com.craftaro.skyblock.island.IslandWorld;
import com.craftaro.skyblock.utils.world.LocationUtil;
import com.craftaro.skyblock.world.WorldManager;
import com.craftaro.third_party.com.cryptomorin.xseries.XMaterial;
import com.craftaro.third_party.com.cryptomorin.xseries.XSound;
import org.bukkit.block.Block;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Cancellable;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerBucketEmptyEvent;
import org.bukkit.event.player.PlayerBucketFillEvent;

public class BucketListeners
implements Listener {
    private final SkyBlock plugin;

    public BucketListeners(SkyBlock plugin) {
        this.plugin = plugin;
    }

    @EventHandler
    public void onPlayerBucketFill(PlayerBucketFillEvent event) {
        Player player = event.getPlayer();
        Block block = event.getBlockClicked();
        IslandManager islandManager = this.plugin.getIslandManager();
        XMaterial clickedBlock = CompatibleMaterial.getMaterial(event.getBlockClicked().getType()).orElse(null);
        if ((clickedBlock == XMaterial.WATER || clickedBlock == XMaterial.LAVA) && this.plugin.getWorldManager().isIslandWorld(block.getWorld())) {
            Island island = islandManager.getIslandAtLocation(block.getLocation());
            if (!this.plugin.getPermissionManager().processPermission((Cancellable)event, player, island)) {
                return;
            }
        }
    }

    @EventHandler
    public void onPlayerBucketEmpty(PlayerBucketEmptyEvent event) {
        Island island;
        Player player = event.getPlayer();
        Block block = event.getBlockClicked().getRelative(event.getBlockFace());
        WorldManager worldManager = this.plugin.getWorldManager();
        IslandManager islandManager = this.plugin.getIslandManager();
        if (this.plugin.getWorldManager().isIslandWorld(block.getWorld())) {
            island = islandManager.getIslandAtLocation(block.getLocation());
            if (!this.plugin.getPermissionManager().processPermission((Cancellable)event, player, island)) {
                return;
            }
        }
        if (!this.plugin.getConfiguration().getBoolean("Island.Spawn.Protection")) {
            return;
        }
        island = islandManager.getIslandAtLocation(block.getLocation());
        if (island == null) {
            return;
        }
        IslandWorld world = worldManager.getIslandWorld(block.getWorld());
        if (LocationUtil.isLocationAffectingIslandSpawn(block.getLocation(), island, world)) {
            event.setCancelled(true);
            this.plugin.getMessageManager().sendMessage((CommandSender)player, this.plugin.getLanguage().getString("Island.SpawnProtection.Place.Message"));
            this.plugin.getSoundManager().playSound((CommandSender)player, XSound.ENTITY_VILLAGER_NO);
        }
    }
}

