/*
 * Decompiled with CFR 0.152.
 */
package com.craftaro.skyblock.listeners;

import com.craftaro.skyblock.SkyBlock;
import com.craftaro.skyblock.core.compatibility.CompatibleMaterial;
import com.craftaro.skyblock.core.compatibility.MajorServerVersion;
import com.craftaro.skyblock.core.hooks.LogManager;
import com.craftaro.skyblock.core.utils.NumberUtils;
import com.craftaro.skyblock.generator.Generator;
import com.craftaro.skyblock.generator.GeneratorManager;
import com.craftaro.skyblock.island.Island;
import com.craftaro.skyblock.island.IslandEnvironment;
import com.craftaro.skyblock.island.IslandLevel;
import com.craftaro.skyblock.island.IslandManager;
import com.craftaro.skyblock.island.IslandRole;
import com.craftaro.skyblock.island.IslandWorld;
import com.craftaro.skyblock.levelling.IslandLevelManager;
import com.craftaro.skyblock.limit.impl.BlockLimitation;
import com.craftaro.skyblock.permission.PermissionManager;
import com.craftaro.skyblock.stackable.Stackable;
import com.craftaro.skyblock.stackable.StackableManager;
import com.craftaro.skyblock.utils.MaterialUtils;
import com.craftaro.skyblock.utils.version.CompatibleSpawners;
import com.craftaro.skyblock.utils.world.LocationUtil;
import com.craftaro.skyblock.world.WorldManager;
import com.craftaro.third_party.com.cryptomorin.xseries.XBlock;
import com.craftaro.third_party.com.cryptomorin.xseries.XMaterial;
import com.craftaro.third_party.com.cryptomorin.xseries.XSound;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import org.apache.commons.lang.WordUtils;
import org.bukkit.Bukkit;
import org.bukkit.Effect;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.BlockState;
import org.bukkit.block.CreatureSpawner;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Blaze;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Ghast;
import org.bukkit.entity.Hoglin;
import org.bukkit.entity.MagmaCube;
import org.bukkit.entity.PigZombie;
import org.bukkit.entity.Piglin;
import org.bukkit.entity.Player;
import org.bukkit.entity.Skeleton;
import org.bukkit.entity.Strider;
import org.bukkit.entity.Wither;
import org.bukkit.entity.Zoglin;
import org.bukkit.event.Cancellable;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockBurnEvent;
import org.bukkit.event.block.BlockDispenseEvent;
import org.bukkit.event.block.BlockFormEvent;
import org.bukkit.event.block.BlockFromToEvent;
import org.bukkit.event.block.BlockIgniteEvent;
import org.bukkit.event.block.BlockMultiPlaceEvent;
import org.bukkit.event.block.BlockPistonExtendEvent;
import org.bukkit.event.block.BlockPistonRetractEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.world.PortalCreateEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.material.Bed;
import org.bukkit.material.Dispenser;
import org.bukkit.plugin.Plugin;

public class BlockListeners
implements Listener {
    private final SkyBlock plugin;
    private final Set<Location> generatorWaitingLocs;

    public BlockListeners(SkyBlock plugin) {
        this.plugin = plugin;
        this.generatorWaitingLocs = new HashSet<Location>();
    }

    @EventHandler(priority=EventPriority.LOW)
    public void onBlockBreak(BlockBreakEvent event) {
        CompatibleSpawners spawner;
        Block belowBlock;
        Stackable stackable;
        Player player = event.getPlayer();
        Block block = event.getBlock();
        IslandManager islandManager = this.plugin.getIslandManager();
        StackableManager stackableManager = this.plugin.getStackableManager();
        WorldManager worldManager = this.plugin.getWorldManager();
        if (!worldManager.isIslandWorld(block.getWorld())) {
            return;
        }
        Location blockLocation = block.getLocation();
        Island island = islandManager.getIslandAtLocation(blockLocation);
        if (island == null) {
            event.setCancelled(true);
            return;
        }
        if (!this.plugin.getPermissionManager().processPermission((Cancellable)event, player, island) || event.isCancelled()) {
            return;
        }
        if (stackableManager != null && stackableManager.isStacked(blockLocation) && (stackable = stackableManager.getStack(block.getLocation(), CompatibleMaterial.getMaterial(block.getType()).get())) != null) {
            IslandLevel level;
            FileConfiguration configLoad;
            int droppedAmount;
            XMaterial material = null;
            if (MajorServerVersion.isServerVersion(MajorServerVersion.V1_8)) {
                switch (block.getType().toString().toUpperCase()) {
                    case "DIODE_BLOCK_OFF": 
                    case "DIODE_BLOCK_ON": {
                        material = XMaterial.REPEATER;
                    }
                }
            }
            if (material == null) {
                material = CompatibleMaterial.getMaterial(block.getType()).get();
            }
            byte data = block.getData();
            if (event.getPlayer().isSneaking()) {
                int count;
                Location dropLoc = blockLocation.clone().add(0.5, 0.5, 0.5);
                droppedAmount = count = stackable.getSize();
                while (count > 64) {
                    dropLoc.getWorld().dropItemNaturally(dropLoc, new ItemStack(material.parseMaterial(), 64, (short)data));
                    count -= 64;
                }
                dropLoc.getWorld().dropItemNaturally(dropLoc, new ItemStack(material.parseMaterial(), count, (short)block.getData()));
                block.setType(Material.AIR);
                stackable.setSize(0);
            } else {
                block.getWorld().dropItemNaturally(blockLocation.clone().add(0.5, 1.0, 0.5), new ItemStack(material.parseMaterial(), 1, (short)data));
                stackable.takeOne();
                droppedAmount = 1;
            }
            if (LogManager.isEnabled()) {
                LogManager.logRemoval((OfflinePlayer)player, block);
            }
            if (stackable.getSize() <= 1) {
                stackableManager.removeStack(stackable);
            }
            if ((configLoad = this.plugin.getConfiguration()).getBoolean("Island.Block.Level.Enable") && material != null && (level = island.getLevel()).hasMaterial(material.name())) {
                long materialAmount = level.getMaterialAmount(material.name());
                if (materialAmount - (long)droppedAmount <= 0L) {
                    level.removeMaterial(material.name());
                } else {
                    level.setMaterialAmount(material.name(), materialAmount - (long)droppedAmount);
                }
            }
            event.setCancelled(true);
        }
        FileConfiguration configLoad = this.plugin.getConfiguration();
        IslandWorld world = worldManager.getIslandWorld(block.getWorld());
        if ((LocationUtil.isLocationLocation(block.getLocation(), island.getLocation(world, IslandEnvironment.MAIN).clone().subtract(0.0, 1.0, 0.0)) || LocationUtil.isLocationLocation(block.getLocation(), island.getLocation(world, IslandEnvironment.VISITOR).clone().subtract(0.0, 1.0, 0.0)) || LocationUtil.isLocationAffectingIslandSpawn(block.getLocation(), island, world)) && configLoad.getBoolean("Island.Spawn.Protection")) {
            event.setCancelled(true);
            this.plugin.getMessageManager().sendMessage((CommandSender)player, this.plugin.getLanguage().getString("Island.SpawnProtection.Break.Message"));
            this.plugin.getSoundManager().playSound((CommandSender)player, XSound.ENTITY_VILLAGER_NO);
        }
        if (event.isCancelled() || !configLoad.getBoolean("Island.Block.Level.Enable")) {
            return;
        }
        XMaterial material = null;
        if (MajorServerVersion.isServerVersion(MajorServerVersion.V1_8)) {
            switch (block.getType().toString().toUpperCase()) {
                case "DIODE_BLOCK_OFF": 
                case "DIODE_BLOCK_ON": {
                    material = XMaterial.REPEATER;
                }
            }
        }
        if (material == null) {
            material = CompatibleMaterial.getMaterial(block.getType()).get();
        }
        if (material == null) {
            return;
        }
        if (MaterialUtils.isTall(material) && MaterialUtils.isTall(CompatibleMaterial.getMaterial((belowBlock = block.getRelative(BlockFace.DOWN)).getType()).orElse(XMaterial.STONE))) {
            block = belowBlock;
        }
        if (block.getType() == XMaterial.SPAWNER.parseMaterial() && (spawner = CompatibleSpawners.getSpawner(((CreatureSpawner)block.getState()).getSpawnedType())) != null) {
            material = CompatibleMaterial.getMaterial(spawner.getMaterial()).get();
        }
        if (material == null) {
            return;
        }
        IslandLevel level = island.getLevel();
        if (!level.hasMaterial(material.name())) {
            return;
        }
        long materialAmount = level.getMaterialAmount(material.name());
        if (materialAmount - 1L <= 0L) {
            level.removeMaterial(material.name());
        } else {
            level.setMaterialAmount(material.name(), materialAmount - 1L);
        }
    }

    @EventHandler(priority=EventPriority.LOW, ignoreCancelled=true)
    public void onBlockPlace(BlockPlaceEvent event) {
        Player player = event.getPlayer();
        Block block = event.getBlock();
        IslandManager islandManager = this.plugin.getIslandManager();
        WorldManager worldManager = this.plugin.getWorldManager();
        IslandLevelManager islandLevelManager = this.plugin.getLevellingManager();
        if (!worldManager.isIslandWorld(block.getWorld())) {
            return;
        }
        Location blockLoc = block.getLocation();
        Island island = islandManager.getIslandAtLocation(blockLoc);
        if (!this.plugin.getPermissionManager().processPermission((Cancellable)event, player, island)) {
            return;
        }
        if (island == null) {
            event.setCancelled(true);
            return;
        }
        if (MajorServerVersion.isServerVersionAbove(MajorServerVersion.V1_8) && event instanceof BlockMultiPlaceEvent) {
            for (BlockState blockState : ((BlockMultiPlaceEvent)event).getReplacedBlockStates()) {
                if (island.equals(islandManager.getIslandAtLocation(blockState.getLocation()))) continue;
                event.setCancelled(true);
                return;
            }
        }
        if (islandLevelManager.isScanning(island)) {
            this.plugin.getMessageManager().sendMessage((CommandSender)player, this.plugin.getLanguage().getString("Command.Island.Level.Scanning.BlockPlacing.Message"));
            event.setCancelled(true);
            return;
        }
        FileConfiguration configLoad = this.plugin.getConfiguration();
        IslandWorld world = worldManager.getIslandWorld(block.getWorld());
        if (!player.hasPermission("fabledskyblock.bypass.netherplace") && !islandManager.isIslandWorldUnlocked(island, IslandWorld.NETHER) && configLoad.getConfigurationSection("Island.Restrict.NetherBlocks") != null) {
            for (String s : configLoad.getConfigurationSection("Island.Restrict.NetherBlocks").getKeys(false)) {
                if (!s.equalsIgnoreCase(block.getType().toString()) || !configLoad.getBoolean("Island.Restrict.NetherBlocks." + s, false)) continue;
                this.plugin.getMessageManager().sendMessage((CommandSender)player, Objects.requireNonNull(this.plugin.getLanguage().getString("Island.Unlock.NetherBlocksPlace.Message")));
                event.setCancelled(true);
                return;
            }
        }
        if (!player.hasPermission("fabledskyblock.bypass.endplace") && !islandManager.isIslandWorldUnlocked(island, IslandWorld.END) && configLoad.getConfigurationSection("Island.Restrict.EndBlocks") != null) {
            for (String s : configLoad.getConfigurationSection("Island.Restrict.EndBlocks").getKeys(false)) {
                if (!s.equalsIgnoreCase(block.getType().toString()) || !configLoad.getBoolean("Island.Restrict.EndBlocks." + s)) continue;
                this.plugin.getMessageManager().sendMessage((CommandSender)player, Objects.requireNonNull(this.plugin.getLanguage().getString("Island.Unlock.EndBlocksPlace.Message")));
                event.setCancelled(true);
                return;
            }
        }
        if (configLoad.getBoolean("Island.WorldBorder.Block") && block.getType() == Material.DISPENSER && !islandManager.isLocationAtIsland(island, blockLoc, world)) {
            event.setCancelled(true);
        }
        if (configLoad.getBoolean("Island.Spawn.Protection")) {
            BlockFace bedDirection;
            Block bedBlock;
            boolean isObstructing = false;
            if (LocationUtil.isLocationAffectingIslandSpawn(blockLoc, island, world)) {
                isObstructing = true;
            }
            if (!isObstructing && event.getBlock().getBlockData() instanceof org.bukkit.block.data.type.Bed && MajorServerVersion.isServerVersionAtLeast(MajorServerVersion.V1_13)) {
                org.bukkit.block.data.type.Bed bedData = (org.bukkit.block.data.type.Bed)event.getBlock().getBlockData();
                BlockFace bedDirection2 = bedData.getFacing();
                Block bedBlock2 = block.getRelative(bedDirection2);
                if (LocationUtil.isLocationAffectingIslandSpawn(bedBlock2.getLocation(), island, world)) {
                    isObstructing = true;
                }
            } else if (MajorServerVersion.isServerVersionAtOrBelow(MajorServerVersion.V1_12) && !isObstructing && event.getBlock().getState().getData() instanceof Bed && LocationUtil.isLocationAffectingIslandSpawn((bedBlock = block.getRelative(bedDirection = ((Bed)event.getBlock().getState().getData()).getFacing())).getLocation(), island, world)) {
                isObstructing = true;
            }
            if (isObstructing) {
                this.plugin.getMessageManager().sendMessage((CommandSender)player, this.plugin.getLanguage().getString("Island.SpawnProtection.Place.Message"));
                this.plugin.getSoundManager().playSound((CommandSender)player, XSound.ENTITY_VILLAGER_NO);
                event.setCancelled(true);
                return;
            }
        }
        BlockLimitation limits = this.plugin.getLimitationHandler().getInstance(BlockLimitation.class);
        long limit = limits.getBlockLimit(player, block.getType());
        ItemStack item = event.getItemInHand();
        if (limits.isBlockLimitExceeded(block, limit) && !XMaterial.ENDER_EYE.isSimilar(item)) {
            XMaterial material = null;
            if (MajorServerVersion.isServerVersion(MajorServerVersion.V1_8)) {
                switch (block.getType().toString().toUpperCase()) {
                    case "DIODE_BLOCK_OFF": 
                    case "DIODE_BLOCK_ON": {
                        material = XMaterial.REPEATER;
                    }
                }
            }
            if (material == null) {
                material = CompatibleMaterial.getMaterial(block.getType()).get();
            }
            this.plugin.getMessageManager().sendMessage((CommandSender)player, this.plugin.getLanguage().getString("Island.Limit.Block.Exceeded.Message").replace("%type", WordUtils.capitalizeFully(material.name().replace("_", " "))).replace("%limit", NumberUtils.formatNumber(limit)));
            this.plugin.getSoundManager().playSound((CommandSender)player, XSound.ENTITY_VILLAGER_NO);
            event.setCancelled(true);
            return;
        }
        if (!configLoad.getBoolean("Island.Block.Level.Enable")) {
            return;
        }
        if (event.getBlock().getType() == XMaterial.END_PORTAL_FRAME.parseMaterial() && XMaterial.ENDER_EYE.isSimilar(event.getPlayer().getItemInHand())) {
            return;
        }
        if (MajorServerVersion.isServerVersionBelow(MajorServerVersion.V1_13) && block.getType() == XMaterial.SPONGE.parseMaterial()) {
            Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> {
                XMaterial material;
                IslandLevel level;
                if (blockLoc.getBlock().getType() == XMaterial.WET_SPONGE.parseMaterial() && (level = island.getLevel()).hasMaterial((material = XMaterial.SPONGE).name())) {
                    long materialAmount = level.getMaterialAmount(material.name());
                    if (materialAmount - 1L <= 0L) {
                        level.removeMaterial(material.name());
                    } else {
                        level.setMaterialAmount(material.name(), materialAmount - 1L);
                    }
                    islandLevelManager.updateLevel(island, blockLoc);
                }
            });
        } else {
            islandLevelManager.updateLevel(island, blockLoc);
        }
    }

    @EventHandler
    public void onBlockFromTo(BlockFromToEvent event) {
        Collection entities;
        if (!this.plugin.getWorldManager().isIslandWorld(event.getBlock().getWorld())) {
            return;
        }
        IslandManager islandManager = this.plugin.getIslandManager();
        WorldManager worldManager = this.plugin.getWorldManager();
        Island island = islandManager.getIslandAtLocation(event.getBlock().getLocation());
        IslandWorld world = worldManager.getIslandWorld(event.getBlock().getWorld());
        FileConfiguration configLoad = this.plugin.getConfiguration();
        if (island == null) {
            return;
        }
        Block block = event.getToBlock();
        if (!islandManager.isLocationAtIsland(island, block.getLocation(), world)) {
            event.setCancelled(true);
            return;
        }
        if (LocationUtil.isLocationAffectingIslandSpawn(block.getLocation(), island, world) && configLoad.getBoolean("Island.Spawn.Protection")) {
            event.setCancelled(true);
            return;
        }
        if (configLoad.getBoolean("Island.Nether.WaterDoNotFlowNearNetherMobs", false) && worldManager.getIslandWorld(block.getWorld()).equals((Object)IslandWorld.NETHER) && (entities = block.getWorld().getNearbyEntities(block.getLocation(), 1.0, 1.0, 1.0)).size() > 0) {
            for (Entity ent : entities) {
                boolean witherSkeleton;
                if (MajorServerVersion.isServerVersionAtLeast(MajorServerVersion.V1_11)) {
                    witherSkeleton = ent.getType().equals((Object)EntityType.WITHER_SKELETON);
                } else {
                    boolean bl = witherSkeleton = ent instanceof Skeleton && ((Skeleton)ent).getSkeletonType().equals((Object)Skeleton.SkeletonType.WITHER);
                }
                if (ent instanceof Blaze || ent instanceof MagmaCube || ent instanceof Wither || ent instanceof Ghast || witherSkeleton) {
                    event.setCancelled(true);
                    XSound.BLOCK_FIRE_EXTINGUISH.play(block.getLocation());
                    event.getToBlock().getWorld().playEffect(block.getLocation(), Effect.SMOKE, 1);
                    continue;
                }
                if (MajorServerVersion.isServerVersionAtLeast(MajorServerVersion.V1_16)) {
                    if (!(ent instanceof Piglin) && !(ent instanceof Hoglin) && !(ent instanceof Strider) && !(ent instanceof Zoglin)) continue;
                    event.setCancelled(true);
                    XSound.BLOCK_FIRE_EXTINGUISH.play(block.getLocation());
                    event.getToBlock().getWorld().playEffect(block.getLocation(), Effect.SMOKE, 1);
                    continue;
                }
                if (!(ent instanceof PigZombie)) continue;
                event.setCancelled(true);
                XSound.BLOCK_FIRE_EXTINGUISH.play(block.getLocation());
                event.getToBlock().getWorld().playEffect(block.getLocation(), Effect.SMOKE, 1);
            }
        }
        if (this.generatorWaitingLocs.contains(LocationUtil.toBlockLocation(block.getLocation().clone()))) {
            event.setCancelled(true);
            return;
        }
        if (MajorServerVersion.isServerVersionBelow(MajorServerVersion.V1_12)) {
            Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, () -> this.handleGeneration(block, island, event.getToBlock().getState()), 1L);
        }
    }

    @EventHandler
    public void onBlockPistonExtend(BlockPistonExtendEvent event) {
        WorldManager worldManager = this.plugin.getWorldManager();
        if (!worldManager.isIslandWorld(event.getBlock().getWorld())) {
            return;
        }
        IslandManager islandManager = this.plugin.getIslandManager();
        Island island = islandManager.getIslandAtLocation(event.getBlock().getLocation());
        if (island == null) {
            return;
        }
        FileConfiguration configLoad = this.plugin.getConfiguration();
        if (this.performStackCheck(event.getBlock(), event.getBlocks(), event.getDirection())) {
            event.setCancelled(true);
            return;
        }
        IslandWorld world = worldManager.getIslandWorld(event.getBlock().getWorld());
        for (Block block : event.getBlocks()) {
            if (!islandManager.isLocationAtIsland(island, block.getLocation(), world) || !islandManager.isLocationAtIsland(island, block.getRelative(event.getDirection()).getLocation(), world)) {
                event.setCancelled(true);
                return;
            }
            if (!island.isInBorder(block.getRelative(event.getDirection()).getLocation())) {
                event.setCancelled(true);
                return;
            }
            if (this.plugin.getStackableManager() != null && this.plugin.getStackableManager().isStacked(block.getLocation())) {
                event.setCancelled(true);
                return;
            }
            if (configLoad.getBoolean("Island.Spawn.Protection")) {
                if (LocationUtil.isLocationAffectingIslandSpawn(block.getLocation(), island, world)) {
                    event.setCancelled(true);
                    return;
                }
                if (LocationUtil.isLocationAffectingIslandSpawn(block.getRelative(event.getDirection()).getLocation(), island, world)) {
                    event.setCancelled(true);
                    return;
                }
            }
            if (this.plugin.getConfiguration().getBoolean("Island.Block.Piston.Connected.Extend") || block.getType() != XMaterial.PISTON.parseMaterial() && block.getType() != XMaterial.STICKY_PISTON.parseMaterial()) continue;
            event.setCancelled(true);
            return;
        }
        if (configLoad.getBoolean("Island.Spawn.Protection") && LocationUtil.isLocationAffectingIslandSpawn(event.getBlock().getRelative(event.getDirection()).getLocation(), island, world)) {
            event.setCancelled(true);
        }
    }

    private boolean performStackCheck(Block block, List<Block> list, BlockFace blockFace) {
        return !this.getArmorStands(list.isEmpty() ? block : list.get(list.size() - 1), blockFace).isEmpty();
    }

    private List<ArmorStand> getArmorStands(Block block, BlockFace blockFace) {
        ArrayList<ArmorStand> list = new ArrayList<ArmorStand>();
        block = block.getRelative(blockFace);
        Location loc = block.getLocation();
        int locX = loc.getBlockX();
        int locZ = loc.getBlockZ();
        int locY = loc.getBlockY();
        for (Entity entity : block.getChunk().getEntities()) {
            int dist;
            Location entityLoc;
            if (!(entity instanceof ArmorStand) || !entity.hasMetadata("StackableArmorStand") || (entityLoc = entity.getLocation()).getBlockX() != locX || entityLoc.getBlockZ() != locZ || (dist = locY - entityLoc.getBlockY()) < 0 || dist >= 2) continue;
            list.add((ArmorStand)entity);
        }
        return list;
    }

    @EventHandler
    public void onBlockPistonRetract(BlockPistonRetractEvent event) {
        WorldManager worldManager = this.plugin.getWorldManager();
        if (!this.plugin.getWorldManager().isIslandWorld(event.getBlock().getWorld())) {
            return;
        }
        IslandManager islandManager = this.plugin.getIslandManager();
        Island island = islandManager.getIslandAtLocation(event.getBlock().getLocation());
        if (island == null) {
            return;
        }
        FileConfiguration configLoad = this.plugin.getConfiguration();
        if (this.performStackCheck(event.getBlock(), event.getBlocks(), event.getDirection())) {
            event.setCancelled(true);
            return;
        }
        IslandWorld world = worldManager.getIslandWorld(event.getBlock().getWorld());
        for (Block block : event.getBlocks()) {
            if (!islandManager.isLocationAtIsland(island, block.getLocation(), world)) {
                event.setCancelled(true);
                return;
            }
            if (!island.isInBorder(block.getLocation())) {
                event.setCancelled(true);
                return;
            }
            if (this.plugin.getStackableManager() != null && this.plugin.getStackableManager().isStacked(block.getLocation())) {
                event.setCancelled(true);
                return;
            }
            if (LocationUtil.isLocationAffectingIslandSpawn(block.getLocation(), island, world) && configLoad.getBoolean("Island.Spawn.Protection")) {
                event.setCancelled(true);
                return;
            }
            if (this.plugin.getConfiguration().getBoolean("Island.Block.Piston.Connected.Retract") || block.getType() != XMaterial.PISTON.parseMaterial() && block.getType() != XMaterial.STICKY_PISTON.parseMaterial()) continue;
            event.setCancelled(true);
            return;
        }
    }

    @EventHandler
    public void onBlockForm(BlockFormEvent event) {
        Block block = event.getBlock();
        WorldManager worldManager = this.plugin.getWorldManager();
        FileConfiguration config = this.plugin.getConfiguration();
        if (!worldManager.isIslandWorld(block.getWorld())) {
            return;
        }
        if (block.getType() == Material.ICE || block.getType() == Material.SNOW) {
            if (!config.getBoolean("Island.Weather.IceAndSnow")) {
                event.setCancelled(true);
            }
            return;
        }
        IslandManager islandManager = this.plugin.getIslandManager();
        Island island = islandManager.getIslandAtLocation(block.getLocation());
        if (island == null) {
            return;
        }
        IslandWorld world = worldManager.getIslandWorld(block.getWorld());
        if (LocationUtil.isLocationAffectingIslandSpawn(block.getLocation(), island, world) && this.plugin.getConfiguration().getBoolean("Island.Spawn.Protection")) {
            event.setCancelled(true);
            return;
        }
        if (this.handleGeneration(block, island, event.getNewState())) {
            event.setCancelled(true);
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onBlockBurn(BlockBurnEvent event) {
        Block block = event.getBlock();
        WorldManager worldManager = this.plugin.getWorldManager();
        if (!worldManager.isIslandWorld(block.getWorld())) {
            return;
        }
        IslandManager islandManager = this.plugin.getIslandManager();
        PermissionManager permissionManager = this.plugin.getPermissionManager();
        if (!permissionManager.hasPermission(islandManager.getIslandAtLocation(block.getLocation()), "FireSpread", IslandRole.OWNER)) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onPortalCreate(PortalCreateEvent event) {
        if (!this.plugin.getConfiguration().getBoolean("Island.Spawn.Protection")) {
            return;
        }
        WorldManager worldManager = this.plugin.getWorldManager();
        IslandManager islandManager = this.plugin.getIslandManager();
        if (MajorServerVersion.isServerVersionAbove(MajorServerVersion.V1_13)) {
            List blocks = event.getBlocks();
            if (event.getBlocks().isEmpty()) {
                return;
            }
            Island island = islandManager.getIslandAtLocation(((BlockState)event.getBlocks().get(0)).getLocation());
            if (island == null) {
                return;
            }
            IslandWorld world = worldManager.getIslandWorld(((BlockState)event.getBlocks().get(0)).getWorld());
            for (BlockState block : blocks) {
                if (!LocationUtil.isLocationAffectingIslandSpawn(block.getLocation(), island, world)) continue;
                event.setCancelled(true);
                return;
            }
        } else {
            try {
                List blocks = (List)event.getClass().getMethod("getBlocks", new Class[0]).invoke((Object)event, new Object[0]);
                if (blocks.isEmpty()) {
                    return;
                }
                Island island = islandManager.getIslandAtLocation(((Block)blocks.get(0)).getLocation());
                if (island == null) {
                    return;
                }
                IslandWorld world = worldManager.getIslandWorld(((Block)blocks.get(0)).getWorld());
                for (Block block : blocks) {
                    if (!LocationUtil.isLocationAffectingIslandSpawn(block.getLocation(), island, world)) continue;
                    event.setCancelled(true);
                    return;
                }
            }
            catch (ReflectiveOperationException ex) {
                ex.printStackTrace();
            }
        }
    }

    @EventHandler
    public void onBlockIgnite(BlockIgniteEvent event) {
        Player player = event.getPlayer();
        if (player == null) {
            return;
        }
        if (this.plugin.getWorldManager().isIslandWorld(player.getWorld())) {
            IslandManager islandManager = this.plugin.getIslandManager();
            Island island = islandManager.getIslandAtLocation(event.getBlock().getLocation());
            this.plugin.getPermissionManager().processPermission((Cancellable)event, player, island);
        }
    }

    @EventHandler
    public void onDispenserDispenseBlock(BlockDispenseEvent event) {
        Island island;
        if (!this.plugin.getConfiguration().getBoolean("Island.Spawn.Protection")) {
            return;
        }
        WorldManager worldManager = this.plugin.getWorldManager();
        IslandManager islandManager = this.plugin.getIslandManager();
        BlockFace dispenserDirection = ((Dispenser)event.getBlock().getState().getData()).getFacing();
        Block placeLocation = event.getBlock().getRelative(dispenserDirection);
        if (XMaterial.WATER_BUCKET.isSimilar(event.getItem()) && this.plugin.getConfiguration().getBoolean("Island.Nether.AllowNetherWater", false)) {
            placeLocation.setType(Material.WATER);
        }
        if ((island = islandManager.getIslandAtLocation(placeLocation.getLocation())) == null) {
            return;
        }
        IslandWorld world = worldManager.getIslandWorld(placeLocation.getWorld());
        if (LocationUtil.isLocationAffectingIslandSpawn(placeLocation.getLocation(), island, world)) {
            event.setCancelled(true);
        }
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.MONITOR)
    public void onLiquidDestroyBlock(BlockFromToEvent event) {
        XMaterial srcmaterial;
        if (!this.plugin.getWorldManager().isIslandWorld(event.getBlock().getWorld())) {
            return;
        }
        IslandManager islandManager = this.plugin.getIslandManager();
        Island island = islandManager.getIslandAtLocation(event.getBlock().getLocation());
        if (island == null) {
            return;
        }
        XMaterial destmaterial = CompatibleMaterial.getMaterial(event.getToBlock().getType()).orElse(XMaterial.AIR);
        if (CompatibleMaterial.isAir(destmaterial)) {
            return;
        }
        if (MajorServerVersion.isServerVersion(MajorServerVersion.V1_8)) {
            switch (event.getToBlock().getType().toString().toUpperCase()) {
                case "DIODE_BLOCK_OFF": 
                case "DIODE_BLOCK_ON": {
                    destmaterial = XMaterial.REPEATER;
                }
            }
        }
        if ((srcmaterial = (XMaterial)CompatibleMaterial.getMaterial(event.getBlock().getType()).orElse(null)) != XMaterial.WATER && srcmaterial != XMaterial.LAVA) {
            return;
        }
        FileConfiguration configLoad = this.plugin.getConfiguration();
        if (!configLoad.getBoolean("Island.Block.Level.Enable")) {
            return;
        }
        IslandLevel level = island.getLevel();
        if (level.hasMaterial(destmaterial.name())) {
            long materialAmount = level.getMaterialAmount(destmaterial.name());
            if (materialAmount - 1L <= 0L) {
                level.removeMaterial(destmaterial.name());
            } else {
                level.setMaterialAmount(destmaterial.name(), materialAmount - 1L);
            }
        }
    }

    public boolean handleGeneration(Block block, Island island, BlockState state) {
        WorldManager worldManager = this.plugin.getWorldManager();
        IslandLevelManager islandLevelManager = this.plugin.getLevellingManager();
        FileConfiguration config = this.plugin.getConfiguration();
        IslandManager islandManager = this.plugin.getIslandManager();
        IslandWorld world = worldManager.getIslandWorld(block.getWorld());
        XMaterial material = CompatibleMaterial.getMaterial(block.getType()).orElse(null);
        if (MajorServerVersion.isServerVersionAtLeast(MajorServerVersion.V1_12) && material != XMaterial.WATER && material != XMaterial.LAVA) {
            return false;
        }
        Material type = state.getType();
        if (type != Material.COBBLESTONE && type != Material.STONE && type != Material.BASALT) {
            return false;
        }
        GeneratorManager generatorManager = this.plugin.getGeneratorManager();
        if (generatorManager == null) {
            return false;
        }
        ArrayList generators = Lists.newArrayList(generatorManager.getGenerators());
        if (generators.isEmpty()) {
            return false;
        }
        Collections.reverse(generators);
        boolean ignoreVisitors = config.getBoolean("Island.Generator.IgnoreVisitors", false);
        ArrayList<Player> possiblePlayers = new ArrayList<Player>();
        Set<UUID> visitors = island.getVisit().getVisitors();
        for (Player player : Bukkit.getOnlinePlayers()) {
            boolean isMember = island.hasRole(IslandRole.OWNER, player.getUniqueId()) || island.hasRole(IslandRole.MEMBER, player.getUniqueId()) || island.hasRole(IslandRole.COOP, player.getUniqueId()) || island.hasRole(IslandRole.OPERATOR, player.getUniqueId()) || !ignoreVisitors && visitors.contains(player.getUniqueId()) && player.hasPermission("fabledskyblock.generator.anywhere");
            if (!isMember || !islandManager.isLocationAtIsland(island, player.getLocation(), world)) continue;
            possiblePlayers.add(player);
        }
        if (!possiblePlayers.isEmpty()) {
            boolean nearestPlayer = config.getBoolean("Island.Generator.CheckOnlyNearestPlayer", false);
            if (nearestPlayer) {
                possiblePlayers.sort(Comparator.comparingDouble(a -> a.getLocation().distance(block.getLocation())));
            }
            boolean onlyOwner = config.getBoolean("Island.Generator.CheckOnlyOwnerPermissions", false);
            double distance = ((Player)possiblePlayers.get(0)).getLocation().distance(block.getLocation());
            block1: for (Generator generator : generators) {
                if (island.getLevel().getLevel() < generator.getLevel()) continue;
                if (onlyOwner && this.plugin.getVaultPermission() != null) {
                    OfflinePlayer owner = Bukkit.getServer().getOfflinePlayer(island.getOwnerUUID());
                    if (owner.isOnline()) {
                        Player onlineOwner = (Player)owner;
                        if (!onlineOwner.hasPermission(generator.getPermission())) continue;
                        this.applyGenerator(block, worldManager, islandLevelManager, island, state, generatorManager, generator);
                        continue;
                    }
                    World finalWorld = block.getWorld();
                    this.generatorWaitingLocs.add(LocationUtil.toBlockLocation(block.getLocation().clone()));
                    Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.plugin, () -> {
                        if (this.plugin.getVaultPermission().playerHas(block.getWorld().getName(), owner, generator.getPermission()) || this.plugin.getVaultPermission().playerHas(block.getWorld().getName(), owner, "fabledskyblock.generator.*") || this.plugin.getVaultPermission().playerHas(block.getWorld().getName(), owner, "fabledskyblock.*")) {
                            Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> {
                                this.generatorWaitingLocs.remove(LocationUtil.toBlockLocation(block.getLocation().clone()));
                                if (worldManager.getIslandWorld(finalWorld) != generator.getIsWorld()) {
                                    return;
                                }
                                BlockState genState = generatorManager.generateBlock(generator, block);
                                block.setType(genState.getType());
                                if (MajorServerVersion.isServerVersionBelow(MajorServerVersion.V1_13)) {
                                    BlockState tempState = block.getState();
                                    tempState.setData(genState.getData());
                                    tempState.update(true, true);
                                }
                                islandLevelManager.updateLevel(island, genState.getLocation());
                            });
                        } else {
                            Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> XBlock.setType((Block)block, (XMaterial)XMaterial.COBBLESTONE));
                        }
                    });
                    return true;
                }
                for (Player player : possiblePlayers) {
                    if (nearestPlayer && player.getLocation().distance(block.getLocation()) > distance) continue block1;
                    if (generator.isPermission() && !player.hasPermission(generator.getPermission()) && !player.hasPermission("fabledskyblock.generator.*") && !player.hasPermission("fabledskyblock.*") || !this.applyGenerator(block, worldManager, islandLevelManager, island, state, generatorManager, generator)) continue;
                    return false;
                }
            }
        }
        return false;
    }

    private boolean applyGenerator(Block block, WorldManager worldManager, IslandLevelManager islandLevelManager, Island island, BlockState state, GeneratorManager generatorManager, Generator generator) {
        if (worldManager.getIslandWorld(block.getWorld()) == generator.getIsWorld()) {
            BlockState genState = generatorManager.generateBlock(generator, block);
            state.setType(genState.getType());
            if (MajorServerVersion.isServerVersionBelow(MajorServerVersion.V1_13)) {
                state.setData(genState.getData());
            }
            islandLevelManager.updateLevel(island, genState.getLocation());
            return true;
        }
        return false;
    }
}

