/*
 * Decompiled with CFR 0.152.
 */
package com.craftaro.skyblock.limit.impl;

import com.craftaro.skyblock.island.Island;
import com.craftaro.skyblock.island.IslandEnvironment;
import com.craftaro.skyblock.island.IslandWorld;
import com.craftaro.skyblock.limit.EnumLimitation;
import com.craftaro.skyblock.limit.LimitationInstanceHandler;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;

public final class EntityLimitation
extends EnumLimitation<EntityType> {
    private final LimitationInstanceHandler limitationInstanceHandler;

    public EntityLimitation(LimitationInstanceHandler limitationInstanceHandler) {
        super(EntityType.class);
        this.limitationInstanceHandler = limitationInstanceHandler;
    }

    public long getEntityCount(Island island, IslandWorld islandWorld, EntityType type) {
        Location islandLocation = island.getLocation(islandWorld, IslandEnvironment.ISLAND);
        World world = islandLocation.getWorld();
        Location minLocation = new Location(world, (double)islandLocation.getBlockX() - island.getRadius(), 0.0, (double)islandLocation.getBlockZ() - island.getRadius());
        Location maxLocation = new Location(world, (double)islandLocation.getBlockX() + island.getRadius(), (double)world.getMaxHeight(), (double)islandLocation.getBlockZ() + island.getRadius());
        int minX = Math.min(maxLocation.getBlockX(), minLocation.getBlockX());
        int minZ = Math.min(maxLocation.getBlockZ(), minLocation.getBlockZ());
        int maxX = Math.max(maxLocation.getBlockX(), minLocation.getBlockX());
        int maxZ = Math.max(maxLocation.getBlockZ(), minLocation.getBlockZ());
        int count = 0;
        for (int x = minX; x < maxX + 16; x += 16) {
            for (int z = minZ; z < maxZ + 16; z += 16) {
                if (!this.limitationInstanceHandler.isLoadChunks() && !world.isChunkLoaded(x >> 4, z >> 4)) continue;
                Chunk chunk = world.getChunkAt(x >> 4, z >> 4);
                for (Entity ent : chunk.getEntities()) {
                    if (ent.getType() != type) continue;
                    ++count;
                }
            }
        }
        return count;
    }

    @Override
    public String getSectionName() {
        return "entity";
    }
}

