/*
 * Decompiled with CFR 0.152.
 */
package com.craftaro.skyblock.limit.impl;

import com.craftaro.skyblock.SkyBlock;
import com.craftaro.skyblock.core.compatibility.CompatibleMaterial;
import com.craftaro.skyblock.core.compatibility.MajorServerVersion;
import com.craftaro.skyblock.island.Island;
import com.craftaro.skyblock.island.IslandManager;
import com.craftaro.skyblock.limit.EnumLimitation;
import com.craftaro.skyblock.utils.player.PlayerUtil;
import com.craftaro.third_party.com.cryptomorin.xseries.XMaterial;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;

public final class BlockLimitation
extends EnumLimitation<XMaterial> {
    public BlockLimitation() {
        super(XMaterial.class);
    }

    @Override
    public String getSectionName() {
        return "block";
    }

    @Override
    public boolean hasTooMuch(long currentAmount, Enum<XMaterial> type) {
        throw new UnsupportedOperationException("Not implemented. Use getBlockLimit and isBlockLimitExceeded instead.");
    }

    @Override
    public void reload(ConfigurationSection loadFrom) {
        this.unload();
        if (loadFrom == null) {
            return;
        }
        Set keys = loadFrom.getKeys(false);
        this.removeAndLoadDefaultLimit(loadFrom, keys);
        for (String key : keys) {
            String enumName = key.toUpperCase(Locale.ENGLISH);
            Optional<XMaterial> type = CompatibleMaterial.getMaterial(enumName);
            if (!type.isPresent()) {
                throw new IllegalArgumentException("Unable to parse Materials from '" + enumName + "' in the Section '" + loadFrom.getCurrentPath() + "'");
            }
            this.getMap().put(type.get(), loadFrom.getLong(key));
        }
    }

    @Deprecated
    public long getBlockLimit(Player player, Block block) {
        return this.getBlockLimit(player, block.getType());
    }

    public long getBlockLimit(Player player, Material type) {
        if (player == null || type == null) {
            return -1L;
        }
        if (player.hasPermission("fabledskyblock.limit.block.*")) {
            return -1L;
        }
        XMaterial material = null;
        if (MajorServerVersion.isServerVersion(MajorServerVersion.V1_8)) {
            switch (type.toString().toUpperCase()) {
                case "DIODE_BLOCK_OFF": 
                case "DIODE_BLOCK_ON": {
                    material = XMaterial.REPEATER;
                }
            }
        }
        if (material == null) {
            Optional<XMaterial> material1 = CompatibleMaterial.getMaterial(type);
            if (!material1.isPresent()) {
                return -1L;
            }
            material = material1.get();
        }
        String name = material.name().toLowerCase();
        return Math.max(this.getMap().getOrDefault(material, this.getDefault()), (long)PlayerUtil.getNumberFromPermission(player, "fabledskyblock.limit.block." + name, true, -1));
    }

    public boolean isBlockLimitExceeded(Block block, long limit) {
        return this.isBlockLimitExceeded(CompatibleMaterial.getMaterial(block.getType()).get(), block.getLocation(), limit);
    }

    public boolean isBlockLimitExceeded(XMaterial type, Location loc, long limit) {
        long totalPlaced;
        if (limit == -1L) {
            return false;
        }
        IslandManager islandManager = ((SkyBlock)SkyBlock.getPlugin(SkyBlock.class)).getIslandManager();
        Island island = islandManager.getIslandAtLocation(loc);
        if (type == XMaterial.SPAWNER) {
            totalPlaced = island.getLevel().getMaterials().entrySet().stream().filter(x -> ((String)x.getKey()).contains("SPAWNER")).mapToLong(Map.Entry::getValue).sum();
        } else {
            XMaterial material = null;
            if (MajorServerVersion.isServerVersion(MajorServerVersion.V1_8)) {
                switch (type.toString().toUpperCase()) {
                    case "DIODE_BLOCK_OFF": 
                    case "DIODE_BLOCK_ON": {
                        material = XMaterial.REPEATER;
                    }
                }
            }
            if (material == null) {
                material = type;
            }
            totalPlaced = island.getLevel().getMaterialAmount(material.name());
        }
        return limit <= totalPlaced;
    }
}

